/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.datastructures.heap;

import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.DoubleHeap;
import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.Iter;
import java.util.Arrays;

public class DoubleMaxHeap
implements DoubleHeap {
    protected double[] twoheap;
    protected int size;
    private static final int TWO_HEAP_INITIAL_SIZE = 31;

    public DoubleMaxHeap() {
        double[] dArray = new double[31];
        this.twoheap = dArray;
    }

    public DoubleMaxHeap(int n) {
        int n2 = MathUtil.nextPow2Int(n + 1) - 1;
        double[] dArray = new double[n2];
        this.twoheap = dArray;
    }

    @Override
    public void clear() {
        this.size = 0;
        Arrays.fill(this.twoheap, 0.0);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void add(double d) {
        double d2 = d;
        if (this.size >= this.twoheap.length) {
            this.twoheap = Arrays.copyOf(this.twoheap, this.twoheap.length + this.twoheap.length + 1);
        }
        int n = this.size++;
        this.twoheap[n] = d2;
        this.heapifyUp(n, d2);
    }

    @Override
    public void add(double d, int n) {
        if (this.size < n) {
            this.add(d);
        } else if (this.twoheap[0] > d) {
            this.replaceTopElement(d);
        }
    }

    @Override
    public double replaceTopElement(double d) {
        double d2 = this.twoheap[0];
        this.heapifyDown(d);
        return d2;
    }

    private void heapifyUp(int n, double d) {
        int n2;
        double d2;
        while (n > 0 && !(d <= (d2 = this.twoheap[n2 = n - 1 >>> 1]))) {
            this.twoheap[n] = d2;
            n = n2;
        }
        this.twoheap[n] = d;
    }

    @Override
    public double poll() {
        double d = this.twoheap[0];
        --this.size;
        if (this.size > 0) {
            double d2 = this.twoheap[this.size];
            this.twoheap[this.size] = 0.0;
            this.heapifyDown(d2);
        } else {
            this.twoheap[0] = 0.0;
        }
        return d;
    }

    private void heapifyDown(double d) {
        int n = this.size >>> 1;
        int n2 = 0;
        while (n2 < n) {
            int n3 = (n2 << 1) + 1;
            double d2 = this.twoheap[n3];
            int n4 = n3 + 1;
            if (n4 < this.size && d2 < this.twoheap[n4]) {
                n3 = n4;
                d2 = this.twoheap[n4];
            }
            if (d >= d2) break;
            this.twoheap[n2] = d2;
            n2 = n3;
        }
        this.twoheap[n2] = d;
    }

    @Override
    public double peek() {
        return this.twoheap[0];
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(DoubleMaxHeap.class.getSimpleName()).append(" [");
        UnsortedIter unsortedIter = new UnsortedIter();
        while (unsortedIter.valid()) {
            stringBuilder.append(unsortedIter.get()).append(',');
            unsortedIter.advance();
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public UnsortedIter unsortedIter() {
        return new UnsortedIter();
    }

    private class UnsortedIter
    implements DoubleHeap.UnsortedIter {
        protected int pos = 0;

        private UnsortedIter() {
        }

        @Override
        public boolean valid() {
            return this.pos < DoubleMaxHeap.this.size;
        }

        @Override
        public Iter advance() {
            ++this.pos;
            return this;
        }

        @Override
        public double get() {
            return DoubleMaxHeap.this.twoheap[this.pos];
        }
    }
}

