/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.ensemble;

import de.lmu.ifi.dbs.elki.utilities.datastructures.QuickSelect;
import de.lmu.ifi.dbs.elki.utilities.ensemble.EnsembleVoting;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;

public class EnsembleVotingMedian
implements EnsembleVoting {
    private double quantile = 0.5;

    public EnsembleVotingMedian(double d) {
        this.quantile = d;
    }

    @Override
    public double combine(double[] dArray) {
        return this.combine(dArray, dArray.length);
    }

    @Override
    public double combine(double[] dArray, int n) {
        return QuickSelect.quantile(dArray, 0, n, this.quantile);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID QUANTILE_ID = new OptionID("ensemble.median.quantile", "Quantile to use in median voting.");
        private double quantile = 0.5;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter = new DoubleParameter(QUANTILE_ID, 0.5);
            doubleParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE);
            doubleParameter.addConstraint(CommonConstraints.LESS_EQUAL_ONE_DOUBLE);
            if (parameterization.grab(doubleParameter)) {
                this.quantile = (Double)doubleParameter.getValue();
            }
        }

        @Override
        protected EnsembleVotingMedian makeInstance() {
            return new EnsembleVotingMedian(this.quantile);
        }
    }
}

