/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints;

import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.ParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.WrongParameterValueException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.GlobalParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Parameter;
import java.util.Arrays;
import java.util.List;

public class OneMustBeSetGlobalConstraint
implements GlobalParameterConstraint {
    private List<Parameter<?>> parameters;

    public OneMustBeSetGlobalConstraint(List<Parameter<?>> list) {
        this.parameters = list;
    }

    public OneMustBeSetGlobalConstraint(Parameter<?> ... parameterArray) {
        this.parameters = Arrays.asList(parameterArray);
    }

    @Override
    public void test() throws ParameterException {
        for (Parameter<?> parameter : this.parameters) {
            if (!parameter.isDefined()) continue;
            return;
        }
        throw new WrongParameterValueException("Global Parameter Constraint Error.\nAt least one of the parameters " + OptionUtil.optionsNamesToString(this.parameters) + " has to be set.");
    }

    @Override
    public String getDescription() {
        return "At least one of the parameters " + OptionUtil.optionsNamesToString(this.parameters) + " has to be set.";
    }
}

