/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization;

import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.ClassGenericsUtil;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.InternalParameterizationErrors;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.ParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.GlobalParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class AbstractParameterization
implements Parameterization {
    List<ParameterException> errors = new ArrayList<ParameterException>();
    private static final Logging LOG = Logging.getLogger(AbstractParameterization.class);

    @Override
    public Collection<ParameterException> getErrors() {
        return this.errors;
    }

    @Override
    public boolean hasErrors() {
        return this.errors.size() > 0;
    }

    @Override
    public void reportError(ParameterException parameterException) {
        this.errors.add(parameterException);
    }

    public synchronized void logAndClearReportedErrors() {
        for (ParameterException parameterException : this.getErrors()) {
            if (LOG.isDebugging()) {
                LOG.warning(parameterException.getMessage(), parameterException);
                continue;
            }
            LOG.warning(parameterException.getMessage());
        }
        this.clearErrors();
    }

    public synchronized void clearErrors() {
        this.errors = new ArrayList<ParameterException>();
    }

    public void failOnErrors() throws AbortException {
        int n = this.getErrors().size();
        if (n > 0) {
            this.logAndClearReportedErrors();
            throw new AbortException(n + " errors occurred during parameterization.");
        }
    }

    public synchronized void reportInternalParameterizationErrors(Parameterization parameterization) {
        int n = this.getErrors().size();
        if (n > 0) {
            parameterization.reportError(new InternalParameterizationErrors(n + " internal (re-) parameterization errors prevented execution.", this.getErrors()));
            this.clearErrors();
        }
    }

    @Override
    public final boolean grab(Parameter<?> parameter) {
        if (parameter.isDefined()) {
            LOG.warning("Option " + parameter.getName() + " is already set!");
        }
        try {
            if (this.setValueForOption(parameter)) {
                return true;
            }
            return parameter.tryDefaultValue();
        }
        catch (ParameterException parameterException) {
            this.reportError(parameterException);
            return false;
        }
    }

    @Override
    public abstract boolean setValueForOption(Parameter<?> var1) throws ParameterException;

    public void finalize() throws Throwable {
        this.failOnErrors();
        super.finalize();
    }

    @Override
    public boolean checkConstraint(GlobalParameterConstraint globalParameterConstraint) {
        try {
            globalParameterConstraint.test();
        }
        catch (ParameterException parameterException) {
            this.reportError(parameterException);
            return false;
        }
        return true;
    }

    @Override
    public <C> C tryInstantiate(Class<C> clazz, Class<?> clazz2) {
        try {
            return ClassGenericsUtil.tryInstantiate(clazz, clazz2, this);
        }
        catch (Exception exception) {
            LOG.exception(exception);
            this.reportError(new InternalParameterizationErrors("Error instantiating internal class: " + clazz2.getName(), exception));
            return null;
        }
    }

    @Override
    public <C> C tryInstantiate(Class<C> clazz) {
        try {
            return ClassGenericsUtil.tryInstantiate(clazz, clazz, this);
        }
        catch (Exception exception) {
            LOG.exception(exception);
            this.reportError(new InternalParameterizationErrors("Error instantiating internal class: " + clazz.getName(), exception));
            return null;
        }
    }
}

