/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization;

import de.lmu.ifi.dbs.elki.utilities.ClassGenericsUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.InternalParameterizationErrors;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.ParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.GlobalParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.ListParameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MergedParameterization
implements Parameterization {
    private final Parameterization inner;
    private final ListParameterization current;
    private final List<ListParameterization.ParameterPair> used;

    public MergedParameterization(Parameterization parameterization) {
        this.inner = parameterization;
        this.current = new ListParameterization();
        this.used = new ArrayList<ListParameterization.ParameterPair>();
    }

    private MergedParameterization(Parameterization parameterization, ListParameterization listParameterization, List<ListParameterization.ParameterPair> list) {
        this.inner = parameterization;
        this.current = listParameterization;
        this.used = list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rewind() {
        List<ListParameterization.ParameterPair> list = this.used;
        synchronized (list) {
            for (ListParameterization.ParameterPair parameterPair : this.used) {
                this.current.addParameter(parameterPair.option, parameterPair.value);
            }
            this.used.clear();
        }
    }

    @Override
    public boolean setValueForOption(Parameter<?> parameter) throws ParameterException {
        try {
            if (this.current.setValueForOption(parameter)) {
                this.used.add(new ListParameterization.ParameterPair(parameter.getOptionID(), parameter.getValue()));
                return true;
            }
        }
        catch (ParameterException parameterException) {
            this.current.reportError(parameterException);
        }
        if (this.inner.setValueForOption(parameter)) {
            this.used.add(new ListParameterization.ParameterPair(parameter.getOptionID(), parameter.getValue()));
            return true;
        }
        this.used.add(new ListParameterization.ParameterPair(parameter.getOptionID(), parameter.getDefaultValue()));
        return false;
    }

    @Override
    public Parameterization descend(Object object) {
        return new MergedParameterization(this.inner.descend(object), this.current, this.used);
    }

    @Override
    public Collection<ParameterException> getErrors() {
        return this.current.getErrors();
    }

    @Override
    public boolean hasErrors() {
        return this.current.hasErrors();
    }

    @Override
    public void reportError(ParameterException parameterException) {
        this.inner.reportError(parameterException);
    }

    @Override
    public boolean grab(Parameter<?> parameter) {
        try {
            if (this.setValueForOption(parameter)) {
                return true;
            }
            return parameter.tryDefaultValue();
        }
        catch (ParameterException parameterException) {
            this.reportError(parameterException);
            return false;
        }
    }

    @Override
    public boolean hasUnusedParameters() {
        return this.inner.hasUnusedParameters();
    }

    @Override
    public boolean checkConstraint(GlobalParameterConstraint globalParameterConstraint) {
        return this.inner.checkConstraint(globalParameterConstraint);
    }

    @Override
    public <C> C tryInstantiate(Class<C> clazz, Class<?> clazz2) {
        try {
            return ClassGenericsUtil.tryInstantiate(clazz, clazz2, this);
        }
        catch (Exception exception) {
            this.reportError(new InternalParameterizationErrors("Error instantiating internal class: " + clazz2.getName(), exception));
            return null;
        }
    }

    @Override
    public <C> C tryInstantiate(Class<C> clazz) {
        try {
            return ClassGenericsUtil.tryInstantiate(clazz, clazz, this);
        }
        catch (Exception exception) {
            this.reportError(new InternalParameterizationErrors("Error instantiating internal class: " + clazz.getName(), exception));
            return null;
        }
    }
}

