/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization;

import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.NoParameterValueException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.ParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.AbstractParameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Parameter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class SerializedParameterization
extends AbstractParameterization {
    public static final String OPTION_PREFIX = "-";
    LinkedList<String> parameters = new LinkedList();

    public SerializedParameterization() {
    }

    public SerializedParameterization(String[] stringArray) {
        this();
        for (String string : stringArray) {
            this.parameters.add(string);
        }
    }

    public SerializedParameterization(List<String> list) {
        this();
        this.parameters.addAll(list);
    }

    public List<String> getRemainingParameters() {
        return this.parameters;
    }

    @Override
    public boolean hasUnusedParameters() {
        return this.parameters.size() > 0;
    }

    public void logUnusedParameters() {
        if (this.hasUnusedParameters()) {
            LoggingUtil.warning("The following parameters were not processed: " + this.parameters);
        }
    }

    @Override
    public boolean setValueForOption(Parameter<?> parameter) throws ParameterException {
        Iterator iterator = this.parameters.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!string.startsWith(OPTION_PREFIX)) continue;
            String string2 = string.substring(OPTION_PREFIX.length());
            if (!parameter.getName().equals(string2)) continue;
            iterator.remove();
            if (parameter instanceof Flag) {
                String string3 = "true";
                if (iterator.hasNext()) {
                    String string4 = (String)iterator.next();
                    if ("true".equals(string4)) {
                        string3 = "true";
                        iterator.remove();
                    } else if ("false".equals(string4)) {
                        string3 = "false";
                        iterator.remove();
                    } else if (!string4.startsWith(OPTION_PREFIX)) {
                        throw new NoParameterValueException("Flag " + parameter.getName() + " requires no parameter-value! " + "(read parameter-value: " + string4 + ")");
                    }
                }
                parameter.setValue(string3);
                return true;
            }
            if (!iterator.hasNext()) {
                throw new NoParameterValueException("Parameter " + parameter.getName() + " requires a parameter value!");
            }
            parameter.setValue(iterator.next());
            iterator.remove();
            return true;
        }
        return false;
    }

    @Override
    public Parameterization descend(Object object) {
        return this;
    }
}

