/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters;

import de.lmu.ifi.dbs.elki.utilities.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.ParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.WrongParameterValueException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ListParameter;

public class DoubleListParameter
extends ListParameter<DoubleListParameter, double[]> {
    public DoubleListParameter(OptionID optionID, boolean bl) {
        super(optionID, bl);
    }

    public DoubleListParameter(OptionID optionID) {
        super(optionID);
    }

    @Override
    public String getValueAsString() {
        return FormatUtil.format((double[])this.getValue(), ",");
    }

    @Override
    public String getDefaultValueAsString() {
        return FormatUtil.format((double[])this.getDefaultValue(), ",");
    }

    @Override
    protected double[] parseValue(Object object) throws ParameterException {
        if (object instanceof double[]) {
            return (double[])double[].class.cast(object);
        }
        if (object instanceof String) {
            String[] stringArray = SPLIT.split((String)object);
            double[] dArray = new double[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                dArray[i++] = FormatUtil.parseDouble(stringArray[i]);
            }
            return dArray;
        }
        if (object instanceof Double) {
            return new double[]{(Double)object};
        }
        throw new WrongParameterValueException("Wrong parameter format! Parameter \"" + this.getName() + "\" requires a list of Double values!");
    }

    @Override
    public int size() {
        return ((double[])this.getValue()).length;
    }

    @Override
    public String getSyntax() {
        return "<double_1,...,double_n>";
    }
}

