/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters;

import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.ParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.UnspecifiedParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.WrongParameterValueException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.AbstractParameter;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class PatternParameter
extends AbstractParameter<PatternParameter, Pattern> {
    public PatternParameter(OptionID optionID, Pattern pattern) {
        super(optionID, pattern);
    }

    public PatternParameter(OptionID optionID, String string) {
        super(optionID, Pattern.compile(string, 2));
    }

    public PatternParameter(OptionID optionID) {
        super(optionID);
    }

    @Override
    public String getValueAsString() {
        return ((Pattern)this.getValue()).toString();
    }

    @Override
    protected Pattern parseValue(Object object) throws ParameterException {
        if (object == null) {
            throw new UnspecifiedParameterException(this);
        }
        if (object instanceof Pattern) {
            return (Pattern)object;
        }
        if (object instanceof String) {
            try {
                return Pattern.compile((String)object, 2);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw new WrongParameterValueException("Given pattern \"" + object + "\" for parameter \"" + this.getName() + "\" is no valid regular expression!");
            }
        }
        throw new WrongParameterValueException("Given pattern \"" + object + "\" for parameter \"" + this.getName() + "\" is of unknown type!");
    }

    @Override
    public String getSyntax() {
        return "<pattern>";
    }
}

