/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.referencepoints;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.referencepoints.ReferencePointsHeuristic;
import java.util.ArrayList;
import java.util.Collection;

public class AxisBasedReferencePoints
implements ReferencePointsHeuristic {
    protected double spacescale;

    public AxisBasedReferencePoints(double d) {
        this.spacescale = d;
    }

    @Override
    public Collection<? extends NumberVector> getReferencePoints(Relation<? extends NumberVector> relation) {
        int n;
        double[][] dArray = RelationUtil.computeMinMax(relation);
        int n2 = RelationUtil.dimensionality(relation);
        double[] dArray2 = dArray[0];
        double[] dArray3 = dArray[1];
        for (int i = 0; i < n2; ++i) {
            int n3 = i;
            dArray3[n3] = dArray3[n3] - dArray2[i];
            int n4 = i;
            dArray2[n4] = dArray2[n4] - dArray3[i] * 0.5;
        }
        ArrayList<Vector> arrayList = new ArrayList<Vector>(2 + n2);
        double[] dArray4 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray4[n] = dArray2[n] - dArray3[n];
        }
        arrayList.add(new Vector(dArray4));
        for (n = 0; n < n2; ++n) {
            dArray4[n] = dArray2[n] + dArray3[n];
        }
        arrayList.add(new Vector(dArray4));
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n2; ++i) {
                dArray4[i] = i != n ? dArray2[i] - dArray3[i] : dArray2[i] + dArray3[i];
            }
            arrayList.add(new Vector(dArray4));
        }
        return arrayList;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID SPACE_SCALE_ID = new OptionID("axisref.scale", "Scale the data space extension by the given factor.");
        protected double spacescale = 0.0;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter = (DoubleParameter)new DoubleParameter(SPACE_SCALE_ID, 1.0).addConstraint(CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE);
            if (parameterization.grab(doubleParameter)) {
                this.spacescale = (Double)doubleParameter.getValue();
            }
        }

        @Override
        protected AxisBasedReferencePoints makeInstance() {
            return new AxisBasedReferencePoints(this.spacescale);
        }
    }
}

