/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.scaling;

import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.utilities.scaling.StaticScalingFunction;

public class LinearScaling
implements StaticScalingFunction {
    private double factor;
    private double shift;

    public LinearScaling() {
        this(1.0, 0.0);
    }

    public LinearScaling(double d) {
        this(d, 0.0);
    }

    public LinearScaling(double d, double d2) {
        this.factor = d;
        this.shift = d2;
    }

    public LinearScaling(DoubleMinMax doubleMinMax) {
        this.factor = 1.0 / (doubleMinMax.getMax() - doubleMinMax.getMin());
        this.shift = -doubleMinMax.getMin() * this.factor;
    }

    @Override
    public double getScaled(double d) {
        return this.factor * d + this.shift;
    }

    @Override
    public double getMin() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double getMax() {
        return Double.POSITIVE_INFINITY;
    }

    public static LinearScaling fromMinMax(double d, double d2) {
        double d3 = 1.0 / (d2 - d);
        return new LinearScaling(d3, -d * d3);
    }
}

