/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.scaling.outlier;

import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.datastructures.QuickSelect;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayLikeUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.scaling.outlier.OutlierScalingFunction;

public class TopKOutlierScaling
implements OutlierScalingFunction {
    public static final OptionID K_ID = new OptionID("topk.k", "Number of outliers to keep.");
    public static final OptionID BINARY_ID = new OptionID("topk.binary", "Make the top k a binary scaling.");
    private int k = -1;
    private boolean binary = false;
    private double cutoff;
    private double ground;
    private double max;

    public TopKOutlierScaling(int n, boolean bl) {
        this.k = n;
        this.binary = bl;
    }

    @Override
    public void prepare(OutlierResult outlierResult) {
        if (this.k <= 0) {
            LoggingUtil.warning("No k configured for Top-k outlier scaling!");
        }
        DBIDArrayMIter dBIDArrayMIter = outlierResult.getOrdering().order(outlierResult.getOrdering().getDBIDs()).iter();
        for (int i = 0; i < this.k && dBIDArrayMIter.valid(); ++i) {
            this.cutoff = outlierResult.getScores().doubleValue(dBIDArrayMIter);
            dBIDArrayMIter.advance();
        }
        this.max = outlierResult.getOutlierMeta().getActualMaximum();
        this.ground = outlierResult.getOutlierMeta().getTheoreticalBaseline();
        if (Double.isInfinite(this.ground) || Double.isNaN(this.ground)) {
            this.ground = outlierResult.getOutlierMeta().getTheoreticalMinimum();
        }
        if (Double.isInfinite(this.ground) || Double.isNaN(this.ground)) {
            this.ground = outlierResult.getOutlierMeta().getActualMinimum();
        }
        if (Double.isInfinite(this.ground) || Double.isNaN(this.ground)) {
            this.ground = Math.min(0.0, this.cutoff);
        }
    }

    @Override
    public <A> void prepare(A a, NumberArrayAdapter<?, A> numberArrayAdapter) {
        if (this.k <= 0) {
            LoggingUtil.warning("No k configured for Top-k outlier scaling!");
        }
        double[] dArray = ArrayLikeUtil.toPrimitiveDoubleArray(a, numberArrayAdapter);
        QuickSelect.quickSelect(dArray, this.k);
        this.cutoff = dArray[this.k - 1];
        this.max = Double.NEGATIVE_INFINITY;
        for (double d : dArray) {
            this.max = Math.max(this.max, d);
        }
        this.ground = Math.min(0.0, this.cutoff);
    }

    @Override
    public double getMax() {
        if (this.binary) {
            return 1.0;
        }
        return this.max;
    }

    @Override
    public double getMin() {
        if (this.binary) {
            return 0.0;
        }
        return this.ground;
    }

    @Override
    public double getScaled(double d) {
        if (this.binary) {
            if (d >= this.cutoff) {
                return 1.0;
            }
            return 0.0;
        }
        if (d >= this.cutoff) {
            return (d - this.ground) / (this.max - this.ground);
        }
        return 0.0;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        protected int k = 0;
        protected boolean binary = false;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            Flag flag;
            super.makeOptions(parameterization);
            IntParameter intParameter = new IntParameter(K_ID);
            intParameter.addConstraint(CommonConstraints.GREATER_THAN_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.k = intParameter.intValue();
            }
            if (parameterization.grab(flag = new Flag(BINARY_ID))) {
                this.binary = flag.isTrue();
            }
        }

        @Override
        protected TopKOutlierScaling makeInstance() {
            return new TopKOutlierScaling(this.k, this.binary);
        }
    }
}

