/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.util.pipeline;

import io.ktor.util.Attributes;
import io.ktor.util.AttributesJvmKt;
import io.ktor.util.InternalAPI;
import io.ktor.util.collections.CollectionUtilsKt;
import io.ktor.util.pipeline.InvalidPhaseException;
import io.ktor.util.pipeline.PhaseContent;
import io.ktor.util.pipeline.PipelineContext;
import io.ktor.util.pipeline.PipelineContextKt;
import io.ktor.util.pipeline.PipelineExecutor;
import io.ktor.util.pipeline.PipelinePhase;
import io.ktor.util.pipeline.PipelinePhaseRelation;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\"\n\u0002\u0018\u0002\n\u0002\b!\n\u0002\u0010!\n\u0002\b\u0003\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u0001*\b\b\u0001\u0010\u0003*\u00020\u00012\u00020\u0001BU\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012?\u0010\f\u001a;\u00127\u00125\b\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0007\u00a2\u0006\u0002\b\u000b0\u0006\u00f8\u0001\u0000\u00a2\u0006\u0004\b\r\u0010\u000eB\u001b\u0012\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u000f\"\u00020\u0004\u00a2\u0006\u0004\b\r\u0010\u0011J\u0015\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0014\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015JK\u0010\u0016\u001a;\u00127\u00125\b\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0007\u00a2\u0006\u0002\b\u000b0\u0006H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0016\u0010\u0017J-\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u001c2\u0006\u0010\u0018\u001a\u00028\u00012\u0006\u0010\u0019\u001a\u00028\u00002\u0006\u0010\u001b\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ#\u0010\u001f\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00028\u00012\u0006\u0010\u0019\u001a\u00028\u0000H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001f\u0010 J#\u0010#\u001a\u00020\"2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000H\u0002\u00a2\u0006\u0004\b#\u0010$J%\u0010&\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010%2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b&\u0010'J\u0017\u0010)\u001a\u00020(2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b)\u0010*J\u0017\u0010+\u001a\u00020\"2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b+\u0010,J\u001d\u0010.\u001a\u00020\n2\u0006\u0010-\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b.\u0010/J\u001d\u00100\u001a\u00020\n2\u0006\u0010-\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b0\u0010/J\u001f\u00103\u001a\u00020\"2\u0006\u00101\u001a\u00020\u00012\u0006\u00102\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b3\u00104JS\u00106\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u000429\u00105\u001a5\b\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0007\u00a2\u0006\u0002\b\u000b\u00f8\u0001\u0000\u00a2\u0006\u0004\b6\u00107JK\u00109\u001a;\u00127\u00125\b\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0007\u00a2\u0006\u0002\b\u000b0\u0006H\u0000\u00f8\u0001\u0000\u00a2\u0006\u0004\b8\u0010\u0017J!\u0010:\u001a\u00020\n2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000\u00a2\u0006\u0004\b:\u0010;JS\u0010=\u001a\u00020\n2?\u0010<\u001a;\u00127\u00125\b\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0007\u00a2\u0006\u0002\b\u000b0\u0006H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b=\u0010>JS\u0010A\u001a;\u00127\u00125\b\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0007\u00a2\u0006\u0002\b\u000b0\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0000\u00f8\u0001\u0000\u00a2\u0006\u0004\b?\u0010@J\u000f\u0010B\u001a\u00020\nH\u0002\u00a2\u0006\u0004\bB\u0010\u0015J#\u0010D\u001a\u00020\n2\u0012\u0010C\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000H\u0002\u00a2\u0006\u0004\bD\u0010;J#\u0010F\u001a\u00020\n2\u0012\u0010E\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010%H\u0002\u00a2\u0006\u0004\bF\u0010GJK\u0010H\u001a;\u00127\u00125\b\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0007\u00a2\u0006\u0002\b\u000b0\u0006H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\bH\u0010\u0017JU\u0010I\u001a\u00020\"2\u0006\u0010\u0005\u001a\u00020\u000429\u00105\u001a5\b\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0007\u00a2\u0006\u0002\b\u000bH\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\bI\u0010JR\u0017\u0010L\u001a\u00020K8\u0006\u00a2\u0006\f\n\u0004\bL\u0010M\u001a\u0004\bN\u0010OR\u001a\u0010P\u001a\u00020\"8\u0016X\u0096D\u00a2\u0006\f\n\u0004\bP\u0010Q\u001a\u0004\bR\u0010SR\u009d\u0001\u0010\f\u001a=\u00127\u00125\b\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0007\u00a2\u0006\u0002\b\u000b\u0018\u00010\u00062A\u0010T\u001a=\u00127\u00125\b\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0007\u00a2\u0006\u0002\b\u000b\u0018\u00010\u00068B@BX\u0082\u000e\u00f8\u0001\u0000\u00a2\u0006\f\u001a\u0004\bU\u0010\u0017\"\u0004\bV\u0010>R+\u0010]\u001a\u00020\"2\u0006\u0010W\u001a\u00020\"8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\bX\u0010Y\u001a\u0004\bZ\u0010S\"\u0004\b[\u0010\\R/\u0010b\u001a\u0004\u0018\u00010\u00042\b\u0010W\u001a\u0004\u0018\u00010\u00048B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b^\u0010Y\u001a\u0004\b_\u0010`\"\u0004\ba\u0010\u0013R+\u0010h\u001a\u00020(2\u0006\u0010W\u001a\u00020(8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\bc\u0010Y\u001a\u0004\bd\u0010e\"\u0004\bf\u0010gR\u001a\u0010i\u001a\u00020\"8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\bj\u0010\u0015\u001a\u0004\bi\u0010SR\u0017\u0010l\u001a\b\u0012\u0004\u0012\u00020\u00040\u00068F\u00a2\u0006\u0006\u001a\u0004\bk\u0010\u0017R\u001a\u0010n\u001a\b\u0012\u0004\u0012\u00020\u00010m8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bn\u0010o\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006p"}, d2={"Lio/ktor/util/pipeline/Pipeline;", "", "TSubject", "TContext", "Lio/ktor/util/pipeline/PipelinePhase;", "phase", "", "Lkotlin/Function3;", "Lio/ktor/util/pipeline/PipelineContext;", "Lkotlin/coroutines/Continuation;", "", "Lkotlin/ExtensionFunctionType;", "interceptors", "<init>", "(Lio/ktor/util/pipeline/PipelinePhase;Ljava/util/List;)V", "", "phases", "([Lio/ktor/util/pipeline/PipelinePhase;)V", "addPhase", "(Lio/ktor/util/pipeline/PipelinePhase;)V", "afterIntercepted", "()V", "cacheInterceptors", "()Ljava/util/List;", "context", "subject", "Lkotlin/coroutines/CoroutineContext;", "coroutineContext", "Lio/ktor/util/pipeline/PipelineExecutor;", "createContext", "(Ljava/lang/Object;Ljava/lang/Object;Lkotlin/coroutines/CoroutineContext;)Lio/ktor/util/pipeline/PipelineExecutor;", "execute", "(Ljava/lang/Object;Ljava/lang/Object;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "from", "", "fastPathMerge", "(Lio/ktor/util/pipeline/Pipeline;)Z", "Lio/ktor/util/pipeline/PhaseContent;", "findPhase", "(Lio/ktor/util/pipeline/PipelinePhase;)Lio/ktor/util/pipeline/PhaseContent;", "", "findPhaseIndex", "(Lio/ktor/util/pipeline/PipelinePhase;)I", "hasPhase", "(Lio/ktor/util/pipeline/PipelinePhase;)Z", "reference", "insertPhaseAfter", "(Lio/ktor/util/pipeline/PipelinePhase;Lio/ktor/util/pipeline/PipelinePhase;)V", "insertPhaseBefore", "fromPhaseOrContent", "fromPhase", "insertRelativePhase", "(Ljava/lang/Object;Lio/ktor/util/pipeline/PipelinePhase;)Z", "block", "intercept", "(Lio/ktor/util/pipeline/PipelinePhase;Lkotlin/jvm/functions/Function3;)V", "interceptorsForTests$ktor_utils", "interceptorsForTests", "merge", "(Lio/ktor/util/pipeline/Pipeline;)V", "list", "notSharedInterceptorsList", "(Ljava/util/List;)V", "phaseInterceptors$ktor_utils", "(Lio/ktor/util/pipeline/PipelinePhase;)Ljava/util/List;", "phaseInterceptors", "resetInterceptorsList", "pipeline", "setInterceptorsListFromAnotherPipeline", "phaseContent", "setInterceptorsListFromPhase", "(Lio/ktor/util/pipeline/PhaseContent;)V", "sharedInterceptorsList", "tryAddToPhaseFastPath", "(Lio/ktor/util/pipeline/PipelinePhase;Lkotlin/jvm/functions/Function3;)Z", "Lio/ktor/util/Attributes;", "attributes", "Lio/ktor/util/Attributes;", "getAttributes", "()Lio/ktor/util/Attributes;", "developmentMode", "Z", "getDevelopmentMode", "()Z", "value", "getInterceptors", "setInterceptors", "<set-?>", "interceptorsListShared$delegate", "Lkotlin/properties/ReadWriteProperty;", "getInterceptorsListShared", "setInterceptorsListShared", "(Z)V", "interceptorsListShared", "interceptorsListSharedPhase$delegate", "getInterceptorsListSharedPhase", "()Lio/ktor/util/pipeline/PipelinePhase;", "setInterceptorsListSharedPhase", "interceptorsListSharedPhase", "interceptorsQuantity$delegate", "getInterceptorsQuantity", "()I", "setInterceptorsQuantity", "(I)V", "interceptorsQuantity", "isEmpty", "isEmpty$annotations", "getItems", "items", "", "phasesRaw", "Ljava/util/List;", "ktor-utils"})
public class Pipeline<TSubject, TContext> {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Attributes attributes;
    private final boolean developmentMode;
    @NotNull
    private final List<Object> phasesRaw;
    @NotNull
    private final ReadWriteProperty interceptorsQuantity$delegate;
    @NotNull
    private volatile /* synthetic */ Object _interceptors;
    @NotNull
    private final ReadWriteProperty interceptorsListShared$delegate;
    @NotNull
    private final ReadWriteProperty interceptorsListSharedPhase$delegate;

    public Pipeline(PipelinePhase ... phases) {
        Intrinsics.checkNotNullParameter((Object)phases, (String)"phases");
        this.attributes = AttributesJvmKt.Attributes(true);
        this.phasesRaw = CollectionUtilsKt.sharedListOf(Arrays.copyOf(phases, phases.length));
        Constable value$iv = 0;
        boolean $i$f$shared = false;
        this.interceptorsQuantity$delegate = (ReadWriteProperty)new ReadWriteProperty<Object, Integer>((Object)value$iv){
            private Integer value;
            final /* synthetic */ Object $value;
            {
                this.$value = $value;
                this.value = this.$value;
            }

            public Integer getValue(@NotNull Object thisRef, @NotNull KProperty<?> property) {
                Intrinsics.checkNotNullParameter((Object)thisRef, (String)"thisRef");
                Intrinsics.checkNotNullParameter(property, (String)"property");
                return this.value;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public void setValue(@NotNull Object thisRef, @NotNull KProperty property, Object value) {
                Intrinsics.checkNotNullParameter((Object)thisRef, (String)"thisRef");
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                this.value = value;
            }
        };
        this._interceptors = null;
        value$iv = Boolean.valueOf(false);
        $i$f$shared = false;
        this.interceptorsListShared$delegate = (ReadWriteProperty)new ReadWriteProperty<Object, Boolean>((Object)value$iv){
            private Boolean value;
            final /* synthetic */ Object $value;
            {
                this.$value = $value;
                this.value = this.$value;
            }

            public Boolean getValue(@NotNull Object thisRef, @NotNull KProperty<?> property) {
                Intrinsics.checkNotNullParameter((Object)thisRef, (String)"thisRef");
                Intrinsics.checkNotNullParameter(property, (String)"property");
                return this.value;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public void setValue(@NotNull Object thisRef, @NotNull KProperty property, Object value) {
                Intrinsics.checkNotNullParameter((Object)thisRef, (String)"thisRef");
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                this.value = value;
            }
        };
        value$iv = null;
        $i$f$shared = false;
        this.interceptorsListSharedPhase$delegate = (ReadWriteProperty)new ReadWriteProperty<Object, PipelinePhase>((Object)value$iv){
            private PipelinePhase value;
            final /* synthetic */ Object $value;
            {
                this.$value = $value;
                this.value = this.$value;
            }

            public PipelinePhase getValue(@NotNull Object thisRef, @NotNull KProperty<?> property) {
                Intrinsics.checkNotNullParameter((Object)thisRef, (String)"thisRef");
                Intrinsics.checkNotNullParameter(property, (String)"property");
                return this.value;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public void setValue(@NotNull Object thisRef, @NotNull KProperty property, Object value) {
                Intrinsics.checkNotNullParameter((Object)thisRef, (String)"thisRef");
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                this.value = value;
            }
        };
    }

    @NotNull
    public final Attributes getAttributes() {
        return this.attributes;
    }

    public boolean getDevelopmentMode() {
        return this.developmentMode;
    }

    private final int getInterceptorsQuantity() {
        return ((Number)this.interceptorsQuantity$delegate.getValue((Object)this, $$delegatedProperties[0])).intValue();
    }

    private final void setInterceptorsQuantity(int n) {
        this.interceptorsQuantity$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)n);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PipelinePhase> getItems() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.phasesRaw;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            PipelinePhase pipelinePhase = it instanceof PipelinePhase ? (PipelinePhase)it : null;
            if (pipelinePhase == null) {
                PhaseContent phaseContent = it instanceof PhaseContent ? (PhaseContent)it : null;
                PipelinePhase pipelinePhase2 = phaseContent == null ? null : phaseContent.getPhase();
                pipelinePhase = pipelinePhase2;
                Intrinsics.checkNotNull((Object)pipelinePhase2);
            }
            collection.add(pipelinePhase);
        }
        return (List)destination$iv$iv;
    }

    public final boolean isEmpty() {
        return this.getInterceptorsQuantity() == 0;
    }

    @InternalAPI
    public static /* synthetic */ void isEmpty$annotations() {
    }

    private final List<Function3<PipelineContext<TSubject, TContext>, TSubject, Continuation<? super Unit>, Object>> getInterceptors() {
        return (List)this._interceptors;
    }

    private final void setInterceptors(List<? extends Function3<? super PipelineContext<TSubject, TContext>, ? super TSubject, ? super Continuation<? super Unit>, ? extends Object>> value) {
        this._interceptors = value;
    }

    private final boolean getInterceptorsListShared() {
        return (Boolean)this.interceptorsListShared$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    private final void setInterceptorsListShared(boolean bl) {
        this.interceptorsListShared$delegate.setValue((Object)this, $$delegatedProperties[1], (Object)bl);
    }

    private final PipelinePhase getInterceptorsListSharedPhase() {
        return (PipelinePhase)this.interceptorsListSharedPhase$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    private final void setInterceptorsListSharedPhase(PipelinePhase pipelinePhase) {
        this.interceptorsListSharedPhase$delegate.setValue((Object)this, $$delegatedProperties[2], (Object)pipelinePhase);
    }

    public Pipeline(@NotNull PipelinePhase phase, @NotNull List<? extends Function3<? super PipelineContext<TSubject, TContext>, ? super TSubject, ? super Continuation<? super Unit>, ? extends Object>> interceptors) {
        Intrinsics.checkNotNullParameter((Object)phase, (String)"phase");
        Intrinsics.checkNotNullParameter(interceptors, (String)"interceptors");
        PipelinePhase[] pipelinePhaseArray = new PipelinePhase[]{phase};
        this(pipelinePhaseArray);
        Iterable $this$forEach$iv = interceptors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function3 it = (Function3)element$iv;
            boolean bl = false;
            this.intercept(phase, it);
        }
    }

    @Nullable
    public final Object execute(@NotNull TContext context, @NotNull TSubject subject, @NotNull Continuation<? super TSubject> $completion) {
        return this.createContext(context, subject, $completion.getContext()).execute(subject, $completion);
    }

    public final void addPhase(@NotNull PipelinePhase phase) {
        Intrinsics.checkNotNullParameter((Object)phase, (String)"phase");
        if (this.hasPhase(phase)) {
            return;
        }
        this.phasesRaw.add(phase);
    }

    public final void insertPhaseAfter(@NotNull PipelinePhase reference, @NotNull PipelinePhase phase) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Intrinsics.checkNotNullParameter((Object)phase, (String)"phase");
        if (this.hasPhase(phase)) {
            return;
        }
        int index = this.findPhaseIndex(reference);
        if (index == -1) {
            throw new InvalidPhaseException("Phase " + reference + " was not registered for this pipeline");
        }
        int lastRelatedPhaseIndex = index;
        int n = index + 1;
        int n2 = CollectionsKt.getLastIndex(this.phasesRaw);
        if (n <= n2) {
            int i;
            do {
                Object object;
                PhaseContent phaseContent = (object = this.phasesRaw.get(i = n++)) instanceof PhaseContent ? (PhaseContent)object : null;
                PipelinePhaseRelation pipelinePhaseRelation = phaseContent == null ? null : phaseContent.getRelation();
                if (pipelinePhaseRelation == null) break;
                PipelinePhaseRelation relation = pipelinePhaseRelation;
                PipelinePhaseRelation.After after = relation instanceof PipelinePhaseRelation.After ? (PipelinePhaseRelation.After)relation : null;
                PipelinePhase pipelinePhase = after == null ? null : after.getRelativeTo();
                if (pipelinePhase == null) continue;
                PipelinePhase relatedTo = pipelinePhase;
                int n3 = lastRelatedPhaseIndex = Intrinsics.areEqual((Object)relatedTo, (Object)reference) ? i : lastRelatedPhaseIndex;
            } while (i != n2);
        }
        this.phasesRaw.add(lastRelatedPhaseIndex + 1, new PhaseContent(phase, new PipelinePhaseRelation.After(reference)));
    }

    public final void insertPhaseBefore(@NotNull PipelinePhase reference, @NotNull PipelinePhase phase) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Intrinsics.checkNotNullParameter((Object)phase, (String)"phase");
        if (this.hasPhase(phase)) {
            return;
        }
        int index = this.findPhaseIndex(reference);
        if (index == -1) {
            throw new InvalidPhaseException("Phase " + reference + " was not registered for this pipeline");
        }
        this.phasesRaw.add(index, new PhaseContent(phase, new PipelinePhaseRelation.Before(reference)));
    }

    public final void intercept(@NotNull PipelinePhase phase, @NotNull Function3<? super PipelineContext<TSubject, TContext>, ? super TSubject, ? super Continuation<? super Unit>, ? extends Object> block) {
        Intrinsics.checkNotNullParameter((Object)phase, (String)"phase");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        PhaseContent<? super TSubject, TContext> phaseContent = this.findPhase(phase);
        if (phaseContent == null) {
            throw new InvalidPhaseException("Phase " + phase + " was not registered for this pipeline");
        }
        PhaseContent<? super TSubject, TContext> phaseContent2 = phaseContent;
        if (this.tryAddToPhaseFastPath(phase, block)) {
            int n = this.getInterceptorsQuantity();
            this.setInterceptorsQuantity(n + 1);
            return;
        }
        phaseContent2.addInterceptor(block);
        int n = this.getInterceptorsQuantity();
        this.setInterceptorsQuantity(n + 1);
        this.resetInterceptorsList();
        this.afterIntercepted();
    }

    public void afterIntercepted() {
    }

    public final void merge(@NotNull Pipeline<TSubject, TContext> from) {
        Intrinsics.checkNotNullParameter(from, (String)"from");
        if (this.fastPathMerge(from)) {
            return;
        }
        if (this.getInterceptorsQuantity() == 0) {
            this.setInterceptorsListFromAnotherPipeline(from);
        } else {
            this.resetInterceptorsList();
        }
        List<Object> fromPhases = from.phasesRaw;
        List toInsert = CollectionsKt.toMutableList((Collection)fromPhases);
        while (!((Collection)toInsert).isEmpty()) {
            Iterator iterator2 = toInsert.iterator();
            while (iterator2.hasNext()) {
                PipelinePhase fromPhase;
                Object fromPhaseOrContent = iterator2.next();
                PipelinePhase pipelinePhase = fromPhaseOrContent instanceof PipelinePhase ? (PipelinePhase)fromPhaseOrContent : null;
                PipelinePhase pipelinePhase2 = fromPhase = pipelinePhase == null ? ((PhaseContent)fromPhaseOrContent).getPhase() : pipelinePhase;
                if (this.hasPhase(fromPhase)) {
                    iterator2.remove();
                } else {
                    boolean inserted = this.insertRelativePhase(fromPhaseOrContent, fromPhase);
                    if (!inserted) continue;
                    iterator2.remove();
                }
                if (!(fromPhaseOrContent instanceof PhaseContent) || ((PhaseContent)fromPhaseOrContent).isEmpty()) continue;
                PhaseContent cfr_ignored_0 = (PhaseContent)fromPhaseOrContent;
                PhaseContent phaseContent = (PhaseContent)fromPhaseOrContent;
                PhaseContent<TSubject, TContext> phaseContent2 = this.findPhase(fromPhase);
                Intrinsics.checkNotNull(phaseContent2);
                phaseContent.addTo(phaseContent2);
                this.setInterceptorsQuantity(this.getInterceptorsQuantity() + ((PhaseContent)fromPhaseOrContent).getSize());
            }
        }
    }

    @NotNull
    public final List<Function3<PipelineContext<TSubject, TContext>, TSubject, Continuation<? super Unit>, Object>> phaseInterceptors$ktor_utils(@NotNull PipelinePhase phase) {
        Intrinsics.checkNotNullParameter((Object)phase, (String)"phase");
        PhaseContent<TSubject, TContext> phaseContent = this.findPhase(phase);
        List list = phaseContent == null ? null : phaseContent.sharedInterceptors();
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public final List<Function3<PipelineContext<TSubject, TContext>, TSubject, Continuation<? super Unit>, Object>> interceptorsForTests$ktor_utils() {
        List<Function3<PipelineContext<TSubject, TContext>, TSubject, Continuation<Unit>, Object>> list = this.getInterceptors();
        if (list == null) {
            list = this.cacheInterceptors();
        }
        return list;
    }

    private final PipelineExecutor<TSubject> createContext(TContext context, TSubject subject, CoroutineContext coroutineContext) {
        return PipelineContextKt.pipelineExecutorFor(context, this.sharedInterceptorsList(), subject, coroutineContext, this.getDevelopmentMode());
    }

    private final PhaseContent<TSubject, TContext> findPhase(PipelinePhase phase) {
        List<Object> phasesList = this.phasesRaw;
        int n = 0;
        int n2 = phasesList.size();
        while (n < n2) {
            int index;
            Object current;
            if ((current = phasesList.get(index = n++)) == phase) {
                PhaseContent content = new PhaseContent(phase, PipelinePhaseRelation.Last.INSTANCE);
                phasesList.set(index, content);
                return content;
            }
            if (!(current instanceof PhaseContent) || ((PhaseContent)current).getPhase() != phase) continue;
            return (PhaseContent)current;
        }
        return null;
    }

    private final int findPhaseIndex(PipelinePhase phase) {
        List<Object> phasesList = this.phasesRaw;
        int n = 0;
        int n2 = phasesList.size();
        while (n < n2) {
            int index;
            Object current;
            if ((current = phasesList.get(index = n++)) != phase && (!(current instanceof PhaseContent) || ((PhaseContent)current).getPhase() != phase)) continue;
            return index;
        }
        return -1;
    }

    private final boolean hasPhase(PipelinePhase phase) {
        List<Object> phasesList = this.phasesRaw;
        int n = 0;
        int n2 = phasesList.size();
        while (n < n2) {
            int index;
            Object current;
            if ((current = phasesList.get(index = n++)) != phase && (!(current instanceof PhaseContent) || ((PhaseContent)current).getPhase() != phase)) continue;
            return true;
        }
        return false;
    }

    private final List<Function3<PipelineContext<TSubject, TContext>, TSubject, Continuation<? super Unit>, Object>> cacheInterceptors() {
        Object object;
        int n;
        int n2;
        int interceptorsQuantity = this.getInterceptorsQuantity();
        if (interceptorsQuantity == 0) {
            this.notSharedInterceptorsList(CollectionsKt.emptyList());
            return CollectionsKt.emptyList();
        }
        List<Object> phases = this.phasesRaw;
        if (interceptorsQuantity == 1 && (n2 = 0) <= (n = CollectionsKt.getLastIndex(phases))) {
            int phaseIndex;
            do {
                PhaseContent phaseContent;
                PhaseContent phaseContent2 = (object = phases.get(phaseIndex = n2++)) instanceof PhaseContent ? (PhaseContent)object : null;
                if (phaseContent2 == null || (phaseContent = phaseContent2).isEmpty()) continue;
                List<Function3<PipelineContext<TSubject, TContext>, TSubject, Continuation<? super Unit>, Object>> interceptors = phaseContent.sharedInterceptors();
                this.setInterceptorsListFromPhase(phaseContent);
                return interceptors;
            } while (phaseIndex != n);
        }
        List destination = CollectionUtilsKt.sharedListOf(new Function3[0]);
        n = 0;
        int n3 = CollectionsKt.getLastIndex(phases);
        if (n <= n3) {
            int phaseIndex;
            do {
                Object object2;
                Object object3 = object = (object2 = phases.get(phaseIndex = n++)) instanceof PhaseContent ? (PhaseContent)object2 : null;
                if (object == null) continue;
                Object phase = object;
                ((PhaseContent)phase).addTo(destination);
            } while (phaseIndex != n3);
        }
        this.notSharedInterceptorsList(destination);
        return destination;
    }

    private final boolean fastPathMerge(Pipeline<TSubject, TContext> from) {
        if (from.phasesRaw.isEmpty()) {
            return true;
        }
        if (!((Collection)this.phasesRaw).isEmpty()) {
            return false;
        }
        int n = 0;
        List<Object> fromPhases = from.phasesRaw;
        int n2 = CollectionsKt.getLastIndex(fromPhases);
        if (n <= n2) {
            int index;
            do {
                Object fromPhaseOrContent;
                if ((fromPhaseOrContent = fromPhases.get(index = n++)) instanceof PipelinePhase) {
                    this.phasesRaw.add(fromPhaseOrContent);
                    continue;
                }
                if (!(fromPhaseOrContent instanceof PhaseContent)) continue;
                PhaseContent cfr_ignored_0 = (PhaseContent)fromPhaseOrContent;
                this.phasesRaw.add(new PhaseContent(((PhaseContent)fromPhaseOrContent).getPhase(), ((PhaseContent)fromPhaseOrContent).getRelation(), ((PhaseContent)fromPhaseOrContent).sharedInterceptors()));
            } while (index != n2);
        }
        this.setInterceptorsQuantity(this.getInterceptorsQuantity() + super.getInterceptorsQuantity());
        this.setInterceptorsListFromAnotherPipeline(from);
        return true;
    }

    private final List<Function3<PipelineContext<TSubject, TContext>, TSubject, Continuation<? super Unit>, Object>> sharedInterceptorsList() {
        if (this.getInterceptors() == null) {
            this.cacheInterceptors();
        }
        this.setInterceptorsListShared(true);
        List<Function3<PipelineContext<TSubject, TContext>, TSubject, Continuation<? super Unit>, Object>> list = this.getInterceptors();
        Intrinsics.checkNotNull(list);
        return list;
    }

    private final void resetInterceptorsList() {
        this.setInterceptors(null);
        this.setInterceptorsListShared(false);
        this.setInterceptorsListSharedPhase(null);
    }

    private final void notSharedInterceptorsList(List<? extends Function3<? super PipelineContext<TSubject, TContext>, ? super TSubject, ? super Continuation<? super Unit>, ? extends Object>> list) {
        this.setInterceptors(list);
        this.setInterceptorsListShared(false);
        this.setInterceptorsListSharedPhase(null);
    }

    private final void setInterceptorsListFromPhase(PhaseContent<TSubject, TContext> phaseContent) {
        this.setInterceptors(phaseContent.sharedInterceptors());
        this.setInterceptorsListShared(false);
        this.setInterceptorsListSharedPhase(phaseContent.getPhase());
    }

    private final void setInterceptorsListFromAnotherPipeline(Pipeline<TSubject, TContext> pipeline) {
        this.setInterceptors(super.sharedInterceptorsList());
        this.setInterceptorsListShared(true);
        this.setInterceptorsListSharedPhase(null);
    }

    private final boolean tryAddToPhaseFastPath(PipelinePhase phase, Function3<? super PipelineContext<TSubject, TContext>, ? super TSubject, ? super Continuation<? super Unit>, ? extends Object> block) {
        List<Function3<PipelineContext<TSubject, TContext>, TSubject, Continuation<Unit>, Object>> currentInterceptors = this.getInterceptors();
        if (this.phasesRaw.isEmpty() || currentInterceptors == null) {
            return false;
        }
        if (this.getInterceptorsListShared() || !TypeIntrinsics.isMutableList(currentInterceptors)) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.getInterceptorsListSharedPhase(), (Object)phase)) {
            currentInterceptors.add(block);
            return true;
        }
        if (Intrinsics.areEqual((Object)phase, (Object)CollectionsKt.last(this.phasesRaw)) || this.findPhaseIndex(phase) == CollectionsKt.getLastIndex(this.phasesRaw)) {
            PhaseContent<? super TSubject, TContext> phaseContent = this.findPhase(phase);
            Intrinsics.checkNotNull(phaseContent);
            phaseContent.addInterceptor(block);
            currentInterceptors.add(block);
            return true;
        }
        return false;
    }

    private final boolean insertRelativePhase(Object fromPhaseOrContent, PipelinePhase fromPhase) {
        PipelinePhaseRelation fromPhaseRelation = fromPhaseOrContent == fromPhase ? (PipelinePhaseRelation)PipelinePhaseRelation.Last.INSTANCE : ((PhaseContent)fromPhaseOrContent).getRelation();
        if (fromPhaseRelation instanceof PipelinePhaseRelation.Last) {
            this.addPhase(fromPhase);
        } else if (fromPhaseRelation instanceof PipelinePhaseRelation.Before && this.hasPhase(((PipelinePhaseRelation.Before)fromPhaseRelation).getRelativeTo())) {
            this.insertPhaseBefore(((PipelinePhaseRelation.Before)fromPhaseRelation).getRelativeTo(), fromPhase);
        } else if (fromPhaseRelation instanceof PipelinePhaseRelation.After) {
            this.insertPhaseAfter(((PipelinePhaseRelation.After)fromPhaseRelation).getRelativeTo(), fromPhase);
        } else {
            return false;
        }
        return true;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Pipeline.class, "interceptorsQuantity", "getInterceptorsQuantity()I", 0))), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Pipeline.class, "interceptorsListShared", "getInterceptorsListShared()Z", 0))), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Pipeline.class, "interceptorsListSharedPhase", "getInterceptorsListSharedPhase()Lio/ktor/util/pipeline/PipelinePhase;", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

