/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.csparsej.tdcomplex;

import edu.emory.mathcs.csparsej.tdcomplex.DZcs_common;
import edu.emory.mathcs.csparsej.tdcomplex.DZcs_complex;
import edu.emory.mathcs.csparsej.tdcomplex.DZcs_spsolve;
import edu.emory.mathcs.csparsej.tdcomplex.DZcs_util;

public class DZcs_lu {
    public static DZcs_common.DZcsn cs_lu(DZcs_common.DZcs A, DZcs_common.DZcss S, double tol) {
        int p;
        int[] Li;
        int k;
        int i;
        DZcs_common.DZcs U;
        DZcs_common.DZcs L;
        DZcs_common.DZcsa Lx = new DZcs_common.DZcsa();
        DZcs_common.DZcsa Ux = new DZcs_common.DZcsa();
        if (!DZcs_util.CS_CSC(A) || S == null) {
            return null;
        }
        int n = A.n;
        int[] q = S.q;
        int lnz = S.lnz;
        int unz = S.unz;
        DZcs_common.DZcsa x = new DZcs_common.DZcsa(n);
        int[] xi = new int[2 * n];
        DZcs_common.DZcsn N = new DZcs_common.DZcsn();
        N.L = L = DZcs_util.cs_spalloc(n, n, lnz, true, false);
        N.U = U = DZcs_util.cs_spalloc(n, n, unz, true, false);
        int[] pinv = new int[n];
        N.pinv = pinv;
        int[] Lp = L.p;
        int[] Up = U.p;
        for (i = 0; i < n; ++i) {
            x.set(i, DZcs_complex.cs_czero());
        }
        for (i = 0; i < n; ++i) {
            pinv[i] = -1;
        }
        for (k = 0; k <= n; ++k) {
            Lp[k] = 0;
        }
        unz = 0;
        lnz = 0;
        for (k = 0; k < n; ++k) {
            Lp[k] = lnz;
            Up[k] = unz;
            if (lnz + n > L.nzmax) {
                DZcs_util.cs_sprealloc(L, 2 * L.nzmax + n);
            }
            if (unz + n > U.nzmax) {
                DZcs_util.cs_sprealloc(U, 2 * U.nzmax + n);
            }
            Li = L.i;
            Lx.x = L.x;
            int[] Ui = U.i;
            Ux.x = U.x;
            int col = q != null ? q[k] : k;
            int top = DZcs_spsolve.cs_spsolve(L, A, col, xi, x, pinv, true);
            int ipiv = -1;
            double a = -1.0;
            for (p = top; p < n; ++p) {
                i = xi[p];
                if (pinv[i] < 0) {
                    double d;
                    double t = DZcs_complex.cs_cabs(x.get(i));
                    if (!(d > a)) continue;
                    a = t;
                    ipiv = i;
                    continue;
                }
                Ui[unz] = pinv[i];
                Ux.set(unz++, x.get(i));
            }
            if (ipiv == -1 || a <= 0.0) {
                return DZcs_util.cs_ndone(N, null, xi, x, false);
            }
            if (pinv[col] < 0 && DZcs_complex.cs_cabs(x.get(col)) >= a * tol) {
                ipiv = col;
            }
            double[] pivot = x.get(ipiv);
            Ui[unz] = k;
            Ux.set(unz++, pivot);
            pinv[ipiv] = k;
            Li[lnz] = ipiv;
            Lx.set(lnz++, DZcs_complex.cs_cone());
            for (p = top; p < n; ++p) {
                i = xi[p];
                if (pinv[i] < 0) {
                    Li[lnz] = i;
                    Lx.set(lnz++, DZcs_complex.cs_cdiv(x.get(i), pivot));
                }
                x.set(i, DZcs_complex.cs_czero());
            }
        }
        Lp[n] = lnz;
        Up[n] = unz;
        Li = L.i;
        for (p = 0; p < lnz; ++p) {
            Li[p] = pinv[Li[p]];
        }
        DZcs_util.cs_sprealloc(L, 0);
        DZcs_util.cs_sprealloc(U, 0);
        return DZcs_util.cs_ndone(N, null, xi, x, true);
    }
}

