/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.csparsej.tfloat.demo;

import edu.emory.mathcs.csparsej.tfloat.Scs_add;
import edu.emory.mathcs.csparsej.tfloat.Scs_chol;
import edu.emory.mathcs.csparsej.tfloat.Scs_cholsol;
import edu.emory.mathcs.csparsej.tfloat.Scs_common;
import edu.emory.mathcs.csparsej.tfloat.Scs_compress;
import edu.emory.mathcs.csparsej.tfloat.Scs_dmperm;
import edu.emory.mathcs.csparsej.tfloat.Scs_droptol;
import edu.emory.mathcs.csparsej.tfloat.Scs_dropzeros;
import edu.emory.mathcs.csparsej.tfloat.Scs_dupl;
import edu.emory.mathcs.csparsej.tfloat.Scs_fkeep;
import edu.emory.mathcs.csparsej.tfloat.Scs_gaxpy;
import edu.emory.mathcs.csparsej.tfloat.Scs_ifkeep;
import edu.emory.mathcs.csparsej.tfloat.Scs_ipvec;
import edu.emory.mathcs.csparsej.tfloat.Scs_load;
import edu.emory.mathcs.csparsej.tfloat.Scs_lsolve;
import edu.emory.mathcs.csparsej.tfloat.Scs_ltsolve;
import edu.emory.mathcs.csparsej.tfloat.Scs_lusol;
import edu.emory.mathcs.csparsej.tfloat.Scs_multiply;
import edu.emory.mathcs.csparsej.tfloat.Scs_norm;
import edu.emory.mathcs.csparsej.tfloat.Scs_permute;
import edu.emory.mathcs.csparsej.tfloat.Scs_pinv;
import edu.emory.mathcs.csparsej.tfloat.Scs_pvec;
import edu.emory.mathcs.csparsej.tfloat.Scs_qrsol;
import edu.emory.mathcs.csparsej.tfloat.Scs_schol;
import edu.emory.mathcs.csparsej.tfloat.Scs_transpose;
import edu.emory.mathcs.csparsej.tfloat.Scs_updown;
import edu.emory.mathcs.csparsej.tfloat.Scs_util;
import java.util.Random;

public class Scs_demo {
    private static int is_sym(Scs_common.Scs A) {
        int n = A.n;
        int m = A.m;
        int[] Ap = A.p;
        int[] Ai = A.i;
        if (m != n) {
            return 0;
        }
        boolean is_upper = true;
        boolean is_lower = true;
        for (int j = 0; j < n; ++j) {
            for (int p = Ap[j]; p < Ap[j + 1]; ++p) {
                if (Ai[p] > j) {
                    is_upper = false;
                }
                if (Ai[p] >= j) continue;
                is_lower = false;
            }
        }
        return is_upper ? 1 : (is_lower ? -1 : 0);
    }

    private static Scs_common.Scs make_sym(Scs_common.Scs A) {
        Scs_common.Scs AT = Scs_transpose.cs_transpose(A, true);
        Scs_fkeep.cs_fkeep(AT, new Dropdiag(), null);
        Scs_common.Scs C = Scs_add.cs_add(A, AT, 1.0f, 1.0f);
        return C;
    }

    private static void rhs(float[] x, float[] b, int m) {
        int i;
        for (i = 0; i < m; ++i) {
            b[i] = 1.0f + (float)i / (float)m;
        }
        for (i = 0; i < m; ++i) {
            x[i] = b[i];
        }
    }

    private static float norm(float[] x, int n) {
        float normx = 0.0f;
        for (int i = 0; i < n; ++i) {
            normx = Math.max(normx, Math.abs(x[i]));
        }
        return normx;
    }

    private static void print_resid(boolean ok, Scs_common.Scs A, float[] x, float[] b, float[] resid) {
        if (!ok) {
            System.out.print("    (failed)\n");
            return;
        }
        int m = A.m;
        int n = A.n;
        for (int i = 0; i < m; ++i) {
            resid[i] = -b[i];
        }
        Scs_gaxpy.cs_gaxpy(A, x, resid);
        System.out.print(String.format("resid: %8.2e\n", Float.valueOf(Scs_demo.norm(resid, m) / (n == 0 ? 1.0f : Scs_norm.cs_norm(A) * Scs_demo.norm(x, n) + Scs_demo.norm(b, m)))));
    }

    private static float tic() {
        return System.nanoTime();
    }

    private static float toc(float t) {
        float s = Scs_demo.tic();
        return Math.max(0.0f, s - t) / 1000000.0f;
    }

    private static void print_order(int order) {
        switch (order) {
            case 0: {
                System.out.print("natural    ");
                break;
            }
            case 1: {
                System.out.print("amd(A+A')  ");
                break;
            }
            case 2: {
                System.out.print("amd(S'*S)  ");
                break;
            }
            case 3: {
                System.out.print("amd(A'*A)  ");
            }
        }
    }

    public static Sproblem get_problem(String fileName, float tol) {
        int sym;
        Scs_common.Scs A;
        Sproblem Prob = new Sproblem();
        Scs_common.Scs T = Scs_load.cs_load(fileName);
        Prob.A = A = Scs_compress.cs_compress(T);
        T = null;
        Scs_dupl.cs_dupl(A);
        Prob.sym = sym = Scs_demo.is_sym(A);
        int m = A.m;
        int n = A.n;
        int mn = Math.max(m, n);
        int nz1 = A.p[n];
        Scs_dropzeros.cs_dropzeros(A);
        int nz2 = A.p[n];
        if (tol > 0.0f) {
            Scs_droptol.cs_droptol(A, tol);
        }
        Scs_common.Scs C = sym != 0 ? Scs_demo.make_sym(A) : A;
        Prob.C = C;
        if (C == null) {
            return null;
        }
        System.out.print(String.format("\n--- Matrix: %d-by-%d, nnz: %d (sym: %d: nnz %d), norm: %8.2e\n", m, n, A.p[n], sym, sym != 0 ? C.p[n] : 0, Float.valueOf(Scs_norm.cs_norm(C))));
        if (nz1 != nz2) {
            System.out.print(String.format("zero entries dropped: %d\n", nz1 - nz2));
        }
        if (nz2 != A.p[n]) {
            System.out.print(String.format("tiny entries dropped: %d\n", nz2 - A.p[n]));
        }
        Prob.b = new float[mn];
        Prob.x = new float[mn];
        Prob.resid = new float[mn];
        return Prob;
    }

    public static boolean demo2(Sproblem Prob) {
        boolean ok;
        float t;
        int order;
        if (Prob == null) {
            return false;
        }
        Scs_common.Scs A = Prob.A;
        Scs_common.Scs C = Prob.C;
        float[] b = Prob.b;
        float[] x = Prob.x;
        float[] resid = Prob.resid;
        int m = A.m;
        int n = A.n;
        float tol = Prob.sym != 0 ? 0.001f : 1.0f;
        Scs_common.Scsd D = Scs_dmperm.cs_dmperm(C, 1);
        if (D == null) {
            return false;
        }
        int nb = D.nb;
        int[] r = D.r;
        int[] s = D.s;
        int[] rr = D.rr;
        int sprank = rr[3];
        int ns = 0;
        for (int k = 0; k < nb; ++k) {
            if (r[k + 1] != r[k] + 1 || s[k + 1] != s[k] + 1) continue;
            ++ns;
        }
        System.out.print(String.format("blocks: %d singletons: %d structural rank: %d\n", nb, ns, sprank));
        D = null;
        for (order = 0; order <= 3; order += 3) {
            if (order == 0 && m > 1000) continue;
            System.out.print("QR   ");
            Scs_demo.print_order(order);
            Scs_demo.rhs(x, b, m);
            t = Scs_demo.tic();
            ok = Scs_qrsol.cs_qrsol(order, C, x);
            System.out.print(String.format("time: %8.2f ms ", Float.valueOf(Scs_demo.toc(t))));
            Scs_demo.print_resid(ok, C, x, b, resid);
        }
        if (m != n || sprank < n) {
            return true;
        }
        for (order = 0; order <= 3; ++order) {
            if (order == 0 && m > 1000) continue;
            System.out.print("LU   ");
            Scs_demo.print_order(order);
            Scs_demo.rhs(x, b, m);
            t = Scs_demo.tic();
            ok = Scs_lusol.cs_lusol(order, C, x, tol);
            System.out.print(String.format("time: %8.2f ms ", Float.valueOf(Scs_demo.toc(t))));
            Scs_demo.print_resid(ok, C, x, b, resid);
        }
        if (Prob.sym == 0) {
            return true;
        }
        for (order = 0; order <= 1; ++order) {
            if (order == 0 && m > 1000) continue;
            System.out.print("Chol ");
            Scs_demo.print_order(order);
            Scs_demo.rhs(x, b, m);
            t = Scs_demo.tic();
            ok = Scs_cholsol.cs_cholsol(order, C, x);
            System.out.print(String.format("time: %8.2f ms ", Float.valueOf(Scs_demo.toc(t))));
            Scs_demo.print_resid(ok, C, x, b, resid);
        }
        return true;
    }

    public static boolean demo3(Sproblem Prob) {
        int p1;
        Scs_common.Scs W = null;
        Scs_common.Scs E = null;
        int[] p = null;
        float[] y = null;
        Scs_common.Scss S = null;
        Scs_common.Scsn N = null;
        if (Prob == null || Prob.sym == 0 || Prob.A.n == 0) {
            return false;
        }
        Scs_common.Scs A = Prob.A;
        Scs_common.Scs C = Prob.C;
        float[] b = Prob.b;
        float[] x = Prob.x;
        float[] resid = Prob.resid;
        int n = A.n;
        if (Prob.sym == 0 || n == 0) {
            return true;
        }
        Scs_demo.rhs(x, b, n);
        System.out.print("\nchol then update/downdate ");
        Scs_demo.print_order(1);
        y = new float[n];
        float t = Scs_demo.tic();
        S = Scs_schol.cs_schol(1, C);
        System.out.print(String.format("\nsymbolic chol time %8.2f ms\n", Float.valueOf(Scs_demo.toc(t))));
        t = Scs_demo.tic();
        N = Scs_chol.cs_chol(C, S);
        System.out.print(String.format("numeric  chol time %8.2f ms\n", Float.valueOf(Scs_demo.toc(t))));
        if (S == null || N == null) {
            return false;
        }
        t = Scs_demo.tic();
        Scs_ipvec.cs_ipvec(S.pinv, b, y, n);
        Scs_lsolve.cs_lsolve(N.L, y);
        Scs_ltsolve.cs_ltsolve(N.L, y);
        Scs_pvec.cs_pvec(S.pinv, y, x, n);
        System.out.print(String.format("solve    chol time %8.2f ms\n", Float.valueOf(Scs_demo.toc(t))));
        System.out.println("original: ");
        Scs_demo.print_resid(true, C, x, b, resid);
        int k = n / 2;
        W = Scs_util.cs_spalloc(n, 1, n, true, false);
        int[] Lp = N.L.p;
        int[] Li = N.L.i;
        float[] Lx = N.L.x;
        int[] Wp = W.p;
        int[] Wi = W.i;
        float[] Wx = W.x;
        Wp[0] = 0;
        Wp[1] = Lp[k + 1] - p1;
        float s = Lx[p1];
        Random r = new Random(1L);
        for (p1 = Lp[k]; p1 < Lp[k + 1]; ++p1) {
            int p2 = p1 - Lp[k];
            Wi[p2] = Li[p1];
            Wx[p2] = s * r.nextFloat();
        }
        t = Scs_demo.tic();
        boolean ok = Scs_updown.cs_updown(N.L, 1, W, S.parent);
        float t1 = Scs_demo.toc(t);
        System.out.print(String.format("update:   time: %8.2f ms\n", Float.valueOf(t1)));
        if (!ok) {
            return false;
        }
        t = Scs_demo.tic();
        Scs_ipvec.cs_ipvec(S.pinv, b, y, n);
        Scs_lsolve.cs_lsolve(N.L, y);
        Scs_ltsolve.cs_ltsolve(N.L, y);
        Scs_pvec.cs_pvec(S.pinv, y, x, n);
        t = Scs_demo.toc(t);
        p = Scs_pinv.cs_pinv(S.pinv, n);
        Scs_common.Scs W2 = Scs_permute.cs_permute(W, p, null, true);
        Scs_common.Scs WT = Scs_transpose.cs_transpose(W2, true);
        Scs_common.Scs WW = Scs_multiply.cs_multiply(W2, WT);
        WT = null;
        W2 = null;
        E = Scs_add.cs_add(C, WW, 1.0f, 1.0f);
        WW = null;
        if (E == null || p == null) {
            return false;
        }
        System.out.print(String.format("update:   time: %8.2f ms(incl solve) ", Float.valueOf(t1 + t)));
        Scs_demo.print_resid(true, E, x, b, resid);
        N = null;
        t = Scs_demo.tic();
        N = Scs_chol.cs_chol(E, S);
        if (N == null) {
            return false;
        }
        Scs_ipvec.cs_ipvec(S.pinv, b, y, n);
        Scs_lsolve.cs_lsolve(N.L, y);
        Scs_ltsolve.cs_ltsolve(N.L, y);
        Scs_pvec.cs_pvec(S.pinv, y, x, n);
        t = Scs_demo.toc(t);
        System.out.print(String.format("rechol:   time: %8.2f ms(incl solve) ", Float.valueOf(t)));
        Scs_demo.print_resid(true, E, x, b, resid);
        t = Scs_demo.tic();
        ok = Scs_updown.cs_updown(N.L, -1, W, S.parent);
        t1 = Scs_demo.toc(t);
        if (!ok) {
            return false;
        }
        System.out.print(String.format("downdate: time: %8.2f\n", Float.valueOf(t1)));
        t = Scs_demo.tic();
        Scs_ipvec.cs_ipvec(S.pinv, b, y, n);
        Scs_lsolve.cs_lsolve(N.L, y);
        Scs_ltsolve.cs_ltsolve(N.L, y);
        Scs_pvec.cs_pvec(S.pinv, y, x, n);
        t = Scs_demo.toc(t);
        System.out.print(String.format("downdate: time: %8.2f ms(incl solve) ", Float.valueOf(t1 + t)));
        Scs_demo.print_resid(true, C, x, b, resid);
        return true;
    }

    private static class Dropdiag
    implements Scs_ifkeep {
        private Dropdiag() {
        }

        public boolean fkeep(int i, int j, float aij, Object other) {
            return i != j;
        }
    }

    public static class Sproblem {
        public Scs_common.Scs A;
        public Scs_common.Scs C;
        public int sym;
        public float[] x;
        public float[] b;
        public float[] resid;
    }
}

