/*
 * Decompiled with CFR 0.152.
 */
package smile.netlib;

import java.util.Arrays;
import org.netlib.util.doubleW;
import org.netlib.util.intW;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.math.Math;
import smile.math.matrix.DenseMatrix;
import smile.math.matrix.EVD;
import smile.math.matrix.Matrix;
import smile.netlib.NLMatrix;

public class ARPACK {
    private static final Logger logger = LoggerFactory.getLogger(ARPACK.class);
    private static final com.github.fommil.netlib.ARPACK arpack = com.github.fommil.netlib.ARPACK.getInstance();

    public static EVD eigen(Matrix A, int k, Ritz ritz) {
        return ARPACK.eigen(A, k, ritz, 1.0E-8, 10 * A.nrows());
    }

    public static EVD eigen(Matrix A, int k, String which) {
        return ARPACK.eigen(A, k, which, 1.0E-8, 10 * A.nrows());
    }

    public static EVD eigen(Matrix A, int k, Ritz ritz, double kappa, int maxIter) {
        return ARPACK.eigen(A, k, ritz.name(), kappa, maxIter);
    }

    public static EVD eigen(Matrix A, int k, String which, double kappa, int maxIter) {
        int iter;
        if (A.nrows() != A.ncols()) {
            throw new IllegalArgumentException(String.format("Matrix is not square: %d x %d", A.nrows(), A.ncols()));
        }
        if (!A.isSymmetric()) {
            throw new UnsupportedOperationException("This matrix is not symmetric.");
        }
        int n = A.nrows();
        if (k <= 0 || k >= n) {
            throw new IllegalArgumentException("Invalid NEV parameter k: " + k);
        }
        if (kappa <= Math.EPSILON) {
            throw new IllegalArgumentException("Invalid tolerance: kappa = " + kappa);
        }
        if (maxIter <= 0) {
            maxIter = 10 * A.nrows();
        }
        intW nev = new intW(k);
        int ncv = Math.min((int)(3 * k), (int)n);
        String bmat = "I";
        doubleW tol = new doubleW(kappa);
        intW info = new intW(0);
        int[] iparam = new int[11];
        iparam[0] = 1;
        iparam[2] = 300;
        iparam[6] = 1;
        intW ido = new intW(0);
        double[] resid = new double[n];
        double[] v = new double[n * ncv];
        double[] workd = new double[3 * n];
        double[] workl = new double[ncv * (ncv + 8)];
        int[] ipntr = new int[11];
        for (iter = 0; iter < maxIter; ++iter) {
            arpack.dsaupd(ido, bmat, n, which, nev.val, tol, resid, ncv, v, n, iparam, ipntr, workd, workl, workl.length, info);
            if (ido.val == 99) break;
            if (ido.val != -1 && ido.val != 1) {
                throw new IllegalStateException("ARPACK DSAUPD ido = " + ido.val);
            }
            ARPACK.av(A, workd, ipntr[0] - 1, ipntr[1] - 1);
        }
        logger.info("ARPACK: " + iter + " iterations for Matrix of size " + n);
        if (info.val != 0) {
            if (info.val == 1) {
                logger.info("ARPACK DSAUPD found all possible eigenvalues: {}", (Object)iparam[4]);
            } else {
                throw new IllegalStateException("ARPACK DSAUPD error code: " + info.val);
            }
        }
        double[] d = new double[nev.val];
        boolean[] select = new boolean[ncv];
        double[] z = Arrays.copyOfRange(v, 0, nev.val * n);
        arpack.dseupd(true, "A", select, d, z, n, 0.0, bmat, n, which, nev, tol.val, resid, ncv, v, n, iparam, ipntr, workd, workl, workl.length, info);
        if (info.val != 0) {
            throw new IllegalStateException("ARPACK DSEUPD error code: " + info.val);
        }
        int computed = iparam[4];
        logger.info("ARPACK computed " + computed + " eigenvalues");
        NLMatrix V = new NLMatrix(n, nev.val, z);
        NLMatrix.reverse(d, (DenseMatrix)V);
        return new EVD((DenseMatrix)V, d);
    }

    private static void av(Matrix A, double[] work, int inputOffset, int outputOffset) {
        int n = A.ncols();
        double[] x = new double[A.ncols()];
        System.arraycopy(work, inputOffset, x, 0, n);
        double[] y = new double[A.ncols()];
        A.ax(x, y);
        System.arraycopy(y, 0, work, outputOffset, n);
    }

    public static enum Ritz {
        LA,
        SA,
        LM,
        SM,
        BE;

    }
}

