/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.mapdb.CC;
import org.mapdb.DBException;
import org.mapdb.DataIO;
import org.mapdb.DataInput2;
import org.mapdb.volume.Volume;
import org.mapdb.volume.VolumeFactory;

public class WriteAheadLog {
    private static final Logger LOG = Logger.getLogger(WriteAheadLog.class.getName());
    protected static final int WAL_HEADER = 1241645056;
    protected static final long WAL_SEAL = 8234892392398238983L;
    protected static final int I_EOF = 0;
    protected static final int I_LONG = 1;
    protected static final int I_BYTE_ARRAY = 2;
    protected static final int I_SKIP_MANY = 3;
    protected static final int I_SKIP_SINGLE = 4;
    protected static final int I_RECORD = 5;
    protected static final int I_TOMBSTONE = 6;
    protected static final int I_PREALLOCATE = 7;
    protected static final int I_COMMIT = 8;
    protected static final int I_ROLLBACK = 9;
    protected static final long MAX_FILE_SIZE = 0x1000000L;
    protected static final long MAX_FILE_RESERVE = 16L;
    protected final long featureBitMap;
    protected final int pointerOffsetBites = 32;
    protected final long pointerOffsetMask = DataIO.fillLowBits(32);
    protected final int pointerSizeBites = 16;
    protected final long pointerSizeMask = DataIO.fillLowBits(16);
    protected final int pointerFileBites = 16;
    protected final long pointerFileMask = DataIO.fillLowBits(16);
    protected final boolean fileDeleteAfterOpen;
    protected int lastChecksum = 0;
    protected long lastChecksumOffset = 16L;
    public static final WALReplay NOREPLAY = new WALReplay(){

        @Override
        public void beforeReplayStart() {
        }

        @Override
        public void afterReplayFinished() {
        }

        @Override
        public void writeLong(long offset, long value) {
        }

        @Override
        public void writeRecord(long recid2, long walId, Volume vol, long volOffset, int length) {
        }

        @Override
        public void writeByteArray(long offset, long walId, Volume vol, long volOffset, int length) {
        }

        @Override
        public void commit() {
        }

        @Override
        public void rollback() {
        }

        @Override
        public void writeTombstone(long recid2) {
        }

        @Override
        public void writePreallocate(long recid2) {
        }
    };
    final String fileName;
    final VolumeFactory volumeFactory;
    protected volatile long fileOffset = 16L;
    protected ReentrantLock fileOffsetLock = new ReentrantLock(true);
    protected final List<Volume> volumes = Collections.synchronizedList(new ArrayList());
    protected final List<Volume> walRec = Collections.synchronizedList(new ArrayList());
    protected Volume curVol;
    protected long fileNum = -1L;

    public WriteAheadLog(String fileName, VolumeFactory volumeFactory, long featureBitMap, boolean fileDeleteAfterOpen) {
        this.fileName = fileName;
        this.volumeFactory = volumeFactory;
        this.featureBitMap = featureBitMap;
        this.fileDeleteAfterOpen = fileDeleteAfterOpen;
    }

    public WriteAheadLog(String fileName) {
        this(fileName, fileName == null ? CC.DEFAULT_MEMORY_VOLUME_FACTORY : CC.DEFAULT_FILE_VOLUME_FACTORY, 0L, false);
    }

    public void initFailedCloseFiles() {
        if (this.walRec != null) {
            for (Volume v : this.walRec) {
                if (v == null || v.isClosed()) continue;
                v.close();
            }
            this.walRec.clear();
        }
        if (this.volumes != null) {
            for (Volume v : this.volumes) {
                if (v == null || v.isClosed()) continue;
                v.close();
            }
            this.volumes.clear();
        }
    }

    public void close() {
        for (Volume v : this.walRec) {
            v.close();
        }
        this.walRec.clear();
        for (Volume v : this.volumes) {
            v.close();
        }
        this.volumes.clear();
        this.curVol = null;
    }

    public void seal() {
        this.ensureFileReady(false);
        long finalOffset = this.allocate(0, 1);
        this.curVol.ensureAvailable(finalOffset + 1L);
        this.curVol.putUnsignedByte(finalOffset, 0 | Long.bitCount(finalOffset) & 0xF);
        this.curVol.sync();
        this.curVol.putLong(8L, 8234892392398238983L);
        this.curVol.sync();
    }

    public void startNextFile() {
        ++this.fileNum;
        String filewal = this.getWalFileName("" + this.fileNum);
        Volume nextVol = this.volumeFactory.makeVolume(filewal, false, -1L);
        if (this.fileDeleteAfterOpen) {
            new File(filewal).delete();
        }
        nextVol.ensureAvailable(16L);
        nextVol.putInt(0L, 1241645056);
        nextVol.putLong(8L, this.featureBitMap);
        this.fileOffsetSet(16L);
        this.volumes.add(nextVol);
        this.lastChecksum = 0;
        this.lastChecksumOffset = 0L;
        this.curVol = nextVol;
    }

    public void rollback() {
        this.ensureFileReady(false);
        int plusSize = 5;
        long walOffset2 = this.allocate(5, 0);
        Volume curVol2 = this.curVol;
        curVol2.ensureAvailable(walOffset2 + 5L);
        if (this.lastChecksumOffset == 0L) {
            this.lastChecksumOffset = 16L;
        }
        int checksum = this.lastChecksum + this.checksum(curVol2, this.lastChecksumOffset, walOffset2);
        this.lastChecksumOffset = walOffset2 + 5L;
        this.lastChecksum = checksum;
        int parity = 1 + Long.bitCount(walOffset2) + Integer.bitCount(checksum);
        curVol2.putUnsignedByte(walOffset2, 0x90 | (parity &= 0xF));
        curVol2.putInt(++walOffset2, checksum);
        curVol2.sync();
    }

    public void commit() {
        this.ensureFileReady(false);
        int plusSize = 5;
        long walOffset2 = this.allocate(5, 0);
        Volume curVol2 = this.curVol;
        curVol2.ensureAvailable(walOffset2 + 5L);
        if (this.lastChecksumOffset == 0L) {
            this.lastChecksumOffset = 16L;
        }
        int checksum = this.lastChecksum + this.checksum(curVol2, this.lastChecksumOffset, walOffset2);
        this.lastChecksumOffset = walOffset2 + 5L;
        this.lastChecksum = checksum;
        int parity = 1 + Long.bitCount(walOffset2) + Integer.bitCount(checksum);
        curVol2.putUnsignedByte(walOffset2, 0x80 | (parity &= 0xF));
        curVol2.putInt(++walOffset2, checksum);
        curVol2.sync();
    }

    protected int checksum(Volume vol, long startOffset, long endOffset) {
        int ret2 = DataIO.longHash(vol.hash(startOffset, endOffset - startOffset, 111L));
        return ret2 == 0 ? 1 : ret2;
    }

    public boolean fileLoad() {
        boolean ret2 = false;
        for (Volume vol : this.volumes) {
            ret2 = vol.fileLoad();
        }
        return ret2;
    }

    public void sync() {
        this.curVol.sync();
    }

    @NotNull
    public Iterable<String> getAllFiles() {
        ArrayList<String> ret2 = new ArrayList<String>();
        for (Volume vol : this.volumes) {
            if (vol.getFile() == null) continue;
            ret2.add(vol.getFile().getPath());
        }
        return ret2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long allocate(int reqSize, int optSize) {
        if ((long)reqSize >= 0x100000L) {
            throw new AssertionError();
        }
        this.fileOffsetLock.lock();
        try {
            while (this.fileOffset >>> 20 != this.fileOffset + (long)reqSize >>> 20) {
                int singleByteSkip = 0x40 | Long.bitCount(this.fileOffset) & 0xF;
                this.curVol.putUnsignedByte(this.fileOffset, singleByteSkip);
                ++this.fileOffset;
            }
            long ret2 = this.fileOffset;
            this.fileOffset += (long)(reqSize + optSize);
            long l = ret2;
            return l;
        }
        finally {
            this.fileOffsetLock.unlock();
        }
    }

    protected void fileOffsetSet(long fileOffset) {
        this.fileOffsetLock.lock();
        try {
            this.fileOffset = fileOffset;
        }
        finally {
            this.fileOffsetLock.unlock();
        }
    }

    void open(WALReplay replay) {
        String wal0Name = this.getWalFileName("0");
        if (wal0Name != null && new File(wal0Name).exists()) {
            String wname;
            File wnameF;
            int i = 0;
            while ((wnameF = new File(wname = this.getWalFileName("" + i))).exists()) {
                this.volumes.add(this.volumeFactory.makeVolume(wname, false, -1L));
                if (this.fileDeleteAfterOpen) {
                    wnameF.delete();
                }
                ++i;
            }
            long walId = this.replayWALSkipRollbacks(replay);
            this.fileNum = this.walPointerToFileNum(walId);
            this.curVol = this.volumes.get((int)this.fileNum);
            this.fileOffsetSet(this.walPointerToOffset(walId));
            this.walRec.clear();
        }
    }

    long replayWALSkipRollbacks(WALReplay replay) {
        long start;
        replay.beforeReplayStart();
        long ret2 = start = this.skipRollbacks(16L);
        block12: while (start != 0L) {
            long fileNum2 = this.walPointerToFileNum(start);
            Volume wal = this.volumes.get((int)fileNum2);
            long pos = this.walPointerToOffset(start);
            ret2 = start;
            block13: while (true) {
                int checksum = wal.getUnsignedByte(pos++);
                int instruction = checksum >>> 4;
                checksum &= 0xF;
                switch (instruction) {
                    case 0: {
                        if ((Long.bitCount(pos - 1L) & 0xF) != checksum) {
                            throw new DBException.DataCorruption("WAL corrupted " + fileNum2 + " - " + pos);
                        }
                        start = this.walPointer(0L, fileNum2 + 1L, 16L);
                        continue block12;
                    }
                    case 1: {
                        pos = this.instLong(wal, pos, checksum, replay);
                        continue block13;
                    }
                    case 2: {
                        pos = this.instByteArray(wal, pos, checksum, fileNum2, replay);
                        continue block13;
                    }
                    case 3: {
                        int skipN = wal.getInt(pos - 1L) & 0xFFFFFF;
                        if ((Integer.bitCount(skipN) & 0xF) != checksum) {
                            throw new DBException.DataCorruption("WAL corrupted");
                        }
                        pos += (long)(3 + skipN);
                        continue block13;
                    }
                    case 4: {
                        if ((Long.bitCount(pos - 1L) & 0xF) == checksum) continue block13;
                        throw new DBException.DataCorruption("WAL corrupted");
                    }
                    case 5: {
                        pos = this.instRecord(wal, pos, checksum, fileNum2, replay);
                        continue block13;
                    }
                    case 6: {
                        pos = this.instTombstone(wal, pos, checksum, replay);
                        continue block13;
                    }
                    case 7: {
                        pos = this.instPreallocate(wal, pos, checksum, replay);
                        continue block13;
                    }
                    case 8: {
                        long currentPos;
                        int checksum2 = wal.getInt(pos);
                        if ((1 + Long.bitCount((pos += 4L) - 5L) + Integer.bitCount(checksum2) & 0xF) != checksum) {
                            throw new DBException.DataCorruption("WAL corrupted");
                        }
                        if (replay != null) {
                            replay.commit();
                        }
                        ret2 = currentPos = this.walPointer(0L, fileNum2, pos);
                        start = this.skipRollbacks(currentPos);
                        continue block12;
                    }
                    case 9: {
                        throw new DBException.DataCorruption("Rollback should be skipped");
                    }
                }
                break;
            }
            throw new DBException.DataCorruption("WAL corrupted, unknown instruction");
        }
        Volume vol = this.volumes.get((int)this.walPointerToFileNum(ret2));
        long offset = this.walPointerToOffset(ret2);
        if (offset != 0L && offset != vol.length()) {
            vol.clearOverlap(offset, vol.length());
            vol.sync();
        }
        replay.afterReplayFinished();
        return ret2;
    }

    /*
     * Exception decompiling
     */
    long skipRollbacks(long start) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[UNCONDITIONALDOLOOP], 15[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void replayWAL(WALReplay replay) {
        replay.beforeReplayStart();
        long fileNum2 = -1L;
        block12: for (Volume wal : this.volumes) {
            ++fileNum2;
            if (wal.length() < 16L) break;
            long pos = 16L;
            block13: while (true) {
                int checksum = wal.getUnsignedByte(pos++);
                int instruction = checksum >>> 4;
                checksum &= 0xF;
                switch (instruction) {
                    case 0: {
                        if ((Long.bitCount(pos - 1L) & 0xF) == checksum) continue block12;
                        throw new DBException.DataCorruption("WAL corrupted");
                    }
                    case 1: {
                        pos = this.instLong(wal, pos, checksum, replay);
                        continue block13;
                    }
                    case 2: {
                        pos = this.instByteArray(wal, pos, checksum, fileNum2, replay);
                        continue block13;
                    }
                    case 3: {
                        int skipN = wal.getInt(pos - 1L) & 0xFFFFFF;
                        if ((Integer.bitCount(skipN) & 0xF) != checksum) {
                            throw new DBException.DataCorruption("WAL corrupted");
                        }
                        pos += (long)(3 + skipN);
                        continue block13;
                    }
                    case 4: {
                        if ((Long.bitCount(pos - 1L) & 0xF) == checksum) continue block13;
                        throw new DBException.DataCorruption("WAL corrupted");
                    }
                    case 5: {
                        pos = this.instRecord(wal, pos, checksum, fileNum2, replay);
                        continue block13;
                    }
                    case 6: {
                        pos = this.instTombstone(wal, pos, checksum, replay);
                        continue block13;
                    }
                    case 7: {
                        pos = this.instPreallocate(wal, pos, checksum, replay);
                        continue block13;
                    }
                    case 8: {
                        int checksum2 = wal.getInt(pos);
                        if ((1 + Long.bitCount((pos += 4L) - 5L) + Integer.bitCount(checksum2) & 0xF) != checksum) {
                            throw new DBException.DataCorruption("WAL corrupted");
                        }
                        replay.commit();
                        continue block13;
                    }
                    case 9: {
                        int checksum2 = wal.getInt(pos);
                        if ((1 + Long.bitCount((pos += 4L) - 5L) + Integer.bitCount(checksum2) & 0xF) != checksum) {
                            throw new DBException.DataCorruption("WAL corrupted");
                        }
                        replay.rollback();
                        continue block13;
                    }
                }
                break;
            }
            throw new DBException.DataCorruption("WAL corrupted, unknown instruction");
        }
        replay.afterReplayFinished();
    }

    private long instTombstone(Volume wal, long pos, int checksum, WALReplay replay) {
        long recid2 = wal.getPackedLong(pos);
        pos += recid2 >>> 60;
        if ((1 + Long.bitCount(recid2 &= 0xFFFFFFFFFFFFFFFL) & 0xF) != checksum) {
            throw new DBException.DataCorruption("WAL corrupted");
        }
        if (replay != null) {
            replay.writeTombstone(recid2);
        }
        return pos;
    }

    private long instPreallocate(Volume wal, long pos, int checksum, WALReplay replay) {
        long recid2 = wal.getPackedLong(pos);
        pos += recid2 >>> 60;
        if ((1 + Long.bitCount(recid2 &= 0xFFFFFFFFFFFFFFFL) & 0xF) != checksum) {
            throw new DBException.DataCorruption("WAL corrupted: " + pos);
        }
        if (replay != null) {
            replay.writePreallocate(recid2);
        }
        return pos;
    }

    private long instRecord(Volume wal, long pos, int checksum, long fileNum2, WALReplay replay) {
        long pos2 = pos - 1L;
        long walId = this.walPointer(0L, fileNum2, pos2);
        long recid2 = wal.getPackedLong(pos);
        pos += recid2 >>> 60;
        long size2 = wal.getPackedLong(pos);
        pos += size2 >>> 60;
        if ((1 + Long.bitCount(recid2 &= 0xFFFFFFFFFFFFFFFL) + Long.bitCount(size2 &= 0xFFFFFFFFFFFFFFFL) + Long.bitCount(pos2) & 0xF) != checksum) {
            throw new DBException.DataCorruption("WAL corrupted");
        }
        if (size2 == 0L) {
            if (replay != null) {
                replay.writeRecord(recid2, 0L, null, 0L, 0);
            }
        } else {
            --size2;
            if (replay != null) {
                replay.writeRecord(recid2, walId, wal, pos, (int)size2);
            }
            pos += size2;
        }
        return pos;
    }

    private long instByteArray(Volume wal, long pos, int checksum, long fileNum2, WALReplay replay) {
        long walId = this.walPointer(0L, fileNum2, pos - 1L);
        int dataSize = wal.getUnsignedShort(pos);
        long offset = wal.getSixLong(pos += 2L);
        pos += 6L;
        if ((1 + Integer.bitCount(dataSize) + Long.bitCount(offset) & 0xF) != checksum) {
            throw new DBException.DataCorruption("WAL corrupted");
        }
        long val = this.fileNum << 32;
        val |= pos;
        if (replay != null) {
            replay.writeByteArray(offset, walId, wal, pos, dataSize);
        }
        return pos += (long)dataSize;
    }

    private long instLong(Volume wal, long pos, int checksum, WALReplay replay) {
        long val = wal.getLong(pos);
        long offset = wal.getSixLong(pos += 8L);
        pos += 6L;
        if ((1 + Long.bitCount(val) + Long.bitCount(offset) & 0xF) != checksum) {
            throw new DBException.DataCorruption("WAL corrupted");
        }
        if (replay != null) {
            replay.writeLong(offset, val);
        }
        return pos;
    }

    public void destroyWalFiles() {
        for (Volume wal : this.volumes) {
            if (!wal.isClosed()) {
                wal.truncate(0L);
                wal.close();
            }
            wal.deleteFile();
        }
        this.fileNum = -1L;
        this.curVol = null;
        this.volumes.clear();
    }

    protected String getWalFileName(String ext) {
        return this.fileName == null ? null : this.fileName + ".wal." + ext;
    }

    public long getNumberOfFiles() {
        return this.volumes.size();
    }

    public DataInput2 walGetByteArray(long walPointer) {
        int arraySize = this.walPointerToSize(walPointer);
        if (arraySize == 0) {
            throw new AssertionError();
        }
        int fileNum = (int)this.walPointerToFileNum(walPointer);
        long dataOffset = this.walPointerToOffset(walPointer);
        Volume vol = this.volumes.get(fileNum);
        return vol.getDataInput(dataOffset, arraySize);
    }

    public byte[] walGetByteArray2(long walPointer) {
        int arraySize = this.walPointerToSize(walPointer);
        long fileNum = this.walPointerToFileNum(walPointer);
        long dataOffset = this.walPointerToOffset(walPointer);
        Volume vol = this.volumes.get((int)fileNum);
        byte[] ret2 = new byte[arraySize];
        vol.getData(dataOffset, ret2, 0, arraySize);
        return ret2;
    }

    protected long walPointerToOffset(long walPointer) {
        return walPointer & this.pointerOffsetMask;
    }

    protected long walPointerToFileNum(long walPointer) {
        return walPointer >>> 32 & this.pointerFileMask;
    }

    protected int walPointerToSize(long walPointer) {
        return (int)(walPointer >>> 48 & this.pointerSizeMask);
    }

    public synchronized byte[] walGetRecord(long walPointer, long expectedRecid) {
        long fileNum = this.walPointerToFileNum(walPointer);
        long dataOffset = this.walPointerToOffset(walPointer);
        Volume vol = this.volumes.get((int)fileNum);
        long recid2 = vol.getPackedLong(++dataOffset);
        dataOffset += recid2 >>> 60;
        if (expectedRecid != 0L && (recid2 &= 0xFFFFFFFFFFFFFFFL) != expectedRecid) {
            throw new AssertionError();
        }
        long size2 = vol.getPackedLong(dataOffset);
        dataOffset += size2 >>> 60;
        if ((size2 &= 0xFFFFFFFFFFFFFFFL) == 0L) {
            return null;
        }
        if (size2 == 1L) {
            return new byte[0];
        }
        byte[] data = new byte[(int)(--size2)];
        DataInput2 in = vol.getDataInputOverlap(dataOffset, data.length);
        try {
            in.readFully(data);
        }
        catch (IOException e) {
            throw new DBException.VolumeIOError(e);
        }
        return data;
    }

    public long walPutByteArray(long offset, byte[] buf, int bufPos, int size2) {
        this.ensureFileReady(true);
        int plusSize = 9 + size2;
        long walOffset2 = this.allocate(plusSize, 0);
        this.curVol.ensureAvailable(walOffset2 + (long)plusSize);
        int checksum = 1 + Integer.bitCount(size2) + Long.bitCount(offset);
        this.curVol.putUnsignedByte(walOffset2, 0x20 | (checksum &= 0xF));
        ++walOffset2;
        if ((size2 & 0xFFFF) != size2) {
            throw new AssertionError();
        }
        this.curVol.putLong(walOffset2, (long)size2 << 48 | offset);
        this.curVol.putData(walOffset2 += 8L, buf, bufPos, size2);
        if (((long)size2 & this.pointerSizeMask) != (long)size2) {
            throw new AssertionError();
        }
        if ((this.fileNum & this.pointerFileMask) != this.fileNum) {
            throw new AssertionError();
        }
        if (this.walPointerToOffset(walOffset2) != walOffset2) {
            throw new AssertionError();
        }
        return this.walPointer(size2, this.fileNum, walOffset2);
    }

    protected long walPointer(long size2, long fileNum, long offset) {
        long val = size2 << 48;
        val |= fileNum << 32;
        if (offset != this.walPointerToOffset(val |= offset)) {
            throw new AssertionError();
        }
        if (fileNum != this.walPointerToOffset(fileNum)) {
            throw new AssertionError();
        }
        if (size2 != this.walPointerToOffset(size2)) {
            throw new AssertionError();
        }
        return val;
    }

    public synchronized long walPutRecord(long recid2, byte[] buf, int bufPos, int size2) {
        long walOffset2;
        if (buf == null && size2 != 0) {
            throw new AssertionError();
        }
        this.ensureFileReady(true);
        long sizeToWrite = buf == null ? 0L : (long)(size2 + 1);
        int plusSize = 1 + DataIO.packLongSize(recid2) + DataIO.packLongSize(sizeToWrite) + size2;
        long startPos = walOffset2 = this.allocate(plusSize - size2, size2);
        if (startPos >= 0x1000000L) {
            throw new AssertionError();
        }
        this.curVol.ensureAvailable(walOffset2 + (long)plusSize);
        int checksum = 1 + Long.bitCount(recid2) + Long.bitCount(sizeToWrite) + Long.bitCount(walOffset2);
        this.curVol.putUnsignedByte(walOffset2, 0x50 | (checksum &= 0xF));
        ++walOffset2;
        walOffset2 += (long)this.curVol.putPackedLong(walOffset2, recid2);
        walOffset2 += (long)this.curVol.putPackedLong(walOffset2, sizeToWrite);
        if (buf != null) {
            this.curVol.putDataOverlap(walOffset2, buf, bufPos, size2);
        }
        long ret2 = this.walPointer(0L, this.fileNum, startPos);
        return ret2;
    }

    public void walPutLong(long offset, long value) {
        this.ensureFileReady(false);
        int plusSize = 15;
        long walOffset2 = this.allocate(15, 0);
        Volume curVol2 = this.curVol;
        if (offset >>> 48 != 0L) {
            throw new DBException.DataCorruption("wrong offset");
        }
        curVol2.ensureAvailable(walOffset2 + 15L);
        int parity = 1 + Long.bitCount(value) + Long.bitCount(offset);
        curVol2.putUnsignedByte(walOffset2, 0x10 | (parity &= 0xF));
        curVol2.putLong(++walOffset2, value);
        curVol2.putSixLong(walOffset2 += 8L, offset);
    }

    protected void ensureFileReady(boolean addressable) {
        if (this.curVol == null) {
            this.startNextFile();
            return;
        }
        if (addressable && this.fileOffset + 16L > 0x1000000L) {
            this.seal();
            this.startNextFile();
        }
    }

    public void walPutTombstone(long recid2) {
        this.ensureFileReady(false);
        int plusSize = 1 + DataIO.packLongSize(recid2);
        long walOffset2 = this.allocate(plusSize, 0);
        Volume curVol2 = this.curVol;
        curVol2.ensureAvailable(walOffset2 + (long)plusSize);
        int checksum = 1 + Long.bitCount(recid2);
        curVol2.putUnsignedByte(walOffset2, 0x60 | (checksum &= 0xF));
        curVol2.putPackedLong(++walOffset2, recid2);
    }

    public void walPutPreallocate(long recid2) {
        this.ensureFileReady(false);
        int plusSize = 1 + DataIO.packLongSize(recid2);
        long walOffset2 = this.allocate(plusSize, 0);
        Volume curVol2 = this.curVol;
        curVol2.ensureAvailable(walOffset2 + (long)plusSize);
        int checksum = 1 + Long.bitCount(recid2);
        curVol2.putUnsignedByte(walOffset2, 0x70 | (checksum &= 0xF));
        curVol2.putPackedLong(++walOffset2, recid2);
    }

    public static interface WALReplay {
        public void beforeReplayStart();

        public void afterReplayFinished();

        public void writeLong(long var1, long var3);

        public void writeRecord(long var1, long var3, @NotNull Volume var5, long var6, int var8);

        public void writeByteArray(long var1, long var3, @NotNull Volume var5, long var6, int var8);

        public void commit();

        public void rollback();

        public void writeTombstone(long var1);

        public void writePreallocate(long var1);
    }
}

