/*
 * Decompiled with CFR 0.152.
 */
package com.joptimizer.algebra;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.colt.matrix.linalg.Property;
import com.joptimizer.algebra.MatrixRescaler;
import com.joptimizer.util.ColtUtils;
import com.joptimizer.util.Utils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.RealMatrix;

public class CholeskyFactorization {
    private int dim;
    private DoubleMatrix2D Q;
    private MatrixRescaler rescaler = null;
    private DoubleMatrix1D U;
    protected Algebra ALG = Algebra.DEFAULT;
    protected DoubleFactory2D F2 = DoubleFactory2D.dense;
    protected DoubleFactory1D F1 = DoubleFactory1D.dense;
    private double[][] LData;
    private DoubleMatrix2D L;
    private DoubleMatrix2D LT;
    private Log log = LogFactory.getLog((String)this.getClass().getName());

    public CholeskyFactorization(DoubleMatrix2D Q) throws Exception {
        this(Q, null);
    }

    public CholeskyFactorization(DoubleMatrix2D Q, MatrixRescaler rescaler) throws Exception {
        this.dim = Q.rows();
        this.Q = Q;
        this.rescaler = rescaler;
    }

    public void factorize() throws Exception {
        this.factorize(false);
    }

    public void factorize(boolean checkSymmetry) throws Exception {
        if (checkSymmetry && !Property.TWELVE.isSymmetric(this.Q)) {
            throw new Exception("Matrix is not symmetric");
        }
        if (this.rescaler != null) {
            boolean checkOK;
            double[] cn_00_original = null;
            double[] cn_2_original = null;
            double[] cn_00_scaled = null;
            double[] cn_2_scaled = null;
            if (this.log.isDebugEnabled()) {
                cn_00_original = ColtUtils.getConditionNumberRange((RealMatrix)new Array2DRowRealMatrix(ColtUtils.fillSubdiagonalSymmetricMatrix(this.Q).toArray()), Integer.MAX_VALUE);
                this.log.debug((Object)("cn_00_original Q before scaling: " + ArrayUtils.toString((Object)cn_00_original)));
                cn_2_original = ColtUtils.getConditionNumberRange((RealMatrix)new Array2DRowRealMatrix(ColtUtils.fillSubdiagonalSymmetricMatrix(this.Q).toArray()), 2);
                this.log.debug((Object)("cn_2_original Q before scaling : " + ArrayUtils.toString((Object)cn_2_original)));
            }
            DoubleMatrix1D Uv = this.rescaler.getMatrixScalingFactorsSymm(this.Q);
            if (this.log.isDebugEnabled() && !(checkOK = this.rescaler.checkScaling(ColtUtils.fillSubdiagonalSymmetricMatrix(this.Q), Uv, Uv))) {
                this.log.warn((Object)"Scaling failed (checkScaling = false)");
            }
            this.U = Uv;
            this.Q = ColtUtils.diagonalMatrixMult(Uv, this.Q, Uv);
            if (this.log.isDebugEnabled()) {
                cn_00_scaled = ColtUtils.getConditionNumberRange((RealMatrix)new Array2DRowRealMatrix(ColtUtils.fillSubdiagonalSymmetricMatrix(this.Q).toArray()), Integer.MAX_VALUE);
                this.log.debug((Object)("cn_00_scaled Q after scaling : " + ArrayUtils.toString((Object)cn_00_scaled)));
                cn_2_scaled = ColtUtils.getConditionNumberRange((RealMatrix)new Array2DRowRealMatrix(ColtUtils.fillSubdiagonalSymmetricMatrix(this.Q).toArray()), 2);
                this.log.debug((Object)("cn_2_scaled Q after scaling  : " + ArrayUtils.toString((Object)cn_2_scaled)));
                if (cn_00_original[0] < cn_00_scaled[0] || cn_2_original[0] < cn_2_scaled[0]) {
                    this.log.warn((Object)"Problematic scaling");
                }
            }
        }
        double threshold = Utils.getDoubleMachineEpsilon();
        this.LData = new double[this.dim][];
        for (int i = 0; i < this.dim; ++i) {
            this.LData[i] = new double[i + 1];
            double[] LDataI = this.LData[i];
            for (int j = 0; j < i; ++j) {
                double[] LDataJ = this.LData[j];
                double sum = 0.0;
                for (int k = 0; k < j; ++k) {
                    sum += LDataI[k] * LDataJ[k];
                }
                LDataI[j] = 1.0 / LDataJ[j] * (this.Q.getQuick(i, j) - sum);
            }
            double sum = 0.0;
            for (int k = 0; k < i; ++k) {
                sum += Math.pow(LDataI[k], 2.0);
            }
            double d = this.Q.getQuick(i, i) - sum;
            if (!(d > threshold)) {
                throw new Exception("not positive definite matrix");
            }
            LDataI[i] = Math.sqrt(d);
        }
    }

    @Deprecated
    public DoubleMatrix2D getInverse() {
        double[][] lTData = this.getLT().toArray();
        int dim = lTData.length;
        double[][] x = new double[dim][dim];
        for (int j = 0; j < dim; ++j) {
            double[] xJ = x[j];
            xJ[j] = 1.0;
            double[] lTJ = lTData[j];
            double lTJJ = lTJ[j];
            int k = 0;
            while (k < j + 1) {
                int n = k++;
                xJ[n] = xJ[n] / lTJJ;
            }
            for (int i = j + 1; i < dim; ++i) {
                double[] xI = x[i];
                double lTJI = lTJ[i];
                if (Double.compare(lTJI, 0.0) == 0) continue;
                for (int k2 = 0; k2 < j + 1; ++k2) {
                    int n = k2;
                    xI[n] = xI[n] - xJ[k2] * lTJI;
                }
            }
        }
        double[][] LInvTData = new double[dim][dim];
        for (int i = 0; i < dim; ++i) {
            double[] LInvTDatai = LInvTData[i];
            for (int j = i; j < dim; ++j) {
                LInvTDatai[j] = x[j][i];
            }
        }
        DoubleMatrix2D QInvData = this.F2.make(dim, dim);
        for (int row = 0; row < dim; ++row) {
            double[] LInvTDataRow = LInvTData[row];
            DoubleMatrix1D QInvDataRow = QInvData.viewRow(row);
            for (int col = row; col < dim; ++col) {
                double[] LInvTDataCol = LInvTData[col];
                double sum = 0.0;
                for (int i = col; i < dim; ++i) {
                    sum += LInvTDataRow[i] * LInvTDataCol[i];
                }
                QInvDataRow.setQuick(col, sum);
                QInvData.setQuick(col, row, sum);
            }
        }
        return QInvData;
    }

    public DoubleMatrix1D solve(DoubleMatrix1D b) {
        int j;
        double sum;
        if (b.size() != this.dim) {
            this.log.error((Object)("wrong dimension of vector b: expected " + this.dim + ", actual " + b.size()));
            throw new RuntimeException("wrong dimension of vector b: expected " + this.dim + ", actual " + b.size());
        }
        if (this.rescaler != null) {
            b = ColtUtils.diagonalMatrixMult(this.U, b);
        }
        double[] y = new double[this.dim];
        for (int i = 0; i < this.dim; ++i) {
            double[] LI = this.LData[i];
            sum = 0.0;
            for (j = 0; j < i; ++j) {
                sum += LI[j] * y[j];
            }
            y[i] = (b.getQuick(i) - sum) / LI[i];
        }
        DoubleMatrix1D x = this.F1.make(this.dim);
        for (int i = this.dim - 1; i > -1; --i) {
            sum = 0.0;
            for (j = this.dim - 1; j > i; --j) {
                sum += this.LData[j][i] * x.getQuick(j);
            }
            x.setQuick(i, (y[i] - sum) / this.LData[i][i]);
        }
        if (this.rescaler != null) {
            return ColtUtils.diagonalMatrixMult(this.U, x);
        }
        return x;
    }

    public DoubleMatrix2D solve(DoubleMatrix2D B) {
        double LII;
        int col;
        double[] sum;
        if (B.rows() != this.dim) {
            this.log.error((Object)("wrong dimension of vector b: expected " + this.dim + ", actual " + B.rows()));
            throw new RuntimeException("wrong dimension of vector b: expected " + this.dim + ", actual " + B.rows());
        }
        if (this.rescaler != null) {
            B = ColtUtils.diagonalMatrixMult(this.U, B);
        }
        int nOfColumns = B.columns();
        double[][] Y = new double[this.dim][nOfColumns];
        for (int i = 0; i < this.dim; ++i) {
            double[] LI = this.LData[i];
            sum = new double[nOfColumns];
            for (int j = 0; j < i; ++j) {
                double LIJ = LI[j];
                double[] YJ = Y[j];
                for (col = 0; col < nOfColumns; ++col) {
                    int n = col;
                    sum[n] = sum[n] + LIJ * YJ[col];
                }
            }
            double[] YI = Y[i];
            DoubleMatrix1D BI = B.viewRow(i);
            LII = LI[i];
            for (col = 0; col < nOfColumns; ++col) {
                YI[col] = (BI.getQuick(col) - sum[col]) / LII;
            }
        }
        DoubleMatrix2D X = this.F2.make(this.dim, nOfColumns);
        for (int i = this.dim - 1; i > -1; --i) {
            sum = new double[nOfColumns];
            for (int j = this.dim - 1; j > i; --j) {
                double[] LJ = this.LData[j];
                DoubleMatrix1D XJ = X.viewRow(j);
                for (int col2 = 0; col2 < nOfColumns; ++col2) {
                    int n = col2;
                    sum[n] = sum[n] + LJ[i] * XJ.getQuick(col2);
                }
            }
            DoubleMatrix1D XI = X.viewRow(i);
            double[] YI = Y[i];
            LII = this.LData[i][i];
            for (col = 0; col < nOfColumns; ++col) {
                XI.setQuick(col, (YI[col] - sum[col]) / LII);
            }
        }
        if (this.rescaler != null) {
            return ColtUtils.diagonalMatrixMult(this.U, X);
        }
        return X;
    }

    public DoubleMatrix2D getL() {
        if (this.L == null) {
            double[][] myL = new double[this.dim][this.dim];
            for (int i = 0; i < this.dim; ++i) {
                double[] LDataI = this.LData[i];
                double[] myLI = myL[i];
                for (int j = 0; j < i + 1; ++j) {
                    myLI[j] = LDataI[j];
                }
            }
            if (this.rescaler != null) {
                DoubleMatrix1D UInv = this.F1.make(this.dim);
                for (int i = 0; i < this.dim; ++i) {
                    UInv.setQuick(i, 1.0 / this.U.getQuick(i));
                }
                this.L = ColtUtils.diagonalMatrixMult(UInv, DoubleFactory2D.sparse.make(myL));
            } else {
                this.L = this.F2.make(myL);
            }
        }
        return this.L;
    }

    public DoubleMatrix2D getLT() {
        if (this.LT == null) {
            this.LT = this.ALG.transpose(this.getL());
        }
        return this.LT;
    }
}

