/*
 * Decompiled with CFR 0.152.
 */
package com.joptimizer.algebra;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.colt.matrix.linalg.Property;
import com.joptimizer.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CholeskyRCFactorization {
    private int dim;
    private DoubleMatrix2D Q;
    double[] LData;
    private DoubleMatrix2D L;
    private DoubleMatrix2D LT;
    protected Algebra ALG = Algebra.DEFAULT;
    protected DoubleFactory2D F2 = DoubleFactory2D.dense;
    protected DoubleFactory1D F1 = DoubleFactory1D.dense;
    private Log log = LogFactory.getLog((String)this.getClass().getName());

    public CholeskyRCFactorization(DoubleMatrix2D Q) throws Exception {
        this.dim = Q.rows();
        this.Q = Q;
    }

    public void factorize() throws Exception {
        this.factorize(false);
    }

    public void factorize(boolean checkSymmetry) throws Exception {
        if (checkSymmetry && !Property.TWELVE.isSymmetric(this.Q)) {
            throw new Exception("Matrix is not symmetric");
        }
        double threshold = Utils.getDoubleMachineEpsilon();
        this.LData = new double[this.dim * this.dim];
        for (int i = 0; i < this.dim; ++i) {
            int iShift = i * this.dim;
            for (int j = 0; j < i + 1; ++j) {
                int jShift = j * this.dim;
                double sum = 0.0;
                for (int k = 0; k < j; ++k) {
                    sum += this.LData[jShift + k] * this.LData[iShift + k];
                }
                if (i == j) {
                    double d = this.Q.getQuick(i, i) - sum;
                    if (!(d > threshold)) {
                        throw new Exception("not positive definite matrix");
                    }
                    this.LData[iShift + i] = Math.sqrt(d);
                    continue;
                }
                this.LData[iShift + j] = 1.0 / this.LData[jShift + j] * (this.Q.getQuick(i, j) - sum);
            }
        }
    }

    @Deprecated
    public DoubleMatrix2D getInverse() {
        double[] LInv = new double[this.dim * this.dim];
        for (int j = 0; j < this.dim; ++j) {
            int jShift = j * this.dim;
            LInv[jShift + j] = 1.0;
            double lTJJ = this.LData[jShift + j];
            for (int k = 0; k < j + 1; ++k) {
                int n = jShift + k;
                LInv[n] = LInv[n] / lTJJ;
            }
            for (int i = j + 1; i < this.dim; ++i) {
                int iShift = i * this.dim;
                double lTJI = this.LData[iShift + j];
                if (Double.compare(lTJI, 0.0) == 0) continue;
                for (int k = 0; k < j + 1; ++k) {
                    int n = iShift + k;
                    LInv[n] = LInv[n] - LInv[jShift + k] * lTJI;
                }
            }
        }
        DoubleMatrix2D QInvData = this.F2.make(this.dim, this.dim);
        for (int row = 0; row < this.dim; ++row) {
            DoubleMatrix1D QInvDataRow = QInvData.viewRow(row);
            for (int col = row; col < this.dim; ++col) {
                double sum = 0.0;
                for (int i = col; i < this.dim; ++i) {
                    sum += LInv[i * this.dim + row] * LInv[i * this.dim + col];
                }
                QInvDataRow.setQuick(col, sum);
                QInvData.setQuick(col, row, sum);
            }
        }
        return QInvData;
    }

    public DoubleMatrix1D solve(DoubleMatrix1D b) {
        if (b.size() != this.dim) {
            this.log.error((Object)("wrong dimension of vector b: expected " + this.dim + ", actual " + b.size()));
            throw new RuntimeException("wrong dimension of vector b: expected " + this.dim + ", actual " + b.size());
        }
        throw new RuntimeException("not yet implemented");
    }

    public DoubleMatrix2D solve(DoubleMatrix2D B) {
        if (B.rows() != this.dim) {
            this.log.error((Object)("wrong dimension of vector b: expected " + this.dim + ", actual " + B.rows()));
            throw new RuntimeException("wrong dimension of vector b: expected " + this.dim + ", actual " + B.rows());
        }
        throw new RuntimeException("not yet implemented");
    }

    public DoubleMatrix2D getL() {
        if (this.L == null) {
            double[][] myL = new double[this.dim][this.dim];
            for (int i = 0; i < this.dim; ++i) {
                int iShift = i * this.dim;
                double[] myLI = myL[i];
                for (int j = 0; j <= i; ++j) {
                    myLI[j] = this.LData[iShift + j];
                }
            }
            this.L = this.F2.make(myL);
        }
        return this.L;
    }

    public DoubleMatrix2D getLT() {
        if (this.LT == null) {
            this.LT = this.ALG.transpose(this.getL());
        }
        return this.LT;
    }
}

