/*
 * Decompiled with CFR 0.152.
 */
package com.joptimizer.algebra;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.SparseDoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.colt.matrix.linalg.Property;
import com.joptimizer.algebra.MatrixRescaler;
import com.joptimizer.util.ColtUtils;
import com.joptimizer.util.Utils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.RealMatrix;

public class CholeskyUpperDiagonalFactorization {
    private int dim;
    private int diagonalLength;
    private MatrixRescaler rescaler = null;
    private SparseDoubleMatrix2D Q;
    private DoubleMatrix1D U;
    protected Algebra ALG = Algebra.DEFAULT;
    protected DoubleFactory2D F2 = DoubleFactory2D.dense;
    protected DoubleFactory1D F1 = DoubleFactory1D.dense;
    private double[][] LData;
    private DoubleMatrix2D L;
    private DoubleMatrix2D LT;
    private Log log = LogFactory.getLog((String)this.getClass().getName());

    public CholeskyUpperDiagonalFactorization(SparseDoubleMatrix2D Q, int diagonalLength) throws Exception {
        this(Q, diagonalLength, null);
    }

    public CholeskyUpperDiagonalFactorization(SparseDoubleMatrix2D Q, int diagonalLength, MatrixRescaler rescaler) throws Exception {
        this.dim = Q.rows();
        this.Q = Q;
        if (diagonalLength < 0) {
            throw new IllegalArgumentException("DiagonalLength cannot be < 0");
        }
        if (this.dim < diagonalLength) {
            throw new IllegalArgumentException("Dimension cannot be less than diagonalLength");
        }
        this.diagonalLength = diagonalLength;
        this.rescaler = rescaler;
    }

    public void factorize() throws Exception {
        this.factorize(false);
    }

    public void factorize(boolean checkSymmetry) throws Exception {
        if (checkSymmetry && !Property.TWELVE.isSymmetric(this.Q)) {
            throw new Exception("Matrix is not symmetric");
        }
        if (this.rescaler != null) {
            boolean checkOK;
            double[] cn_00_original = null;
            double[] cn_2_original = null;
            double[] cn_00_scaled = null;
            double[] cn_2_scaled = null;
            if (this.log.isDebugEnabled()) {
                cn_00_original = ColtUtils.getConditionNumberRange((RealMatrix)new Array2DRowRealMatrix(ColtUtils.fillSubdiagonalSymmetricMatrix(this.Q).toArray()), Integer.MAX_VALUE);
                this.log.debug((Object)("cn_00_original Q before scaling: " + ArrayUtils.toString((Object)cn_00_original)));
                cn_2_original = ColtUtils.getConditionNumberRange((RealMatrix)new Array2DRowRealMatrix(ColtUtils.fillSubdiagonalSymmetricMatrix(this.Q).toArray()), 2);
                this.log.debug((Object)("cn_2_original Q before scaling : " + ArrayUtils.toString((Object)cn_2_original)));
            }
            DoubleMatrix1D Uv = this.rescaler.getMatrixScalingFactorsSymm(this.Q);
            if (this.log.isDebugEnabled() && !(checkOK = this.rescaler.checkScaling(ColtUtils.fillSubdiagonalSymmetricMatrix(this.Q), Uv, Uv))) {
                this.log.warn((Object)"Scaling failed (checkScaling = false)");
            }
            this.U = Uv;
            this.Q = (SparseDoubleMatrix2D)ColtUtils.diagonalMatrixMult(Uv, this.Q, Uv);
            if (this.log.isDebugEnabled()) {
                cn_00_scaled = ColtUtils.getConditionNumberRange((RealMatrix)new Array2DRowRealMatrix(ColtUtils.fillSubdiagonalSymmetricMatrix(this.Q).toArray()), Integer.MAX_VALUE);
                this.log.debug((Object)("cn_00_scaled Q after scaling : " + ArrayUtils.toString((Object)cn_00_scaled)));
                cn_2_scaled = ColtUtils.getConditionNumberRange((RealMatrix)new Array2DRowRealMatrix(ColtUtils.fillSubdiagonalSymmetricMatrix(this.Q).toArray()), 2);
                this.log.debug((Object)("cn_2_scaled Q after scaling  : " + ArrayUtils.toString((Object)cn_2_scaled)));
                if (cn_00_original[0] < cn_00_scaled[0] || cn_2_original[0] < cn_2_scaled[0]) {
                    this.log.warn((Object)"Problematic scaling");
                }
            }
        }
        double threshold = Utils.getDoubleMachineEpsilon();
        this.LData = new double[this.dim - this.diagonalLength + 1][];
        double[] LData0 = new double[this.diagonalLength];
        this.LData[0] = LData0;
        if (this.dim - this.diagonalLength == 1 && Double.compare(this.Q.getQuick(this.dim - 1, this.dim - 1), 1.0) == 0) {
            for (int i = 0; i < this.dim - 1; ++i) {
                double d = this.Q.getQuick(i, i);
                if (d < Utils.getDoubleMachineEpsilon()) {
                    throw new Exception("not positive definite matrix");
                }
                LData0[i] = Math.sqrt(d);
            }
            double[] LData1 = new double[this.dim];
            for (int j = 0; j < this.dim - 1; ++j) {
                LData1[j] = this.Q.getQuick(this.dim - 1, j) / LData0[j];
            }
            double d = 0.0;
            for (int k = 0; k < this.diagonalLength; ++k) {
                d += Math.pow(this.Q.getQuick(this.dim - 1, k), 2.0) / this.Q.getQuick(k, k);
            }
            LData1[this.dim - 1] = Math.sqrt(1.0 - d);
            this.LData[1] = LData1;
        } else {
            for (int i = 0; i < this.dim; ++i) {
                int j;
                if (i < this.diagonalLength) {
                    double d = this.Q.getQuick(i, i);
                    if (!(d > threshold)) {
                        throw new Exception("not positive definite matrix");
                    }
                    LData0[i] = Math.sqrt(d);
                    continue;
                }
                this.LData[i - this.diagonalLength + 1] = new double[i + 1];
                double[] LDataI = this.LData[i - this.diagonalLength + 1];
                for (j = 0; j < this.diagonalLength; ++j) {
                    LDataI[j] = 1.0 / this.LData[0][j] * this.Q.getQuick(i, j);
                }
                for (j = this.diagonalLength; j < i; ++j) {
                    double[] LDataJ = this.LData[j - this.diagonalLength + 1];
                    double sum = 0.0;
                    for (int k = 0; k < j; ++k) {
                        sum += LDataI[k] * LDataJ[k];
                    }
                    LDataI[j] = 1.0 / LDataJ[j] * (this.Q.getQuick(i, j) - sum);
                }
                double sum = 0.0;
                for (int k = 0; k < i; ++k) {
                    sum += Math.pow(LDataI[k], 2.0);
                }
                double d = this.Q.getQuick(i, i) - sum;
                if (d < Utils.getDoubleMachineEpsilon()) {
                    throw new Exception("not positive definite matrix");
                }
                LDataI[i] = Math.sqrt(d);
            }
        }
    }

    public DoubleMatrix1D solve(DoubleMatrix1D b) {
        double sum;
        int i;
        int i2;
        if (b.size() != this.dim) {
            this.log.error((Object)("wrong dimension of vector b: expected " + this.dim + ", actual " + b.size()));
            throw new RuntimeException("wrong dimension of vector b: expected " + this.dim + ", actual " + b.size());
        }
        if (this.rescaler != null) {
            b = ColtUtils.diagonalMatrixMult(this.U, b);
        }
        double[] y = new double[this.dim];
        for (i2 = 0; i2 < this.diagonalLength; ++i2) {
            double LII = this.LData[0][i2];
            y[i2] = b.getQuick(i2) / LII;
        }
        for (i2 = this.diagonalLength; i2 < this.dim; ++i2) {
            double[] LI = this.LData[i2 - this.diagonalLength + 1];
            double LII = LI[i2];
            double sum2 = 0.0;
            for (int j = 0; j < i2; ++j) {
                sum2 += LI[j] * y[j];
            }
            y[i2] = (b.getQuick(i2) - sum2) / LII;
        }
        DoubleMatrix1D x = this.F1.make(this.dim);
        for (i = this.dim - 1; i > this.diagonalLength - 1; --i) {
            sum = 0.0;
            for (int j = this.dim - 1; j > i; --j) {
                sum += this.LData[j - this.diagonalLength + 1][i] * x.getQuick(j);
            }
            x.setQuick(i, (y[i] - sum) / this.LData[i - this.diagonalLength + 1][i]);
        }
        for (i = this.diagonalLength - 1; i > -1; --i) {
            sum = 0.0;
            for (int j = this.dim - 1; j > this.diagonalLength - 1; --j) {
                sum += this.LData[j - this.diagonalLength + 1][i] * x.getQuick(j);
            }
            x.setQuick(i, (y[i] - sum) / this.LData[0][i]);
        }
        if (this.rescaler != null) {
            return ColtUtils.diagonalMatrixMult(this.U, x);
        }
        return x;
    }

    public DoubleMatrix2D solve(DoubleMatrix2D B) {
        double[] YI;
        int col;
        double[] LJ;
        int i;
        int col2;
        double[] sum;
        double LII;
        int i2;
        if (B.rows() != this.dim) {
            this.log.error((Object)("wrong dimension of vector b: expected " + this.dim + ", actual " + B.rows()));
            throw new RuntimeException("wrong dimension of vector b: expected " + this.dim + ", actual " + B.rows());
        }
        if (this.rescaler != null) {
            B = ColtUtils.diagonalMatrixMult(this.U, B);
        }
        int nOfColumns = B.columns();
        double[][] Y = new double[this.dim][nOfColumns];
        for (i2 = 0; i2 < this.diagonalLength; ++i2) {
            double LII2 = this.LData[0][i2];
            double[] YI2 = Y[i2];
            DoubleMatrix1D BI = B.viewRow(i2);
            for (int col3 = 0; col3 < nOfColumns; ++col3) {
                YI2[col3] = BI.getQuick(col3) / LII2;
            }
        }
        for (i2 = this.diagonalLength; i2 < this.dim; ++i2) {
            double[] LI = this.LData[i2 - this.diagonalLength + 1];
            LII = LI[i2];
            sum = new double[nOfColumns];
            for (int j = 0; j < i2; ++j) {
                double LIJ = LI[j];
                double[] YJ = Y[j];
                for (int col4 = 0; col4 < nOfColumns; ++col4) {
                    int n = col4;
                    sum[n] = sum[n] + LIJ * YJ[col4];
                }
            }
            double[] YI3 = Y[i2];
            DoubleMatrix1D BI = B.viewRow(i2);
            for (col2 = 0; col2 < nOfColumns; ++col2) {
                YI3[col2] = (BI.getQuick(col2) - sum[col2]) / LII;
            }
        }
        DoubleMatrix2D X = this.F2.make(this.dim, nOfColumns);
        for (i = this.dim - 1; i > this.diagonalLength - 1; --i) {
            LII = this.LData[i - this.diagonalLength + 1][i];
            sum = new double[nOfColumns];
            for (int j = this.dim - 1; j > i; --j) {
                LJ = this.LData[j - this.diagonalLength + 1];
                double LJI = LJ[i];
                DoubleMatrix1D XJ = X.viewRow(j);
                for (col = 0; col < nOfColumns; ++col) {
                    int n = col;
                    sum[n] = sum[n] + LJI * XJ.getQuick(col);
                }
            }
            DoubleMatrix1D XI = X.viewRow(i);
            YI = Y[i];
            for (col2 = 0; col2 < nOfColumns; ++col2) {
                XI.setQuick(col2, (YI[col2] - sum[col2]) / LII);
            }
        }
        for (i = this.diagonalLength - 1; i > -1; --i) {
            LII = this.LData[0][i];
            sum = new double[nOfColumns];
            for (int j = this.dim - 1; j > this.diagonalLength - 1; --j) {
                LJ = this.LData[j - this.diagonalLength + 1];
                double LJI = LJ[i];
                DoubleMatrix1D XJ = X.viewRow(j);
                for (col = 0; col < nOfColumns; ++col) {
                    int n = col;
                    sum[n] = sum[n] + LJI * XJ.getQuick(col);
                }
            }
            DoubleMatrix1D XI = X.viewRow(i);
            YI = Y[i];
            for (col2 = 0; col2 < nOfColumns; ++col2) {
                XI.setQuick(col2, (YI[col2] - sum[col2]) / LII);
            }
        }
        if (this.rescaler != null) {
            return ColtUtils.diagonalMatrixMult(this.U, X);
        }
        return X;
    }

    public DoubleMatrix2D getL() {
        if (this.L == null) {
            int i;
            double[][] myL = new double[this.dim][this.dim];
            for (i = 0; i < this.diagonalLength; ++i) {
                myL[i][i] = this.LData[0][i];
            }
            for (i = this.diagonalLength; i < this.dim; ++i) {
                double[] LDataI = this.LData[i - this.diagonalLength + 1];
                double[] myLI = myL[i];
                for (int j = 0; j < i + 1; ++j) {
                    myLI[j] = LDataI[j];
                }
            }
            if (this.rescaler != null) {
                DoubleMatrix1D UInv = this.F1.make(this.dim);
                for (int i2 = 0; i2 < this.dim; ++i2) {
                    UInv.setQuick(i2, 1.0 / this.U.getQuick(i2));
                }
                this.L = ColtUtils.diagonalMatrixMult(UInv, DoubleFactory2D.sparse.make(myL));
            } else {
                this.L = this.F2.make(myL);
            }
        }
        return this.L;
    }

    public DoubleMatrix2D getLT() {
        if (this.LT == null) {
            this.LT = this.ALG.transpose(this.getL());
        }
        return this.LT;
    }
}

