/*
 * Decompiled with CFR 0.152.
 */
package com.joptimizer.algebra;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.colt.matrix.linalg.Property;
import com.joptimizer.algebra.MatrixRescaler;
import com.joptimizer.util.ColtUtils;
import com.joptimizer.util.Utils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.RealMatrix;

public class LDLTFactorization {
    private int dim;
    private DoubleMatrix2D Q;
    private MatrixRescaler rescaler = null;
    private DoubleMatrix1D U;
    protected Algebra ALG = Algebra.DEFAULT;
    protected DoubleFactory2D F2 = DoubleFactory2D.dense;
    protected DoubleFactory1D F1 = DoubleFactory1D.dense;
    private double[][] LData;
    private double[] DData;
    private DoubleMatrix2D L;
    private DoubleMatrix2D LT;
    private DoubleMatrix2D D;
    private Log log = LogFactory.getLog((String)this.getClass().getName());

    public LDLTFactorization(DoubleMatrix2D Q) throws Exception {
        this(Q, null);
    }

    public LDLTFactorization(DoubleMatrix2D Q, MatrixRescaler rescaler) throws Exception {
        this.dim = Q.rows();
        this.Q = Q;
        this.rescaler = rescaler;
    }

    public void factorize() throws Exception {
        this.factorize(false);
    }

    public void factorize(boolean checkSymmetry) throws Exception {
        if (checkSymmetry && !Property.TWELVE.isSymmetric(this.Q)) {
            throw new Exception("Matrix is not symmetric");
        }
        if (this.rescaler != null) {
            boolean checkOK;
            double[] cn_00_original = null;
            double[] cn_2_original = null;
            double[] cn_00_scaled = null;
            double[] cn_2_scaled = null;
            if (this.log.isDebugEnabled()) {
                cn_00_original = ColtUtils.getConditionNumberRange((RealMatrix)new Array2DRowRealMatrix(ColtUtils.fillSubdiagonalSymmetricMatrix(this.Q).toArray()), Integer.MAX_VALUE);
                this.log.debug((Object)("cn_00_original Q before scaling: " + ArrayUtils.toString((Object)cn_00_original)));
                cn_2_original = ColtUtils.getConditionNumberRange((RealMatrix)new Array2DRowRealMatrix(ColtUtils.fillSubdiagonalSymmetricMatrix(this.Q).toArray()), 2);
                this.log.debug((Object)("cn_2_original Q before scaling : " + ArrayUtils.toString((Object)cn_2_original)));
            }
            DoubleMatrix1D Uv = this.rescaler.getMatrixScalingFactorsSymm(this.Q);
            if (this.log.isDebugEnabled() && !(checkOK = this.rescaler.checkScaling(ColtUtils.fillSubdiagonalSymmetricMatrix(this.Q), Uv, Uv))) {
                this.log.warn((Object)"Scaling failed (checkScaling = false)");
            }
            this.U = Uv;
            this.Q = ColtUtils.diagonalMatrixMult(Uv, this.Q, Uv);
            if (this.log.isDebugEnabled()) {
                cn_00_scaled = ColtUtils.getConditionNumberRange((RealMatrix)new Array2DRowRealMatrix(ColtUtils.fillSubdiagonalSymmetricMatrix(this.Q).toArray()), Integer.MAX_VALUE);
                this.log.debug((Object)("cn_00_scaled Q after scaling : " + ArrayUtils.toString((Object)cn_00_scaled)));
                cn_2_scaled = ColtUtils.getConditionNumberRange((RealMatrix)new Array2DRowRealMatrix(ColtUtils.fillSubdiagonalSymmetricMatrix(this.Q).toArray()), 2);
                this.log.debug((Object)("cn_2_scaled Q after scaling  : " + ArrayUtils.toString((Object)cn_2_scaled)));
                if (cn_00_original[0] < cn_00_scaled[0] || cn_2_original[0] < cn_2_scaled[0]) {
                    this.log.warn((Object)"Problematic scaling");
                }
            }
        }
        double threshold = Utils.getDoubleMachineEpsilon();
        this.LData = new double[this.dim][];
        this.DData = new double[this.dim];
        for (int i = 0; i < this.dim; ++i) {
            this.LData[i] = new double[i + 1];
            double[] LI = this.LData[i];
            for (int j = 0; j < i; ++j) {
                double[] LJ = this.LData[j];
                double sum = 0.0;
                for (int k = 0; k < j; ++k) {
                    sum += LI[k] * LJ[k] * this.DData[k];
                }
                LI[j] = 1.0 / this.DData[j] * (this.Q.getQuick(i, j) - sum);
            }
            double sum = 0.0;
            for (int k = 0; k < i; ++k) {
                sum += Math.pow(LI[k], 2.0) * this.DData[k];
            }
            double dii = this.Q.getQuick(i, i) - sum;
            if (!(Math.abs(dii) > threshold)) {
                throw new Exception("singular matrix");
            }
            this.DData[i] = dii;
            LI[i] = 1.0;
        }
    }

    public DoubleMatrix1D solve(DoubleMatrix1D b) {
        if (b.size() != this.dim) {
            this.log.error((Object)("wrong dimension of vector b: expected " + this.dim + ", actual " + b.size()));
            throw new RuntimeException("wrong dimension of vector b: expected " + this.dim + ", actual " + b.size());
        }
        if (this.rescaler != null) {
            b = ColtUtils.diagonalMatrixMult(this.U, b);
        }
        double[] y = new double[this.dim];
        for (int i = 0; i < this.dim; ++i) {
            double[] LI = this.LData[i];
            double sum = 0.0;
            for (int j = 0; j < i; ++j) {
                sum += LI[j] * y[j];
            }
            y[i] = (b.getQuick(i) - sum) / LI[i];
        }
        double[] z = new double[this.dim];
        for (int i = 0; i < this.dim; ++i) {
            z[i] = y[i] / this.DData[i];
        }
        DoubleMatrix1D x = this.F1.make(this.dim);
        for (int i = this.dim - 1; i > -1; --i) {
            double sum = 0.0;
            for (int j = this.dim - 1; j > i; --j) {
                sum += this.LData[j][i] * x.getQuick(j);
            }
            x.setQuick(i, (z[i] - sum) / this.LData[i][i]);
        }
        if (this.rescaler != null) {
            return ColtUtils.diagonalMatrixMult(this.U, x);
        }
        return x;
    }

    public DoubleMatrix2D solve(DoubleMatrix2D B) {
        if (B.rows() != this.dim) {
            this.log.error((Object)("wrong dimension of vector b: expected " + this.dim + ", actual " + B.rows()));
            throw new RuntimeException("wrong dimension of vector b: expected " + this.dim + ", actual " + B.rows());
        }
        throw new RuntimeException("not yet implemented");
    }

    public DoubleMatrix2D getL() {
        if (this.L == null) {
            double[][] myL = new double[this.dim][this.dim];
            for (int i = 0; i < this.dim; ++i) {
                double[] LDataI = this.LData[i];
                double[] myLI = myL[i];
                for (int j = 0; j < i + 1; ++j) {
                    myLI[j] = LDataI[j];
                }
            }
            if (this.rescaler != null) {
                DoubleMatrix1D UInv = this.F1.make(this.dim);
                for (int i = 0; i < this.dim; ++i) {
                    UInv.setQuick(i, 1.0 / this.U.getQuick(i));
                }
                this.L = ColtUtils.diagonalMatrixMult(UInv, DoubleFactory2D.sparse.make(myL));
            } else {
                this.L = this.F2.make(myL);
            }
        }
        return this.L;
    }

    public DoubleMatrix2D getLT() {
        if (this.LT == null) {
            this.LT = this.ALG.transpose(this.getL());
        }
        return this.LT;
    }

    public DoubleMatrix2D getD() {
        if (this.D == null) {
            this.D = this.F2.diagonal(this.F1.make(this.DData));
        }
        return this.D;
    }
}

