/*
 * Decompiled with CFR 0.152.
 */
package com.joptimizer.functions;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.jet.math.Functions;
import cern.jet.math.Mult;
import com.joptimizer.functions.ConvexMultivariateRealFunction;
import java.util.Arrays;

public class FunctionsUtils {
    public static final double[][] ZEROES_2D_ARRAY_PLACEHOLDER = new double[0][0];
    public static final DoubleMatrix2D ZEROES_MATRIX_PLACEHOLDER = DoubleFactory2D.dense.make(0, 0);
    private static DoubleFactory1D F1 = DoubleFactory1D.dense;
    private static DoubleFactory2D F2 = DoubleFactory2D.dense;

    public static ConvexMultivariateRealFunction createCircle(int dim, double radius) {
        double[] center = new double[dim];
        return FunctionsUtils.createCircle(dim, radius, center);
    }

    public static ConvexMultivariateRealFunction createCircle(final int dim, final double radius, double[] center) {
        final DoubleMatrix1D C = F1.make(center);
        return new ConvexMultivariateRealFunction(){

            public double value(double[] X) {
                DoubleMatrix1D x = DoubleFactory1D.dense.make(X);
                DoubleMatrix1D D = x.assign(C, Functions.minus);
                double d = D.zDotProduct(D) - Math.pow(radius, 2.0);
                return d;
            }

            public double[] gradient(double[] X) {
                DoubleMatrix1D x = DoubleFactory1D.dense.make(X);
                DoubleMatrix1D D = x.assign(C, Functions.minus);
                return D.assign(Mult.mult(2.0)).toArray();
            }

            public double[][] hessian(double[] X) {
                double[] d = new double[dim];
                Arrays.fill(d, 2.0);
                return F2.diagonal(F1.make(d)).toArray();
            }

            public int getDim() {
                return dim;
            }
        };
    }
}

