/*
 * Decompiled with CFR 0.152.
 */
package com.joptimizer.functions;

import cern.colt.matrix.DoubleFactory1D;
import com.joptimizer.functions.BarrierFunction;
import com.joptimizer.util.Utils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.CholeskyDecomposition;
import org.apache.commons.math3.linear.EigenDecomposition;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.NonPositiveDefiniteMatrixException;
import org.apache.commons.math3.linear.RealMatrix;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDPLogarithmicBarrier
implements BarrierFunction {
    private RealMatrix[] Fi = null;
    private RealMatrix G = null;
    private int dim = -1;
    private int p = -1;

    public SDPLogarithmicBarrier(List<double[][]> FiMatrixList, double[][] GMatrix) {
        int dim = FiMatrixList.size();
        this.Fi = new RealMatrix[dim];
        Array2DRowRealMatrix Gg = new Array2DRowRealMatrix(GMatrix);
        if (Gg.getRowDimension() != Gg.getColumnDimension()) {
            throw new IllegalArgumentException("All matrices must be symmetric");
        }
        this.G = Gg;
        int pp = this.G.getRowDimension();
        for (int i = 0; i < dim; ++i) {
            double[][] FiMatrix = FiMatrixList.get(i);
            Array2DRowRealMatrix Fii = new Array2DRowRealMatrix(FiMatrix);
            if (Fii.getRowDimension() != Fii.getColumnDimension() || pp != Fii.getRowDimension()) {
                throw new IllegalArgumentException("All matrices must be symmetric and with the same dimensions");
            }
            this.Fi[i] = Fii;
        }
        this.dim = dim;
        this.p = pp;
    }

    @Override
    public double value(double[] X) {
        RealMatrix S = this.buildS(X);
        try {
            CholeskyDecomposition cFact = new CholeskyDecomposition(S);
            double detS = cFact.getDeterminant();
            return -Math.log(detS);
        }
        catch (NonPositiveDefiniteMatrixException e) {
            return Double.NaN;
        }
    }

    @Override
    public double[] gradient(double[] X) {
        double[] ret = new double[this.dim];
        RealMatrix S = this.buildS(X);
        CholeskyDecomposition cFact = new CholeskyDecomposition(S);
        RealMatrix SInv = cFact.getSolver().getInverse();
        for (int i = 0; i < this.dim; ++i) {
            ret[i] = SInv.multiply(this.Fi[i]).getTrace();
        }
        return ret;
    }

    @Override
    public double[][] hessian(double[] X) {
        RealMatrix S = this.buildS(X);
        CholeskyDecomposition cFact = new CholeskyDecomposition(S);
        RealMatrix SInv = cFact.getSolver().getInverse();
        double[][] ret = new double[this.dim][this.dim];
        for (int i = 0; i < this.dim; ++i) {
            for (int j = i; j < this.dim; ++j) {
                double h;
                ret[i][j] = h = SInv.multiply(this.Fi[i]).multiply(SInv.multiply(this.Fi[j])).getTrace();
                ret[j][i] = h;
            }
        }
        return ret;
    }

    @Override
    public BarrierFunction createPhase1BarrierFunction() {
        ArrayList<double[][]> FiPh1MatrixList = new ArrayList<double[][]>();
        for (int i = 0; i < this.Fi.length; ++i) {
            FiPh1MatrixList.add(FiPh1MatrixList.size(), this.Fi[i].getData());
        }
        FiPh1MatrixList.add(FiPh1MatrixList.size(), MatrixUtils.createRealIdentityMatrix((int)this.p).scalarMultiply(-1.0).getData());
        return new SDPLogarithmicBarrier(FiPh1MatrixList, this.G.getData());
    }

    @Override
    public double calculatePhase1InitialFeasiblePoint(double[] originalNotFeasiblePoint, double tolerance) {
        RealMatrix F = this.buildS(originalNotFeasiblePoint).scalarMultiply(-1.0);
        RealMatrix S = F.scalarMultiply(-1.0);
        try {
            new CholeskyDecomposition(S);
            return -1.0;
        }
        catch (NonPositiveDefiniteMatrixException ee) {
            EigenDecomposition eFact = new EigenDecomposition(F);
            double[] eValues = eFact.getRealEigenvalues();
            double minEigenValue = eValues[Utils.getMinIndex(DoubleFactory1D.dense.make(eValues))];
            return -Math.min(minEigenValue * Math.pow(tolerance, -0.5), 0.0);
        }
    }

    private RealMatrix buildS(double[] X) {
        RealMatrix S = this.G.scalarMultiply(-1.0);
        for (int i = 0; i < this.dim; ++i) {
            S = S.add(this.Fi[i].scalarMultiply(-1.0 * X[i]));
        }
        return S;
    }

    @Override
    public int getDim() {
        return this.dim;
    }

    @Override
    public double getDualityGap(double t) {
        return (double)this.p / t;
    }
}

