/*
 * Decompiled with CFR 0.152.
 */
package com.joptimizer.functions;

import com.joptimizer.functions.BarrierFunction;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOCPLogarithmicBarrier
implements BarrierFunction {
    private List<SOCPConstraintParameters> socpConstraintParametersList = null;
    private int dim = -1;

    public SOCPLogarithmicBarrier(List<SOCPConstraintParameters> socpConstraintParametersList, int dim) {
        this.socpConstraintParametersList = socpConstraintParametersList;
        this.dim = dim;
    }

    @Override
    public double value(double[] X) {
        ArrayRealVector x = new ArrayRealVector(X);
        double ret = 0.0;
        for (int i = 0; i < this.socpConstraintParametersList.size(); ++i) {
            SOCPConstraintParameters param = this.socpConstraintParametersList.get(i);
            double t = this.buildT(param, (RealVector)x);
            if (t < 0.0) {
                return Double.NaN;
            }
            RealVector u = this.buildU(param, (RealVector)x);
            double t2uu = t * t - u.dotProduct(u);
            if (t2uu <= 0.0) {
                return Double.NaN;
            }
            double ret_i = -Math.log(t2uu);
            ret += ret_i;
        }
        return ret;
    }

    @Override
    public double[] gradient(double[] X) {
        ArrayRealVector x = new ArrayRealVector(X);
        ArrayRealVector ret = new ArrayRealVector(this.dim);
        for (int i = 0; i < this.socpConstraintParametersList.size(); ++i) {
            SOCPConstraintParameters param = this.socpConstraintParametersList.get(i);
            double t = this.buildT(param, (RealVector)x);
            RealVector u = this.buildU(param, (RealVector)x);
            double t2uu = t * t - u.dotProduct(u);
            RealMatrix Jacob = this.buildJ(param, (RealVector)x);
            int k = u.getDimension();
            ArrayRealVector G = new ArrayRealVector(k + 1);
            G.setSubVector(0, u);
            G.setEntry(k, -t);
            RealVector ret_i = Jacob.operate((RealVector)G).mapMultiply(2.0 / t2uu);
            ret = ret.add(ret_i);
        }
        return ret.toArray();
    }

    @Override
    public double[][] hessian(double[] X) {
        ArrayRealVector x = new ArrayRealVector(X);
        Array2DRowRealMatrix ret = new Array2DRowRealMatrix(this.dim, this.dim);
        for (int i = 0; i < this.socpConstraintParametersList.size(); ++i) {
            SOCPConstraintParameters param = this.socpConstraintParametersList.get(i);
            double t = this.buildT(param, (RealVector)x);
            RealVector u = this.buildU(param, (RealVector)x);
            double t2uu = t * t - u.dotProduct(u);
            RealVector t2u = u.mapMultiply(-2.0 * t);
            RealMatrix Jacob = this.buildJ(param, (RealVector)x);
            int k = u.getDimension();
            Array2DRowRealMatrix H = new Array2DRowRealMatrix(k + 1, k + 1);
            RealMatrix ID = MatrixUtils.createRealIdentityMatrix((int)k);
            H.setSubMatrix(ID.scalarMultiply(t2uu).add(u.outerProduct(u).scalarMultiply(2.0)).getData(), 0, 0);
            H.setSubMatrix((double[][])new double[][]{t2u.toArray()}, k, 0);
            for (int j = 0; j < k; ++j) {
                H.setEntry(j, k, t2u.getEntry(j));
            }
            H.setEntry(k, k, t * t + u.dotProduct(u));
            RealMatrix ret_i = Jacob.multiply((RealMatrix)H).multiply(Jacob.transpose()).scalarMultiply(2.0 / Math.pow(t2uu, 2.0));
            ret = ret.add(ret_i);
        }
        return ret.getData();
    }

    @Override
    public BarrierFunction createPhase1BarrierFunction() {
        int dimPh1 = this.dim + 1;
        ArrayList<SOCPConstraintParameters> socpConstraintParametersPh1List = new ArrayList<SOCPConstraintParameters>();
        SOCPLogarithmicBarrier bfPh1 = new SOCPLogarithmicBarrier(socpConstraintParametersPh1List, dimPh1);
        for (int i = 0; i < this.socpConstraintParametersList.size(); ++i) {
            SOCPConstraintParameters param = this.socpConstraintParametersList.get(i);
            RealMatrix A = param.getA();
            RealVector b = param.getB();
            RealVector c = param.getC();
            double d = param.getD();
            RealMatrix APh1 = MatrixUtils.createRealMatrix((int)A.getRowDimension(), (int)dimPh1);
            APh1.setSubMatrix(A.getData(), 0, 0);
            RealVector bPh1 = b;
            ArrayRealVector cPh1 = new ArrayRealVector(c.getDimension() + 1);
            cPh1.setSubVector(0, c);
            cPh1.setEntry(c.getDimension(), 1.0);
            double dPh1 = d;
            SOCPConstraintParameters paramsPh1 = new SOCPConstraintParameters(APh1.getData(), bPh1.toArray(), cPh1.toArray(), dPh1);
            socpConstraintParametersPh1List.add(socpConstraintParametersPh1List.size(), paramsPh1);
        }
        return bfPh1;
    }

    @Override
    public double calculatePhase1InitialFeasiblePoint(double[] originalNotFeasiblePoint, double tolerance) {
        double s = -1.7976931348623157E308;
        ArrayRealVector x = new ArrayRealVector(originalNotFeasiblePoint);
        for (int i = 0; i < this.socpConstraintParametersList.size(); ++i) {
            SOCPConstraintParameters param = this.socpConstraintParametersList.get(i);
            RealMatrix A = param.getA();
            RealVector b = param.getB();
            RealVector c = param.getC();
            double d = param.getD();
            s = Math.max(s, (A.operate((RealVector)x).subtract(b).getNorm() - (c.dotProduct((RealVector)x) + d)) * Math.pow(tolerance, -0.5));
        }
        if (Double.compare(0.0, s) == 0) {
            s = 2.0 * tolerance;
        }
        return s;
    }

    @Override
    public int getDim() {
        return this.dim;
    }

    private double buildT(SOCPConstraintParameters param, RealVector X) {
        return param.getC().dotProduct(X) + param.getD();
    }

    private RealVector buildU(SOCPConstraintParameters param, RealVector X) {
        return param.getA().operate(X).add(param.getB());
    }

    private RealMatrix buildJ(SOCPConstraintParameters param, RealVector X) {
        Array2DRowRealMatrix J = new Array2DRowRealMatrix(this.dim, param.getA().getRowDimension() + 1);
        J.setSubMatrix(param.getA().transpose().getData(), 0, 0);
        J.setColumnVector(param.getA().getRowDimension(), param.getC());
        return J;
    }

    @Override
    public double getDualityGap(double t) {
        return (double)this.socpConstraintParametersList.size() / t;
    }

    public class SOCPConstraintParameters {
        private RealMatrix A = null;
        private RealVector b;
        private RealVector c;
        private double d;

        public SOCPConstraintParameters(double[][] AMatrix, double[] bVector, double[] cVector, double d) {
            this.A = new Array2DRowRealMatrix(AMatrix);
            this.b = new ArrayRealVector(bVector);
            this.c = new ArrayRealVector(cVector);
            this.d = d;
        }

        public RealMatrix getA() {
            return this.A;
        }

        public RealVector getB() {
            return this.b;
        }

        public RealVector getC() {
            return this.c;
        }

        public double getD() {
            return this.d;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("SOCPConstraintParameters ||A.x+b|| < c.x + d:");
            sb.append("\nA : " + ArrayUtils.toString((Object)this.A.getData()));
            sb.append("\nb : " + ArrayUtils.toString((Object)this.b.toArray()));
            sb.append("\nc : " + ArrayUtils.toString((Object)this.c.toArray()));
            sb.append("\nd : " + this.d);
            return sb.toString();
        }
    }
}

