/*
 * Decompiled with CFR 0.152.
 */
package com.joptimizer.optimizers;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.SparseDoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.jet.math.Functions;
import com.joptimizer.optimizers.LPOptimizationRequest;
import com.joptimizer.optimizers.LPOptimizationResponse;
import com.joptimizer.optimizers.LPPrimalDualMethod;
import com.joptimizer.solvers.UpperDiagonalHKKTSolver;
import com.joptimizer.util.ColtUtils;
import com.joptimizer.util.Utils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BasicPhaseILPPDM {
    private LPPrimalDualMethod originalProblem;
    private int originalDim = -1;
    private int dim = -1;
    private Algebra ALG = Algebra.DEFAULT;
    private DoubleFactory1D F1 = DoubleFactory1D.dense;
    private Log log = LogFactory.getLog((String)this.getClass().getName());

    public BasicPhaseILPPDM(LPPrimalDualMethod originalProblem) {
        this.originalProblem = originalProblem;
        this.originalDim = originalProblem.getDim();
        this.dim = originalProblem.getDim() + 1;
    }

    public DoubleMatrix1D findFeasibleInitialPoint() throws Exception {
        int maxIneqIndex;
        DoubleMatrix1D originalFiX0;
        DoubleMatrix1D X0;
        this.log.debug((Object)"findFeasibleInitialPoint");
        LPOptimizationRequest or = new LPOptimizationRequest();
        DoubleMatrix1D c = this.F1.make(this.dim);
        c.set(this.dim - 1, 1.0);
        or.setC(c);
        or.setToleranceFeas(this.originalProblem.getToleranceFeas());
        or.setTolerance(this.originalProblem.getTolerance());
        DoubleMatrix2D AEorig = this.originalProblem.getA();
        DoubleMatrix1D BEorig = this.originalProblem.getB();
        if (AEorig != null) {
            DoubleFactory2D F2 = AEorig instanceof SparseDoubleMatrix2D ? DoubleFactory2D.sparse : DoubleFactory2D.dense;
            DoubleMatrix2D zeroCols = F2.make(AEorig.rows(), 1);
            DoubleMatrix2D[][] parts = new DoubleMatrix2D[][]{{AEorig, zeroCols}};
            DoubleMatrix2D AE = F2.compose(parts);
            DoubleMatrix1D BE = BEorig;
            or.setA(AE);
            or.setB(BE);
        }
        if ((X0 = this.originalProblem.getNotFeasibleInitialPoint()) == null) {
            X0 = AEorig != null ? this.findOneRoot(AEorig, BEorig) : this.F1.make(this.originalProblem.getDim(), 1.0 / (double)this.originalProblem.getDim());
        }
        if (AEorig != null) {
            DoubleMatrix1D originalRPriX0 = ColtUtils.zMult(AEorig, X0, BEorig, -1.0);
            double norm = Math.sqrt(this.ALG.norm2(originalRPriX0));
            this.log.debug((Object)("norm: " + norm));
            if (norm > this.originalProblem.getToleranceFeas()) {
                throw new Exception("The initial point for Basic Phase I Method must be equalities-feasible");
            }
        }
        if ((originalFiX0 = this.originalProblem.getFi(X0)).get(maxIneqIndex = Utils.getMaxIndex(originalFiX0)) + this.originalProblem.getTolerance() < 0.0) {
            return X0;
        }
        DoubleMatrix1D initialPoint = this.F1.make(1, Math.sqrt(this.originalProblem.getToleranceFeas()));
        initialPoint = this.F1.append(X0, initialPoint);
        double s0 = initialPoint.getQuick(this.dim - 1);
        for (int i = 0; i < originalFiX0.size(); ++i) {
            s0 = Math.max(s0, originalFiX0.get(i) * 1.1);
        }
        initialPoint.setQuick(this.dim - 1, s0);
        or.setInitialPoint(initialPoint.toArray());
        PhaseILPPrimalDualMethod opt = new PhaseILPPrimalDualMethod(2.0 * s0);
        opt.setKKTSolver(new UpperDiagonalHKKTSolver(this.originalDim));
        opt.setOptimizationRequest(or);
        if (opt.optimizePresolvedStandardLP() == 2) {
            throw new Exception("Failed to find an initial feasible point");
        }
        LPOptimizationResponse response = opt.getLPOptimizationResponse();
        DoubleMatrix1D sol = this.F1.make(response.getSolution());
        DoubleMatrix1D ret = sol.viewPart(0, this.originalDim);
        DoubleMatrix1D ineq = this.originalProblem.getFi(ret);
        maxIneqIndex = Utils.getMaxIndex(ineq);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("ineq        : " + ArrayUtils.toString((Object)ineq.toArray())));
            this.log.debug((Object)("max ineq pos: " + maxIneqIndex));
            this.log.debug((Object)("max ineq val: " + ineq.get(maxIneqIndex)));
        }
        if (ineq.get(maxIneqIndex) >= 0.0) {
            throw new Exception("Infeasible problem");
        }
        return ret;
    }

    private DoubleMatrix1D findOneRoot(DoubleMatrix2D A, DoubleMatrix1D b) throws Exception {
        return this.originalProblem.findEqFeasiblePoint(A, b);
    }

    private class PhaseILPPrimalDualMethod
    extends LPPrimalDualMethod {
        private double maxSValue;

        PhaseILPPrimalDualMethod(double maxSValue) {
            this.maxSValue = maxSValue;
            this.dim = BasicPhaseILPPDM.this.originalProblem.getDim() + 1;
            this.meq = BasicPhaseILPPDM.this.originalProblem.getMeq();
            this.mieq = BasicPhaseILPPDM.this.originalProblem.getMieq() + 1;
        }

        protected DoubleMatrix1D getFi(DoubleMatrix1D Xs) {
            double[] ret = new double[BasicPhaseILPPDM.this.originalProblem.getMieq() + 1];
            double s = Xs.getQuick(this.getDim() - 1);
            for (int i = 0; i < BasicPhaseILPPDM.this.originalProblem.getDim(); ++i) {
                ret[i] = -Xs.getQuick(i) - s + BasicPhaseILPPDM.this.originalProblem.getLb().getQuick(i);
                ret[((BasicPhaseILPPDM)BasicPhaseILPPDM.this).originalProblem.getDim() + i] = Xs.getQuick(i) - s - BasicPhaseILPPDM.this.originalProblem.getUb().getQuick(i);
            }
            ret[((BasicPhaseILPPDM)BasicPhaseILPPDM.this).originalProblem.getMieq()] = s - this.maxSValue;
            return this.F1.make(ret);
        }

        protected DoubleMatrix1D rDual(DoubleMatrix1D gradF0X, DoubleMatrix1D L, DoubleMatrix1D V) {
            DoubleMatrix1D m1 = this.F1.make(this.getDim());
            for (int i = 0; i < BasicPhaseILPPDM.this.originalProblem.getDim(); ++i) {
                double m = 0.0;
                m += -L.getQuick(i);
                m1.setQuick(i, m += L.getQuick(BasicPhaseILPPDM.this.originalProblem.getDim() + i));
            }
            double d = 0.0;
            for (int i = 0; i < BasicPhaseILPPDM.this.originalProblem.getMieq(); ++i) {
                d += L.getQuick(i);
            }
            m1.setQuick(this.getDim() - 1, m1.getQuick(this.getDim() - 1) - d);
            m1 = m1.assign(gradF0X, Functions.plus);
            double m = L.getQuick(L.size() - 1);
            m1.setQuick(this.getDim() - 1, m1.getQuick(this.getDim() - 1) + m);
            if (this.getMeq() == 0) {
                return m1;
            }
            return ColtUtils.zMultTranspose(this.getA(), V, m1, 1.0);
        }

        protected DoubleMatrix1D gradSum(double t, DoubleMatrix1D fiX) {
            DoubleMatrix1D gradSum = this.F1.make(this.getDim());
            double ddim = 0.0;
            for (int i = 0; i < BasicPhaseILPPDM.this.originalProblem.getDim(); ++i) {
                double di = 0.0;
                double fiXL = fiX.getQuick(i);
                di += 1.0 / (t * fiXL);
                ddim += 1.0 / (t * fiXL);
                double fiXU = fiX.getQuick(BasicPhaseILPPDM.this.originalProblem.getDim() + i);
                ddim += 1.0 / (t * fiXU);
                gradSum.setQuick(i, di += -1.0 / (t * fiXU));
            }
            double fsU = fiX.getQuick(fiX.size() - 1);
            gradSum.setQuick(this.getDim() - 1, ddim += -1.0 / (t * fsU));
            return gradSum;
        }

        protected DoubleMatrix2D GradLSum(DoubleMatrix1D L, DoubleMatrix1D fiX) {
            SparseDoubleMatrix2D GradLSum = new SparseDoubleMatrix2D(this.getDim(), this.getDim());
            double ddimdim = 0.0;
            for (int i = 0; i < BasicPhaseILPPDM.this.originalProblem.getDim(); ++i) {
                double dii = 0.0;
                double didim = 0.0;
                double fiXL = fiX.getQuick(i);
                double LI = L.getQuick(i);
                double LIFiXL = -LI / fiXL;
                dii += LIFiXL;
                didim += LIFiXL;
                ddimdim += LIFiXL;
                double LDimI = L.getQuick(BasicPhaseILPPDM.this.originalProblem.getDim() + i);
                double fiXU = fiX.getQuick(BasicPhaseILPPDM.this.originalProblem.getDim() + i);
                double LDimIFiXU = -LDimI / fiXU;
                ddimdim += LDimIFiXU;
                GradLSum.setQuick(i, i, dii += LDimIFiXU);
                GradLSum.setQuick(this.getDim() - 1, i, didim -= LDimIFiXU);
            }
            double LDimS = L.getQuick(L.size() - 1);
            double fsU = fiX.getQuick(fiX.size() - 1);
            double LDimSFsU = -LDimS / fsU;
            GradLSum.setQuick(this.getDim() - 1, this.getDim() - 1, ddimdim += LDimSFsU);
            return GradLSum;
        }

        protected DoubleMatrix1D gradFiStepX(DoubleMatrix1D stepX) {
            DoubleMatrix1D ret = this.F1.make(this.getMieq());
            for (int i = 0; i < BasicPhaseILPPDM.this.originalProblem.getDim(); ++i) {
                ret.setQuick(i, -stepX.getQuick(i) - stepX.getQuick(this.getDim() - 1));
                ret.setQuick(BasicPhaseILPPDM.this.originalProblem.getDim() + i, stepX.getQuick(i) - stepX.getQuick(this.getDim() - 1));
            }
            ret.setQuick(this.getMieq() - 1, stepX.getQuick(this.getDim() - 1));
            return ret;
        }

        protected boolean checkCustomExitConditions(DoubleMatrix1D Xs) {
            int ineqMaxIndex;
            DoubleMatrix1D X = Xs.viewPart(0, this.getDim() - 1);
            DoubleMatrix1D ineqX = BasicPhaseILPPDM.this.originalProblem.getFi(X);
            boolean isInternal = ineqX.get(ineqMaxIndex = Utils.getMaxIndex(ineqX)) + this.getTolerance() < 0.0 || Xs.get(Xs.size() - 1) < 0.0;
            BasicPhaseILPPDM.this.log.info((Object)("isInternal  : " + isInternal));
            if (!isInternal) {
                return false;
            }
            DoubleMatrix1D originalRPriX = this.F1.make(0);
            if (this.getA() != null) {
                originalRPriX = ColtUtils.zMult(BasicPhaseILPPDM.this.originalProblem.getA(), X, BasicPhaseILPPDM.this.originalProblem.getB(), -1.0);
            }
            boolean isPrimalFeas = Math.sqrt(this.ALG.norm2(originalRPriX)) < BasicPhaseILPPDM.this.originalProblem.getToleranceFeas();
            BasicPhaseILPPDM.this.log.info((Object)("isPrimalFeas: " + isPrimalFeas));
            BasicPhaseILPPDM.this.log.info((Object)("checkCustomExitConditions: " + (isInternal && isPrimalFeas)));
            return isInternal && isPrimalFeas;
        }

        protected DoubleMatrix1D getLb() {
            return null;
        }

        protected DoubleMatrix1D getUb() {
            return null;
        }

        protected boolean checkDualityConditions(DoubleMatrix1D X, DoubleMatrix1D L, DoubleMatrix1D V) {
            return true;
        }

        protected boolean checkEqConstraintsLagrangianBounds(DoubleMatrix1D V) {
            return true;
        }

        protected boolean checkIneqConstraintsLagrangianBounds(DoubleMatrix1D X, DoubleMatrix1D L) {
            return true;
        }
    }
}

