/*
 * Decompiled with CFR 0.152.
 */
package com.joptimizer.optimizers;

import cern.colt.function.IntIntDoubleFunction;
import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.SparseDoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import com.joptimizer.algebra.Matrix1NormRescaler;
import com.joptimizer.util.ColtUtils;
import com.joptimizer.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;

public class LPPresolver {
    public static final double DEFAULT_UNBOUNDED_LOWER_BOUND = Double.NaN;
    public static final double DEFAULT_UNBOUNDED_UPPER_BOUND = Double.NaN;
    private Algebra ALG = Algebra.DEFAULT;
    private DoubleFactory1D F1 = null;
    private DoubleFactory2D F2 = null;
    private double eps = Utils.getDoubleMachineEpsilon();
    private boolean useSparsity = true;
    private boolean avoidIncreaseSparsity = false;
    private boolean avoidFillIn = false;
    private boolean avoidScaling = false;
    private double unboundedLBValue = Double.NaN;
    private double unboundedUBValue = Double.NaN;
    private int originalN;
    private int originalMeq;
    private short nOfSlackVariables = (short)-1;
    private int presolvedN = -1;
    private int presolvedMeq = -1;
    private boolean[] indipendentVariables;
    private short[] presolvedX;
    private short[] presolvedPositions;
    private DoubleMatrix1D presolvedC = null;
    private DoubleMatrix2D presolvedA = null;
    private DoubleMatrix1D presolvedB = null;
    private DoubleMatrix1D presolvedLB = null;
    private DoubleMatrix1D presolvedUB = null;
    private DoubleMatrix1D presolvedYlb = null;
    private DoubleMatrix1D presolvedYub = null;
    private DoubleMatrix1D presolvedZlb = null;
    private DoubleMatrix1D presolvedZub = null;
    private short[][] vRowPositions;
    private short[][] vColPositions;
    short[] duplicatedColsArray = new short[0];
    private double[] g;
    private double[] h;
    private int[][] vRowLengthMap;
    private int[][] vColLengthMap;
    private boolean someReductionDone = true;
    private DoubleMatrix1D T = null;
    private DoubleMatrix1D R = null;
    private double minRescaledLB = Double.NaN;
    private double maxRescaledUB = Double.NaN;
    private List<PresolvingStackElement> presolvingStack = new ArrayList<PresolvingStackElement>();
    private Log log = LogFactory.getLog((String)this.getClass().getName());
    private double[] expectedSolution;
    private double expectedTolerance = Double.NaN;

    public LPPresolver() {
        this(Double.NaN, Double.NaN);
    }

    public LPPresolver(double unboundedLBValue, double unboundedUBValue) {
        if (!Double.isNaN(unboundedLBValue) && !Double.isInfinite(unboundedLBValue)) {
            throw new IllegalArgumentException("The field unboundedLBValue must be set to Double.NaN or Double.NEGATIVE_INFINITY");
        }
        if (!Double.isNaN(unboundedUBValue) && !Double.isInfinite(unboundedUBValue)) {
            throw new IllegalArgumentException("The field unboundedUBValue must be set to Double.NaN or Double.POSITIVE_INFINITY");
        }
        this.unboundedLBValue = unboundedLBValue;
        this.unboundedUBValue = unboundedUBValue;
    }

    public boolean isUseSparsity() {
        return this.useSparsity;
    }

    public void setUseSparsity(boolean useSparsity) {
        this.useSparsity = useSparsity;
    }

    public boolean isAvoidIncreaseSparsity() {
        return this.avoidIncreaseSparsity;
    }

    public void setAvoidIncreaseSparsity(boolean avoidIncreaseSparsity) {
        this.avoidIncreaseSparsity = avoidIncreaseSparsity;
    }

    public void setAvoidFillIn(boolean avoidFillIn) {
        this.avoidFillIn = avoidFillIn;
    }

    public boolean isAvoidFillIn() {
        return this.avoidFillIn;
    }

    public void setAvoidScaling(boolean avoidScaling) {
        this.avoidScaling = avoidScaling;
    }

    public boolean isAvoidScaling() {
        return this.avoidScaling;
    }

    public void presolve(double[] originalC, double[][] originalA, double[] originalB, double[] originalLB, double[] originalUB) {
        this.F1 = this.useSparsity ? DoubleFactory1D.sparse : DoubleFactory1D.dense;
        this.F2 = this.useSparsity ? DoubleFactory2D.sparse : DoubleFactory2D.dense;
        DoubleMatrix1D cVector = this.F1.make(originalC);
        DoubleMatrix2D AMatrix = null;
        DoubleMatrix1D bVector = null;
        if (originalA != null) {
            AMatrix = this.F2.make(originalA);
            bVector = this.F1.make(originalB);
        }
        if (originalLB != null && originalUB != null && originalLB.length != originalUB.length) {
            throw new IllegalArgumentException("lower and upper bounds have different lenght");
        }
        DoubleMatrix1D lbVector = originalLB != null ? this.F1.make(originalLB) : null;
        DoubleMatrix1D ubVector = originalUB != null ? this.F1.make(originalUB) : null;
        this.presolve(cVector, AMatrix, bVector, lbVector, ubVector);
    }

    public void presolve(DoubleMatrix1D originalC, DoubleMatrix2D originalA, DoubleMatrix1D originalB, DoubleMatrix1D originalLB, DoubleMatrix1D originalUB) {
        int i;
        short col;
        int j;
        short[] vRowPositionsI;
        long t0 = System.currentTimeMillis();
        this.F1 = this.useSparsity ? DoubleFactory1D.sparse : DoubleFactory1D.dense;
        this.F2 = this.useSparsity ? DoubleFactory2D.sparse : DoubleFactory2D.dense;
        DoubleMatrix1D c = originalC.copy();
        this.originalN = originalA != null ? originalA.columns() : originalLB.size();
        this.originalMeq = originalA != null ? originalA.rows() : 0;
        this.indipendentVariables = new boolean[this.originalN];
        Arrays.fill(this.indipendentVariables, true);
        this.g = new double[this.originalN];
        this.h = new double[this.originalN];
        if (originalLB == null) {
            originalLB = this.F1.make(this.originalN, this.unboundedLBValue);
        }
        if (originalUB == null) {
            originalUB = this.F1.make(this.originalN, this.unboundedUBValue);
        }
        for (int i2 = 0; i2 < this.originalN; ++i2) {
            if (!(originalUB.getQuick(i2) < originalLB.getQuick(i2))) continue;
            this.log.debug((Object)"Infeasible problem");
            throw new RuntimeException("Infeasible problem");
        }
        DoubleMatrix1D lb = originalLB.copy();
        DoubleMatrix1D ub = originalUB.copy();
        final DoubleMatrix2D A = this.useSparsity ? new SparseDoubleMatrix2D(this.originalMeq, this.originalN) : this.F2.make(this.originalMeq, this.originalN);
        DoubleMatrix1D b = originalB != null ? originalB.copy() : this.F1.make(0);
        this.vRowLengthMap = new int[this.originalN + 1][];
        this.vColLengthMap = new int[this.originalMeq + 1][];
        DoubleMatrix1D ylb = this.F1.make(this.originalMeq, this.unboundedLBValue);
        DoubleMatrix1D yub = this.F1.make(this.originalMeq, this.unboundedUBValue);
        DoubleMatrix1D zlb = this.F1.make(this.originalN, this.unboundedLBValue);
        DoubleMatrix1D zub = this.F1.make(this.originalN, this.unboundedUBValue);
        int entries = this.originalN * this.originalMeq;
        int cardinality = 0;
        short[] vColCounter = new short[this.originalN];
        this.vRowPositions = new short[this.originalMeq][0];
        if (originalA instanceof SparseDoubleMatrix2D) {
            SparseDoubleMatrix2D Q = (SparseDoubleMatrix2D)originalA;
            final int[] cardinalityHolder = new int[]{cardinality};
            final short[] vColCounterPH = new short[this.originalN];
            for (int column = 0; column < this.originalN; ++column) {
                final int[] currentColumnIndexHolder = new int[]{column};
                DoubleMatrix2D P = Q.viewPart(0, column, this.originalMeq, 1);
                P.forEachNonZero(new IntIntDoubleFunction(){

                    public double apply(int i, int j, double qij) {
                        cardinalityHolder[0] = cardinalityHolder[0] + 1;
                        if (LPPresolver.this.vRowPositions[i] == null) {
                            ((LPPresolver)LPPresolver.this).vRowPositions[i] = new short[0];
                        }
                        ((LPPresolver)LPPresolver.this).vRowPositions[i] = ArrayUtils.add((short[])LPPresolver.this.vRowPositions[i], (int)LPPresolver.this.vRowPositions[i].length, (short)((short)currentColumnIndexHolder[0]));
                        vColCounterPH[currentColumnIndexHolder[0]] = (short)(vColCounterPH[currentColumnIndexHolder[0]] + 1);
                        A.setQuick(i, currentColumnIndexHolder[0], qij);
                        return qij;
                    }
                });
            }
            cardinality = cardinalityHolder[0];
            vColCounter = vColCounterPH;
            for (int i3 = 0; i3 < this.originalMeq; ++i3) {
                short[] vRowPositionsI2 = this.vRowPositions[i3];
                if (vRowPositionsI2.length < 1 && !this.isZero(originalB.getQuick(i3))) {
                    this.log.debug((Object)"Infeasible problem");
                    throw new RuntimeException("Infeasible problem");
                }
                this.vRowLengthMap[vRowPositionsI2.length] = this.vRowLengthMap[vRowPositionsI2.length] == null ? new int[]{i3} : this.addToSortedArray(this.vRowLengthMap[vRowPositionsI2.length], i3);
            }
        } else {
            for (int i4 = 0; i4 < this.originalMeq; i4 = (int)((short)(i4 + 1))) {
                vRowPositionsI = new short[]{};
                for (short j2 = 0; j2 < this.originalN; j2 = (short)((short)(j2 + 1))) {
                    double originalAIJ = originalA.getQuick(i4, j2);
                    if (this.isZero(originalAIJ)) continue;
                    ++cardinality;
                    vRowPositionsI = ArrayUtils.add((short[])vRowPositionsI, (int)vRowPositionsI.length, (short)j2);
                    short s = j2;
                    vColCounter[s] = (short)(vColCounter[s] + 1);
                    A.setQuick(i4, j2, originalAIJ);
                }
                if (vRowPositionsI.length < 1 && !this.isZero(originalB.getQuick(i4))) {
                    this.log.debug((Object)"Infeasible problem");
                    throw new RuntimeException("Infeasible problem");
                }
                this.vRowPositions[i4] = vRowPositionsI;
                this.vRowLengthMap[vRowPositionsI.length] = this.vRowLengthMap[vRowPositionsI.length] == null ? new int[]{i4} : this.addToSortedArray(this.vRowLengthMap[vRowPositionsI.length], i4);
            }
        }
        for (j = 0; j < vColCounter.length; ++j) {
            if (vColCounter[j] != 0) continue;
            if (originalC.getQuick(j) > 0.0) {
                if (this.isLBUnbounded(lb.getQuick(j))) {
                    this.log.debug((Object)"unbounded problem");
                    throw new RuntimeException("unbounded problem");
                }
                this.log.debug((Object)("found empty column: " + j));
                ub.setQuick(j, lb.getQuick(j));
                continue;
            }
            if (!(originalC.getQuick(j) < 0.0)) continue;
            if (this.isUBUnbounded(ub.getQuick(j))) {
                this.log.debug((Object)"unbounded problem");
                throw new RuntimeException("unbounded problem");
            }
            this.log.debug((Object)("found empty column: " + j));
            lb.setQuick(j, ub.getQuick(j));
        }
        this.vColPositions = new short[this.originalN][];
        for (j = 0; j < this.originalN; ++j) {
            short length = vColCounter[j];
            this.vColPositions[j] = new short[length];
            this.vColLengthMap[length] = this.vColLengthMap[length] == null ? new int[]{j} : this.addToSortedArray(this.vColLengthMap[length], j);
        }
        for (int i5 = 0; i5 < this.vRowPositions.length; ++i5) {
            vRowPositionsI = this.vRowPositions[i5];
            for (int j3 = 0; j3 < vRowPositionsI.length; ++j3) {
                col = vRowPositionsI[j3];
                this.vColPositions[col][this.vColPositions[col].length - vColCounter[col]] = (short)i5;
                short s = vRowPositionsI[j3];
                vColCounter[s] = (short)(vColCounter[s] - 1);
            }
        }
        vColCounter = null;
        this.log.debug((Object)("sparsity index: " + 100.0 * (double)(entries - cardinality) / (double)entries + " % (" + cardinality + "nz/" + entries + "tot)"));
        this.checkProgress(c, A, b, lb, ub, ylb, yub, zlb, zub);
        this.removeFixedVariables(c, A, b, lb, ub, ylb, yub, zlb, zub);
        int iteration = 0;
        while (this.someReductionDone) {
            this.log.debug((Object)("iteration: " + ++iteration));
            this.someReductionDone = false;
            this.checkProgress(c, A, b, lb, ub, ylb, yub, zlb, zub);
            this.removeFixedVariables(c, A, b, lb, ub, ylb, yub, zlb, zub);
            this.checkProgress(c, A, b, lb, ub, ylb, yub, zlb, zub);
            this.removeSingletonRows(c, A, b, lb, ub, ylb, yub, zlb, zub);
            this.checkProgress(c, A, b, lb, ub, ylb, yub, zlb, zub);
            this.removeForcingConstraints(c, A, b, lb, ub, ylb, yub, zlb, zub);
            this.checkProgress(c, A, b, lb, ub, ylb, yub, zlb, zub);
            if (iteration < 5) {
                this.compareBounds(c, A, b, lb, ub, ylb, yub, zlb, zub);
                this.checkProgress(c, A, b, lb, ub, ylb, yub, zlb, zub);
            }
            this.removeDominatedConstraints(c, A, b, lb, ub, ylb, yub, zlb, zub);
            this.checkProgress(c, A, b, lb, ub, ylb, yub, zlb, zub);
            this.checkColumnSingletons(c, A, b, lb, ub, ylb, yub, zlb, zub);
            this.checkProgress(c, A, b, lb, ub, ylb, yub, zlb, zub);
            this.removeDominatedColumns(c, A, b, lb, ub, ylb, yub, zlb, zub);
            this.checkProgress(c, A, b, lb, ub, ylb, yub, zlb, zub);
            if (!this.avoidIncreaseSparsity) {
                this.removeDuplicateRow(c, A, b, lb, ub, ylb, yub, zlb, zub);
                this.checkProgress(c, A, b, lb, ub, ylb, yub, zlb, zub);
                this.removeDuplicateColumn(c, A, b, lb, ub, ylb, yub, zlb, zub);
                this.checkProgress(c, A, b, lb, ub, ylb, yub, zlb, zub);
            }
            if (this.avoidFillIn) continue;
            this.removeDoubletonRow(c, A, b, lb, ub, ylb, yub, zlb, zub);
            this.checkProgress(c, A, b, lb, ub, ylb, yub, zlb, zub);
        }
        this.removeAllEmptyRowsAndColumns(c, A, b, lb, ub, ylb, yub, zlb, zub);
        this.presolvedN = 0;
        this.presolvedX = new short[this.originalN];
        Arrays.fill(this.presolvedX, (short)-1);
        this.presolvedPositions = new short[this.originalN];
        Arrays.fill(this.presolvedPositions, (short)-1);
        for (int j4 = 0; j4 < this.indipendentVariables.length; ++j4) {
            if (!this.indipendentVariables[j4]) continue;
            this.presolvedX[this.presolvedN] = (short)j4;
            this.presolvedPositions[j4] = (short)this.presolvedN;
            ++this.presolvedN;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("final n    : " + this.presolvedN));
            this.log.debug((Object)("presolvedX           : " + ArrayUtils.toString((Object)this.presolvedX)));
            this.log.debug((Object)("presolvedPositions   : " + ArrayUtils.toString((Object)this.presolvedPositions)));
            this.log.debug((Object)("indipendentVariables : " + ArrayUtils.toString((Object)this.indipendentVariables)));
        }
        this.presolvedMeq = 0;
        for (int i6 = 0; i6 < this.vRowPositions.length; ++i6) {
            if (this.vRowPositions[i6].length <= 0) continue;
            ++this.presolvedMeq;
        }
        this.log.debug((Object)("final meq: " + ArrayUtils.toString((Object)this.presolvedMeq)));
        if (this.presolvedMeq > 0) {
            this.presolvedA = this.useSparsity ? new SparseDoubleMatrix2D(this.presolvedMeq, this.presolvedN) : this.F2.make(this.presolvedMeq, this.presolvedN);
            this.presolvedB = this.F1.make(this.presolvedMeq);
            this.presolvedYlb = this.F1.make(this.presolvedMeq);
            this.presolvedYub = this.F1.make(this.presolvedMeq);
        }
        if (this.presolvedN > 0) {
            this.presolvedC = this.F1.make(this.presolvedN);
            this.presolvedLB = this.F1.make(this.presolvedN);
            this.presolvedUB = this.F1.make(this.presolvedN);
            this.presolvedZlb = this.F1.make(this.presolvedN);
            this.presolvedZub = this.F1.make(this.presolvedN);
        }
        int cntR = 0;
        for (i = 0; this.presolvedA != null && i < this.vRowPositions.length; ++i) {
            short[] vRowPositionsI3 = this.vRowPositions[i];
            if (vRowPositionsI3.length <= 0) continue;
            for (int j5 = 0; j5 < vRowPositionsI3.length; ++j5) {
                short jnz = vRowPositionsI3[j5];
                short col2 = this.presolvedPositions[jnz];
                this.presolvedA.setQuick(cntR, col2, A.getQuick(i, jnz));
                this.presolvedB.setQuick(cntR, b.getQuick(i));
            }
            cntR = (short)(cntR + 1);
        }
        cntR = 0;
        for (i = 0; i < this.vRowPositions.length; ++i) {
            if (this.vRowPositions[i].length <= 0) continue;
            this.presolvedYlb.setQuick(cntR, ylb.getQuick(i));
            this.presolvedYub.setQuick(cntR, yub.getQuick(i));
            cntR = (short)(cntR + 1);
        }
        for (int j6 = 0; j6 < this.presolvedN; ++j6) {
            col = this.presolvedX[j6];
            this.presolvedC.setQuick(j6, c.getQuick(col));
            this.presolvedLB.setQuick(j6, lb.getQuick(col));
            this.presolvedUB.setQuick(j6, ub.getQuick(col));
            this.presolvedZlb.setQuick(j6, zlb.getQuick(col));
            this.presolvedZub.setQuick(j6, zub.getQuick(col));
        }
        if (!this.avoidScaling) {
            this.scaling();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("presolvingStack : " + this.presolvingStack));
            if (this.R != null) {
                this.log.debug((Object)("presolving R : " + ArrayUtils.toString((Object)this.R.toArray())));
                this.log.debug((Object)("presolving T : " + ArrayUtils.toString((Object)this.T.toArray())));
            }
        }
        this.log.info((Object)("end presolving (" + (System.currentTimeMillis() - t0) + " ms)"));
    }

    public double[] presolve(double[] x) {
        int i;
        if (x.length != this.originalN) {
            throw new IllegalArgumentException("wrong array dimension: " + x.length);
        }
        double[] presolvedX = this.duplicateArray(x);
        for (int i2 = 0; i2 < this.presolvingStack.size(); ++i2) {
            this.presolvingStack.get(i2).preSolve(presolvedX);
        }
        double[] ret = new double[this.presolvedN];
        int cntPosition = 0;
        for (i = 0; i < presolvedX.length; ++i) {
            if (!this.indipendentVariables[i]) continue;
            ret[cntPosition] = presolvedX[i];
            ++cntPosition;
        }
        if (this.T != null) {
            for (i = 0; i < ret.length; ++i) {
                ret[i] = ret[i] / this.T.getQuick(i);
            }
        }
        return ret;
    }

    public double[] postsolve(double[] x) {
        int i;
        double[] postsolvedX = new double[this.originalN];
        if (this.T != null) {
            for (i = 0; i < x.length; ++i) {
                x[i] = this.T.getQuick(i) * x[i];
            }
        }
        for (i = 0; i < x.length; ++i) {
            postsolvedX[this.presolvedX[i]] = x[i];
        }
        for (i = this.presolvingStack.size() - 1; i > -1; --i) {
            this.presolvingStack.get(i).postSolve(postsolvedX);
        }
        return postsolvedX;
    }

    private void removeFixedVariables(DoubleMatrix1D c, DoubleMatrix2D A, DoubleMatrix1D b, DoubleMatrix1D lb, DoubleMatrix1D ub, DoubleMatrix1D ylb, DoubleMatrix1D yub, DoubleMatrix1D zlb, DoubleMatrix1D zub) {
        for (short j = 0; j < this.indipendentVariables.length; j = (short)((short)(j + 1))) {
            if (!this.indipendentVariables[j] || this.isLBUnbounded(lb.getQuick(j)) || !this.isZero(lb.getQuick(j) - ub.getQuick(j))) continue;
            double v = lb.getQuick(j);
            this.log.debug((Object)("found fixed variables: x[" + j + "]=" + v));
            this.checkFixedVariableBounds(j, v, lb, ub);
            this.addToPresolvingStack(new LinearDependency(j, null, null, v));
            block1: for (short k = 0; k < this.vRowPositions.length; k = (short)((short)(k + 1))) {
                short[] vRowPositionsK = this.vRowPositions[k];
                for (int i = 0; i < vRowPositionsK.length; i = (int)((short)(i + 1))) {
                    if (vRowPositionsK[i] == j) {
                        if (vRowPositionsK.length == 1 && !this.isZero(v - b.getQuick(k) / A.getQuick(k, j))) {
                            this.log.debug((Object)"Infeasible problem");
                            throw new RuntimeException("Infeasible problem");
                        }
                        b.setQuick(k, b.getQuick(k) - A.getQuick(k, j) * v);
                        this.vRowPositions[k] = this.removeElementFromSortedArray(vRowPositionsK, j);
                        this.changeRowsLengthPosition(k, this.vRowPositions[k].length + 1, this.vRowPositions[k].length);
                        A.setQuick(k, j, 0.0);
                        continue block1;
                    }
                    if (vRowPositionsK[i] > j) continue block1;
                }
            }
            this.changeColumnsLengthPosition(j, this.vColPositions[j].length, 0);
            this.vColPositions[j] = new short[0];
            this.someReductionDone = true;
        }
    }

    private void removeSingletonRows(DoubleMatrix1D c, DoubleMatrix2D A, DoubleMatrix1D b, DoubleMatrix1D lb, DoubleMatrix1D ub, DoubleMatrix1D ylb, DoubleMatrix1D yub, DoubleMatrix1D zlb, DoubleMatrix1D zub) {
        for (int i = 0; i < this.vRowPositions.length; i = (int)((short)(i + 1))) {
            short[] vRowPositionsI = this.vRowPositions[i];
            if (vRowPositionsI.length != 1) continue;
            short j = vRowPositionsI[0];
            double AIJ = A.getQuick(i, j);
            if (this.isZero(AIJ)) {
                this.log.debug((Object)("A[" + i + "][" + j + "]: expected non-zero but was " + AIJ));
                throw new IllegalStateException("A[" + i + "][" + j + "]: expected non-zero but was " + AIJ);
            }
            double xj = b.getQuick(i) / AIJ;
            this.log.debug((Object)("found singleton at row " + i + ": x[" + j + "]=" + xj));
            this.checkFixedVariableBounds(j, xj, lb, ub);
            this.addToPresolvingStack(new LinearDependency(j, null, null, xj));
            block1: for (short k = 0; k < this.vRowPositions.length; k = (short)((short)(k + 1))) {
                if (k == i) continue;
                short[] vRowPositionsK = this.vRowPositions[k];
                for (int nz = 0; nz < vRowPositionsK.length; nz = (int)((short)(nz + 1))) {
                    if (vRowPositionsK[nz] == j) {
                        if (vRowPositionsK.length == 1 && !this.isZero(xj - b.getQuick(k) / A.getQuick(k, j))) {
                            this.log.debug((Object)"Infeasible problem");
                            throw new RuntimeException("Infeasible problem");
                        }
                        b.setQuick(k, b.getQuick(k) - A.getQuick(k, j) * xj);
                        A.setQuick(k, j, 0.0);
                        this.vRowPositions[k] = ArrayUtils.remove((short[])vRowPositionsK, (int)nz);
                        this.changeRowsLengthPosition(k, this.vRowPositions[k].length + 1, this.vRowPositions[k].length);
                        continue block1;
                    }
                    if (vRowPositionsK[nz] > j) continue block1;
                }
            }
            A.setQuick(i, j, 0.0);
            b.setQuick(i, 0.0);
            this.changeColumnsLengthPosition(j, this.vColPositions[j].length, 0);
            this.vColPositions[j] = new short[0];
            this.vRowPositions[i] = ArrayUtils.remove((short[])vRowPositionsI, (int)0);
            this.changeRowsLengthPosition((short)i, this.vRowPositions[i].length + 1, this.vRowPositions[i].length);
            this.someReductionDone = true;
            i = -1;
        }
    }

    private void removeForcingConstraints(DoubleMatrix1D c, DoubleMatrix2D A, DoubleMatrix1D b, DoubleMatrix1D lb, DoubleMatrix1D ub, DoubleMatrix1D ylb, DoubleMatrix1D yub, DoubleMatrix1D zlb, DoubleMatrix1D zub) {
        for (short i = 0; i < this.vRowPositions.length; i = (short)((short)(i + 1))) {
            boolean t2;
            int nz;
            short[] vRowPositionsI = this.vRowPositions[i];
            if (vRowPositionsI.length <= 0) continue;
            this.g[i] = 0.0;
            this.h[i] = 0.0;
            boolean allPositive = true;
            boolean allNegative = true;
            boolean allLbPositive = true;
            boolean allUbFinite = true;
            for (int nz2 = 0; nz2 < vRowPositionsI.length; nz2 = (int)((short)(nz2 + 1))) {
                short j = vRowPositionsI[nz2];
                double AIJ = A.getQuick(i, j);
                if (this.isZero(AIJ)) {
                    this.log.debug((Object)("A[" + i + "][" + j + "]: expected non-zero but was " + AIJ));
                    throw new IllegalStateException("A[" + i + "][" + j + "]: expected non-zero but was " + AIJ);
                }
                if (AIJ > 0.0) {
                    short s = i;
                    this.g[s] = this.g[s] + AIJ * lb.getQuick(j);
                    short s2 = i;
                    this.h[s2] = this.h[s2] + AIJ * ub.getQuick(j);
                    allNegative = false;
                } else {
                    short s = i;
                    this.g[s] = this.g[s] + AIJ * ub.getQuick(j);
                    short s3 = i;
                    this.h[s3] = this.h[s3] + AIJ * lb.getQuick(j);
                    allPositive = false;
                }
                allLbPositive = allLbPositive && lb.getQuick(j) >= 0.0;
                allUbFinite = allUbFinite && !this.isUBUnbounded(ub.getQuick(j));
            }
            if (this.h[i] < b.getQuick(i) || b.getQuick(i) < this.g[i]) {
                this.log.debug((Object)"Infeasible problem");
                throw new RuntimeException("Infeasible problem");
            }
            short[] forcedVariablesI = new short[]{};
            if (this.isZero(this.g[i] - b.getQuick(i))) {
                this.log.debug((Object)("found forcing constraint at row: " + i));
                for (nz = 0; nz < vRowPositionsI.length; nz = (int)((short)(nz + 1))) {
                    short j = vRowPositionsI[nz];
                    double aij = A.getQuick(i, j);
                    if (aij > 0.0) {
                        ub.setQuick(j, lb.getQuick(j));
                    } else {
                        lb.setQuick(j, ub.getQuick(j));
                    }
                    this.log.debug((Object)("x[" + j + "]=" + lb.getQuick(j)));
                    forcedVariablesI = ArrayUtils.add((short[])forcedVariablesI, (short)j);
                    this.checkFixedVariableBounds(j, lb.getQuick(j), lb, ub);
                    this.addToPresolvingStack(new LinearDependency(j, null, null, lb.getQuick(j)));
                }
            } else if (this.isZero(this.h[i] - b.getQuick(i))) {
                this.log.debug((Object)("found forcing constraint at row: " + i));
                for (nz = 0; nz < vRowPositionsI.length; nz = (int)((short)(nz + 1))) {
                    short j = vRowPositionsI[nz];
                    double aij = A.getQuick(i, j);
                    if (aij > 0.0) {
                        lb.setQuick(j, ub.getQuick(j));
                    } else {
                        ub.setQuick(j, lb.getQuick(j));
                    }
                    this.log.debug((Object)("x[" + j + "]=" + lb.getQuick(j)));
                    forcedVariablesI = ArrayUtils.add((short[])forcedVariablesI, (short)j);
                    this.checkFixedVariableBounds(j, lb.getQuick(j), lb, ub);
                    this.addToPresolvingStack(new LinearDependency(j, null, null, lb.getQuick(j)));
                }
            }
            if (forcedVariablesI.length > 0) {
                for (int fv = 0; fv < forcedVariablesI.length; fv = (int)((short)(fv + 1))) {
                    short j = forcedVariablesI[fv];
                    double xj = lb.getQuick(j);
                    block5: for (short k = 0; k < this.vRowPositions.length; k = (short)((short)(k + 1))) {
                        if (k == i) continue;
                        short[] vRowPositionsK = this.vRowPositions[k];
                        for (int nz3 = 0; nz3 < vRowPositionsK.length; nz3 = (int)((short)(nz3 + 1))) {
                            if (vRowPositionsK[nz3] == j) {
                                if (vRowPositionsK.length == 1 && !this.isZero(xj - b.getQuick(k) / A.getQuick(k, j))) {
                                    this.log.debug((Object)"Infeasible problem");
                                    throw new RuntimeException("Infeasible problem");
                                }
                                b.setQuick(k, b.getQuick(k) - A.getQuick(k, j) * xj);
                                A.setQuick(k, j, 0.0);
                                this.vRowPositions[k] = ArrayUtils.remove((short[])vRowPositionsK, (int)nz3);
                                this.changeRowsLengthPosition(k, this.vRowPositions[k].length + 1, this.vRowPositions[k].length);
                                this.changeColumnsLengthPosition(j, this.vColPositions[j].length, this.vColPositions[j].length - 1);
                                this.vColPositions[j] = ArrayUtils.remove((short[])this.vColPositions[j], (int)0);
                                continue block5;
                            }
                            if (vRowPositionsK[nz3] > j) continue block5;
                        }
                    }
                    A.setQuick(i, j, 0.0);
                    b.setQuick(i, 0.0);
                    this.vRowPositions[i] = this.removeElementFromSortedArray(this.vRowPositions[i], j);
                    this.changeRowsLengthPosition(i, this.vRowPositions[i].length + 1, this.vRowPositions[i].length);
                    if (this.vColPositions[j].length != 1 && this.vColPositions[j][0] != j) {
                        this.log.debug((Object)("Expected empty column " + j + " but was not empty"));
                        throw new IllegalStateException("Expected empty column " + j + " but was not empty");
                    }
                    this.changeColumnsLengthPosition(j, this.vColPositions[j].length, 0);
                    this.vColPositions[j] = new short[0];
                    this.someReductionDone = true;
                }
                if (this.vRowPositions[i].length > 0) {
                    this.log.debug((Object)("Expected empty row " + i + " but was not empty"));
                    throw new IllegalStateException("Expected empty row " + i + " but was not empty");
                }
                this.vRowPositions[i] = new short[0];
                b.setQuick(i, 0.0);
                continue;
            }
            boolean aa = this.g[i] >= 0.0 && b.getQuick(i) >= 0.0;
            boolean bb = this.h[i] <= 0.0 && b.getQuick(i) <= 0.0;
            boolean t1 = aa && allPositive;
            boolean bl = t2 = bb && allNegative;
            if (!t1 && !t2) continue;
            boolean sameSignReductionDone = false;
            for (int nz4 = 0; nz4 < vRowPositionsI.length; nz4 = (int)((short)(nz4 + 1))) {
                short nzj = vRowPositionsI[nz4];
                double d = b.getQuick(i) / A.getQuick(i, nzj);
                if (!this.isUBUnbounded(ub.getQuick(nzj)) && !(ub.getQuick(nzj) > d)) continue;
                ub.setQuick(nzj, d);
                sameSignReductionDone = true;
            }
            if (!sameSignReductionDone) continue;
            this.someReductionDone = true;
            this.log.debug((Object)("all same signs lb reduction at row " + i));
        }
    }

    private void compareBounds(DoubleMatrix1D c, DoubleMatrix2D A, DoubleMatrix1D b, DoubleMatrix1D lb, DoubleMatrix1D ub, DoubleMatrix1D ylb, DoubleMatrix1D yub, DoubleMatrix1D zlb, DoubleMatrix1D zub) {
        int treshold = this.avoidFillIn ? 2 : 3;
        for (int i = 0; i < this.vRowPositions.length; i = (int)((short)(i + 1))) {
            int j;
            short[] vRowPositionsI = this.vRowPositions[i];
            if (vRowPositionsI.length < treshold) continue;
            boolean allLbPositive = true;
            int cntSP = 0;
            int cntSM = 0;
            boolean allSPLbFinite = true;
            boolean allSPUbFinite = true;
            boolean allSMLbFinite = true;
            boolean allSMUbFinite = true;
            for (int nz = 0; nz < vRowPositionsI.length; nz = (int)((short)(nz + 1))) {
                short j2 = vRowPositionsI[nz];
                allLbPositive = allLbPositive && lb.getQuick(j2) >= 0.0;
                double aij = A.getQuick(i, j2);
                if (aij >= 0.0) {
                    ++cntSP;
                    allSPLbFinite = allSPLbFinite && !this.isLBUnbounded(lb.getQuick(j2));
                    allSPUbFinite = allSPUbFinite && !this.isUBUnbounded(ub.getQuick(j2));
                } else {
                    ++cntSM;
                    allSMLbFinite = allSMLbFinite && !this.isLBUnbounded(lb.getQuick(j2));
                    boolean bl = allSMUbFinite = allSMUbFinite && !this.isUBUnbounded(ub.getQuick(j2));
                }
                if (!allLbPositive && !allSPLbFinite && !allSPUbFinite && !allSMLbFinite && !allSMUbFinite) break;
            }
            if (!allLbPositive) continue;
            if (allSPUbFinite) {
                double aij;
                short j3;
                int nz;
                this.log.debug((Object)("all lb positive and ub of variables with positive coeff finite at row " + i));
                int cntAijPositive = 0;
                int cntAijNegative = 0;
                double spub = 0.0;
                for (nz = 0; nz < vRowPositionsI.length; nz = (int)((short)(nz + 1))) {
                    j3 = vRowPositionsI[nz];
                    aij = A.getQuick(i, j3);
                    if (!(aij >= 0.0)) continue;
                    ++cntAijPositive;
                    spub += aij * ub.getQuick(j3);
                }
                for (nz = 0; nz < vRowPositionsI.length; nz = (int)((short)(nz + 1))) {
                    j3 = vRowPositionsI[nz];
                    aij = A.getQuick(i, j3);
                    if (!(aij < 0.0)) continue;
                    ++cntAijNegative;
                    if (!this.isUBUnbounded(ub.getQuick(j3)) && !(ub.getQuick(j3) > -(spub - b.getQuick(i)) / aij)) continue;
                    this.log.debug((Object)("old ub: " + ub.getQuick(j3)));
                    this.log.debug((Object)("new ub: " + -(spub - b.getQuick(i)) / aij));
                    ub.setQuick(j3, -(spub - b.getQuick(i)) / aij);
                    this.someReductionDone = true;
                }
            }
            if (allSMUbFinite) {
                short j4;
                int nz;
                this.log.debug((Object)("all lb positive and ub of variables with negative coeff finite at row " + i));
                double smub = 0.0;
                for (nz = 0; nz < vRowPositionsI.length; nz = (int)((short)(nz + 1))) {
                    j4 = vRowPositionsI[nz];
                    double aij = A.getQuick(i, j4);
                    if (!(aij <= 0.0)) continue;
                    smub -= aij * ub.getQuick(j4);
                }
                for (nz = 0; nz < vRowPositionsI.length; nz = (int)((short)(nz + 1))) {
                    j4 = vRowPositionsI[nz];
                    double aij = A.getQuick(i, j4);
                    if (!(aij > 0.0) || !this.isUBUnbounded(ub.getQuick(j4)) && !(ub.getQuick(j4) > (b.getQuick(i) + smub) / aij)) continue;
                    this.log.debug((Object)("old ub: " + ub.getQuick(j4)));
                    this.log.debug((Object)("new ub: " + (b.getQuick(i) + smub) / aij));
                    ub.setQuick(j4, (b.getQuick(i) + smub) / aij);
                    this.someReductionDone = true;
                }
            }
            if (cntSM == 1 && allSPLbFinite) {
                this.log.debug((Object)("1 negative coeff and finite lb of positice coeff variables at row " + i));
                double splb = 0.0;
                int m = -1;
                for (int nz = 0; nz < vRowPositionsI.length; nz = (int)((short)(nz + 1))) {
                    j = vRowPositionsI[nz];
                    double aij = A.getQuick(i, j);
                    if (aij >= 0.0) {
                        splb += aij * lb.getQuick(j);
                        continue;
                    }
                    m = j;
                }
                double aim = -A.getQuick(i, m);
                if (this.isLBUnbounded(lb.getQuick(m)) || lb.getQuick(m) < (-b.getQuick(i) + splb) / aim) {
                    this.log.debug((Object)("old lb: " + lb.getQuick(m)));
                    this.log.debug((Object)("new lb: " + (-b.getQuick(i) + splb) / aim));
                    lb.setQuick(m, (-b.getQuick(i) + splb) / aim);
                    this.someReductionDone = true;
                }
            }
            if (cntSP != true || !allSMLbFinite) continue;
            this.log.debug((Object)("1 positive coeff and finite lb of negative coeff variables at row " + i));
            double smlb = 0.0;
            int p = -1;
            for (int nz = 0; nz < vRowPositionsI.length; nz = (int)((short)(nz + 1))) {
                j = vRowPositionsI[nz];
                double aij = A.getQuick(i, j);
                if (aij <= 0.0) {
                    smlb -= aij * lb.getQuick(j);
                    continue;
                }
                p = j;
            }
            double aip = A.getQuick(i, p);
            if (!this.isLBUnbounded(lb.getQuick(p)) && !(lb.getQuick(p) < (b.getQuick(i) + smlb) / aip)) continue;
            this.log.debug((Object)("old lb: " + lb.getQuick(p)));
            this.log.debug((Object)("new lb: " + (b.getQuick(i) + smlb) / aip));
            lb.setQuick(p, (b.getQuick(i) + smlb) / aip);
            this.someReductionDone = true;
        }
    }

    private void removeDominatedConstraints(DoubleMatrix1D c, DoubleMatrix2D A, DoubleMatrix1D b, DoubleMatrix1D lb, DoubleMatrix1D ub, DoubleMatrix1D ylb, DoubleMatrix1D yub, DoubleMatrix1D zlb, DoubleMatrix1D zub) {
    }

    private void checkColumnSingletons(DoubleMatrix1D c, DoubleMatrix2D A, DoubleMatrix1D b, DoubleMatrix1D lb, DoubleMatrix1D ub, DoubleMatrix1D ylb, DoubleMatrix1D yub, DoubleMatrix1D zlb, DoubleMatrix1D zub) {
        for (short col = 0; col < this.vColPositions.length; col = (short)((short)(col + 1))) {
            boolean isImpliedFree;
            boolean ifu;
            double impliedU;
            double impliedL;
            if (this.vColPositions[col].length != 1) continue;
            short row = this.vColPositions[col][0];
            this.log.debug((Object)("found column singleton at row " + row + ", col " + col));
            short[] vRowPositionsRow = this.vRowPositions[row];
            if (vRowPositionsRow.length < 2) continue;
            double ARcol = A.getQuick(row, col);
            double cCol = c.getQuick(col);
            boolean isCColNz = !this.isZero(cCol);
            double lbCol = lb.getQuick(col);
            double ubCol = ub.getQuick(col);
            boolean isLBUnbounded = this.isLBUnbounded(lbCol);
            boolean isUBUnbounded = this.isUBUnbounded(ubCol);
            if (isLBUnbounded || isUBUnbounded) {
                if (isLBUnbounded) {
                    if (isUBUnbounded) {
                        zlb.setQuick(col, 0.0);
                        zub.setQuick(col, 0.0);
                        ylb.setQuick(row, cCol / ARcol);
                        yub.setQuick(row, cCol / ARcol);
                    } else if (ARcol > 0.0) {
                        zub.setQuick(col, 0.0);
                        ylb.setQuick(row, cCol / ARcol);
                    } else {
                        zub.setQuick(col, 0.0);
                        yub.setQuick(row, cCol / ARcol);
                    }
                } else if (isUBUnbounded) {
                    if (ARcol > 0.0) {
                        zlb.setQuick(col, 0.0);
                        yub.setQuick(row, cCol / ARcol);
                    } else {
                        zlb.setQuick(col, 0.0);
                        ylb.setQuick(row, cCol / ARcol);
                    }
                }
                if (isLBUnbounded && isUBUnbounded) {
                    int j;
                    this.log.debug((Object)"free column singleton");
                    short[] xi = new short[vRowPositionsRow.length - 1];
                    double[] mi = new double[vRowPositionsRow.length - 1];
                    int cntXi = 0;
                    for (j = 0; j < vRowPositionsRow.length; ++j) {
                        short nzJ = vRowPositionsRow[j];
                        if (nzJ == col) continue;
                        xi[cntXi] = nzJ;
                        mi[cntXi] = -A.getQuick(row, nzJ) / ARcol;
                        ++cntXi;
                        if (!isCColNz) continue;
                        c.setQuick(nzJ, c.getQuick(nzJ) - cCol * A.getQuick(row, nzJ) / ARcol);
                    }
                    this.addToPresolvingStack(new LinearDependency(col, xi, mi, b.getQuick(row)));
                    for (j = 0; j < vRowPositionsRow.length; j = (int)((short)(j + 1))) {
                        short column = vRowPositionsRow[j];
                        if (column != col && this.vColPositions[column].length == 1) {
                            if (c.getQuick(column) < 0.0) {
                                lb.setQuick(column, ub.getQuick(column));
                            } else if (c.getQuick(column) > 0.0) {
                                ub.setQuick(column, lb.getQuick(column));
                            } else {
                                ub.setQuick(column, lb.getQuick(column));
                            }
                            this.log.debug((Object)("found fixed variables: x[" + column + "]=" + lb.getQuick(column)));
                            this.checkFixedVariableBounds(column, lb.getQuick(column), lb, ub);
                            this.addToPresolvingStack(new LinearDependency(column, null, null, lb.getQuick(column)));
                            this.pruneFixedVariable(column, c, A, b, lb, ub, ylb, yub, zlb, zub);
                        }
                        this.changeColumnsLengthPosition(column, this.vColPositions[column].length, this.vColPositions[column].length - 1);
                        this.vColPositions[column] = this.removeElementFromSortedArray(this.vColPositions[column], row);
                        A.setQuick(row, column, 0.0);
                    }
                    this.changeRowsLengthPosition(row, this.vRowPositions[row].length, 0);
                    this.vRowPositions[row] = new short[0];
                    if (this.vColPositions[col].length > 0) {
                        this.log.debug((Object)("Expected empty column " + col + " but was not empty"));
                        throw new IllegalStateException("Expected empty column " + col + " but was not empty");
                    }
                    this.vColPositions[col] = new short[0];
                    ylb.setQuick(row, cCol / ARcol);
                    yub.setQuick(row, cCol / ARcol);
                    b.setQuick(row, 0.0);
                    lb.setQuick(col, this.unboundedLBValue);
                    ub.setQuick(col, this.unboundedUBValue);
                    c.setQuick(col, 0.0);
                    this.someReductionDone = true;
                    continue;
                }
            }
            if (ARcol > 0.0) {
                impliedL = (b.getQuick(row) - this.h[row]) / ARcol + ubCol;
                impliedU = (b.getQuick(row) - this.g[row]) / ARcol + lbCol;
            } else {
                impliedL = (b.getQuick(row) - this.g[row]) / ARcol + ubCol;
                impliedU = (b.getQuick(row) - this.h[row]) / ARcol + lbCol;
            }
            boolean ifl = impliedL > lbCol;
            boolean bl = ifu = impliedU < ubCol;
            if (ifl) {
                lb.setQuick(col, impliedL);
                lbCol = impliedL;
                this.someReductionDone = true;
            }
            if (ifu) {
                ub.setQuick(col, impliedU);
                ubCol = impliedU;
                this.someReductionDone = true;
            }
            boolean bl2 = isImpliedFree = ifl && ifu || this.isZero(impliedL - lbCol) && this.isZero(impliedU - ubCol);
            if (vRowPositionsRow.length != 2 && !isImpliedFree) continue;
            int y = -1;
            double q = 0.0;
            double m = 0.0;
            short[] xi = new short[vRowPositionsRow.length - 1];
            double[] mi = new double[vRowPositionsRow.length - 1];
            StringBuffer sb = new StringBuffer("x[" + col + "]=");
            q = b.getQuick(row) / ARcol;
            sb.append(q);
            int cntXi = 0;
            for (int j = 0; j < vRowPositionsRow.length; ++j) {
                int nzJ = vRowPositionsRow[j];
                if (nzJ == col) continue;
                double ARnzJ = A.getQuick(row, nzJ);
                m = -ARnzJ / ARcol;
                xi[cntXi] = nzJ;
                mi[cntXi] = m;
                ++cntXi;
                sb.append(" + " + m + "*x[" + nzJ + "]");
                if (isCColNz) {
                    double cc = c.getQuick(col) * ARnzJ / ARcol;
                    c.setQuick(nzJ, c.getQuick(nzJ) - cc);
                }
                y = nzJ;
            }
            this.addToPresolvingStack(new LinearDependency(col, xi, mi, q));
            if (vRowPositionsRow.length == 2) {
                double u;
                double l;
                this.log.debug((Object)("doubleton equation combined with a column singleton: " + sb.toString()));
                double lbY = lb.getQuick(y);
                double ubY = ub.getQuick(y);
                boolean isLBYUnbounded = this.isLBUnbounded(lbY);
                boolean isUBYUnbounded = this.isLBUnbounded(ubY);
                if (m > 0.0) {
                    if (!isLBUnbounded) {
                        l = lbCol / m - q / m;
                        lb.setQuick(y, isLBYUnbounded ? l : Math.max(lbY, l));
                    }
                    if (!isUBUnbounded) {
                        u = ubCol / m - q / m;
                        ub.setQuick(y, isUBYUnbounded ? u : Math.min(ubY, u));
                    }
                } else {
                    if (!isUBUnbounded) {
                        u = ubCol / m - q / m;
                        lb.setQuick(y, isLBYUnbounded ? u : Math.max(lbY, u));
                    }
                    if (!isLBUnbounded) {
                        l = lbCol / m - q / m;
                        ub.setQuick(y, isUBYUnbounded ? l : Math.min(ubY, l));
                    }
                }
                if (this.vColPositions[y].length == 1) {
                    if (c.getQuick(y) < 0.0) {
                        if (this.isUBUnbounded(ub.getQuick(y))) {
                            throw new RuntimeException("unbounded problem");
                        }
                        lb.setQuick(y, ub.getQuick(y));
                    } else if (c.getQuick(y) > 0.0) {
                        if (this.isLBUnbounded(lb.getQuick(y))) {
                            throw new RuntimeException("unbounded problem");
                        }
                        ub.setQuick(y, lb.getQuick(y));
                    } else {
                        if (this.isLBUnbounded(lb.getQuick(y)) && this.isUBUnbounded(ub.getQuick(y))) {
                            throw new RuntimeException("unbounded problem");
                        }
                        if (!this.isLBUnbounded(lb.getQuick(y)) && !this.isUBUnbounded(ub.getQuick(y))) {
                            double d = (ub.getQuick(y) - lb.getQuick(y)) / 2.0;
                            lb.setQuick(y, d);
                            ub.setQuick(y, d);
                        } else if (!this.isLBUnbounded(lb.getQuick(y))) {
                            ub.setQuick(y, lb.getQuick(y));
                        } else {
                            lb.setQuick(y, ub.getQuick(y));
                        }
                    }
                }
                lb.setQuick(col, this.unboundedLBValue);
                ub.setQuick(col, this.unboundedUBValue);
                A.setQuick(row, col, 0.0);
                A.setQuick(row, y, 0.0);
                b.setQuick(row, 0.0);
                this.changeColumnsLengthPosition(col, this.vColPositions[col].length, 0);
                this.vColPositions[col] = new short[0];
                vRowPositionsRow = this.removeElementFromSortedArray(vRowPositionsRow, col);
                this.changeRowsLengthPosition(row, vRowPositionsRow.length + 1, vRowPositionsRow.length);
                this.changeColumnsLengthPosition(vRowPositionsRow[0], this.vColPositions[vRowPositionsRow[0]].length, this.vColPositions[vRowPositionsRow[0]].length - 1);
                this.vColPositions[vRowPositionsRow[0]] = this.removeElementFromSortedArray(this.vColPositions[vRowPositionsRow[0]], row);
                this.vRowPositions[row] = new short[0];
                this.someReductionDone = true;
                continue;
            }
            this.log.debug((Object)("implied free column singletons: " + sb.toString()));
            ylb.setQuick(row, c.getQuick(col) / A.getQuick(row, col));
            yub.setQuick(row, c.getQuick(col) / A.getQuick(row, col));
            for (int cc = 0; cc < this.vRowPositions[row].length; cc = (int)((short)(cc + 1))) {
                short column = this.vRowPositions[row][cc];
                if (column == col) continue;
                if (this.vColPositions[column].length == 1) {
                    if (c.getQuick(column) < 0.0) {
                        if (this.isUBUnbounded(ub.getQuick(column))) {
                            throw new RuntimeException("unbounded problem");
                        }
                        lb.setQuick(column, ub.getQuick(column));
                    } else if (c.getQuick(column) > 0.0) {
                        if (this.isLBUnbounded(lb.getQuick(column))) {
                            throw new RuntimeException("unbounded problem");
                        }
                        ub.setQuick(column, lb.getQuick(column));
                    } else {
                        if (this.isLBUnbounded(lb.getQuick(column)) || this.isUBUnbounded(ub.getQuick(column))) {
                            throw new RuntimeException("unbounded problem");
                        }
                        double d = (ub.getQuick(y) - lb.getQuick(y)) / 2.0;
                        lb.setQuick(y, d);
                        ub.setQuick(y, d);
                    }
                    this.log.debug((Object)("found fixed variables: x[" + column + "]=" + lb.getQuick(column)));
                    this.checkFixedVariableBounds(column, lb.getQuick(column), lb, ub);
                    this.addToPresolvingStack(new LinearDependency(column, null, null, lb.getQuick(column)));
                    this.pruneFixedVariable(column, c, A, b, lb, ub, ylb, yub, zlb, zub);
                }
                this.changeColumnsLengthPosition(column, this.vColPositions[column].length, this.vColPositions[column].length - 1);
                this.vColPositions[column] = this.removeElementFromSortedArray(this.vColPositions[column], row);
                A.setQuick(row, column, 0.0);
            }
            A.setQuick(row, col, 0.0);
            b.setQuick(row, 0.0);
            lb.setQuick(col, this.unboundedLBValue);
            ub.setQuick(col, this.unboundedUBValue);
            c.setQuick(col, 0.0);
            this.changeColumnsLengthPosition(col, this.vColPositions[col].length, 0);
            this.vColPositions[col] = new short[0];
            this.changeRowsLengthPosition(row, this.vRowPositions[row].length, 0);
            this.vRowPositions[row] = new short[0];
            this.someReductionDone = true;
        }
    }

    private void removeDominatedColumns(DoubleMatrix1D c, DoubleMatrix2D A, DoubleMatrix1D b, DoubleMatrix1D lb, DoubleMatrix1D ub, DoubleMatrix1D ylb, DoubleMatrix1D yub, DoubleMatrix1D zlb, DoubleMatrix1D zub) {
        for (short col = 0; col < this.vColPositions.length; col = (short)((short)(col + 1))) {
            double AIJ;
            short row;
            int i;
            short[] vColPositionsCol = this.vColPositions[col];
            if (vColPositionsCol == null || vColPositionsCol.length == 0) continue;
            double e = 0.0;
            double d = 0.0;
            for (int i2 = 0; i2 < vColPositionsCol.length; ++i2) {
                short row2 = vColPositionsCol[i2];
                double AIJ2 = A.getQuick(row2, col);
                if (AIJ2 > 0.0) {
                    e += AIJ2 * ylb.getQuick(row2);
                    d += AIJ2 * yub.getQuick(row2);
                    continue;
                }
                e += AIJ2 * yub.getQuick(row2);
                d += AIJ2 * ylb.getQuick(row2);
            }
            double cmd = c.getQuick(col) - d;
            double cme = c.getQuick(col) - e;
            boolean isCmdPositive = cmd > 0.0 && !this.isZero(cmd);
            boolean isCmeNegative = cme < 0.0 && !this.isZero(cme);
            boolean isLBColUnbounded = this.isLBUnbounded(lb.getQuick(col));
            boolean isUBColUnbounded = this.isUBUnbounded(ub.getQuick(col));
            if (isCmdPositive || isCmeNegative) {
                this.log.debug((Object)("found dominated column: " + col));
                if (isCmdPositive) {
                    zlb.setQuick(col, 0.0);
                    if (isLBColUnbounded) {
                        this.log.debug((Object)"unbounded problem");
                        throw new RuntimeException("unbounded problem");
                    }
                    ub.setQuick(col, lb.getQuick(col));
                    this.log.debug((Object)("x[" + col + "]=" + lb.getQuick(col)));
                    this.checkFixedVariableBounds(col, lb.getQuick(col), lb, ub);
                    this.addToPresolvingStack(new LinearDependency(col, null, null, lb.getQuick(col)));
                    this.pruneFixedVariable(col, c, A, b, lb, ub, ylb, yub, zlb, zub);
                    continue;
                }
                if (!isCmeNegative) continue;
                zub.setQuick(col, 0.0);
                if (isUBColUnbounded) {
                    this.log.debug((Object)"unbounded problem");
                    throw new RuntimeException("unbounded problem");
                }
                lb.setQuick(col, ub.getQuick(col));
                this.log.debug((Object)("x[" + col + "]=" + ub.getQuick(col)));
                this.checkFixedVariableBounds(col, ub.getQuick(col), lb, ub);
                this.addToPresolvingStack(new LinearDependency(col, null, null, ub.getQuick(col)));
                this.pruneFixedVariable(col, c, A, b, lb, ub, ylb, yub, zlb, zub);
                continue;
            }
            if (vColPositionsCol.length > 1) {
                if (!isLBColUnbounded && this.isZero(cmd)) {
                    this.log.debug((Object)("found weakly dominated column: " + col));
                    ub.setQuick(col, lb.getQuick(col));
                    this.log.debug((Object)("x[" + col + "]=" + lb.getQuick(col)));
                    this.checkFixedVariableBounds(col, lb.getQuick(col), lb, ub);
                    this.addToPresolvingStack(new LinearDependency(col, null, null, lb.getQuick(col)));
                    this.pruneFixedVariable(col, c, A, b, lb, ub, ylb, yub, zlb, zub);
                    continue;
                }
                if (!isUBColUnbounded && this.isZero(cme)) {
                    this.log.debug((Object)("found weakly dominated column: " + col));
                    lb.setQuick(col, ub.getQuick(col));
                    this.log.debug((Object)("x[" + col + "]=" + ub.getQuick(col)));
                    this.checkFixedVariableBounds(col, ub.getQuick(col), lb, ub);
                    this.addToPresolvingStack(new LinearDependency(col, null, null, ub.getQuick(col)));
                    this.pruneFixedVariable(col, c, A, b, lb, ub, ylb, yub, zlb, zub);
                    continue;
                }
            }
            if (!isLBColUnbounded && isUBColUnbounded) {
                for (i = 0; i < vColPositionsCol.length; ++i) {
                    row = vColPositionsCol[i];
                    AIJ = A.getQuick(row, col);
                    if (AIJ > 0.0) {
                        if (this.isUBUnbounded(cme / AIJ + ylb.getQuick(row))) continue;
                        this.log.debug((Object)("set new bounds on the optimal Lagrange multipliers: " + row));
                        yub.setQuick(row, Math.min(yub.getQuick(row), cme / AIJ + ylb.getQuick(row)));
                        continue;
                    }
                    if (this.isLBUnbounded(cme / AIJ + yub.getQuick(row))) continue;
                    this.log.debug((Object)("set new bounds on the optimal Lagrange multipliers: " + row));
                    ylb.setQuick(row, Math.max(ylb.getQuick(row), cme / AIJ + yub.getQuick(row)));
                }
            }
            if (!isLBColUnbounded || isUBColUnbounded) continue;
            for (i = 0; i < vColPositionsCol.length; ++i) {
                row = vColPositionsCol[i];
                AIJ = A.getQuick(row, col);
                if (AIJ > 0.0) {
                    if (this.isLBUnbounded(cmd / AIJ + yub.getQuick(row))) continue;
                    this.log.debug((Object)("set new bounds on the optimal Lagrange multipliers: " + row));
                    ylb.setQuick(row, Math.max(ylb.getQuick(row), cmd / AIJ + yub.getQuick(row)));
                    continue;
                }
                if (this.isUBUnbounded(cmd / AIJ + ylb.getQuick(row))) continue;
                this.log.debug((Object)("set new bounds on the optimal Lagrange multipliers: " + row));
                yub.setQuick(row, Math.min(yub.getQuick(row), cmd / AIJ + ylb.getQuick(row)));
            }
        }
    }

    private void removeDuplicateRow(DoubleMatrix1D c, DoubleMatrix2D A, DoubleMatrix1D b, DoubleMatrix1D lb, DoubleMatrix1D ub, DoubleMatrix1D ylb, DoubleMatrix1D yub, DoubleMatrix1D zlb, DoubleMatrix1D zub) {
        int startingLength;
        for (int i = startingLength = 3; i < this.vRowLengthMap.length; ++i) {
            int[] vRowLengthMapI = this.vRowLengthMap[i];
            if (vRowLengthMapI == null || vRowLengthMapI.length < 1) continue;
            boolean stop = false;
            for (int j = 0; !stop && j < vRowLengthMapI.length; ++j) {
                short prow = (short)vRowLengthMapI[j];
                if (this.vRowPositions[prow].length == 0 || prow < this.nOfSlackVariables) continue;
                short[] vRowPositionsProw = this.vRowPositions[prow];
                if (vRowPositionsProw.length != i) {
                    this.log.debug((Object)("Row " + prow + " has an unexpected number of nz: expected " + i + " but is " + vRowPositionsProw.length));
                    throw new IllegalStateException();
                }
                block2: for (int si = i; !stop && si < this.vRowLengthMap.length; ++si) {
                    int[] vRowLengthMapSI = this.vRowLengthMap[si];
                    if (vRowLengthMapSI == null || vRowLengthMapSI.length < 1) continue;
                    for (int sj = 0; sj < vRowLengthMapSI.length; ++sj) {
                        short[] vRowPositionsSrow;
                        short srow;
                        if (si == i && sj <= j || this.vRowPositions[srow = (short)vRowLengthMapSI[sj]].length == 0 || !this.isSubsetSparsityPattern(vRowPositionsProw, vRowPositionsSrow = this.vRowPositions[srow])) continue;
                        this.log.debug((Object)("found superset sparsity pattern: row " + prow + " contained in row " + srow));
                        HashMap coeffRatiosMap = new HashMap();
                        for (int k = 0; k < vRowPositionsProw.length; k = (int)((short)(k + 1))) {
                            short col = vRowPositionsProw[k];
                            double APRL = A.getQuick(prow, col);
                            double ASRL = A.getQuick(srow, col);
                            double ratio = -ASRL / APRL;
                            boolean added = false;
                            for (Double keyRatio : coeffRatiosMap.keySet()) {
                                if (!this.isZero(ratio - keyRatio)) continue;
                                ((List)coeffRatiosMap.get(keyRatio)).add(Integer.valueOf(col));
                                added = true;
                                break;
                            }
                            if (added) continue;
                            ArrayList<Integer> newList = new ArrayList<Integer>();
                            newList.add(Integer.valueOf(col));
                            coeffRatiosMap.put(ratio, newList);
                        }
                        int maxNumberOfColumn = -1;
                        List candidatedColumns = null;
                        for (Double keyRatio : coeffRatiosMap.keySet()) {
                            int size = ((List)coeffRatiosMap.get(keyRatio)).size();
                            if (size > maxNumberOfColumn) {
                                maxNumberOfColumn = size;
                                candidatedColumns = (List)coeffRatiosMap.get(keyRatio);
                                continue;
                            }
                            if (size != maxNumberOfColumn) continue;
                            candidatedColumns.addAll((Collection)coeffRatiosMap.get(keyRatio));
                        }
                        short lessFilledColumn = -1;
                        int lessFilledColumnLength = this.originalMeq + 1;
                        for (int k = 0; k < candidatedColumns.size(); k = (int)((short)(k + 1))) {
                            short col = ((Integer)candidatedColumns.get(k)).shortValue();
                            if (this.vColPositions[col].length <= 1 || this.vColPositions[col].length >= lessFilledColumnLength) continue;
                            lessFilledColumn = col;
                            lessFilledColumnLength = this.vColPositions[col].length;
                        }
                        this.log.debug((Object)("less filled column (" + lessFilledColumn + "): length=" + lessFilledColumnLength));
                        double APRL = A.getQuick(prow, lessFilledColumn);
                        double ASRL = A.getQuick(srow, lessFilledColumn);
                        double alpha = -ASRL / APRL;
                        b.setQuick(srow, b.getQuick(srow) + alpha * b.getQuick(prow));
                        for (int t = 0; t < vRowPositionsProw.length; t = (int)((short)(t + 1))) {
                            short cc = vRowPositionsProw[t];
                            double nv = 0.0;
                            if (cc != lessFilledColumn) {
                                nv = A.getQuick(srow, cc) + alpha * A.getQuick(prow, cc);
                            }
                            A.setQuick(srow, cc, nv);
                            if (!this.isZero(nv)) continue;
                            this.vRowPositions[srow] = this.removeElementFromSortedArray(this.vRowPositions[srow], cc);
                            this.changeColumnsLengthPosition(cc, this.vColPositions[cc].length, this.vColPositions[cc].length - 1);
                            this.vColPositions[cc] = this.removeElementFromSortedArray(this.vColPositions[cc], srow);
                            this.changeRowsLengthPosition(srow, this.vRowPositions[srow].length + 1, this.vRowPositions[srow].length);
                            A.setQuick(srow, cc, 0.0);
                        }
                        this.someReductionDone = true;
                        stop = true;
                        i = startingLength - 1;
                        continue block2;
                    }
                }
            }
        }
    }

    private void removeDuplicateColumn(DoubleMatrix1D c, DoubleMatrix2D A, DoubleMatrix1D b, DoubleMatrix1D lb, DoubleMatrix1D ub, DoubleMatrix1D ylb, DoubleMatrix1D yub, DoubleMatrix1D zlb, DoubleMatrix1D zub) {
        int startingLength;
        for (int i = startingLength = 2; i < this.vColLengthMap.length; ++i) {
            int[] vColLengthMapI = this.vColLengthMap[i];
            if (vColLengthMapI == null || vColLengthMapI.length < 1) continue;
            boolean stop = false;
            block1: for (int j = 0; !stop && j < vColLengthMapI.length; ++j) {
                short pcol = (short)vColLengthMapI[j];
                if (ArrayUtils.contains((short[])this.duplicatedColsArray, (short)pcol)) continue;
                short[] vColPositionsPcol = this.vColPositions[pcol];
                if (vColPositionsPcol.length != i) {
                    this.log.debug((Object)("Column " + pcol + " has an unexpected number of nz: expected " + i + " but is " + vColPositionsPcol.length));
                    throw new IllegalStateException();
                }
                if (pcol < this.nOfSlackVariables) continue;
                for (int sj = j + 1; !stop && sj < vColLengthMapI.length; ++sj) {
                    boolean isVNeg;
                    short scol = (short)vColLengthMapI[sj];
                    if (ArrayUtils.contains((short[])this.duplicatedColsArray, (short)scol)) continue;
                    short[] vColPositionsScol = this.vColPositions[scol];
                    if (vColPositionsScol.length != i) {
                        this.log.debug((Object)("Column " + scol + " has an unexpected number of nz: expected " + i + " but is " + vColPositionsScol.length));
                        throw new IllegalStateException();
                    }
                    if (!this.isSameSparsityPattern(vColPositionsPcol, vColPositionsScol)) continue;
                    boolean isDuplicated = true;
                    double v = A.getQuick(vColPositionsPcol[0], pcol) / A.getQuick(vColPositionsScol[0], scol);
                    for (int k = 1; k < i && (isDuplicated = this.isZero(v - A.getQuick(vColPositionsPcol[k], pcol) / A.getQuick(vColPositionsScol[k], scol))); ++k) {
                    }
                    if (!isDuplicated) continue;
                    this.log.debug((Object)("found duplicated columns: col " + pcol + " and col " + scol + ": v=" + v));
                    double cAlfaC = c.getQuick(pcol) - v * c.getQuick(scol);
                    boolean isLBPUnbounded = this.isLBUnbounded(lb.getQuick(pcol));
                    boolean isUBPUnbounded = this.isUBUnbounded(ub.getQuick(pcol));
                    if (!this.isZero(cAlfaC)) {
                        if (this.isUBUnbounded(ub.getQuick(scol)) && zlb.getQuick(scol) >= 0.0) {
                            if (v >= 0.0 && cAlfaC > 0.0) {
                                zlb.setQuick(pcol, 0.0);
                                if (!isLBPUnbounded) {
                                    if (isUBPUnbounded) {
                                        ub.setQuick(pcol, lb.getQuick(pcol));
                                        this.log.debug((Object)("found fixed variables: x[" + pcol + "]=" + lb.getQuick(pcol)));
                                        this.checkFixedVariableBounds(pcol, lb.getQuick(pcol), lb, ub);
                                        this.addToPresolvingStack(new LinearDependency(pcol, null, null, lb.getQuick(pcol)));
                                        this.pruneFixedVariable(pcol, c, A, b, lb, ub, ylb, yub, zlb, zub);
                                    }
                                } else {
                                    this.log.debug((Object)"unbounded problem");
                                    throw new RuntimeException("unbounded problem");
                                }
                                this.someReductionDone = true;
                            } else if (v <= 0.0 && cAlfaC < 0.0) {
                                zub.setQuick(pcol, 0.0);
                                if (isLBPUnbounded) {
                                    if (!isUBPUnbounded) {
                                        lb.setQuick(pcol, ub.getQuick(pcol));
                                        this.log.debug((Object)("found fixed variables: x[" + pcol + "]=" + ub.getQuick(pcol)));
                                        this.checkFixedVariableBounds(pcol, ub.getQuick(pcol), lb, ub);
                                        this.addToPresolvingStack(new LinearDependency(pcol, null, null, ub.getQuick(pcol)));
                                        this.pruneFixedVariable(pcol, c, A, b, lb, ub, ylb, yub, zlb, zub);
                                    }
                                } else {
                                    this.log.debug((Object)"unbounded problem");
                                    throw new RuntimeException("unbounded problem");
                                }
                                this.someReductionDone = true;
                            }
                        }
                        if (!this.isLBUnbounded(lb.getQuick(scol)) || !(zlb.getQuick(scol) <= 0.0)) continue;
                        if (v >= 0.0 && cAlfaC < 0.0) {
                            zlb.setQuick(pcol, 0.0);
                            if (isLBPUnbounded) {
                                if (!isUBPUnbounded) {
                                    lb.setQuick(pcol, ub.getQuick(pcol));
                                    this.log.debug((Object)("found fixed variables: x[" + pcol + "]=" + ub.getQuick(pcol)));
                                    this.checkFixedVariableBounds(pcol, ub.getQuick(pcol), lb, ub);
                                    this.addToPresolvingStack(new LinearDependency(pcol, null, null, ub.getQuick(pcol)));
                                    this.pruneFixedVariable(pcol, c, A, b, lb, ub, ylb, yub, zlb, zub);
                                }
                            } else {
                                this.log.debug((Object)"unbounded problem");
                                throw new RuntimeException("unbounded problem");
                            }
                            this.someReductionDone = true;
                            continue;
                        }
                        if (!(v <= 0.0) || !(cAlfaC > 0.0)) continue;
                        zub.setQuick(pcol, 0.0);
                        if (!isLBPUnbounded) {
                            if (isUBPUnbounded) {
                                ub.setQuick(pcol, lb.getQuick(pcol));
                                this.log.debug((Object)("found fixed variables: x[" + pcol + "]=" + lb.getQuick(pcol)));
                                this.checkFixedVariableBounds(pcol, lb.getQuick(pcol), lb, ub);
                                this.addToPresolvingStack(new LinearDependency(pcol, null, null, lb.getQuick(pcol)));
                                this.pruneFixedVariable(pcol, c, A, b, lb, ub, ylb, yub, zlb, zub);
                            }
                        } else {
                            this.log.debug((Object)"unbounded problem");
                            throw new RuntimeException("unbounded problem");
                        }
                        this.someReductionDone = true;
                        continue;
                    }
                    boolean isVPos = v > 0.0;
                    boolean bl = isVNeg = v < 0.0;
                    if (!isVPos && !isVNeg) continue;
                    this.log.debug((Object)("Replaced two duplicate columns (" + pcol + "," + scol + ") by one (" + scol + ")"));
                    for (int r = 0; r < vColPositionsPcol.length; ++r) {
                        short row = vColPositionsPcol[r];
                        this.vRowPositions[row] = this.removeElementFromSortedArray(this.vRowPositions[row], pcol);
                        A.setQuick(row, pcol, 0.0);
                        this.changeRowsLengthPosition(row, this.vRowPositions[row].length + 1, this.vRowPositions[row].length);
                    }
                    this.changeColumnsLengthPosition(pcol, this.vColPositions[pcol].length, 0);
                    this.vColPositions[pcol] = new short[0];
                    DuplicatedColumn dc = new DuplicatedColumn(pcol, scol, scol, v, lb.getQuick(pcol), ub.getQuick(pcol), lb.getQuick(scol), ub.getQuick(scol));
                    this.addToPresolvingStack(dc);
                    if (isVPos) {
                        lb.setQuick(scol, lb.getQuick(scol) + v * lb.getQuick(pcol));
                        ub.setQuick(scol, ub.getQuick(scol) + v * ub.getQuick(pcol));
                    } else if (isVNeg) {
                        lb.setQuick(scol, lb.getQuick(scol) + v * ub.getQuick(pcol));
                        ub.setQuick(scol, ub.getQuick(scol) + v * lb.getQuick(pcol));
                    }
                    this.duplicatedColsArray = this.addToSortedArray(this.duplicatedColsArray, pcol);
                    this.someReductionDone = true;
                    if (this.expectedSolution == null) continue block1;
                    dc.preSolve(this.expectedSolution);
                    continue block1;
                }
            }
        }
    }

    private void removeDoubletonRow(DoubleMatrix1D c, DoubleMatrix2D A, DoubleMatrix1D b, DoubleMatrix1D lb, DoubleMatrix1D ub, DoubleMatrix1D ylb, DoubleMatrix1D yub, DoubleMatrix1D zlb, DoubleMatrix1D zub) {
        for (short i = 0; i < this.vRowPositions.length; i = (short)((short)(i + 1))) {
            double u;
            double l;
            short[] vRowPositionsI = this.vRowPositions[i];
            if (vRowPositionsI.length != 2) continue;
            short x = vRowPositionsI[0];
            short y = vRowPositionsI[1];
            double r = A.getQuick(i, x);
            double s = A.getQuick(i, y);
            double t = b.getQuick(i);
            double m = -s / r;
            double q = t / r;
            this.log.debug((Object)("found doubleton row " + i + ": x[" + x + "]=" + m + "*x[" + y + "] + " + q));
            this.addToPresolvingStack(new LinearDependency(x, new short[]{y}, new double[]{m}, q));
            double lbX = lb.getQuick(x);
            double ubX = ub.getQuick(x);
            double lbY = lb.getQuick(y);
            double ubY = ub.getQuick(y);
            boolean isLBXUnbounded = this.isLBUnbounded(lbX);
            boolean isUBXUnbounded = this.isLBUnbounded(ubX);
            boolean isLBYUnbounded = this.isLBUnbounded(lbY);
            boolean isUBYUnbounded = this.isLBUnbounded(ubY);
            if (m > 0.0) {
                if (!isLBXUnbounded) {
                    l = lbX / m - q / m;
                    lb.setQuick(y, isLBYUnbounded ? l : Math.max(lbY, l));
                }
                if (!isUBXUnbounded) {
                    u = ubX / m - q / m;
                    ub.setQuick(y, isUBYUnbounded ? u : Math.min(ubY, u));
                }
            } else {
                if (!isUBXUnbounded) {
                    u = ubX / m - q / m;
                    lb.setQuick(y, isLBYUnbounded ? u : Math.max(lbY, u));
                }
                if (!isLBXUnbounded) {
                    l = lbX / m - q / m;
                    ub.setQuick(y, isUBYUnbounded ? l : Math.min(ubY, l));
                }
            }
            double cc = c.getQuick(x) * s / r;
            c.setQuick(y, c.getQuick(y) - cc);
            block1: for (short k = 0; k < this.vRowPositions.length; k = (short)((short)(k + 1))) {
                if (k == i) continue;
                short[] vRowPositionsK = this.vRowPositions[k];
                for (int j = 0; j < vRowPositionsK.length; j = (int)((short)(j + 1))) {
                    if (vRowPositionsK[j] == x) {
                        double AKx = A.getQuick(k, x);
                        double AKy = A.getQuick(k, y);
                        double AKyNew = AKy + AKx * m;
                        if (!this.isZero(AKyNew)) {
                            A.setQuick(k, y, AKyNew);
                            if (!ArrayUtils.contains((short[])vRowPositionsK, (short)y)) {
                                this.vRowPositions[k] = this.addToSortedArray(vRowPositionsK, y);
                                this.changeRowsLengthPosition(k, this.vRowPositions[k].length - 1, this.vRowPositions[k].length);
                                this.changeColumnsLengthPosition(y, this.vColPositions[y].length, this.vColPositions[y].length + 1);
                                this.vColPositions[y] = this.addToSortedArray(this.vColPositions[y], k);
                            }
                        } else {
                            this.vRowPositions[k] = this.removeElementFromSortedArray(vRowPositionsK, y);
                            this.changeRowsLengthPosition(k, this.vRowPositions[k].length + 1, this.vRowPositions[k].length);
                            this.changeColumnsLengthPosition(y, this.vColPositions[y].length, this.vColPositions[y].length - 1);
                            this.vColPositions[y] = this.removeElementFromSortedArray(this.vColPositions[y], k);
                            A.setQuick(k, y, 0.0);
                        }
                        b.setQuick(k, b.getQuick(k) - AKx * q);
                        A.setQuick(k, x, 0.0);
                        this.vRowPositions[k] = this.removeElementFromSortedArray(this.vRowPositions[k], x);
                        this.changeRowsLengthPosition(k, this.vRowPositions[k].length + 1, this.vRowPositions[k].length);
                        this.changeColumnsLengthPosition(x, this.vColPositions[x].length, this.vColPositions[x].length - 1);
                        this.vColPositions[x] = this.removeElementFromSortedArray(this.vColPositions[x], k);
                        continue block1;
                    }
                    if (vRowPositionsK[j] > x) continue block1;
                }
            }
            this.vRowPositions[i] = new short[0];
            if (this.vColPositions[x].length != 1 && this.vColPositions[x][0] != i) {
                this.log.debug((Object)("Expected empty column " + x + " but was not empty"));
                throw new IllegalStateException("Expected empty column " + x + " but was not empty");
            }
            this.changeColumnsLengthPosition(x, this.vColPositions[x].length, 0);
            this.vColPositions[x] = new short[0];
            this.changeColumnsLengthPosition(y, this.vColPositions[y].length, this.vColPositions[y].length - 1);
            this.vColPositions[y] = this.removeElementFromSortedArray(this.vColPositions[y], i);
            A.setQuick(i, x, 0.0);
            A.setQuick(i, y, 0.0);
            b.setQuick(i, 0.0);
            this.someReductionDone = true;
        }
    }

    private void scaling() {
        if (this.presolvedA instanceof SparseDoubleMatrix2D) {
            int i;
            Matrix1NormRescaler rescaler = new Matrix1NormRescaler();
            DoubleMatrix1D[] UV = rescaler.getMatrixScalingFactors((SparseDoubleMatrix2D)this.presolvedA);
            this.R = UV[0];
            this.T = UV[1];
            if (this.log.isDebugEnabled()) {
                boolean checkOK = rescaler.checkScaling(this.presolvedA, this.R, this.T);
                if (!checkOK) {
                    this.log.warn((Object)"Scaling failed (checkScaling = false)");
                }
                double[] cn_00_original = ColtUtils.getConditionNumberRange((RealMatrix)new Array2DRowRealMatrix(this.presolvedA.toArray()), Integer.MAX_VALUE);
                this.log.debug((Object)("cn_00_original A before scaling: " + ArrayUtils.toString((Object)cn_00_original)));
                double[] cn_2_original = ColtUtils.getConditionNumberRange((RealMatrix)new Array2DRowRealMatrix(this.presolvedA.toArray()), 2);
                this.log.debug((Object)("cn_2_original A before scaling : " + ArrayUtils.toString((Object)cn_2_original)));
            }
            this.presolvedA = ColtUtils.diagonalMatrixMult(this.R, this.presolvedA, this.T);
            if (this.log.isDebugEnabled()) {
                double[] cn_00_scaled = ColtUtils.getConditionNumberRange((RealMatrix)new Array2DRowRealMatrix(this.presolvedA.toArray()), Integer.MAX_VALUE);
                this.log.debug((Object)("cn_00_scaled A after scaling : " + ArrayUtils.toString((Object)cn_00_scaled)));
                double[] cn_2_scaled = ColtUtils.getConditionNumberRange((RealMatrix)new Array2DRowRealMatrix(this.presolvedA.toArray()), 2);
                this.log.debug((Object)("cn_2_scaled A after scaling  : " + ArrayUtils.toString((Object)cn_2_scaled)));
            }
            for (i = 0; i < this.R.size(); ++i) {
                double ri = this.R.getQuick(i);
                this.presolvedB.setQuick(i, this.presolvedB.getQuick(i) * ri);
            }
            this.minRescaledLB = Double.MAX_VALUE;
            this.maxRescaledUB = -1.7976931348623157E308;
            for (i = 0; i < this.T.size(); ++i) {
                double ti = this.T.getQuick(i);
                this.presolvedC.setQuick(i, this.presolvedC.getQuick(i) * ti);
                double lbi = this.presolvedLB.getQuick(i) / ti;
                this.presolvedLB.setQuick(i, lbi);
                this.minRescaledLB = Math.min(this.minRescaledLB, lbi);
                double ubi = this.presolvedUB.getQuick(i) / ti;
                this.presolvedUB.setQuick(i, ubi);
                this.maxRescaledUB = Math.max(this.maxRescaledUB, ubi);
            }
        }
    }

    private void removeAllEmptyRowsAndColumns(DoubleMatrix1D c, DoubleMatrix2D A, DoubleMatrix1D b, DoubleMatrix1D lb, DoubleMatrix1D ub, DoubleMatrix1D ylb, DoubleMatrix1D yub, DoubleMatrix1D zlb, DoubleMatrix1D zub) {
    }

    private void pruneFixedVariable(short x, DoubleMatrix1D c, DoubleMatrix2D A, DoubleMatrix1D b, DoubleMatrix1D lb, DoubleMatrix1D ub, DoubleMatrix1D ylb, DoubleMatrix1D yub, DoubleMatrix1D zlb, DoubleMatrix1D zub) {
        double v = lb.getQuick(x);
        for (short i = 0; i < this.vRowPositions.length; i = (short)((short)(i + 1))) {
            if (!ArrayUtils.contains((short[])this.vRowPositions[i], (short)x)) continue;
            this.vRowPositions[i] = this.removeElementFromSortedArray(this.vRowPositions[i], x);
            this.changeRowsLengthPosition(i, this.vRowPositions[i].length + 1, this.vRowPositions[i].length);
            if (this.vRowPositions[i] == null || this.vRowPositions[i].length == 0) {
                if (!this.isZero(v - b.getQuick(i) / A.getQuick(i, x))) {
                    this.log.debug((Object)"Infeasible problem");
                    throw new RuntimeException("Infeasible problem");
                }
                A.setQuick(i, x, 0.0);
                b.setQuick(i, 0.0);
                continue;
            }
            b.setQuick(i, b.getQuick(i) - A.getQuick(i, x) * v);
            A.setQuick(i, x, 0.0);
        }
        this.changeColumnsLengthPosition(x, this.vColPositions[x].length, 0);
        this.vColPositions[x] = new short[0];
        this.someReductionDone = true;
    }

    private short[] removeElementFromSortedArray(short[] array, short element) {
        if (array.length < 2) {
            return new short[0];
        }
        return ArrayUtils.removeElement((short[])array, (short)element);
    }

    private int[] removeElementFromSortedArray(int[] array, int element) {
        if (array.length < 2) {
            return new int[0];
        }
        return ArrayUtils.removeElement((int[])array, (int)element);
    }

    private short[] addToSortedArray(short[] array, short element) {
        short[] ret = new short[array.length + 1];
        int cnt = 0;
        boolean goStraight = false;
        for (int i = 0; i < array.length; i = (int)((short)(i + 1))) {
            short s = array[i];
            if (goStraight) {
                ret[cnt] = s;
                cnt = (short)(cnt + 1);
                continue;
            }
            if (s < element) {
                ret[cnt] = s;
                cnt = (short)(cnt + 1);
                continue;
            }
            if (s == element) {
                return array;
            }
            if (s <= element) continue;
            ret[cnt] = element;
            cnt = (short)(cnt + 1);
            ret[cnt] = s;
            cnt = (short)(cnt + 1);
            goStraight = true;
        }
        if (cnt < ret.length) {
            ret[cnt] = element;
        }
        return ret;
    }

    private int[] addToSortedArray(int[] array, int element) {
        int[] ret = new int[array.length + 1];
        int cnt = 0;
        boolean goStraight = false;
        for (int i = 0; i < array.length; i = (int)((short)(i + 1))) {
            int s = array[i];
            if (goStraight) {
                ret[cnt] = s;
                cnt = (short)(cnt + 1);
                continue;
            }
            if (s < element) {
                ret[cnt] = s;
                cnt = (short)(cnt + 1);
                continue;
            }
            if (s == element) {
                return array;
            }
            if (s <= element) continue;
            ret[cnt] = element;
            cnt = (short)(cnt + 1);
            ret[cnt] = s;
            cnt = (short)(cnt + 1);
            goStraight = true;
        }
        if (cnt < ret.length) {
            ret[cnt] = element;
        }
        return ret;
    }

    private boolean isSubsetSparsityPattern(short[] subset, short[] superset) {
        int position = 0;
        for (int i = 0; i < subset.length; i = (int)((short)(i + 1))) {
            short s = subset[i];
            boolean found = false;
            for (int j = position; j < superset.length; j = (int)((short)(j + 1))) {
                if (superset[j] != s) continue;
                found = true;
                position = j;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private boolean isSameSparsityPattern(short[] sp1, short[] sp2) {
        if (sp1.length == sp2.length) {
            for (int k = 0; k < sp1.length; ++k) {
                if (sp1[k] == sp2[k]) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isLBUnbounded(double lb) {
        return Double.compare(this.unboundedLBValue, lb) == 0;
    }

    public boolean isUBUnbounded(double ub) {
        return Double.compare(this.unboundedUBValue, ub) == 0;
    }

    public int getOriginalN() {
        return this.originalN;
    }

    public int getOriginalMeq() {
        return this.originalMeq;
    }

    public int getPresolvedN() {
        return this.presolvedN;
    }

    public int getPresolvedMeq() {
        return this.presolvedMeq;
    }

    public DoubleMatrix1D getPresolvedC() {
        return this.presolvedC;
    }

    public DoubleMatrix2D getPresolvedA() {
        return this.presolvedA;
    }

    public DoubleMatrix1D getPresolvedB() {
        return this.presolvedB;
    }

    public DoubleMatrix1D getPresolvedLB() {
        return this.presolvedLB;
    }

    public DoubleMatrix1D getPresolvedUB() {
        return this.presolvedUB;
    }

    public DoubleMatrix1D getPresolvedYlb() {
        return this.presolvedYlb;
    }

    public DoubleMatrix1D getPresolvedYub() {
        return this.presolvedYub;
    }

    public DoubleMatrix1D getPresolvedZlb() {
        return this.presolvedZlb;
    }

    public DoubleMatrix1D getPresolvedZub() {
        return this.presolvedZub;
    }

    private boolean isZero(double d) {
        return Math.abs(d) < this.eps;
    }

    public void setNOfSlackVariables(short nOfSlackVariables) {
        this.nOfSlackVariables = nOfSlackVariables;
    }

    private void checkFixedVariableBounds(short x, double v, DoubleMatrix1D lb, DoubleMatrix1D ub) {
        if (v < lb.getQuick(x) || v > ub.getQuick(x)) {
            this.log.debug((Object)"Infeasible problem");
            throw new RuntimeException("Infeasible problem");
        }
    }

    private void addToPresolvingStack(LinearDependency linearDependency) {
        this.indipendentVariables[linearDependency.x] = false;
        this.presolvingStack.add(this.presolvingStack.size(), linearDependency);
    }

    private void addToPresolvingStack(DuplicatedColumn duplicatedColumn) {
        this.indipendentVariables[duplicatedColumn.xj] = false;
        this.presolvingStack.add(this.presolvingStack.size(), duplicatedColumn);
    }

    private double[] duplicateArray(double[] v) {
        double[] vv = new double[v.length];
        System.arraycopy(v, 0, vv, 0, v.length);
        return vv;
    }

    private void checkProgress(DoubleMatrix1D c, DoubleMatrix2D A, DoubleMatrix1D b, DoubleMatrix1D lb, DoubleMatrix1D ub, DoubleMatrix1D ylb, DoubleMatrix1D yub, DoubleMatrix1D zlb, DoubleMatrix1D zub) {
        int i;
        short[] vRowPositionsI;
        int i2;
        if (this.expectedSolution == null) {
            return;
        }
        if (Double.isNaN(this.expectedTolerance)) {
            RealVector X = MatrixUtils.createRealVector((double[])this.expectedSolution);
            RealMatrix AMatrix = MatrixUtils.createRealMatrix((double[][])A.toArray());
            RealVector Bvector = MatrixUtils.createRealVector((double[])b.toArray());
            RealVector Axb = AMatrix.operate(X).subtract(Bvector);
            double norm = Axb.getNorm();
            this.expectedTolerance = Math.max(1.0E-7, 1.5 * norm);
        }
        double tolerance = this.expectedTolerance;
        this.log.debug((Object)("tolerance: " + tolerance));
        RealVector X = MatrixUtils.createRealVector((double[])this.expectedSolution);
        RealMatrix AMatrix = MatrixUtils.createRealMatrix((double[][])A.toArray());
        RealVector Bvector = MatrixUtils.createRealVector((double[])b.toArray());
        for (i2 = 0; i2 < this.vRowPositions.length; ++i2) {
            for (short nzJ : vRowPositionsI = this.vRowPositions[i2]) {
                if (Double.compare(A.getQuick(i2, nzJ), 0.0) != 0) continue;
                this.log.debug((Object)("entry " + i2 + "," + nzJ + " est zero: " + A.getQuick(i2, nzJ)));
                throw new IllegalStateException();
            }
        }
        for (int j = 0; j < this.vColPositions.length; ++j) {
            short[] vColPositionsJ = this.vColPositions[j];
            for (short nzI : vColPositionsJ) {
                if (Double.compare(A.getQuick(nzI, j), 0.0) != 0) continue;
                this.log.debug((Object)("entry (" + nzI + "," + j + ") est zero: " + A.getQuick(nzI, j)));
                throw new IllegalStateException();
            }
        }
        for (i2 = 0; i2 < A.rows(); ++i2) {
            vRowPositionsI = this.vRowPositions[i2];
            for (int j = 0; j < A.columns(); ++j) {
                if (Double.compare(Math.abs(A.getQuick(i2, j)), 0.0) == 0) continue;
                if (!ArrayUtils.contains((short[])vRowPositionsI, (short)((short)j))) {
                    this.log.debug((Object)("entry " + i2 + "," + j + " est non-zero: " + A.getQuick(i2, j)));
                    throw new IllegalStateException();
                }
                if (ArrayUtils.contains((short[])this.vColPositions[j], (short)((short)i2))) continue;
                this.log.debug((Object)("entry " + i2 + "," + j + " est non-zero: " + A.getQuick(i2, j)));
                throw new IllegalStateException();
            }
        }
        RealVector Axb = AMatrix.operate(X).subtract(Bvector);
        double norm = Axb.getNorm();
        this.log.debug((Object)("|| A.x-b ||: " + norm));
        if (norm > tolerance) {
            for (i = 0; i < Axb.getDimension(); ++i) {
                if (!(Math.abs(Axb.getEntry(i)) > tolerance)) continue;
                this.log.debug((Object)("entry " + i + ": " + Axb.getEntry(i)));
                throw new IllegalStateException();
            }
            throw new IllegalStateException();
        }
        for (i = 0; i < X.getDimension(); ++i) {
            if (X.getEntry(i) + tolerance < lb.getQuick(i)) {
                this.log.debug((Object)("lower bound " + i + " not respected: lb=" + lb.getQuick(i) + ", value=" + X.getEntry(i)));
                throw new IllegalStateException();
            }
            if (!(X.getEntry(i) > ub.getQuick(i) + tolerance)) continue;
            this.log.debug((Object)("upper bound " + i + " not respected: ub=" + ub.getQuick(i) + ", value=" + X.getEntry(i)));
            throw new IllegalStateException();
        }
    }

    private void changeRowsLengthPosition(short rowIndex, int lengthIndexFrom, int lengthIndexTo) {
        if (lengthIndexFrom == 0) {
            return;
        }
        if (this.vRowLengthMap[lengthIndexTo] == null) {
            this.vRowLengthMap[lengthIndexTo] = new int[0];
        }
        this.vRowLengthMap[lengthIndexTo] = this.addToSortedArray(this.vRowLengthMap[lengthIndexTo], (int)rowIndex);
        this.vRowLengthMap[lengthIndexFrom] = this.removeElementFromSortedArray(this.vRowLengthMap[lengthIndexFrom], (int)rowIndex);
    }

    private void changeColumnsLengthPosition(short colIndex, int lengthIndexFrom, int lengthIndexTo) {
        if (lengthIndexFrom == 0) {
            return;
        }
        if (this.vColLengthMap[lengthIndexTo] == null) {
            this.vColLengthMap[lengthIndexTo] = new int[0];
        }
        this.vColLengthMap[lengthIndexTo] = this.addToSortedArray(this.vColLengthMap[lengthIndexTo], (int)colIndex);
        this.vColLengthMap[lengthIndexFrom] = this.removeElementFromSortedArray(this.vColLengthMap[lengthIndexFrom], (int)colIndex);
    }

    public void setExpectedSolution(double[] sol) {
        this.expectedSolution = this.duplicateArray(sol);
    }

    public void setExpectedTolerance(double expectedTolerance) {
        this.expectedTolerance = expectedTolerance;
    }

    public double getMinRescaledLB() {
        return this.minRescaledLB;
    }

    public double getMaxRescaledUB() {
        return this.maxRescaledUB;
    }

    public void setZeroTolerance(double eps) {
        this.eps = eps;
    }

    private class DuplicatedColumn
    extends PresolvingStackElement {
        short xj;
        short xk;
        short xkPrime;
        double v;
        double lbj;
        double ubj;
        double lbk;
        double ubk;

        DuplicatedColumn(short xj, short xk, short xkPrime, double v, double lbj, double ubj, double lbk, double ubk) {
            this.xj = (short)-1;
            this.xk = (short)-1;
            this.xkPrime = (short)-1;
            this.v = Double.NaN;
            this.xj = xj;
            this.xk = xk;
            this.xkPrime = xkPrime;
            this.v = v;
            this.lbj = lbj;
            this.ubj = ubj;
            this.lbk = lbk;
            this.ubk = ubk;
        }

        void postSolve(double[] postsolvedX) {
            this.lbk = LPPresolver.this.isLBUnbounded(this.lbk) ? -1.7976931348623157E308 : this.lbk;
            this.lbj = LPPresolver.this.isLBUnbounded(this.lbj) ? -1.7976931348623157E308 : this.lbj;
            this.ubk = LPPresolver.this.isLBUnbounded(this.ubk) ? Double.MAX_VALUE : this.ubk;
            double d = this.ubj = LPPresolver.this.isUBUnbounded(this.ubj) ? Double.MAX_VALUE : this.ubj;
            if (this.v > 0.0) {
                double p = postsolvedX[this.xkPrime];
                postsolvedX[this.xk] = Math.max(this.lbk, p - this.v * this.ubj);
                postsolvedX[this.xj] = (p - postsolvedX[this.xk]) / this.v;
            } else if (this.v < 0.0) {
                double p = postsolvedX[this.xkPrime];
                postsolvedX[this.xk] = Math.max(this.lbk, p - this.v * this.lbj);
                postsolvedX[this.xj] = (p - postsolvedX[this.xk]) / this.v;
            } else {
                throw new IllegalStateException("coefficient v must be >0 or <0");
            }
        }

        void preSolve(double[] x) {
            x[this.xkPrime] = x[this.xk] + this.v * x[this.xj];
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("x[" + this.xk + "]=-" + this.v + "*x[" + this.xj + "] + xPrime[" + this.xkPrime + "]");
            return sb.toString();
        }
    }

    private class LinearDependency
    extends PresolvingStackElement {
        short x;
        short[] xi;
        double[] mi;
        double q;

        LinearDependency(short x, short[] xi, double[] mi, double q) {
            this.x = x;
            this.xi = xi;
            this.mi = mi;
            this.q = q;
        }

        void postSolve(double[] postsolvedX) {
            for (int k = 0; this.xi != null && k < this.xi.length; ++k) {
                short s = this.x;
                postsolvedX[s] = postsolvedX[s] + this.mi[k] * postsolvedX[this.xi[k]];
            }
            short s = this.x;
            postsolvedX[s] = postsolvedX[s] + this.q;
        }

        void preSolve(double[] v) {
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("x[" + this.x + "]=");
            for (int i = 0; this.xi != null && i < this.xi.length; i = (int)((short)(i + 1))) {
                sb.append("+" + this.mi[i] + "*x[" + this.xi[i] + "]");
            }
            sb.append("+" + this.q);
            return sb.toString();
        }
    }

    private abstract class PresolvingStackElement {
        private PresolvingStackElement() {
        }

        abstract void postSolve(double[] var1);

        abstract void preSolve(double[] var1);
    }
}

