/*
 * Decompiled with CFR 0.152.
 */
package com.joptimizer.solvers;

import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.SparseDoubleMatrix2D;
import cern.jet.math.Mult;
import com.joptimizer.algebra.Matrix1NormRescaler;
import com.joptimizer.algebra.QRSparseFactorization;
import com.joptimizer.solvers.KKTSolver;
import com.joptimizer.util.ColtUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FullKKTSolver
extends KKTSolver {
    private Log log = LogFactory.getLog((String)this.getClass().getName());

    public DoubleMatrix1D[] solve() throws Exception {
        DoubleMatrix1D v = null;
        DoubleMatrix1D w = null;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("H: " + ArrayUtils.toString((Object)this.H.toArray())));
            this.log.debug((Object)("g: " + ArrayUtils.toString((Object)this.g.toArray())));
            if (this.A != null) {
                this.log.debug((Object)("A: " + ArrayUtils.toString((Object)this.A.toArray())));
            }
            if (this.h != null) {
                this.log.debug((Object)("h: " + ArrayUtils.toString((Object)this.h.toArray())));
            }
        }
        DoubleMatrix2D KKT = null;
        DoubleMatrix1D b = null;
        DoubleMatrix2D HFull = ColtUtils.fillSubdiagonalSymmetricMatrix((SparseDoubleMatrix2D)this.H);
        if (this.A != null) {
            DoubleMatrix2D[][] parts;
            if (this.h != null) {
                parts = new DoubleMatrix2D[][]{{HFull, this.AT}, {this.A, null}};
                KKT = HFull instanceof SparseDoubleMatrix2D && this.A instanceof SparseDoubleMatrix2D ? DoubleFactory2D.sparse.compose(parts) : DoubleFactory2D.dense.compose(parts);
                b = this.F1.append(this.g, this.h).assign(Mult.mult(-1.0));
            } else {
                parts = new DoubleMatrix2D[][]{{HFull, this.AT}};
                KKT = HFull instanceof SparseDoubleMatrix2D && this.A instanceof SparseDoubleMatrix2D ? DoubleFactory2D.sparse.compose(parts) : DoubleFactory2D.dense.compose(parts);
                b = ColtUtils.scalarMult(this.g, -1.0);
            }
        } else {
            KKT = HFull;
            b = ColtUtils.scalarMult(this.g, -1.0);
        }
        QRSparseFactorization KKTFact = new QRSparseFactorization((SparseDoubleMatrix2D)KKT, new Matrix1NormRescaler());
        try {
            KKTFact.factorize();
        }
        catch (Exception e) {
            this.log.error((Object)"singular KKT system");
            throw new Exception("singular KKT system");
        }
        DoubleMatrix1D x = KKTFact.solve(b);
        v = x.viewPart(0, this.H.rows());
        w = x.viewPart(this.H.rows() - 1, x.size() - this.H.rows());
        if (this.checkKKTSolutionAccuracy && !this.checkKKTSolutionAccuracy(v, w)) {
            this.log.error((Object)"KKT solution failed");
            throw new Exception("KKT solution failed");
        }
        DoubleMatrix1D[] ret = new DoubleMatrix1D[]{v, w};
        return ret;
    }
}

