/*
 * Decompiled with CFR 0.152.
 */
package com.joptimizer.util;

public class BitwiseMath {
    public static int add(int a, int b) {
        int partialSum;
        int carry;
        do {
            partialSum = a ^ b;
            carry = (a & b) << 1;
            a = partialSum;
            b = carry;
        } while (carry != 0);
        return partialSum;
    }

    public static int subtract(int a, int b) {
        return BitwiseMath.add(a, BitwiseMath.add(~b, 1));
    }

    public static int multiply(int n1, int n2) {
        int a = n1;
        int result = 0;
        for (int b = n2; b != 0; b >>>= 1) {
            if ((b & 1) != 0) {
                result += a;
            }
            a <<= 1;
        }
        return result;
    }

    public static int divide(int dividend, int divisor) {
        boolean negative = false;
        if ((dividend & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
            negative = !negative;
            dividend = BitwiseMath.add(~dividend, 1);
        }
        if ((divisor & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
            negative = !negative;
            divisor = BitwiseMath.add(~divisor, 1);
        }
        int quotient = 0;
        int i = 30;
        while (i >= 0) {
            long r = divisor << i;
            if (r < Integer.MAX_VALUE && r >= 0L && r <= (long)dividend) {
                quotient |= 1 << i;
                dividend = BitwiseMath.subtract(dividend, (int)r);
            }
            i = BitwiseMath.subtract(i, 1);
        }
        if (negative) {
            quotient = BitwiseMath.add(~quotient, 1);
        }
        return quotient;
    }
}

