/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkConformanceVersionKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MAJOR;
    public static final int MINOR;
    public static final int SUBMINOR;
    public static final int PATCH;

    public VkConformanceVersionKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkConformanceVersionKHR.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint8_t")
    public byte major() {
        return VkConformanceVersionKHR.nmajor(this.address());
    }

    @NativeType(value="uint8_t")
    public byte minor() {
        return VkConformanceVersionKHR.nminor(this.address());
    }

    @NativeType(value="uint8_t")
    public byte subminor() {
        return VkConformanceVersionKHR.nsubminor(this.address());
    }

    @NativeType(value="uint8_t")
    public byte patch() {
        return VkConformanceVersionKHR.npatch(this.address());
    }

    public VkConformanceVersionKHR major(@NativeType(value="uint8_t") byte value) {
        VkConformanceVersionKHR.nmajor(this.address(), value);
        return this;
    }

    public VkConformanceVersionKHR minor(@NativeType(value="uint8_t") byte value) {
        VkConformanceVersionKHR.nminor(this.address(), value);
        return this;
    }

    public VkConformanceVersionKHR subminor(@NativeType(value="uint8_t") byte value) {
        VkConformanceVersionKHR.nsubminor(this.address(), value);
        return this;
    }

    public VkConformanceVersionKHR patch(@NativeType(value="uint8_t") byte value) {
        VkConformanceVersionKHR.npatch(this.address(), value);
        return this;
    }

    public VkConformanceVersionKHR set(byte major, byte minor, byte subminor, byte patch) {
        this.major(major);
        this.minor(minor);
        this.subminor(subminor);
        this.patch(patch);
        return this;
    }

    public VkConformanceVersionKHR set(VkConformanceVersionKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkConformanceVersionKHR malloc() {
        return (VkConformanceVersionKHR)VkConformanceVersionKHR.wrap(VkConformanceVersionKHR.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkConformanceVersionKHR calloc() {
        return (VkConformanceVersionKHR)VkConformanceVersionKHR.wrap(VkConformanceVersionKHR.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkConformanceVersionKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkConformanceVersionKHR)VkConformanceVersionKHR.wrap(VkConformanceVersionKHR.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkConformanceVersionKHR create(long address) {
        return (VkConformanceVersionKHR)VkConformanceVersionKHR.wrap(VkConformanceVersionKHR.class, (long)address);
    }

    @Nullable
    public static VkConformanceVersionKHR createSafe(long address) {
        return address == 0L ? null : (VkConformanceVersionKHR)VkConformanceVersionKHR.wrap(VkConformanceVersionKHR.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkConformanceVersionKHR.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkConformanceVersionKHR.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkConformanceVersionKHR.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkConformanceVersionKHR.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkConformanceVersionKHR.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkConformanceVersionKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkConformanceVersionKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkConformanceVersionKHR mallocStack() {
        return VkConformanceVersionKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkConformanceVersionKHR callocStack() {
        return VkConformanceVersionKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkConformanceVersionKHR mallocStack(MemoryStack stack) {
        return (VkConformanceVersionKHR)VkConformanceVersionKHR.wrap(VkConformanceVersionKHR.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkConformanceVersionKHR callocStack(MemoryStack stack) {
        return (VkConformanceVersionKHR)VkConformanceVersionKHR.wrap(VkConformanceVersionKHR.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkConformanceVersionKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkConformanceVersionKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkConformanceVersionKHR.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkConformanceVersionKHR.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static byte nmajor(long struct) {
        return UNSAFE.getByte(null, struct + (long)MAJOR);
    }

    public static byte nminor(long struct) {
        return UNSAFE.getByte(null, struct + (long)MINOR);
    }

    public static byte nsubminor(long struct) {
        return UNSAFE.getByte(null, struct + (long)SUBMINOR);
    }

    public static byte npatch(long struct) {
        return UNSAFE.getByte(null, struct + (long)PATCH);
    }

    public static void nmajor(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)MAJOR, value);
    }

    public static void nminor(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)MINOR, value);
    }

    public static void nsubminor(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)SUBMINOR, value);
    }

    public static void npatch(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)PATCH, value);
    }

    static {
        Struct.Layout layout = VkConformanceVersionKHR.__struct((Struct.Member[])new Struct.Member[]{VkConformanceVersionKHR.__member((int)1), VkConformanceVersionKHR.__member((int)1), VkConformanceVersionKHR.__member((int)1), VkConformanceVersionKHR.__member((int)1)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MAJOR = layout.offsetof(0);
        MINOR = layout.offsetof(1);
        SUBMINOR = layout.offsetof(2);
        PATCH = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkConformanceVersionKHR, Buffer>
    implements NativeResource {
        private static final VkConformanceVersionKHR ELEMENT_FACTORY = VkConformanceVersionKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkConformanceVersionKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint8_t")
        public byte major() {
            return VkConformanceVersionKHR.nmajor(this.address());
        }

        @NativeType(value="uint8_t")
        public byte minor() {
            return VkConformanceVersionKHR.nminor(this.address());
        }

        @NativeType(value="uint8_t")
        public byte subminor() {
            return VkConformanceVersionKHR.nsubminor(this.address());
        }

        @NativeType(value="uint8_t")
        public byte patch() {
            return VkConformanceVersionKHR.npatch(this.address());
        }

        public Buffer major(@NativeType(value="uint8_t") byte value) {
            VkConformanceVersionKHR.nmajor(this.address(), value);
            return this;
        }

        public Buffer minor(@NativeType(value="uint8_t") byte value) {
            VkConformanceVersionKHR.nminor(this.address(), value);
            return this;
        }

        public Buffer subminor(@NativeType(value="uint8_t") byte value) {
            VkConformanceVersionKHR.nsubminor(this.address(), value);
            return this;
        }

        public Buffer patch(@NativeType(value="uint8_t") byte value) {
            VkConformanceVersionKHR.npatch(this.address(), value);
            return this;
        }
    }
}

