/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkGeometryDataNV;

public class VkGeometryNV
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int GEOMETRYTYPE;
    public static final int GEOMETRY;
    public static final int FLAGS;

    public VkGeometryNV(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkGeometryNV.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkGeometryNV.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkGeometryNV.npNext(this.address());
    }

    @NativeType(value="VkGeometryTypeNV")
    public int geometryType() {
        return VkGeometryNV.ngeometryType(this.address());
    }

    public VkGeometryDataNV geometry() {
        return VkGeometryNV.ngeometry(this.address());
    }

    public VkGeometryNV geometry(Consumer<VkGeometryDataNV> consumer) {
        consumer.accept(this.geometry());
        return this;
    }

    @NativeType(value="VkGeometryFlagsNV")
    public int flags() {
        return VkGeometryNV.nflags(this.address());
    }

    public VkGeometryNV sType(@NativeType(value="VkStructureType") int value) {
        VkGeometryNV.nsType(this.address(), value);
        return this;
    }

    public VkGeometryNV pNext(@NativeType(value="void const *") long value) {
        VkGeometryNV.npNext(this.address(), value);
        return this;
    }

    public VkGeometryNV geometryType(@NativeType(value="VkGeometryTypeNV") int value) {
        VkGeometryNV.ngeometryType(this.address(), value);
        return this;
    }

    public VkGeometryNV geometry(VkGeometryDataNV value) {
        VkGeometryNV.ngeometry(this.address(), value);
        return this;
    }

    public VkGeometryNV flags(@NativeType(value="VkGeometryFlagsNV") int value) {
        VkGeometryNV.nflags(this.address(), value);
        return this;
    }

    public VkGeometryNV set(int sType, long pNext, int geometryType, VkGeometryDataNV geometry, int flags) {
        this.sType(sType);
        this.pNext(pNext);
        this.geometryType(geometryType);
        this.geometry(geometry);
        this.flags(flags);
        return this;
    }

    public VkGeometryNV set(VkGeometryNV src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkGeometryNV malloc() {
        return (VkGeometryNV)VkGeometryNV.wrap(VkGeometryNV.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkGeometryNV calloc() {
        return (VkGeometryNV)VkGeometryNV.wrap(VkGeometryNV.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkGeometryNV create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkGeometryNV)VkGeometryNV.wrap(VkGeometryNV.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkGeometryNV create(long address) {
        return (VkGeometryNV)VkGeometryNV.wrap(VkGeometryNV.class, (long)address);
    }

    @Nullable
    public static VkGeometryNV createSafe(long address) {
        return address == 0L ? null : (VkGeometryNV)VkGeometryNV.wrap(VkGeometryNV.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkGeometryNV.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkGeometryNV.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkGeometryNV.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkGeometryNV.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkGeometryNV.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkGeometryNV.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkGeometryNV.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkGeometryNV mallocStack() {
        return VkGeometryNV.mallocStack(MemoryStack.stackGet());
    }

    public static VkGeometryNV callocStack() {
        return VkGeometryNV.callocStack(MemoryStack.stackGet());
    }

    public static VkGeometryNV mallocStack(MemoryStack stack) {
        return (VkGeometryNV)VkGeometryNV.wrap(VkGeometryNV.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkGeometryNV callocStack(MemoryStack stack) {
        return (VkGeometryNV)VkGeometryNV.wrap(VkGeometryNV.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkGeometryNV.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkGeometryNV.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkGeometryNV.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkGeometryNV.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int ngeometryType(long struct) {
        return UNSAFE.getInt(null, struct + (long)GEOMETRYTYPE);
    }

    public static VkGeometryDataNV ngeometry(long struct) {
        return VkGeometryDataNV.create(struct + (long)GEOMETRY);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void ngeometryType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)GEOMETRYTYPE, value);
    }

    public static void ngeometry(long struct, VkGeometryDataNV value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)GEOMETRY), (long)VkGeometryDataNV.SIZEOF);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    static {
        Struct.Layout layout = VkGeometryNV.__struct((Struct.Member[])new Struct.Member[]{VkGeometryNV.__member((int)4), VkGeometryNV.__member((int)POINTER_SIZE), VkGeometryNV.__member((int)4), VkGeometryNV.__member((int)VkGeometryDataNV.SIZEOF, (int)VkGeometryDataNV.ALIGNOF), VkGeometryNV.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        GEOMETRYTYPE = layout.offsetof(2);
        GEOMETRY = layout.offsetof(3);
        FLAGS = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkGeometryNV, Buffer>
    implements NativeResource {
        private static final VkGeometryNV ELEMENT_FACTORY = VkGeometryNV.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkGeometryNV getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkGeometryNV.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkGeometryNV.npNext(this.address());
        }

        @NativeType(value="VkGeometryTypeNV")
        public int geometryType() {
            return VkGeometryNV.ngeometryType(this.address());
        }

        public VkGeometryDataNV geometry() {
            return VkGeometryNV.ngeometry(this.address());
        }

        public Buffer geometry(Consumer<VkGeometryDataNV> consumer) {
            consumer.accept(this.geometry());
            return this;
        }

        @NativeType(value="VkGeometryFlagsNV")
        public int flags() {
            return VkGeometryNV.nflags(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkGeometryNV.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkGeometryNV.npNext(this.address(), value);
            return this;
        }

        public Buffer geometryType(@NativeType(value="VkGeometryTypeNV") int value) {
            VkGeometryNV.ngeometryType(this.address(), value);
            return this;
        }

        public Buffer geometry(VkGeometryDataNV value) {
            VkGeometryNV.ngeometry(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkGeometryFlagsNV") int value) {
            VkGeometryNV.nflags(this.address(), value);
            return this;
        }
    }
}

