/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.NumberFormat;
import org.joml.Rectangled;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.internal.Options;
import org.joml.internal.Runtime;

public class Rectanglef
implements Externalizable {
    public float minX;
    public float minY;
    public float maxX;
    public float maxY;

    public Rectanglef() {
    }

    public Rectanglef(Rectanglef source) {
        this.minX = source.minX;
        this.minY = source.minY;
        this.maxX = source.maxX;
        this.maxY = source.maxY;
    }

    public Rectanglef(Vector2fc min, Vector2fc max) {
        this.minX = min.x();
        this.minY = min.y();
        this.maxX = max.x();
        this.maxY = max.y();
    }

    public Rectanglef(float minX, float minY, float maxX, float maxY) {
        this.minX = minX;
        this.minY = minY;
        this.maxX = maxX;
        this.maxY = maxY;
    }

    public boolean intersects(Rectangled other) {
        return (double)this.minX < other.maxX && (double)this.maxX >= other.minX && (double)this.maxY >= other.minY && (double)this.minY < other.maxY;
    }

    public boolean contains(Vector2f point) {
        return this.contains(point.x, point.y);
    }

    public boolean contains(float x, float y) {
        return x >= this.minX && y >= this.minX && x < this.maxX && y < this.maxY;
    }

    public Rectanglef translate(Vector2fc xy) {
        return this.translate(xy.x(), xy.y(), this);
    }

    public Rectanglef translate(Vector2fc xy, Rectanglef dest) {
        return this.translate(xy.x(), xy.y(), dest);
    }

    public Rectanglef translate(float x, float y) {
        return this.translate(x, y, this);
    }

    public Rectanglef translate(float x, float y, Rectanglef dest) {
        dest.minX = this.minX + x;
        dest.minY = this.minY + y;
        dest.maxX = this.maxX + x;
        dest.maxY = this.maxY + y;
        return dest;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.maxX);
        result = 31 * result + Float.floatToIntBits(this.maxY);
        result = 31 * result + Float.floatToIntBits(this.minX);
        result = 31 * result + Float.floatToIntBits(this.minY);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Rectanglef other = (Rectanglef)obj;
        if (Float.floatToIntBits(this.maxX) != Float.floatToIntBits(other.maxX)) {
            return false;
        }
        if (Float.floatToIntBits(this.maxY) != Float.floatToIntBits(other.maxY)) {
            return false;
        }
        if (Float.floatToIntBits(this.minX) != Float.floatToIntBits(other.minX)) {
            return false;
        }
        return Float.floatToIntBits(this.minY) == Float.floatToIntBits(other.minY);
    }

    public String toString() {
        return Runtime.formatNumbers(this.toString(Options.NUMBER_FORMAT));
    }

    public String toString(NumberFormat formatter) {
        return "(" + formatter.format(this.minX) + " " + formatter.format(this.minY) + ") < (" + formatter.format(this.maxX) + " " + formatter.format(this.maxY) + ")";
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeFloat(this.minX);
        out.writeFloat(this.minY);
        out.writeFloat(this.maxX);
        out.writeFloat(this.maxY);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.minX = in.readFloat();
        this.minY = in.readFloat();
        this.maxX = in.readFloat();
        this.maxY = in.readFloat();
    }
}

