/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.BTreeMap;
import org.mapdb.ConcurrentNavigableMapExtra;
import org.mapdb.DataIO;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.Serializer;
import org.mapdb.StoreBinaryGetLong;
import org.mapdb.serializer.GroupSerializer;

public class BTreeMapJava {
    static final int DIR = 8;
    static final int LEFT = 4;
    static final int RIGHT = 2;
    static final int LAST_KEY_DOUBLE = 1;
    public static final Comparator COMPARABLE_COMPARATOR = new Comparator<Comparable>(){

        @Override
        public int compare(Comparable o1, Comparable o2) {
            return o1.compareTo(o2);
        }
    };
    static final Object LINK = new Object(){

        public String toString() {
            return "BTreeMap.LINK";
        }
    };

    static long findChild(GroupSerializer keySerializer, Node node, Comparator comparator, Object key) {
        long[] children;
        if (!node.isDir()) {
            throw new AssertionError();
        }
        int pos = keySerializer.valueArraySearch(node.keys, key, comparator);
        if (pos < 0) {
            pos = -pos - 1;
        }
        pos += -1 + node.intLeftEdge();
        if ((pos = Math.max(0, pos)) >= (children = (long[])node.values).length) {
            if (node.isRightEdge()) {
                throw new AssertionError();
            }
            return node.link;
        }
        return children[pos];
    }

    static Object leafGet(Node node, Comparator comparator, Object key, GroupSerializer keySerializer, GroupSerializer valueSerializer) {
        int pos = keySerializer.valueArraySearch(node.keys, key, comparator);
        return BTreeMapJava.leafGet(node, pos, keySerializer, valueSerializer);
    }

    static Object leafGet(Node node, int pos, GroupSerializer keySerializer, GroupSerializer valueSerializer) {
        if (pos < 1 - node.intLeftEdge()) {
            if (!node.isRightEdge() && pos < -keySerializer.valueArraySize(node.keys)) {
                return LINK;
            }
            return null;
        }
        int valsLen = valueSerializer.valueArraySize(node.values);
        if (!node.isRightEdge() && pos == valsLen + 1) {
            return null;
        }
        if (pos >= valsLen + 1) {
            return LINK;
        }
        if ((pos = pos - 1 + node.intLeftEdge()) >= valsLen) {
            return null;
        }
        return valueSerializer.valueArrayGet(node.values, pos);
    }

    protected static Object[] arrayPut(Object[] array, int pos, Object value) {
        Object[] ret2 = Arrays.copyOf(array, array.length + 1);
        if (pos < array.length) {
            System.arraycopy(array, pos, ret2, pos + 1, array.length - pos);
        }
        ret2[pos] = value;
        return ret2;
    }

    protected static long[] arrayPut(long[] array, int pos, long value) {
        long[] ret2 = Arrays.copyOf(array, array.length + 1);
        if (pos < array.length) {
            System.arraycopy(array, pos, ret2, pos + 1, array.length - pos);
        }
        ret2[pos] = value;
        return ret2;
    }

    static <E> List<E> toList(Collection<E> c) {
        ArrayList<E> list = new ArrayList<E>();
        for (E e : c) {
            list.add(e);
        }
        return list;
    }

    protected static class DescendingMap<K, V>
    extends AbstractMap<K, V>
    implements ConcurrentNavigableMap2<K, V> {
        protected final ConcurrentNavigableMapExtra<K, V> m;
        protected final K lo;
        protected final boolean loInclusive;
        protected final K hi;
        protected final boolean hiInclusive;

        public DescendingMap(ConcurrentNavigableMapExtra<K, V> m, K lo, boolean loInclusive, K hi, boolean hiInclusive) {
            this.m = m;
            this.lo = lo;
            this.loInclusive = loInclusive;
            this.hi = hi;
            this.hiInclusive = hiInclusive;
            if (lo != null && hi != null && m.comparator().compare(lo, hi) > 0) {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public boolean containsKey(Object key) {
            if (key == null) {
                throw new NullPointerException();
            }
            Object k = key;
            return this.inBounds(k) && this.m.containsKey(k);
        }

        @Override
        public V get(Object key) {
            if (key == null) {
                throw new NullPointerException();
            }
            Object k = key;
            return !this.inBounds(k) ? null : (V)this.m.get(k);
        }

        @Override
        public V put(K key, V value) {
            this.checkKeyBounds(key);
            return this.m.put(key, value);
        }

        @Override
        public V remove(Object key) {
            Object k = key;
            return !this.inBounds(k) ? null : (V)this.m.remove(k);
        }

        @Override
        public int size() {
            if (this.hi == null && this.lo == null) {
                return this.m.size();
            }
            Iterator<K> i = this.m.keyIterator(this.lo, this.loInclusive, this.hi, this.hiInclusive);
            long counter = 0L;
            while (i.hasNext()) {
                ++counter;
                i.next();
            }
            return (int)Math.min(counter, Integer.MAX_VALUE);
        }

        @Override
        public boolean isEmpty() {
            return !this.keyIterator().hasNext();
        }

        @Override
        public boolean containsValue(Object value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Iterator<V> i = this.valueIterator();
            while (i.hasNext()) {
                if (!this.m.getValueSerializer().equals(value, i.next())) continue;
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            Iterator<K> i = this.keyIterator();
            while (i.hasNext()) {
                i.next();
                i.remove();
            }
        }

        @Override
        public V putIfAbsent(K key, V value) {
            this.checkKeyBounds(key);
            return this.m.putIfAbsent(key, value);
        }

        @Override
        public boolean remove(Object key, Object value) {
            Object k = key;
            return this.inBounds(k) && this.m.remove(k, value);
        }

        @Override
        public boolean replace(K key, V oldValue, V newValue) {
            this.checkKeyBounds(key);
            return this.m.replace(key, oldValue, newValue);
        }

        @Override
        public V replace(K key, V value) {
            this.checkKeyBounds(key);
            return this.m.replace(key, value);
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.m.comparator();
        }

        @Override
        public Map.Entry<K, V> higherEntry(K key) {
            if (key == null) {
                throw new NullPointerException();
            }
            if (this.tooLow(key)) {
                return null;
            }
            if (this.tooHigh(key)) {
                return this.firstEntry();
            }
            Map.Entry r = this.m.lowerEntry(key);
            return r != null && !this.tooLow(r.getKey()) ? r : null;
        }

        @Override
        public K lowerKey(K key) {
            Map.Entry<K, V> n = this.lowerEntry(key);
            return n == null ? null : (K)n.getKey();
        }

        @Override
        public Map.Entry<K, V> ceilingEntry(K key) {
            if (key == null) {
                throw new NullPointerException();
            }
            if (this.tooLow(key)) {
                return null;
            }
            if (this.tooHigh(key)) {
                return this.firstEntry();
            }
            Map.Entry ret2 = this.m.floorEntry(key);
            if (ret2 != null && this.tooLow(ret2.getKey())) {
                return null;
            }
            return ret2;
        }

        @Override
        public K floorKey(K key) {
            Map.Entry<K, V> n = this.floorEntry(key);
            return n == null ? null : (K)n.getKey();
        }

        @Override
        public Map.Entry<K, V> floorEntry(K key) {
            if (key == null) {
                throw new NullPointerException();
            }
            if (this.tooHigh(key)) {
                return null;
            }
            if (this.tooLow(key)) {
                return this.lastEntry();
            }
            Map.Entry ret2 = this.m.ceilingEntry(key);
            if (ret2 != null && this.tooHigh(ret2.getKey())) {
                return null;
            }
            return ret2;
        }

        @Override
        public K ceilingKey(K key) {
            Map.Entry<K, V> k = this.ceilingEntry(key);
            return k != null ? (K)k.getKey() : null;
        }

        @Override
        public Map.Entry<K, V> lowerEntry(K key) {
            Map.Entry r = this.m.higherEntry(key);
            return r != null && this.inBounds(r.getKey()) ? r : null;
        }

        @Override
        public K higherKey(K key) {
            Map.Entry<K, V> k = this.higherEntry(key);
            return k != null ? (K)k.getKey() : null;
        }

        @Override
        public K firstKey2() {
            Map.Entry<K, V> e = this.firstEntry();
            if (e == null) {
                return null;
            }
            return e.getKey();
        }

        @Override
        public K lastKey2() {
            Map.Entry<K, V> e = this.lastEntry();
            if (e == null) {
                return null;
            }
            return e.getKey();
        }

        @Override
        public K firstKey() {
            K key = this.firstKey2();
            if (key == null) {
                throw new NoSuchElementException();
            }
            return key;
        }

        @Override
        public K lastKey() {
            K key = this.lastKey2();
            if (key == null) {
                throw new NoSuchElementException();
            }
            return key;
        }

        @Override
        public Map.Entry<K, V> lastEntry() {
            Map.Entry k = this.lo == null ? this.m.firstEntry() : this.m.findHigher(this.lo, this.loInclusive);
            return k != null && this.inBounds(k.getKey()) ? k : null;
        }

        @Override
        public Map.Entry<K, V> firstEntry() {
            Map.Entry k = this.hi == null ? this.m.lastEntry() : this.m.findLower(this.hi, this.hiInclusive);
            return k != null && this.inBounds(k.getKey()) ? k : null;
        }

        @Override
        public Map.Entry<K, V> pollFirstEntry() {
            Map.Entry<K, V> e;
            while ((e = this.firstEntry()) != null && !this.remove(e.getKey(), e.getValue())) {
            }
            return e;
        }

        @Override
        public Map.Entry<K, V> pollLastEntry() {
            Map.Entry<K, V> e;
            while ((e = this.lastEntry()) != null && !this.remove(e.getKey(), e.getValue())) {
            }
            return e;
        }

        private DescendingMap<K, V> newSubMap(K toKey, boolean toInclusive, K fromKey, boolean fromInclusive) {
            int c;
            if (this.lo != null) {
                if (fromKey == null) {
                    fromKey = this.lo;
                    fromInclusive = this.loInclusive;
                } else {
                    c = this.m.comparator().compare(fromKey, this.lo);
                    if (c < 0 || c == 0 && !this.loInclusive && fromInclusive) {
                        throw new IllegalArgumentException("key out of range");
                    }
                }
            }
            if (this.hi != null) {
                if (toKey == null) {
                    toKey = this.hi;
                    toInclusive = this.hiInclusive;
                } else {
                    c = this.m.comparator().compare(toKey, this.hi);
                    if (c > 0 || c == 0 && !this.hiInclusive && toInclusive) {
                        throw new IllegalArgumentException("key out of range");
                    }
                }
            }
            return new DescendingMap<K, V>(this.m, fromKey, fromInclusive, toKey, toInclusive);
        }

        @Override
        public DescendingMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
            if (fromKey == null || toKey == null) {
                throw new NullPointerException();
            }
            return this.newSubMap(fromKey, fromInclusive, toKey, toInclusive);
        }

        @Override
        public DescendingMap<K, V> headMap(K toKey, boolean inclusive) {
            if (toKey == null) {
                throw new NullPointerException();
            }
            return this.newSubMap(null, false, toKey, inclusive);
        }

        @Override
        public DescendingMap<K, V> tailMap(K fromKey, boolean inclusive) {
            if (fromKey == null) {
                throw new NullPointerException();
            }
            return this.newSubMap(fromKey, inclusive, null, false);
        }

        @Override
        public DescendingMap<K, V> subMap(K fromKey, K toKey) {
            return this.subMap((Object)fromKey, true, (Object)toKey, false);
        }

        @Override
        public DescendingMap<K, V> headMap(K toKey) {
            return this.headMap((Object)toKey, false);
        }

        @Override
        public DescendingMap<K, V> tailMap(K fromKey) {
            return this.tailMap((Object)fromKey, true);
        }

        @Override
        public ConcurrentNavigableMap<K, V> descendingMap() {
            if (this.lo == null && this.hi == null) {
                return this.m;
            }
            return this.m.subMap((Object)this.lo, this.loInclusive, (Object)this.hi, this.hiInclusive);
        }

        @Override
        public NavigableSet<K> navigableKeySet() {
            return new KeySet(this, this.m.getHasValues());
        }

        private boolean tooLow(K key) {
            int c;
            return this.lo != null && ((c = this.m.comparator().compare(key, this.lo)) < 0 || c == 0 && !this.loInclusive);
        }

        private boolean tooHigh(K key) {
            int c;
            return this.hi != null && ((c = this.m.comparator().compare(key, this.hi)) > 0 || c == 0 && !this.hiInclusive);
        }

        private boolean inBounds(K key) {
            return !this.tooLow(key) && !this.tooHigh(key);
        }

        private void checkKeyBounds(K key) throws IllegalArgumentException {
            if (key == null) {
                throw new NullPointerException();
            }
            if (!this.inBounds(key)) {
                throw new IllegalArgumentException("key out of range");
            }
        }

        @Override
        public NavigableSet<K> keySet() {
            return new KeySet(this, this.m.getHasValues());
        }

        @Override
        public NavigableSet<K> descendingKeySet() {
            return new KeySet((ConcurrentNavigableMap2)this.descendingMap(), this.m.getHasValues());
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new EntrySet(this, this.m.getValueSerializer());
        }

        Iterator<K> keyIterator() {
            if (this.lo == null && this.hi == null) {
                return this.m.descendingKeyIterator();
            }
            return this.m.descendingKeyIterator(this.lo, this.loInclusive, this.hi, this.hiInclusive);
        }

        Iterator<V> valueIterator() {
            if (this.lo == null && this.hi == null) {
                return this.m.descendingValueIterator();
            }
            return this.m.descendingValueIterator(this.lo, this.loInclusive, this.hi, this.hiInclusive);
        }

        Iterator<Map.Entry<K, V>> entryIterator() {
            if (this.lo == null && this.hi == null) {
                return this.m.descendingEntryIterator();
            }
            return this.m.descendingEntryIterator(this.lo, this.loInclusive, this.hi, this.hiInclusive);
        }
    }

    public static interface ConcurrentNavigableMap2<K, V>
    extends ConcurrentNavigableMap<K, V> {
        public K firstKey2();

        public K lastKey2();
    }

    protected static class SubMap<K, V>
    extends AbstractMap<K, V>
    implements ConcurrentNavigableMap2<K, V> {
        protected final ConcurrentNavigableMapExtra<K, V> m;
        protected final K lo;
        protected final boolean loInclusive;
        protected final K hi;
        protected final boolean hiInclusive;

        public SubMap(ConcurrentNavigableMapExtra<K, V> m, K lo, boolean loInclusive, K hi, boolean hiInclusive) {
            this.m = m;
            this.lo = lo;
            this.loInclusive = loInclusive;
            this.hi = hi;
            this.hiInclusive = hiInclusive;
            if (lo != null && hi != null && m.comparator().compare(lo, hi) > 0) {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public boolean containsKey(Object key) {
            if (key == null) {
                throw new NullPointerException();
            }
            Object k = key;
            return this.inBounds(k) && this.m.containsKey(k);
        }

        @Override
        public V get(Object key) {
            if (key == null) {
                throw new NullPointerException();
            }
            Object k = key;
            return !this.inBounds(k) ? null : (V)this.m.get(k);
        }

        @Override
        public V put(K key, V value) {
            this.checkKeyBounds(key);
            return this.m.put(key, value);
        }

        @Override
        public V remove(Object key) {
            if (key == null) {
                throw new NullPointerException("key null");
            }
            Object k = key;
            return !this.inBounds(k) ? null : (V)this.m.remove(k);
        }

        @Override
        public int size() {
            return (int)Math.min(this.sizeLong(), Integer.MAX_VALUE);
        }

        public long sizeLong() {
            if (this.hi == null && this.lo == null) {
                return this.m.sizeLong();
            }
            Iterator<K> i = this.keyIterator();
            long counter = 0L;
            while (i.hasNext()) {
                ++counter;
                i.next();
            }
            return counter;
        }

        @Override
        public boolean isEmpty() {
            return !this.keyIterator().hasNext();
        }

        @Override
        public boolean containsValue(Object value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Iterator<V> i = this.valueIterator();
            while (i.hasNext()) {
                if (!this.m.getValueSerializer().equals(value, i.next())) continue;
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            Iterator<K> i = this.keyIterator();
            while (i.hasNext()) {
                i.next();
                i.remove();
            }
        }

        @Override
        public V putIfAbsent(K key, V value) {
            this.checkKeyBounds(key);
            return this.m.putIfAbsent(key, value);
        }

        @Override
        public boolean remove(Object key, Object value) {
            Object k = key;
            return this.inBounds(k) && this.m.remove(k, value);
        }

        @Override
        public boolean replace(K key, V oldValue, V newValue) {
            this.checkKeyBounds(key);
            return this.m.replace(key, oldValue, newValue);
        }

        @Override
        public V replace(K key, V value) {
            this.checkKeyBounds(key);
            return this.m.replace(key, value);
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.m.comparator();
        }

        @Override
        public Map.Entry<K, V> lowerEntry(K key) {
            if (key == null) {
                throw new NullPointerException();
            }
            if (this.tooLow(key)) {
                return null;
            }
            if (this.tooHigh(key)) {
                return this.lastEntry();
            }
            Map.Entry r = this.m.lowerEntry(key);
            return r != null && !this.tooLow(r.getKey()) ? r : null;
        }

        @Override
        public K lowerKey(K key) {
            if (key == null) {
                throw new NullPointerException();
            }
            if (this.tooLow(key)) {
                return null;
            }
            if (this.tooHigh(key)) {
                return this.lastKey2();
            }
            K r = this.m.lowerKey(key);
            return r != null && !this.tooLow(r) ? (K)r : null;
        }

        @Override
        public Map.Entry<K, V> floorEntry(K key) {
            if (key == null) {
                throw new NullPointerException();
            }
            if (this.tooLow(key)) {
                return null;
            }
            if (this.tooHigh(key)) {
                return this.lastEntry();
            }
            Map.Entry ret2 = this.m.floorEntry(key);
            if (ret2 != null && this.tooLow(ret2.getKey())) {
                return null;
            }
            return ret2;
        }

        @Override
        public K floorKey(K key) {
            if (key == null) {
                throw new NullPointerException();
            }
            if (this.tooLow(key)) {
                return null;
            }
            if (this.tooHigh(key)) {
                return this.lastKey2();
            }
            K ret2 = this.m.floorKey(key);
            if (ret2 != null && this.tooLow(ret2)) {
                return null;
            }
            return ret2;
        }

        @Override
        public Map.Entry<K, V> ceilingEntry(K key) {
            if (key == null) {
                throw new NullPointerException();
            }
            if (this.tooHigh(key)) {
                return null;
            }
            if (this.tooLow(key)) {
                return this.firstEntry();
            }
            Map.Entry ret2 = this.m.ceilingEntry(key);
            if (ret2 != null && this.tooHigh(ret2.getKey())) {
                return null;
            }
            return ret2;
        }

        @Override
        public K ceilingKey(K key) {
            if (key == null) {
                throw new NullPointerException();
            }
            if (this.tooHigh(key)) {
                return null;
            }
            if (this.tooLow(key)) {
                return this.firstKey2();
            }
            K ret2 = this.m.ceilingKey(key);
            if (ret2 != null && this.tooHigh(ret2)) {
                return null;
            }
            return ret2;
        }

        @Override
        public Map.Entry<K, V> higherEntry(K key) {
            Map.Entry r = this.m.higherEntry(key);
            return r != null && this.inBounds(r.getKey()) ? r : null;
        }

        @Override
        public K higherKey(K key) {
            K r = this.m.higherKey(key);
            return r != null && this.inBounds(r) ? (K)r : null;
        }

        @Override
        public K firstKey2() {
            Object k = this.lo == null ? this.m.firstKey2() : this.m.findHigherKey(this.lo, this.loInclusive);
            return k != null && this.inBounds(k) ? (K)k : null;
        }

        @Override
        public K lastKey2() {
            Object k = this.hi == null ? this.m.lastKey2() : this.m.findLowerKey(this.hi, this.hiInclusive);
            return k != null && this.inBounds(k) ? (K)k : null;
        }

        @Override
        public K firstKey() {
            K ret2 = this.firstKey2();
            if (ret2 == null) {
                throw new NoSuchElementException();
            }
            return ret2;
        }

        @Override
        public K lastKey() {
            K ret2 = this.lastKey2();
            if (ret2 == null) {
                throw new NoSuchElementException();
            }
            return ret2;
        }

        @Override
        public Map.Entry<K, V> firstEntry() {
            Map.Entry k = this.lo == null ? this.m.firstEntry() : this.m.findHigher(this.lo, this.loInclusive);
            return k != null && this.inBounds(k.getKey()) ? k : null;
        }

        @Override
        public Map.Entry<K, V> lastEntry() {
            Map.Entry k = this.hi == null ? this.m.lastEntry() : this.m.findLower(this.hi, this.hiInclusive);
            return k != null && this.inBounds(k.getKey()) ? k : null;
        }

        @Override
        public Map.Entry<K, V> pollFirstEntry() {
            Map.Entry<K, V> e;
            while ((e = this.firstEntry()) != null && !this.remove(e.getKey(), e.getValue())) {
            }
            return e;
        }

        @Override
        public Map.Entry<K, V> pollLastEntry() {
            Map.Entry<K, V> e;
            while ((e = this.lastEntry()) != null && !this.remove(e.getKey(), e.getValue())) {
            }
            return e;
        }

        private SubMap<K, V> newSubMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
            int c;
            if (this.lo != null) {
                if (fromKey == null) {
                    fromKey = this.lo;
                    fromInclusive = this.loInclusive;
                } else {
                    c = this.m.comparator().compare(fromKey, this.lo);
                    if (c < 0 || c == 0 && !this.loInclusive && fromInclusive) {
                        throw new IllegalArgumentException("key out of range");
                    }
                }
            }
            if (this.hi != null) {
                if (toKey == null) {
                    toKey = this.hi;
                    toInclusive = this.hiInclusive;
                } else {
                    c = this.m.comparator().compare(toKey, this.hi);
                    if (c > 0 || c == 0 && !this.hiInclusive && toInclusive) {
                        throw new IllegalArgumentException("key out of range");
                    }
                }
            }
            return new SubMap<K, V>(this.m, fromKey, fromInclusive, toKey, toInclusive);
        }

        @Override
        public SubMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
            if (fromKey == null || toKey == null) {
                throw new NullPointerException();
            }
            return this.newSubMap(fromKey, fromInclusive, toKey, toInclusive);
        }

        @Override
        public SubMap<K, V> headMap(K toKey, boolean inclusive) {
            if (toKey == null) {
                throw new NullPointerException();
            }
            return this.newSubMap(null, false, toKey, inclusive);
        }

        @Override
        public SubMap<K, V> tailMap(K fromKey, boolean inclusive) {
            if (fromKey == null) {
                throw new NullPointerException();
            }
            return this.newSubMap(fromKey, inclusive, null, false);
        }

        @Override
        public SubMap<K, V> subMap(K fromKey, K toKey) {
            return this.subMap((Object)fromKey, true, (Object)toKey, false);
        }

        @Override
        public SubMap<K, V> headMap(K toKey) {
            return this.headMap((Object)toKey, false);
        }

        @Override
        public SubMap<K, V> tailMap(K fromKey) {
            return this.tailMap((Object)fromKey, true);
        }

        @Override
        public ConcurrentNavigableMap<K, V> descendingMap() {
            return new DescendingMap<K, V>(this.m, this.lo, this.loInclusive, this.hi, this.hiInclusive);
        }

        @Override
        public NavigableSet<K> navigableKeySet() {
            return new KeySet(this, this.m.getHasValues());
        }

        private boolean tooLow(K key) {
            int c;
            return this.lo != null && ((c = this.m.comparator().compare(key, this.lo)) < 0 || c == 0 && !this.loInclusive);
        }

        private boolean tooHigh(K key) {
            int c;
            return this.hi != null && ((c = this.m.comparator().compare(key, this.hi)) > 0 || c == 0 && !this.hiInclusive);
        }

        private boolean inBounds(K key) {
            return !this.tooLow(key) && !this.tooHigh(key);
        }

        private void checkKeyBounds(K key) throws IllegalArgumentException {
            if (key == null) {
                throw new NullPointerException();
            }
            if (!this.inBounds(key)) {
                throw new IllegalArgumentException("key out of range");
            }
        }

        @Override
        public NavigableSet<K> keySet() {
            return new KeySet(this, this.m.getHasValues());
        }

        @Override
        public NavigableSet<K> descendingKeySet() {
            return new DescendingMap<K, V>(this.m, this.lo, this.loInclusive, this.hi, this.hiInclusive).keySet();
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new EntrySet(this, this.m.getValueSerializer());
        }

        Iterator<K> keyIterator() {
            return this.m.keyIterator(this.lo, this.loInclusive, this.hi, this.hiInclusive);
        }

        Iterator<V> valueIterator() {
            return this.m.valueIterator(this.lo, this.loInclusive, this.hi, this.hiInclusive);
        }

        Iterator<Map.Entry<K, V>> entryIterator() {
            return this.m.entryIterator(this.lo, this.loInclusive, this.hi, this.hiInclusive);
        }
    }

    static final class EntrySet<K1, V1>
    extends AbstractSet<Map.Entry<K1, V1>> {
        private final ConcurrentNavigableMap<K1, V1> m;
        private final Serializer valueSerializer;

        EntrySet(ConcurrentNavigableMap<K1, V1> map2, Serializer valueSerializer) {
            this.m = map2;
            this.valueSerializer = valueSerializer;
        }

        @Override
        public Iterator<Map.Entry<K1, V1>> iterator() {
            if (this.m instanceof BTreeMap) {
                return ((BTreeMap)this.m).entryIterator();
            }
            if (this.m instanceof SubMap) {
                return ((SubMap)this.m).entryIterator();
            }
            return ((DescendingMap)this.m).entryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (key == null) {
                return false;
            }
            Object v = this.m.get(key);
            return v != null && this.valueSerializer.equals(v, e.getValue());
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (key == null) {
                return false;
            }
            return this.m.remove(key, e.getValue());
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public int size() {
            return this.m.size();
        }

        @Override
        public void clear() {
            this.m.clear();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Set)) {
                return false;
            }
            Collection c = (Collection)o;
            try {
                return this.containsAll(c) && c.containsAll(this);
            }
            catch (ClassCastException unused) {
                return false;
            }
            catch (NullPointerException unused) {
                return false;
            }
        }

        @Override
        public Object[] toArray() {
            return BTreeMapJava.toList(this).toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return BTreeMapJava.toList(this).toArray(a);
        }
    }

    public static final class KeySet<E>
    extends AbstractSet<E>
    implements NavigableSet<E>,
    Closeable,
    Serializable {
        protected final ConcurrentNavigableMap2<E, Object> m;
        private final boolean hasValues;

        KeySet(ConcurrentNavigableMap2<E, Object> map2, boolean hasValues) {
            this.m = map2;
            this.hasValues = hasValues;
        }

        @Override
        public int size() {
            return this.m.size();
        }

        public long sizeLong() {
            if (this.m instanceof BTreeMap) {
                return ((BTreeMap)this.m).sizeLong();
            }
            return ((SubMap)this.m).sizeLong();
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.m.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return this.m.remove(o) != null;
        }

        @Override
        public void clear() {
            this.m.clear();
        }

        @Override
        public E lower(E e) {
            return this.m.lowerKey(e);
        }

        @Override
        public E floor(E e) {
            return this.m.floorKey(e);
        }

        @Override
        public E ceiling(E e) {
            return this.m.ceilingKey(e);
        }

        @Override
        public E higher(E e) {
            return this.m.higherKey(e);
        }

        @Override
        public Comparator<? super E> comparator() {
            return this.m.comparator();
        }

        @Override
        public E first() {
            return (E)this.m.firstKey();
        }

        @Override
        public E last() {
            return (E)this.m.lastKey();
        }

        @Override
        public E pollFirst() {
            E e;
            while ((e = this.m.firstKey2()) != null && this.m.remove(e) == null) {
            }
            return e;
        }

        @Override
        public E pollLast() {
            E e;
            while ((e = this.m.lastKey2()) != null && this.m.remove(e) == null) {
            }
            return e;
        }

        @Override
        public Iterator<E> iterator() {
            if (this.m instanceof ConcurrentNavigableMapExtra) {
                return ((ConcurrentNavigableMapExtra)this.m).keyIterator();
            }
            if (this.m instanceof SubMap) {
                return ((SubMap)this.m).keyIterator();
            }
            return ((DescendingMap)this.m).keyIterator();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Set)) {
                return false;
            }
            Collection c = (Collection)o;
            try {
                return this.containsAll(c) && c.containsAll(this);
            }
            catch (ClassCastException unused) {
                return false;
            }
            catch (NullPointerException unused) {
                return false;
            }
        }

        @Override
        public Object[] toArray() {
            return BTreeMapJava.toList(this).toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return BTreeMapJava.toList(this).toArray(a);
        }

        @Override
        public Iterator<E> descendingIterator() {
            return this.descendingSet().iterator();
        }

        @Override
        public NavigableSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
            return new KeySet<E>((ConcurrentNavigableMap2)this.m.subMap((Object)fromElement, fromInclusive, (Object)toElement, toInclusive), this.hasValues);
        }

        @Override
        public NavigableSet<E> headSet(E toElement, boolean inclusive) {
            return new KeySet<E>((ConcurrentNavigableMap2)this.m.headMap((Object)toElement, inclusive), this.hasValues);
        }

        @Override
        public NavigableSet<E> tailSet(E fromElement, boolean inclusive) {
            return new KeySet<E>((ConcurrentNavigableMap2)this.m.tailMap((Object)fromElement, inclusive), this.hasValues);
        }

        @Override
        public NavigableSet<E> subSet(E fromElement, E toElement) {
            return this.subSet(fromElement, true, toElement, false);
        }

        @Override
        public NavigableSet<E> headSet(E toElement) {
            return this.headSet(toElement, false);
        }

        @Override
        public NavigableSet<E> tailSet(E fromElement) {
            return this.tailSet(fromElement, true);
        }

        @Override
        public NavigableSet<E> descendingSet() {
            return new KeySet<E>((ConcurrentNavigableMap2)this.m.descendingMap(), this.hasValues);
        }

        @Override
        public boolean add(E k) {
            if (this.hasValues) {
                throw new UnsupportedOperationException();
            }
            return this.m.put(k, Boolean.TRUE) == null;
        }

        @Override
        public void close() {
            if (this.m instanceof BTreeMap) {
                ((BTreeMap)this.m).close();
            }
        }

        Object writeReplace() throws ObjectStreamException {
            ConcurrentSkipListSet<E> ret2 = new ConcurrentSkipListSet<E>();
            for (E e : this) {
                ret2.add(e);
            }
            return ret2;
        }
    }

    public static class BinaryGet<K, V>
    implements StoreBinaryGetLong {
        final GroupSerializer<K> keySerializer;
        final GroupSerializer<V> valueSerializer;
        final Comparator<K> comparator;
        final K key;
        V value = null;

        public BinaryGet(@NotNull GroupSerializer<K> keySerializer, @NotNull GroupSerializer<V> valueSerializer, @NotNull Comparator<K> comparator, @NotNull K key) {
            this.keySerializer = keySerializer;
            this.valueSerializer = valueSerializer;
            this.comparator = comparator;
            this.key = key;
        }

        @Override
        public long get(DataInput2 input, int size2) throws IOException {
            int keysLen = DataIO.parity1Get(input.unpackInt()) >>> 1;
            int flags = keysLen & 0xF;
            if ((keysLen >>>= 4) == 0) {
                return -1L;
            }
            long link = (flags & 2) != 0 ? 0L : input.unpackLong();
            int intLeft = flags >>> 2 & 1;
            int intRight = flags >>> 1 & 1;
            int pos = this.keySerializer.valueArrayBinarySearch(this.key, input, keysLen, this.comparator);
            if ((flags & 8) != 0) {
                if (pos < 0) {
                    pos = -pos - 1;
                }
                pos += -1 + intLeft;
                if ((pos = Math.max(0, pos)) >= (keysLen = keysLen - 1 + intLeft + intRight)) {
                    if (intRight == 1) {
                        throw new AssertionError();
                    }
                    return link;
                }
                if (pos > 0) {
                    input.unpackLongSkip(pos - 1);
                }
                return input.unpackLong();
            }
            if (pos < 1 - intLeft) {
                if (intRight == 0 && pos < -keysLen) {
                    return link;
                }
                return -1L;
            }
            int valsLen = keysLen - 2 + intLeft + intRight + (flags & 1);
            if (intRight == 0 && pos == valsLen + 1) {
                return -1L;
            }
            if (pos >= valsLen + 1) {
                return link;
            }
            if ((pos = pos - 1 + (flags >>> 2 & 1)) >= valsLen) {
                return -1L;
            }
            this.value = this.valueSerializer.valueArrayBinaryGet(input, valsLen, pos);
            return -1L;
        }
    }

    public static class NodeSerializer
    implements Serializer<Node> {
        final GroupSerializer keySerializer;
        final Comparator comparator;
        final GroupSerializer valueSerializer;

        NodeSerializer(GroupSerializer keySerializer, Comparator comparator, GroupSerializer valueSerializer) {
            this.keySerializer = keySerializer;
            this.comparator = comparator;
            this.valueSerializer = valueSerializer;
        }

        @Override
        public void serialize(@NotNull DataOutput2 out, @NotNull Node value) throws IOException {
            if (value.flags >>> 4 != 0) {
                throw new AssertionError();
            }
            int keysLenOrig = this.keySerializer.valueArraySize(value.keys);
            int keysLen = this.keySerializer.valueArraySize(value.keys) << 4;
            keysLen += value.flags;
            keysLen = DataIO.parity1Set(keysLen << 1);
            out.packInt(keysLen);
            if (!value.isRightEdge()) {
                out.packLong(value.link);
            }
            if (keysLenOrig > 0) {
                this.keySerializer.valueArraySerialize(out, value.keys);
            }
            if (value.isDir()) {
                long[] child = (long[])value.values;
                out.packLongArray(child, 0, child.length);
            } else {
                this.valueSerializer.valueArraySerialize(out, value.values);
            }
        }

        @Override
        public Node deserialize(@NotNull DataInput2 input, int available) throws IOException {
            Object values2;
            Object keys;
            int keysLen = DataIO.parity1Get(input.unpackInt()) >>> 1;
            int flags = keysLen & 0xF;
            long link = (flags & 2) != 0 ? 0L : input.unpackLong();
            Object object = keys = keysLen == 0 ? this.keySerializer.valueArrayEmpty() : this.keySerializer.valueArrayDeserialize(input, keysLen >>>= 4);
            if (keysLen != this.keySerializer.valueArraySize(keys)) {
                throw new AssertionError();
            }
            if ((flags & 8) != 0) {
                long[] c;
                keysLen = keysLen - 1 + (flags >> 2 & 1) + (flags >> 1 & 1);
                values2 = c = new long[keysLen];
                input.unpackLongArray(c, 0, keysLen);
            } else {
                values2 = this.valueSerializer.valueArrayDeserialize(input, keysLen - 2 + (flags >>> 2 & 1) + (flags >>> 1 & 1) + (flags & 1));
            }
            Node ret2 = new Node(flags, link, keys, values2);
            return ret2;
        }

        @Override
        public boolean isTrusted() {
            return this.keySerializer.isTrusted() && this.valueSerializer.isTrusted();
        }
    }

    public static class Node {
        final byte flags;
        final long link;
        final Object keys;
        final Object values;

        Node(int flags, long link, Object keys, Object values2) {
            this.flags = (byte)flags;
            this.link = link;
            this.keys = keys;
            this.values = values2;
            if (this.isLastKeyDouble() && this.isDir()) {
                throw new AssertionError();
            }
            if (this.isRightEdge() && link != 0L) {
                throw new AssertionError();
            }
            if (!this.isRightEdge() && link == 0L) {
                throw new AssertionError();
            }
            if (this.isDir() && this.getChildren().length == 0) {
                throw new AssertionError();
            }
        }

        int intDir() {
            return this.flags >>> 3 & 1;
        }

        int intLeftEdge() {
            return this.flags >>> 2 & 1;
        }

        int intRightEdge() {
            return this.flags >>> 1 & 1;
        }

        int intLastKeyTwice() {
            return this.flags & 1;
        }

        boolean isDir() {
            return (this.flags >>> 3 & 1) == 1;
        }

        boolean isLeftEdge() {
            return (this.flags >>> 2 & 1) == 1;
        }

        boolean isRightEdge() {
            return (this.flags >>> 1 & 1) == 1;
        }

        boolean isLastKeyDouble() {
            return (this.flags & 1) == 1;
        }

        boolean isEmpty(GroupSerializer keySerializer) {
            int keySize = keySerializer.valueArraySize(this.keys);
            return !this.isLastKeyDouble() && keySize == 2 - this.intLeftEdge() - this.intRightEdge();
        }

        @Nullable
        public <K> K highKey(GroupSerializer<K> keySerializer) {
            int keysLen = keySerializer.valueArraySize(this.keys);
            return keySerializer.valueArrayGet(this.keys, keysLen - 1);
        }

        public long[] getChildren() {
            return (long[])this.values;
        }

        public void verifyNode(GroupSerializer keySerializer, Comparator comparator, GroupSerializer valueSerializer) {
            int keysLen = keySerializer.valueArraySize(this.keys);
            if (this.isDir() ? keysLen - 1 + this.intLeftEdge() + this.intRightEdge() != ((long[])this.values).length : keysLen != valueSerializer.valueArraySize(this.values) + 2 - this.intLeftEdge() - this.intRightEdge() - this.intLastKeyTwice()) {
                throw new AssertionError();
            }
            if (keysLen > 1) {
                for (int i = 1; i < keysLen; ++i) {
                    int c = comparator.compare(keySerializer.valueArrayGet(this.keys, i - 1), keySerializer.valueArrayGet(this.keys, i));
                    if (c > 0) {
                        throw new AssertionError();
                    }
                    if (c == 0 && i != keysLen - 1) {
                        throw new AssertionError();
                    }
                }
            }
        }
    }
}

