/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl.gl;

import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLException;
import com.jogamp.opencl.CLImage;
import com.jogamp.opencl.CLImageFormat;
import com.jogamp.opencl.CLMemory;
import com.jogamp.opencl.gl.CLGLBuffer;
import com.jogamp.opencl.gl.CLGLImage2d;
import com.jogamp.opencl.gl.CLGLTexture;
import com.jogamp.opencl.llb.CL;
import com.jogamp.opencl.llb.gl.CLGL;
import com.jogamp.opencl.llb.impl.CLImageFormatImpl;
import java.nio.Buffer;

public class CLGLTexture2d<B extends Buffer>
extends CLGLImage2d<B>
implements CLGLTexture {
    public final int target;
    public final int mipMapLevel;

    public CLGLTexture2d(CLContext cLContext, B b, CLImageFormat cLImageFormat, CLImage.CLImageInfoAccessor cLImageInfoAccessor, int n, int n2, int n3, int n4, long l, int n5, int n6) {
        super(cLContext, b, cLImageFormat, cLImageInfoAccessor, n3, n4, l, n5, n6);
        this.target = n;
        this.mipMapLevel = n2;
    }

    static <B extends Buffer> CLGLTexture2d<B> createFromGLTexture2d(CLContext cLContext, B b, int n, int n2, int n3, int n4) {
        CLGLBuffer.checkBuffer(b, n4);
        CL cL = CLGLTexture2d.getCL(cLContext);
        int[] nArray = new int[1];
        CLGL cLGL = (CLGL)cL;
        long l = cLGL.clCreateFromGLTexture2D(cLContext.ID, n4, n, n3, n2, nArray, 0);
        CLException.checkForError(nArray[0], "can not create CLGLTexture2d from texture #" + n2 + ".");
        CLImage.CLImageInfoAccessor cLImageInfoAccessor = new CLImage.CLImageInfoAccessor(cL, l);
        CLImageFormat cLImageFormat = CLGLTexture2d.createUninitializedImageFormat();
        cLImageInfoAccessor.getInfo(4368, CLImageFormatImpl.size(), cLImageFormat.getFormatImpl().getBuffer(), null);
        int n5 = (int)cLImageInfoAccessor.getLong(4372);
        int n6 = (int)cLImageInfoAccessor.getLong(4373);
        return new CLGLTexture2d<B>(cLContext, b, cLImageFormat, cLImageInfoAccessor, n, n3, n5, n6, l, n2, n4);
    }

    @Override
    public int getTextureTarget() {
        return this.target;
    }

    @Override
    public int getMipMapLevel() {
        return this.mipMapLevel;
    }

    @Override
    public CLMemory.GLObjectType getGLObjectType() {
        return CLMemory.GLObjectType.GL_OBJECT_TEXTURE2D;
    }
}

