/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl.util;

import com.jogamp.common.JogampRuntimeException;
import com.jogamp.opencl.CLDevice;
import com.jogamp.opencl.CLPlatform;
import com.jogamp.opencl.CLProperty;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CLUtil {
    public static String clString2JavaString(byte[] byArray, int n) {
        while (n > 0 && byArray[--n] == 0) {
        }
        return n == 0 ? "" : new String(byArray, 0, n + 1);
    }

    public static String clString2JavaString(ByteBuffer byteBuffer, int n) {
        if (n == 0) {
            return "";
        }
        byte[] byArray = new byte[n];
        byteBuffer.get(byArray).rewind();
        return CLUtil.clString2JavaString(byArray, n);
    }

    public static boolean clBoolean(int n) {
        return n == 1;
    }

    public static int clBoolean(boolean bl) {
        return bl ? 1 : 0;
    }

    public static Map<String, String> obtainPlatformProperties(CLPlatform cLPlatform) {
        return CLUtil.readCLProperties(cLPlatform);
    }

    public static Map<String, String> obtainDeviceProperties(CLDevice cLDevice) {
        return CLUtil.readCLProperties(cLDevice);
    }

    private static Map<String, String> readCLProperties(Object object) {
        try {
            return CLUtil.invoke(CLUtil.listMethods(object.getClass()), object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new JogampRuntimeException((Throwable)illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JogampRuntimeException((Throwable)illegalAccessException);
        }
    }

    static Map<String, String> invoke(List<Method> list, Object object) throws IllegalArgumentException, IllegalAccessException {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        for (Method method : list) {
            List<Number> list2 = null;
            try {
                list2 = method.invoke(object, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                list2 = invocationTargetException.getTargetException();
            }
            if (list2.getClass().isArray()) {
                list2 = CLUtil.asList(list2);
            }
            String string = method.getAnnotation(CLProperty.class).value();
            linkedHashMap.put(string, list2.toString());
        }
        return linkedHashMap;
    }

    static List<Method> listMethods(Class<?> clazz) throws SecurityException {
        ArrayList<Method> arrayList = new ArrayList<Method>();
        for (Method method : clazz.getDeclaredMethods()) {
            Annotation[] annotationArray;
            for (Annotation annotation : annotationArray = method.getDeclaredAnnotations()) {
                if (!(annotation instanceof CLProperty)) continue;
                arrayList.add(method);
            }
        }
        return arrayList;
    }

    private static List<Number> asList(Object object) {
        ArrayList<Number> arrayList;
        block5: {
            double[] dArray;
            block7: {
                float[] fArray;
                block6: {
                    long[] lArray;
                    block4: {
                        int[] nArray;
                        arrayList = new ArrayList<Number>();
                        if (!(object instanceof int[])) break block4;
                        for (int n : nArray = (int[])object) {
                            arrayList.add(n);
                        }
                        break block5;
                    }
                    if (!(object instanceof long[])) break block6;
                    for (long l : lArray = (long[])object) {
                        arrayList.add(l);
                    }
                    break block5;
                }
                if (!(object instanceof float[])) break block7;
                for (float f : fArray = (float[])object) {
                    arrayList.add(Float.valueOf(f));
                }
                break block5;
            }
            if (!(object instanceof double[])) break block5;
            for (double d : dArray = (double[])object) {
                arrayList.add(d);
            }
        }
        return arrayList;
    }
}

