/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.astar;

import edu.duke.cs.osprey.tools.JvmMem;
import edu.duke.cs.osprey.tools.Stopwatch;
import java.io.Serializable;

public class AStarProgress
implements Serializable {
    private static final long serialVersionUID = 767988861537797830L;
    private static final int ReportIntervalMs = 10000;
    private int numLevels;
    private int level;
    private int deepestLevel;
    private double gscore;
    private double hscore;
    private long numNodesExpanded;
    private long numNodesInQueue;
    private long numNodesQueuedThisReport;
    private Stopwatch stopwatch;
    private int msRunning;
    private int numLeafNodes;
    private double goalScore;

    public AStarProgress(int numLevels) {
        this.numLevels = numLevels;
        this.level = 0;
        this.deepestLevel = 0;
        this.gscore = Double.POSITIVE_INFINITY;
        this.hscore = Double.POSITIVE_INFINITY;
        this.numNodesInQueue = 0L;
        this.numNodesQueuedThisReport = 0L;
        this.stopwatch = new Stopwatch();
        this.msRunning = 0;
        this.numLeafNodes = 0;
    }

    public void reportInternalNode(int level, double gscore, double hscore, long numNodesInQueue, int numAddedToQueue) {
        int msRunning;
        ++this.numNodesExpanded;
        this.numNodesInQueue = numNodesInQueue;
        this.numNodesQueuedThisReport += (long)numAddedToQueue;
        if (this.numLeafNodes > 0) {
            return;
        }
        this.level = level;
        this.deepestLevel = Math.max(this.deepestLevel, this.level);
        this.gscore = gscore;
        this.hscore = hscore;
        if (!this.stopwatch.isRunning()) {
            this.stopwatch.start();
            this.msRunning = 0;
        }
        if ((msRunning = (int)this.stopwatch.getTimeMs()) >= this.msRunning + 10000) {
            this.printProgressReport();
            this.msRunning = msRunning;
            this.numNodesQueuedThisReport = 0L;
        }
    }

    public void printProgressReport() {
        System.out.println(this.makeProgressReport());
    }

    public String makeProgressReport() {
        double diffMs = this.stopwatch.getTimeMs() - (double)this.msRunning;
        return String.format("A* g:%10.4f, h:%10.4f, f:%10.4f, level:%4d/%4d/%4d, expanded:%10d, queued:%10d, scored/sec:%5d, time:%s, heapMem:%s", this.gscore, this.hscore, this.gscore + this.hscore, this.level, this.deepestLevel, this.numLevels - 1, this.numNodesExpanded, this.numNodesInQueue, (int)((double)(this.numNodesQueuedThisReport * 1000L) / diffMs), this.stopwatch.getTime(2), JvmMem.getOldPool());
    }

    public void setGoalScore(double val) {
        this.goalScore = val;
    }

    public void reportLeafNode(double gscore, long numNodesInQueue) {
        this.numNodesInQueue = numNodesInQueue;
        if (this.numLeafNodes == 0) {
            this.level = this.numLevels - 1;
            this.deepestLevel = this.numLevels - 1;
            this.gscore = gscore;
            this.hscore = 0.0;
            this.printProgressReport();
        }
        this.gscore = gscore;
        ++this.numLeafNodes;
        int msRunning = (int)this.stopwatch.getTimeMs();
        if (msRunning >= this.msRunning + 10000) {
            this.printLeafProgressReport();
            this.msRunning = msRunning;
            this.numNodesQueuedThisReport = 0L;
        }
    }

    protected void printLeafProgressReport() {
        System.out.println(this.makeLeafProgressReport());
    }

    protected String makeLeafProgressReport() {
        double diffMs = this.stopwatch.getTimeMs() - (double)this.msRunning;
        return String.format("A* leaf nodes:%10d, score:%14.8f, remaining:%14.8f, expanded:%10d, queued:%10d, scored/sec:%5d, time:%s, heapMem:%s", this.numLeafNodes, this.gscore, this.goalScore - this.gscore, this.numNodesExpanded, this.numNodesInQueue, (int)((double)(this.numNodesQueuedThisReport * 1000L) / diffMs), this.stopwatch.getTime(2), JvmMem.getOldPool());
    }
}

