/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.astar.comets;

import edu.duke.cs.osprey.astar.ConfTree;
import edu.duke.cs.osprey.astar.FullAStarNode;
import edu.duke.cs.osprey.pruning.PruningMatrix;
import java.util.ArrayList;
import java.util.PriorityQueue;

public class COMETSNode
extends FullAStarNode {
    PruningMatrix[] pruneMat;
    ConfTree<FullAStarNode>[] stateTrees = null;
    double[] stateUB = null;

    public COMETSNode(int[] nodeAssignments, PruningMatrix[] pruneMat) {
        super(nodeAssignments);
        this.pruneMat = pruneMat;
    }

    public COMETSNode(COMETSNode cn) {
        super(cn);
        this.pruneMat = cn.pruneMat;
        this.stateTrees = cn.stateTrees;
        this.stateUB = cn.stateUB;
    }

    void expandConfTree() {
        int firstSplittableLevel = Integer.MAX_VALUE;
        int stateToSplit = -1;
        for (int state = 0; state < this.stateTrees.length; ++state) {
            int stateFirstSplittableLevel;
            FullAStarNode curBestNode;
            ConfTree<FullAStarNode> stateTree = this.stateTrees[state];
            if (stateTree == null || (curBestNode = (FullAStarNode)stateTree.getQueue().peek()).isFullyDefined() || (stateFirstSplittableLevel = stateTree.nextLevelToExpand(curBestNode)) >= firstSplittableLevel) continue;
            stateToSplit = state;
            firstSplittableLevel = stateFirstSplittableLevel;
        }
        ConfTree<FullAStarNode> treeToSplit = this.stateTrees[stateToSplit];
        PriorityQueue expansion = treeToSplit.getQueue();
        FullAStarNode bestNode = (FullAStarNode)expansion.poll();
        ArrayList<FullAStarNode> children = treeToSplit.getChildren(bestNode);
        for (FullAStarNode child : children) {
            child.UB = Double.NaN;
            child.UBConf = bestNode.UBConf;
            expansion.add(child);
        }
    }
}

