/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.astar.conf;

import edu.duke.cs.osprey.astar.conf.ConfAStarNode;
import java.util.Arrays;

public class ConfIndex {
    public final int numPos;
    public ConfAStarNode node;
    public int numDefined;
    public final int[] definedPos;
    public final int[] definedRCs;
    public int numUndefined;
    public final int[] undefinedPos;

    public ConfIndex(int numPos) {
        this.numPos = numPos;
        this.node = null;
        this.numDefined = 0;
        this.definedPos = new int[numPos];
        this.definedRCs = new int[numPos];
        this.numUndefined = 0;
        this.undefinedPos = new int[numPos];
    }

    public ConfIndex(ConfIndex other) {
        this.numPos = other.numPos;
        this.numDefined = other.numDefined;
        this.definedPos = (int[])other.definedPos.clone();
        this.definedRCs = (int[])other.definedRCs.clone();
        this.numUndefined = other.numUndefined;
        this.undefinedPos = (int[])other.undefinedPos.clone();
        this.node = null;
    }

    public boolean isFullyDefined() {
        return this.numDefined == this.numPos;
    }

    public boolean isDefined(int pos) {
        return this.findDefined(pos) >= 0;
    }

    public int findDefined(int pos) {
        for (int i = 0; i < this.numDefined; ++i) {
            if (this.definedPos[i] != pos) continue;
            return i;
        }
        return -1;
    }

    public boolean isUndefined(int pos) {
        return this.findUndefined(pos) >= 0;
    }

    public int findUndefined(int pos) {
        for (int i = 0; i < this.numUndefined; ++i) {
            if (this.undefinedPos[i] != pos) continue;
            return i;
        }
        return -1;
    }

    public ConfIndex assign(int nextPos, int nextRc) {
        ConfIndex other = new ConfIndex(this);
        other.assignInPlace(nextPos, nextRc);
        other.node = null;
        return other;
    }

    public void assignInPlace(int pos, int rc) {
        int insertIndex = Arrays.binarySearch(this.definedPos, 0, this.numDefined, pos);
        if (insertIndex >= 0) {
            throw new IllegalArgumentException("pos " + pos + " already assigned");
        }
        insertIndex = -insertIndex - 1;
        for (int i = this.numDefined; i > insertIndex; --i) {
            this.definedPos[i] = this.definedPos[i - 1];
            this.definedRCs[i] = this.definedRCs[i - 1];
        }
        this.definedPos[insertIndex] = pos;
        this.definedRCs[insertIndex] = rc;
        ++this.numDefined;
        this.updateUndefined();
    }

    public ConfIndex unassign(int pos) {
        ConfIndex other = new ConfIndex(this);
        other.unassignInPlace(pos);
        other.node = null;
        return other;
    }

    public void unassignInPlace(int pos) {
        int removeIndex = Arrays.binarySearch(this.definedPos, 0, this.numDefined, pos);
        if (removeIndex < 0) {
            throw new IllegalArgumentException("pos " + pos + " not assigned");
        }
        --this.numDefined;
        for (int i = removeIndex; i < this.numDefined; ++i) {
            this.definedPos[i] = this.definedPos[i + 1];
            this.definedRCs[i] = this.definedRCs[i + 1];
        }
        this.updateUndefined();
    }

    public void sortDefined() {
        for (int i = 1; i < this.numDefined; ++i) {
            int tempPos = this.definedPos[i];
            int tempRT = this.definedRCs[i];
            for (int j = i; j >= 1 && tempPos < this.definedPos[j - 1]; --j) {
                this.definedPos[j] = this.definedPos[j - 1];
                this.definedRCs[j] = this.definedRCs[j - 1];
            }
            this.definedPos[j] = tempPos;
            this.definedRCs[j] = tempRT;
        }
    }

    public void updateUndefined() {
        this.numUndefined = 0;
        int i = 0;
        for (int pos = 0; pos < this.numPos; ++pos) {
            if (i < this.numDefined && pos == this.definedPos[i]) {
                ++i;
                continue;
            }
            this.undefinedPos[this.numUndefined++] = pos;
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        for (int i = 0; i < this.numDefined; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(this.definedPos[i]);
            buf.append('=');
            buf.append(this.definedRCs[i]);
        }
        buf.append(']');
        return buf.toString();
    }
}

