/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.astar.conf.pruning;

import edu.duke.cs.osprey.astar.conf.ConfAStarNode;
import edu.duke.cs.osprey.astar.conf.pruning.AStarPruner;
import edu.duke.cs.osprey.confspace.Sequence;
import edu.duke.cs.osprey.confspace.SimpleConfSpace;
import edu.duke.cs.osprey.tools.PrefixTreeSet;
import java.util.ArrayList;
import java.util.List;

public class AStarSequencePruner
implements AStarPruner {
    public final SimpleConfSpace confSpace;
    private PrefixTreeSet<String> prunedSequences = new PrefixTreeSet();
    private List<String> sequence = null;
    private int[] assignments = null;

    public AStarSequencePruner(SimpleConfSpace confSpace) {
        this.confSpace = confSpace;
        int n = confSpace.positions.size();
        this.sequence = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            this.sequence.add(null);
        }
        this.assignments = new int[n];
    }

    public void add(Sequence sequence) {
        for (SimpleConfSpace.Position pos : this.confSpace.positions) {
            this.sequence.set(pos.index, sequence.get((String)pos.resNum).name);
        }
        this.prunedSequences.add(this.sequence);
    }

    @Override
    public boolean isPruned(ConfAStarNode node) {
        node.getConf(this.assignments);
        return this.isPruned();
    }

    @Override
    public boolean isPruned(ConfAStarNode node, int nextPos, int nextRc) {
        node.getConf(this.assignments);
        this.assignments[nextPos] = nextRc;
        return this.isPruned();
    }

    private boolean isPruned() {
        for (SimpleConfSpace.Position pos : this.confSpace.positions) {
            int rc = this.assignments[pos.index];
            if (rc == -1) {
                this.sequence.set(pos.index, null);
                continue;
            }
            this.sequence.set(pos.index, pos.resConfs.get((int)rc).template.name);
        }
        return this.prunedSequences.contains(this.sequence);
    }
}

