/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.astar.conf.scoring;

import edu.duke.cs.osprey.astar.conf.ConfIndex;
import edu.duke.cs.osprey.astar.conf.RCs;
import edu.duke.cs.osprey.astar.conf.scoring.AStarScorer;
import edu.duke.cs.osprey.ematrix.EnergyMatrix;
import edu.duke.cs.osprey.tools.MathTools;

public class PairwiseGScorer
implements AStarScorer {
    public final EnergyMatrix emat;
    public final MathTools.Optimizer optimizer;

    public PairwiseGScorer(EnergyMatrix emat) {
        this(emat, MathTools.Optimizer.Minimize);
    }

    public PairwiseGScorer(EnergyMatrix emat, MathTools.Optimizer optimizer) {
        this.emat = emat;
        this.optimizer = optimizer;
    }

    @Override
    public PairwiseGScorer make() {
        return new PairwiseGScorer(this.emat, this.optimizer);
    }

    @Override
    public double calc(ConfIndex confIndex, RCs rcs) {
        int rc1;
        int pos1;
        int i;
        double gscore = this.emat.getConstTerm();
        for (i = 0; i < confIndex.numDefined; ++i) {
            pos1 = confIndex.definedPos[i];
            rc1 = confIndex.definedRCs[i];
            gscore += this.emat.getOneBody(pos1, rc1).doubleValue();
        }
        for (i = 0; i < confIndex.numDefined; ++i) {
            pos1 = confIndex.definedPos[i];
            rc1 = confIndex.definedRCs[i];
            for (int j = 0; j < i; ++j) {
                int pos2 = confIndex.definedPos[j];
                int rc2 = confIndex.definedRCs[j];
                gscore += this.emat.getPairwise(pos1, rc1, pos2, rc2).doubleValue();
            }
        }
        return gscore;
    }

    @Override
    public double calcDifferential(ConfIndex confIndex, RCs rcs, int nextPos, int nextRc) {
        double gscore = confIndex.node.getGScore(this.optimizer);
        gscore += this.emat.getOneBody(nextPos, nextRc).doubleValue();
        for (int i = 0; i < confIndex.numDefined; ++i) {
            int pos = confIndex.definedPos[i];
            int rc = confIndex.definedRCs[i];
            gscore += this.emat.getPairwise(pos, rc, nextPos, nextRc).doubleValue();
        }
        return gscore;
    }
}

