/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.astar.conf.scoring.mplp;

import edu.duke.cs.osprey.astar.conf.ConfIndex;
import edu.duke.cs.osprey.astar.conf.RCs;
import edu.duke.cs.osprey.astar.conf.scoring.mplp.MPLPUpdater;
import edu.duke.cs.osprey.astar.conf.scoring.mplp.MessageVars;
import edu.duke.cs.osprey.ematrix.EnergyMatrix;

public class EdgeUpdater
implements MPLPUpdater {
    @Override
    public void update(MessageVars lambdas, EnergyMatrix emat) {
        ConfIndex confIndex = lambdas.getConfIndex();
        for (int posi1 = 0; posi1 < confIndex.numUndefined; ++posi1) {
            int pos1 = confIndex.undefinedPos[posi1];
            for (int posi2 = 0; posi2 < confIndex.numUndefined; ++posi2) {
                int pos2 = confIndex.undefinedPos[posi2];
                if (pos2 >= pos1) continue;
                this.update(lambdas, emat, posi1, posi2);
                this.update(lambdas, emat, posi2, posi1);
            }
        }
    }

    private void update(MessageVars lambdas, EnergyMatrix emat, int posi1, int posi2) {
        RCs rcs = lambdas.getRCs();
        ConfIndex confIndex = lambdas.getConfIndex();
        int pos1 = confIndex.undefinedPos[posi1];
        int pos2 = confIndex.undefinedPos[posi2];
        for (int rci1 = 0; rci1 < rcs.getNum(pos1); ++rci1) {
            int rc1 = rcs.get(pos1, rci1);
            double minEnergy = Double.POSITIVE_INFINITY;
            for (int rci2 = 0; rci2 < rcs.getNum(pos2); ++rci2) {
                int rc2 = rcs.get(pos2, rci2);
                double energy = lambdas.getEnergyWithout(posi2, rci2, posi1) + emat.getPairwise(pos1, rc1, pos2, rc2);
                minEnergy = Math.min(minEnergy, energy);
            }
            double energyWithout = lambdas.getEnergyWithout(posi1, rci1, posi2);
            minEnergy = Double.isFinite(energyWithout) ? (minEnergy - energyWithout) / 2.0 : Double.POSITIVE_INFINITY;
            lambdas.set(posi2, posi1, rci1, minEnergy);
        }
    }
}

