/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.astar.seq;

import edu.duke.cs.osprey.Queue;
import edu.duke.cs.osprey.astar.seq.RTs;
import edu.duke.cs.osprey.astar.seq.nodes.LinkedSeqAStarNode;
import edu.duke.cs.osprey.astar.seq.nodes.SeqAStarNode;
import edu.duke.cs.osprey.astar.seq.order.SeqAStarOrder;
import edu.duke.cs.osprey.astar.seq.scoring.SeqAStarScorer;
import edu.duke.cs.osprey.ewakstar.EwakstarLimitedSequenceTrie;
import edu.duke.cs.osprey.tools.MathTools;
import java.math.BigInteger;

public class SeqAStarTree {
    public final RTs rts;
    public final MathTools.Optimizer optimizer;
    public final Queue<SeqAStarNode> queue;
    public final SeqAStarNode rootNode;
    public final SeqAStarOrder order;
    public final SeqAStarScorer gscorer;
    public final SeqAStarScorer hscorer;
    public final int numMutable;
    public final String mutableType;
    public final EwakstarLimitedSequenceTrie elst;
    private SeqAStarNode trivialRootNode = null;
    private SeqAStarNode.Assignments assignments;

    private SeqAStarTree(RTs rts, MathTools.Optimizer optimizer, Queue<SeqAStarNode> queue, SeqAStarNode rootNode, SeqAStarOrder order, SeqAStarScorer gscorer, SeqAStarScorer hscorer, String mutableType, int numMutable, EwakstarLimitedSequenceTrie elst) {
        this.rts = rts;
        this.optimizer = optimizer;
        this.queue = queue;
        this.rootNode = rootNode;
        this.order = order;
        this.gscorer = gscorer;
        this.hscorer = hscorer;
        this.mutableType = mutableType;
        this.numMutable = numMutable;
        this.elst = elst;
        this.assignments = new SeqAStarNode.Assignments(rts.numPos);
    }

    public BigInteger getNumSequences() {
        return this.rts.getNumSequences();
    }

    public void add(SeqAStarNode node) {
        this.queue.push(node);
    }

    public SeqAStarNode nextLeafNode() {
        SeqAStarNode node;
        if (this.trivialRootNode == null) {
            node = this.trivialRootNode = this.rootNode;
            for (int pos = 0; pos < this.rts.numPos; ++pos) {
                if (this.rts.numTypesAt(pos) != 1) continue;
                node = node.assign(pos, this.rts.indicesAt(pos)[0]);
            }
            assert (node.getLevel() == this.rts.getNumTrivialPos());
            node.getAssignments(this.assignments);
            node.setGScore(this.gscorer.calc(this.assignments), this.optimizer);
            node.setHScore(this.hscorer.calc(this.assignments), this.optimizer);
            this.queue.push(node);
        }
        block1: while (!this.queue.isEmpty()) {
            boolean moreMutationsAllowed;
            String seq;
            node = this.queue.poll();
            node.getAssignments(this.assignments);
            boolean keepSeq = true;
            if (this.elst != null && node.getLevel() != 0 && !this.elst.containsSeq(seq = node.makeSequence(this.elst.seqSpace).toString())) {
                keepSeq = false;
            }
            if (!keepSeq) continue;
            if (this.mutableType.equals("exact") && node.getLevel() == this.rts.numPos) {
                if (this.rts.getNumMutations(this.assignments) != this.numMutable && this.rts.getNumMutations(this.assignments) != 0) continue;
                return node;
            }
            if (node.getLevel() == this.rts.numPos) {
                return node;
            }
            int nextPos = this.order.getNextPos(this.assignments, this.rts);
            boolean bl = moreMutationsAllowed = this.rts.getNumMutations(this.assignments) < this.numMutable;
            if (moreMutationsAllowed) {
                int[] nArray = this.rts.indicesAt(nextPos);
                int n = nArray.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) continue block1;
                    int nextRt = nArray[n2];
                    this.addChild(node, nextPos, nextRt);
                    ++n2;
                }
            }
            this.addChild(node, nextPos, this.rts.wildTypeAt(nextPos));
        }
        return null;
    }

    private SeqAStarNode addChild(SeqAStarNode node, int nextPos, int nextRt) {
        node.getAssignments(this.assignments);
        double gscore = this.gscorer.calcDifferential(this.assignments, nextPos, nextRt);
        double hscore = this.hscorer.calcDifferential(this.assignments, nextPos, nextRt);
        if (Double.isInfinite(gscore) || Double.isInfinite(hscore)) {
            return null;
        }
        SeqAStarNode child = node.assign(nextPos, nextRt);
        child.setGScore(gscore, this.optimizer);
        child.setHScore(hscore, this.optimizer);
        this.queue.push(child);
        return child;
    }

    public static class Builder {
        private final RTs rts;
        private MathTools.Optimizer optimizer = MathTools.Optimizer.Minimize;
        private SeqAStarOrder order;
        private SeqAStarScorer gscorer;
        private SeqAStarScorer hscorer;
        private int numMutable;
        private String mutableType = "max";
        private EwakstarLimitedSequenceTrie elst = null;

        public Builder(RTs rts) {
            this.rts = rts;
        }

        public Builder setSeqTrie(EwakstarLimitedSequenceTrie obj) {
            this.elst = obj;
            return this;
        }

        public Builder setMutableType(String type) {
            this.mutableType = type;
            return this;
        }

        public Builder setOptimizer(MathTools.Optimizer val) {
            this.optimizer = val;
            return this;
        }

        public Builder setHeuristics(SeqAStarOrder order, SeqAStarScorer gscorer, SeqAStarScorer hscorer) {
            this.order = order;
            this.gscorer = gscorer;
            this.hscorer = hscorer;
            return this;
        }

        public Builder setNumMutable(int val) {
            this.numMutable = val;
            return this;
        }

        public SeqAStarTree build() {
            Queue<SeqAStarNode> queue = Queue.PriorityFactory.of(null, new SeqAStarNode[0]);
            LinkedSeqAStarNode rootNode = new LinkedSeqAStarNode();
            if (this.order == null) {
                throw new IllegalArgumentException("no order heuristic set");
            }
            if (this.gscorer == null) {
                throw new IllegalArgumentException("no g-score heuristic set");
            }
            if (this.hscorer == null) {
                throw new IllegalArgumentException("no h-score heuristic set");
            }
            return new SeqAStarTree(this.rts, this.optimizer, queue, rootNode, this.order, this.gscorer, this.hscorer, this.mutableType, this.numMutable, this.elst);
        }
    }
}

