/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.bbfree;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.colt.matrix.linalg.SingularValueDecomposition;
import edu.duke.cs.osprey.bbfree.BBFreeDOF;
import edu.duke.cs.osprey.bbfree.PepPlaneLinModel;
import edu.duke.cs.osprey.bbfree.VoxelSeriesChecker;
import edu.duke.cs.osprey.control.EnvironmentVars;
import edu.duke.cs.osprey.dof.DOFBlock;
import edu.duke.cs.osprey.dof.DegreeOfFreedom;
import edu.duke.cs.osprey.dof.deeper.GenChi1Calc;
import edu.duke.cs.osprey.dof.deeper.SidechainIdealizer;
import edu.duke.cs.osprey.ematrix.epic.SeriesFitter;
import edu.duke.cs.osprey.structure.Molecule;
import edu.duke.cs.osprey.structure.Residue;
import edu.duke.cs.osprey.tools.RigidBodyMotion;
import edu.duke.cs.osprey.tools.RotationMatrix;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;

public class BBFreeBlock
implements Serializable,
DOFBlock {
    List<Residue> residues;
    ArrayList<BBFreeDOF> freeDOFs = new ArrayList();
    double[][] freeDOFVoxel;
    double[] curFreeDOFVals;
    double[] fullDOFCenter;
    DoubleMatrix1D freeDOFCenter;
    double[][] fullDOFPolys;
    PepPlaneLinModel[] pepPlanes;
    DoubleMatrix2D freeDOFMatrix;
    static int polyOrder = 2;
    ArrayList<ArrayList<JacDerivEntry>> jacDerivs;
    double[][] deriv1;
    double[][][] wderiv2;
    double[][][] deriv2;
    double[][][][] wderiv3;
    double[][][][] deriv3;
    double[][][][][] wderiv4;
    double[][][][][] deriv4;

    public BBFreeBlock() {
    }

    public BBFreeBlock(List<Residue> residues) {
        this.residues = residues;
        int numRes = residues.size();
        int numFreeDOFs = 2 * numRes - 6;
        this.pepPlanes = new PepPlaneLinModel[numRes - 1];
        for (int planeNum = 0; planeNum < numRes - 1; ++planeNum) {
            this.pepPlanes[planeNum] = new PepPlaneLinModel(residues.get(planeNum), residues.get(planeNum + 1));
        }
        DoubleMatrix2D constrJac = this.getConstrJac();
        DoubleMatrix2D freeDOFCoeffs = this.getOrthogVectors(constrJac);
        this.freeDOFMatrix = Algebra.DEFAULT.transpose(freeDOFCoeffs);
        for (int freeDOF = 0; freeDOF < numFreeDOFs; ++freeDOF) {
            this.freeDOFs.add(new BBFreeDOF(freeDOFCoeffs.viewColumn(freeDOF), this, this.freeDOFs.size()));
        }
        this.fullDOFCenter = new double[6 * numRes - 9];
        for (int resNum = 1; resNum < numRes; ++resNum) {
            Residue curRes = residues.get(resNum);
            System.arraycopy(curRes.getCoordsByAtomName("N"), 0, this.fullDOFCenter, 6 * (resNum - 1), 3);
            if (resNum >= numRes - 1) continue;
            System.arraycopy(curRes.getCoordsByAtomName("CA"), 0, this.fullDOFCenter, 6 * resNum - 3, 3);
        }
        this.freeDOFCenter = DoubleFactory1D.dense.make(numFreeDOFs);
        for (int f = 0; f < numFreeDOFs; ++f) {
            this.freeDOFCenter.set(f, this.freeDOFs.get(f).evalAtFullDOFs(DoubleFactory1D.dense.make(this.fullDOFCenter)));
        }
        DoubleMatrix2D J = DoubleFactory2D.dense.compose((DoubleMatrix2D[][])new DoubleMatrix2D[][]{{Algebra.DEFAULT.transpose(freeDOFCoeffs)}, {constrJac}});
        this.makeTaylorSeries(J);
        this.setVoxelBySeries();
        this.curFreeDOFVals = new double[numFreeDOFs];
    }

    private void setVoxelBySeries() {
        int numRes = this.residues.size();
        int numFreeDOFs = 2 * numRes - 6;
        int numFullDOFs = 6 * numRes - 9;
        this.freeDOFVoxel = new double[2][numFreeDOFs];
        Arrays.fill(this.freeDOFVoxel[0], -1.0);
        Arrays.fill(this.freeDOFVoxel[1], 1.0);
        double sizeStepFactor = 1.3;
        double targetResid = 1.0E-4;
        VoxelSeriesChecker vsc = new VoxelSeriesChecker(this.residues, numFreeDOFs, numFullDOFs, this.fullDOFPolys, this.pepPlanes, this.freeDOFMatrix, this.freeDOFCenter);
        double resid = vsc.getConstraintsResid(this.freeDOFVoxel);
        System.out.println("Init voxel resid: " + resid);
        while (resid > targetResid) {
            for (int a = 0; a < 2; ++a) {
                int f = 0;
                while (f < numFreeDOFs) {
                    double[] dArray = this.freeDOFVoxel[a];
                    int n = f++;
                    dArray[n] = dArray[n] / sizeStepFactor;
                }
            }
            resid = vsc.getConstraintsResid(this.freeDOFVoxel);
            System.out.println("Voxel reduced resid: " + resid);
        }
    }

    private void allocateDerivs(int numFullDOFs, int numFreeDOFs) {
        this.deriv1 = new double[numFullDOFs][numFullDOFs];
        this.wderiv2 = new double[numFullDOFs][numFullDOFs][numFullDOFs];
        this.deriv2 = new double[numFullDOFs][numFullDOFs][numFreeDOFs];
        this.wderiv3 = new double[numFullDOFs][numFullDOFs][numFullDOFs][numFreeDOFs];
        this.deriv3 = new double[numFullDOFs][numFullDOFs][numFreeDOFs][numFreeDOFs];
        this.wderiv4 = new double[numFullDOFs][numFullDOFs][numFullDOFs][numFreeDOFs][numFreeDOFs];
        this.deriv4 = new double[numFullDOFs][numFullDOFs][numFreeDOFs][numFreeDOFs][numFreeDOFs];
    }

    private void calcDerivs(int numFullDOFs, int numFreeDOFs, DoubleMatrix2D Jinv) {
        int l;
        int j;
        int i;
        this.allocateDerivs(numFullDOFs, numFreeDOFs);
        for (i = 0; i < numFullDOFs; ++i) {
            for (j = 0; j < numFullDOFs; ++j) {
                this.deriv1[i][j] = Jinv.get(i, j);
            }
        }
        for (i = 0; i < numFullDOFs; ++i) {
            for (j = 0; j < numFullDOFs; ++j) {
                for (int w = 0; w < numFullDOFs; ++w) {
                    this.wderiv2[i][j][w] = 0.0;
                    for (JacDerivEntry jde : this.jacDerivs.get(w)) {
                        double[] dArray = this.wderiv2[i][j];
                        int n = w;
                        dArray[n] = dArray[n] - jde.val * this.deriv1[i][jde.u] * this.deriv1[jde.v][j];
                    }
                }
                for (int k = 0; k < numFreeDOFs; ++k) {
                    this.deriv2[i][j][k] = 0.0;
                    for (int w = 0; w < numFullDOFs; ++w) {
                        double[] dArray = this.deriv2[i][j];
                        int n = k;
                        dArray[n] = dArray[n] + this.wderiv2[i][j][w] * this.deriv1[w][k];
                    }
                }
            }
        }
        if (polyOrder >= 3) {
            for (i = 0; i < numFullDOFs; ++i) {
                for (j = 0; j < numFullDOFs; ++j) {
                    for (l = 0; l < numFreeDOFs; ++l) {
                        for (int w = 0; w < numFullDOFs; ++w) {
                            this.wderiv3[i][j][w][l] = 0.0;
                            for (JacDerivEntry jde : this.jacDerivs.get(w)) {
                                double[] dArray = this.wderiv3[i][j][w];
                                int n = l;
                                dArray[n] = dArray[n] - jde.val * this.deriv2[i][jde.u][l] * this.deriv1[jde.v][j];
                                double[] dArray2 = this.wderiv3[i][j][w];
                                int n2 = l;
                                dArray2[n2] = dArray2[n2] - jde.val * this.deriv1[i][jde.u] * this.deriv2[jde.v][j][l];
                            }
                        }
                        for (int k = 0; k < numFreeDOFs; ++k) {
                            this.deriv3[i][j][k][l] = 0.0;
                            for (int w = 0; w < numFullDOFs; ++w) {
                                double[] dArray = this.deriv3[i][j][k];
                                int n = l;
                                dArray[n] = dArray[n] + this.wderiv3[i][j][w][l] * this.deriv1[w][k];
                                double[] dArray3 = this.deriv3[i][j][k];
                                int n3 = l;
                                dArray3[n3] = dArray3[n3] + this.wderiv2[i][j][w] * this.deriv2[w][k][l];
                            }
                        }
                    }
                }
            }
        }
        if (polyOrder >= 4) {
            for (i = 0; i < numFullDOFs; ++i) {
                for (j = 0; j < numFullDOFs; ++j) {
                    for (l = 0; l < numFreeDOFs; ++l) {
                        for (int m = 0; m < numFreeDOFs; ++m) {
                            for (int w = 0; w < numFullDOFs; ++w) {
                                this.wderiv4[i][j][w][l][m] = 0.0;
                                for (JacDerivEntry jde : this.jacDerivs.get(w)) {
                                    double[] dArray = this.wderiv4[i][j][w][l];
                                    int n = m;
                                    dArray[n] = dArray[n] - jde.val * this.deriv3[i][jde.u][l][m] * this.deriv1[jde.v][j];
                                    double[] dArray4 = this.wderiv4[i][j][w][l];
                                    int n4 = m;
                                    dArray4[n4] = dArray4[n4] - jde.val * this.deriv2[i][jde.u][l] * this.deriv2[jde.v][j][m];
                                    double[] dArray5 = this.wderiv4[i][j][w][l];
                                    int n5 = m;
                                    dArray5[n5] = dArray5[n5] - jde.val * this.deriv2[i][jde.u][m] * this.deriv2[jde.v][j][l];
                                    double[] dArray6 = this.wderiv4[i][j][w][l];
                                    int n6 = m;
                                    dArray6[n6] = dArray6[n6] - jde.val * this.deriv1[i][jde.u] * this.deriv3[jde.v][j][l][m];
                                }
                            }
                            for (int k = 0; k < numFreeDOFs; ++k) {
                                this.deriv4[i][j][k][l][m] = 0.0;
                                for (int w = 0; w < numFullDOFs; ++w) {
                                    double[] dArray = this.deriv4[i][j][k][l];
                                    int n = m;
                                    dArray[n] = dArray[n] + this.wderiv4[i][j][w][l][m] * this.deriv1[w][k];
                                    double[] dArray7 = this.deriv4[i][j][k][l];
                                    int n7 = m;
                                    dArray7[n7] = dArray7[n7] + this.wderiv3[i][j][w][l] * this.deriv2[w][k][m];
                                    double[] dArray8 = this.deriv4[i][j][k][l];
                                    int n8 = m;
                                    dArray8[n8] = dArray8[n8] + this.wderiv3[i][j][w][m] * this.deriv2[w][k][l];
                                    double[] dArray9 = this.deriv4[i][j][k][l];
                                    int n9 = m;
                                    dArray9[n9] = dArray9[n9] + this.wderiv2[i][j][w] * this.deriv3[w][k][l][m];
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private void makeTaylorSeries(DoubleMatrix2D J) {
        int numFullDOFs = 6 * this.residues.size() - 9;
        int numFreeDOFs = 2 * this.residues.size() - 6;
        int numParams = SeriesFitter.getNumParams(numFreeDOFs, true, polyOrder);
        DoubleMatrix2D Jinv = Algebra.DEFAULT.inverse(J);
        this.calcDerivs(numFullDOFs, numFreeDOFs, Jinv);
        this.fullDOFPolys = new double[numFullDOFs][];
        for (int fullDOF = 0; fullDOF < numFullDOFs; ++fullDOF) {
            int dof3;
            int dof2;
            int dof;
            double[] series = new double[numParams];
            series[0] = this.fullDOFCenter[fullDOF];
            for (int freeDOF = 0; freeDOF < numFreeDOFs; ++freeDOF) {
                series[freeDOF + 1] = this.deriv1[fullDOF][freeDOF];
            }
            int coeffCount = numFreeDOFs + 1;
            if (polyOrder >= 2) {
                for (dof = 0; dof < numFreeDOFs; ++dof) {
                    for (dof2 = 0; dof2 <= dof; ++dof2) {
                        series[coeffCount] = this.deriv2[fullDOF][dof][dof2] / (double)BBFreeBlock.multFacProd(dof, dof2);
                        ++coeffCount;
                    }
                }
            }
            if (polyOrder >= 3) {
                for (dof = 0; dof < numFreeDOFs; ++dof) {
                    for (dof2 = 0; dof2 <= dof; ++dof2) {
                        for (dof3 = 0; dof3 <= dof2; ++dof3) {
                            series[coeffCount] = this.deriv3[fullDOF][dof][dof2][dof3] / (double)BBFreeBlock.multFacProd(dof, dof2, dof3);
                            ++coeffCount;
                        }
                    }
                }
            }
            if (polyOrder >= 4) {
                for (dof = 0; dof < numFreeDOFs; ++dof) {
                    for (dof2 = 0; dof2 <= dof; ++dof2) {
                        for (dof3 = 0; dof3 <= dof2; ++dof3) {
                            for (int dof4 = 0; dof4 <= dof3; ++dof4) {
                                series[coeffCount] = this.deriv4[fullDOF][dof][dof2][dof3][dof4] / (double)BBFreeBlock.multFacProd(dof, dof2, dof3, dof4);
                                ++coeffCount;
                            }
                        }
                    }
                }
            }
            this.fullDOFPolys[fullDOF] = series;
        }
    }

    private static int multFacProd(int ... a) {
        int curFactor = 1;
        int ans = 1;
        for (int b = 0; b < a.length - 1; ++b) {
            curFactor = a[b] == a[b + 1] ? ++curFactor : 1;
            ans *= curFactor;
        }
        return ans;
    }

    @Override
    public DOFBlock copyForNewMolecule(Molecule mol, LinkedHashMap<DegreeOfFreedom, DegreeOfFreedom> copiedDOFMap) {
        BBFreeBlock copiedBlock = new BBFreeBlock();
        copiedBlock.residues = new ArrayList<Residue>();
        for (Residue res : this.residues) {
            Residue newMolRes = mol.getResByPDBResNumber(res.getPDBResNumber());
            copiedBlock.residues.add(newMolRes);
        }
        copiedBlock.freeDOFs = new ArrayList();
        for (BBFreeDOF dof : this.freeDOFs) {
            BBFreeDOF copiedDOF = new BBFreeDOF(dof.coeffs, copiedBlock, dof.indexInBlock);
            copiedDOFMap.put(dof, copiedDOF);
            copiedBlock.freeDOFs.add(copiedDOF);
        }
        copiedBlock.freeDOFVoxel = this.freeDOFVoxel;
        copiedBlock.curFreeDOFVals = (double[])this.curFreeDOFVals.clone();
        copiedBlock.fullDOFCenter = this.fullDOFCenter;
        copiedBlock.freeDOFCenter = this.freeDOFCenter;
        copiedBlock.fullDOFPolys = this.fullDOFPolys;
        copiedBlock.pepPlanes = this.pepPlanes;
        copiedBlock.freeDOFMatrix = this.freeDOFMatrix;
        copiedBlock.jacDerivs = this.jacDerivs;
        return copiedBlock;
    }

    private static double invMatrixDeriv(DoubleMatrix2D Minv, int i, int j, int u, int v) {
        return -Minv.get(i, u) * Minv.get(v, j);
    }

    private DoubleMatrix2D getOrthogVectors(DoubleMatrix2D M) {
        DoubleMatrix2D Maug = DoubleFactory2D.dense.make(M.columns(), M.columns());
        Maug.viewPart(0, 0, M.rows(), M.columns()).assign(M);
        SingularValueDecomposition svd = new SingularValueDecomposition(Maug);
        int numOrthVecs = M.columns() - M.rows();
        if (svd.rank() != M.rows()) {
            throw new RuntimeException("ERROR: Singularity in constr jac.  Rank: " + svd.rank());
        }
        DoubleMatrix2D orthVecs = svd.getV().viewPart(0, M.rows(), M.columns(), numOrthVecs);
        return orthVecs;
    }

    private DoubleMatrix2D getConstrJac() {
        int numRes = this.residues.size();
        int numFullDOFs = 6 * numRes - 9;
        int numFreeDOFs = 2 * numRes - 6;
        this.jacDerivs = new ArrayList();
        for (int f = 0; f < numFullDOFs; ++f) {
            this.jacDerivs.add(new ArrayList());
        }
        DoubleMatrix2D ans = DoubleFactory2D.dense.make(numFullDOFs - numFreeDOFs, numFullDOFs);
        int constrCount = 0;
        for (int resNum = 0; resNum < numRes; ++resNum) {
            Residue curRes = this.residues.get(resNum);
            double[] NCoord = curRes.getCoordsByAtomName("N");
            double[] CACoord = curRes.getCoordsByAtomName("CA");
            if (resNum > 0) {
                Residue prevRes = this.residues.get(resNum - 1);
                double[] prevCACoord = prevRes.getCoordsByAtomName("CA");
                this.makeDistConstrJac(ans, constrCount, NCoord, CACoord, 2 * (resNum - 1), 2 * resNum - 1);
                this.makeDistConstrJac(ans, ++constrCount, prevCACoord, CACoord, 2 * resNum - 3, 2 * resNum - 1);
                this.makeDistConstrJac(ans, ++constrCount, prevCACoord, NCoord, 2 * resNum - 3, 2 * (resNum - 1));
                ++constrCount;
            }
            if (resNum == numRes - 1) {
                double[] CCoord = curRes.getCoordsByAtomName("C");
                this.makeLastNCACCConstrJac(ans, constrCount, CACoord, CCoord, 2 * (resNum - 1));
            } else {
                Residue nextRes = this.residues.get(resNum + 1);
                double[] NCoordNext = nextRes.getCoordsByAtomName("N");
                double[] CACoordNext = nextRes.getCoordsByAtomName("CA");
                this.makeNCACCConstrJac(ans, constrCount, NCoord, CACoord, NCoordNext, CACoordNext, 2 * (resNum - 1), resNum);
            }
            ++constrCount;
        }
        return ans;
    }

    private void recordJacDeriv(int constrNum, int fullDOF1, int fullDOF2, double val) {
        int numFreeDOFs = 2 * this.residues.size() - 6;
        this.jacDerivs.get(fullDOF1).add(new JacDerivEntry(constrNum + numFreeDOFs, fullDOF2, val));
    }

    private void makeDistConstrJac(DoubleMatrix2D constrJac, int constrNum, double[] coord1, double[] coord2, int atomNum1, int atomNum2) {
        for (int dim = 0; dim < 3; ++dim) {
            if (atomNum1 >= 0 && 3 * atomNum1 < constrJac.columns()) {
                constrJac.set(constrNum, 3 * atomNum1 + dim, 2.0 * coord1[dim] - 2.0 * coord2[dim]);
                this.recordJacDeriv(constrNum, 3 * atomNum1 + dim, 3 * atomNum1 + dim, 2.0);
                if (atomNum2 >= 0 && 3 * atomNum2 < constrJac.columns()) {
                    this.recordJacDeriv(constrNum, 3 * atomNum1 + dim, 3 * atomNum2 + dim, -2.0);
                }
            }
            if (atomNum2 < 0 || 3 * atomNum2 >= constrJac.columns()) continue;
            constrJac.set(constrNum, 3 * atomNum2 + dim, 2.0 * coord2[dim] - 2.0 * coord1[dim]);
            this.recordJacDeriv(constrNum, 3 * atomNum2 + dim, 3 * atomNum2 + dim, 2.0);
            if (atomNum1 < 0 || 3 * atomNum1 >= constrJac.columns()) continue;
            this.recordJacDeriv(constrNum, 3 * atomNum2 + dim, 3 * atomNum1 + dim, -2.0);
        }
    }

    private void makeNCACCConstrJac(DoubleMatrix2D constrJac, int constrNum, double[] NCoord, double[] CACoord, double[] NCoordNext, double[] CACoordNext, int atomNumN, int pepPlaneNum) {
        double[] expansionCoeffs = this.pepPlanes[pepPlaneNum].getProjCAtomCoeffs();
        double a = expansionCoeffs[0];
        double b = expansionCoeffs[1];
        double c = expansionCoeffs[2];
        for (int dim = 0; dim < 3; ++dim) {
            if (atomNumN >= 0) {
                double NGrad = (a - 1.0) * CACoord[dim] + b * NCoordNext[dim] + c * CACoordNext[dim];
                double CAGrad = (a - 1.0) * NCoord[dim] + 2.0 * (1.0 - a) * CACoord[dim] - b * NCoordNext[dim] - c * CACoordNext[dim];
                constrJac.set(constrNum, 3 * atomNumN + dim, NGrad);
                constrJac.set(constrNum, 3 * atomNumN + 3 + dim, CAGrad);
                this.recordJacDeriv(constrNum, 3 * atomNumN + dim, 3 * atomNumN + 3 + dim, a - 1.0);
                this.recordJacDeriv(constrNum, 3 * atomNumN + dim, 3 * atomNumN + 6 + dim, b);
                if (3 * atomNumN + 9 < constrJac.columns()) {
                    this.recordJacDeriv(constrNum, 3 * atomNumN + dim, 3 * atomNumN + 9 + dim, c);
                }
                this.recordJacDeriv(constrNum, 3 * atomNumN + 3 + dim, 3 * atomNumN + dim, a - 1.0);
                this.recordJacDeriv(constrNum, 3 * atomNumN + 3 + dim, 3 * atomNumN + 3 + dim, 2.0 * (1.0 - a));
                this.recordJacDeriv(constrNum, 3 * atomNumN + 3 + dim, 3 * atomNumN + 6 + dim, -b);
                if (3 * atomNumN + 9 < constrJac.columns()) {
                    this.recordJacDeriv(constrNum, 3 * atomNumN + 3 + dim, 3 * atomNumN + 9 + dim, -c);
                }
            }
            constrJac.set(constrNum, 3 * atomNumN + 6 + dim, b * NCoord[dim] - b * CACoord[dim]);
            if (atomNumN >= 0) {
                this.recordJacDeriv(constrNum, 3 * atomNumN + 6 + dim, 3 * atomNumN + dim, b);
                this.recordJacDeriv(constrNum, 3 * atomNumN + 6 + dim, 3 * atomNumN + 3 + dim, -b);
            }
            if (3 * atomNumN + 9 >= constrJac.columns()) continue;
            constrJac.set(constrNum, 3 * atomNumN + 9 + dim, c * NCoord[dim] - c * CACoord[dim]);
            if (atomNumN < 0) continue;
            this.recordJacDeriv(constrNum, 3 * atomNumN + 9 + dim, 3 * atomNumN + dim, c);
            this.recordJacDeriv(constrNum, 3 * atomNumN + 9 + dim, 3 * atomNumN + 3 + dim, -c);
        }
    }

    private void makeLastNCACCConstrJac(DoubleMatrix2D constrJac, int constrNum, double[] CACoord, double[] CCoord, int atomNumN) {
        for (int dim = 0; dim < 3; ++dim) {
            constrJac.set(constrNum, 3 * atomNumN + dim, CCoord[dim] - CACoord[dim]);
        }
    }

    public void setDOFs(DoubleMatrix1D x) {
        int resNum;
        int numRes = this.residues.size();
        int numDOFsFull = this.fullDOFPolys.length;
        double[] fullDOFVals = new double[this.fullDOFPolys.length];
        for (int fullDOF = 0; fullDOF < numDOFsFull; ++fullDOF) {
            fullDOFVals[fullDOF] = SeriesFitter.evalSeries(this.fullDOFPolys[fullDOF], x, x.size(), true, polyOrder);
        }
        double[] genChi1 = new double[numRes];
        double[][] SCTranslations = new double[numRes][3];
        for (resNum = 0; resNum < numRes; ++resNum) {
            Residue curRes = this.residues.get(resNum);
            if (resNum > 0 && resNum < numRes - 1) {
                double[] curCACoords = curRes.getCoordsByAtomName("CA");
                for (int dim = 0; dim < 3; ++dim) {
                    SCTranslations[resNum][dim] = fullDOFVals[6 * (resNum - 1) + 3 + dim] - curCACoords[dim];
                }
            }
            genChi1[resNum] = GenChi1Calc.getGenChi1(curRes);
            if (resNum <= 0) continue;
            int CAIndex = curRes.getAtomIndexByName("CA");
            int NIndex = curRes.getAtomIndexByName("N");
            for (int dim = 0; dim < 3; ++dim) {
                if (resNum < numRes - 1) {
                    curRes.coords[3 * CAIndex + dim] = fullDOFVals[6 * (resNum - 1) + 3 + dim];
                }
                curRes.coords[3 * NIndex + dim] = fullDOFVals[6 * (resNum - 1) + dim];
            }
        }
        for (int pepPlaneNum = 0; pepPlaneNum < numRes - 1; ++pepPlaneNum) {
            Residue res1 = this.residues.get(pepPlaneNum);
            Residue res2 = this.residues.get(pepPlaneNum + 1);
            double[] CA1 = res1.getCoordsByAtomName("CA");
            double[] N = res2.getCoordsByAtomName("N");
            double[] CA2 = res2.getCoordsByAtomName("CA");
            res1.setCoordsByAtomName("C", this.pepPlanes[pepPlaneNum].calcCCoords(CA1, N, CA2, false));
            res1.setCoordsByAtomName("O", this.pepPlanes[pepPlaneNum].calcOCoords(CA1, N, CA2));
            res2.setCoordsByAtomName("H", this.pepPlanes[pepPlaneNum].calcHCoords(CA1, N, CA2));
        }
        for (resNum = 0; resNum < numRes; ++resNum) {
            RigidBodyMotion motion = new RigidBodyMotion(new double[3], RotationMatrix.identity(), SCTranslations[resNum]);
            SidechainIdealizer.moveSidechain(this.residues.get(resNum), motion);
            SidechainIdealizer.idealizeSidechain(EnvironmentVars.resTemplates, this.residues.get(resNum));
            GenChi1Calc.setGenChi1(this.residues.get(resNum), genChi1[resNum]);
        }
        this.curFreeDOFVals = x.toArray();
    }

    public ArrayList<BBFreeDOF> getDOFs() {
        return this.freeDOFs;
    }

    public double[][] getFreeDOFVoxel() {
        return this.freeDOFVoxel;
    }

    public List<Residue> getResidues() {
        return this.residues;
    }

    private class JacDerivEntry
    implements Serializable {
        int u;
        int v;
        double val;

        public JacDerivEntry(int u, int v, double val) {
            this.u = u;
            this.v = v;
            this.val = val;
        }
    }
}

