/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.confspace;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleMatrix1D;
import edu.duke.cs.osprey.bbfree.BBFreeBlock;
import edu.duke.cs.osprey.confspace.PositionConfSpace;
import edu.duke.cs.osprey.confspace.RCTuple;
import edu.duke.cs.osprey.confspace.Strand;
import edu.duke.cs.osprey.control.EnvironmentVars;
import edu.duke.cs.osprey.dof.DegreeOfFreedom;
import edu.duke.cs.osprey.dof.FreeDihedral;
import edu.duke.cs.osprey.dof.MoveableStrand;
import edu.duke.cs.osprey.dof.ProlinePucker;
import edu.duke.cs.osprey.dof.ResidueTypeDOF;
import edu.duke.cs.osprey.dof.StrandRotation;
import edu.duke.cs.osprey.dof.StrandTranslation;
import edu.duke.cs.osprey.dof.deeper.DEEPerSettings;
import edu.duke.cs.osprey.dof.deeper.perts.Perturbation;
import edu.duke.cs.osprey.energy.EnergyFunction;
import edu.duke.cs.osprey.energy.MultiTermEnergyFunction;
import edu.duke.cs.osprey.minimization.CCDMinimizer;
import edu.duke.cs.osprey.minimization.MoleculeModifierAndScorer;
import edu.duke.cs.osprey.multistatekstar.ResidueTermini;
import edu.duke.cs.osprey.restypes.HardCodedResidueInfo;
import edu.duke.cs.osprey.restypes.ResidueTemplate;
import edu.duke.cs.osprey.structure.Molecule;
import edu.duke.cs.osprey.structure.PDBIO;
import edu.duke.cs.osprey.structure.Residue;
import edu.duke.cs.osprey.tools.StringParsing;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;

public class ConfSpace
implements Serializable {
    private static final long serialVersionUID = 6414329117813457771L;
    public Molecule m;
    public ArrayList<DegreeOfFreedom> confDOFs = new ArrayList();
    public ArrayList<ResidueTypeDOF> mutDOFs = new ArrayList();
    public ArrayList<PositionConfSpace> posFlex = new ArrayList();
    public ArrayList<String> flexibleRes;
    public int numPos;
    public boolean useEllipses = false;

    public ConfSpace(String PDBFile, ArrayList<String> flexibleRes, ArrayList<ArrayList<String>> allowedAAs, boolean addWT, ArrayList<String> wtRotOnlyRes, boolean contSCFlex, DEEPerSettings dset, ArrayList<String[]> moveableStrands, ArrayList<String[]> freeBBZones, boolean ellipses, boolean addWTRots, ResidueTermini termini) {
        this.useEllipses = ellipses;
        this.flexibleRes = flexibleRes;
        this.numPos = flexibleRes.size();
        this.m = new Strand.Builder((Molecule)PDBIO.readFile((String)PDBFile)).setResidues((ResidueTermini)termini).build().mol;
        ArrayList<Object> wtRots = new ArrayList<Object>(Collections.nCopies(this.numPos, null));
        if (addWTRots) {
            for (int i = 0; i < this.numPos; ++i) {
                Residue res = this.m.getResByPDBResNumber(flexibleRes.get(i));
                wtRots.set(i, ResidueTemplate.makeFromResidueConfs(res));
            }
        }
        this.makeRingPuckers(allowedAAs, flexibleRes);
        ArrayList<Object> singleResDOFs = new ArrayList<Object>();
        for (int pos = 0; pos < this.numPos; ++pos) {
            Residue res = this.m.getResByPDBResNumber(flexibleRes.get(pos));
            String wtName = res.template.name;
            if (!StringParsing.containsIgnoreCase(allowedAAs.get(pos), wtName)) {
                if (addWT || allowedAAs.get(pos).isEmpty()) {
                    allowedAAs.get(pos).add(wtName);
                } else {
                    wtRots.set(pos, null);
                }
            }
            ArrayList<DegreeOfFreedom> resDOFs = ConfSpace.mutablePosDOFs(res, allowedAAs.get(pos));
            ResidueTypeDOF resMutDOF = (ResidueTypeDOF)resDOFs.remove(0);
            this.mutDOFs.add(resMutDOF);
            singleResDOFs.add(resDOFs);
        }
        ArrayList<DegreeOfFreedom> strandDOFs = this.strandMotionDOFs(moveableStrands, flexibleRes);
        this.confDOFs.addAll(strandDOFs);
        this.standardizeMutatableRes(allowedAAs, flexibleRes);
        ArrayList<Perturbation> perts = dset.makePerturbations(this.m);
        this.confDOFs.addAll(perts);
        ArrayList<BBFreeBlock> bfbList = this.getBBFreeBlocks(freeBBZones, flexibleRes);
        for (BBFreeBlock bfb : bfbList) {
            this.confDOFs.addAll(bfb.getDOFs());
        }
        for (int pos = 0; pos < this.numPos; ++pos) {
            Residue res = this.m.getResByPDBResNumber(flexibleRes.get(pos));
            ArrayList resDOFs = (ArrayList)singleResDOFs.get(pos);
            ArrayList<DegreeOfFreedom> resStrandDOFs = this.strandDOFsForRes(res, strandDOFs);
            BBFreeBlock curBFB = this.getCurBFB(bfbList, res);
            boolean wtRotOnly = wtRotOnlyRes.contains(flexibleRes.get(pos));
            if (wtRotOnly && (wtRots.get(pos) == null || allowedAAs.get(pos).size() != 1)) {
                throw new RuntimeException("ERROR: WT rot only on but residue not single AA type with wild-type rotamer");
            }
            PositionConfSpace rcs = new PositionConfSpace(pos, res, resDOFs, allowedAAs.get(pos), contSCFlex, resStrandDOFs, perts, dset.getPertIntervals(), dset.getPertStates(pos), curBFB, this.useEllipses, (ResidueTemplate)wtRots.get(pos), wtRotOnly);
            this.posFlex.add(rcs);
            if (this.useEllipses) {
                this.confDOFs.addAll(rcs.getEllipsoidalArray());
                continue;
            }
            this.confDOFs.addAll(resDOFs);
        }
    }

    public ConfSpace(ConfSpace other) {
        this.m = other.m;
        this.confDOFs = new ArrayList<DegreeOfFreedom>(other.confDOFs);
        this.mutDOFs = new ArrayList<ResidueTypeDOF>(other.mutDOFs);
        this.posFlex = new ArrayList<PositionConfSpace>(other.posFlex);
        this.flexibleRes = new ArrayList<String>(other.flexibleRes);
        this.numPos = other.numPos;
        this.useEllipses = other.useEllipses;
    }

    private ArrayList<BBFreeBlock> getBBFreeBlocks(ArrayList<String[]> freeBBZones, ArrayList<String> flexibleRes) {
        ArrayList<BBFreeBlock> ans = new ArrayList<BBFreeBlock>();
        for (String[] termini : freeBBZones) {
            ArrayList<Residue> curBFBRes = this.resListFromTermini(termini, flexibleRes);
            BBFreeBlock bfb = new BBFreeBlock(curBFBRes);
            ans.add(bfb);
        }
        return ans;
    }

    private BBFreeBlock getCurBFB(ArrayList<BBFreeBlock> bfbList, Residue res) {
        for (BBFreeBlock bfb : bfbList) {
            if (!bfb.getResidues().contains(res)) continue;
            return bfb;
        }
        return null;
    }

    private void makeRingPuckers(ArrayList<ArrayList<String>> allowedAAs, ArrayList<String> flexibleRes) {
        for (int pos = 0; pos < this.numPos; ++pos) {
            Residue res = this.m.getResByPDBResNumber(flexibleRes.get(pos));
            if (res.template.name.equalsIgnoreCase("PRO")) {
                res.pucker = new ProlinePucker(EnvironmentVars.resTemplates, res);
            } else {
                for (String AAType : allowedAAs.get(pos)) {
                    if (!AAType.equalsIgnoreCase("PRO")) continue;
                    res.pucker = new ProlinePucker(EnvironmentVars.resTemplates, res);
                    break;
                }
            }
            if (res.pucker == null) continue;
            this.confDOFs.add(res.pucker);
        }
    }

    private ArrayList<Residue> resListFromTermini(String[] termini, ArrayList<String> flexibleRes) {
        return this.m.resListFromTermini(termini, flexibleRes);
    }

    private ArrayList<DegreeOfFreedom> strandMotionDOFs(ArrayList<String[]> moveableStrands, ArrayList<String> flexibleRes) {
        ArrayList<DegreeOfFreedom> ans = new ArrayList<DegreeOfFreedom>();
        for (String[] termini : moveableStrands) {
            ArrayList<Residue> curStrandRes = this.resListFromTermini(termini, flexibleRes);
            MoveableStrand str = new MoveableStrand(curStrandRes);
            ans.addAll(str.getDOFs());
        }
        return ans;
    }

    private ArrayList<DegreeOfFreedom> strandDOFsForRes(Residue res, ArrayList<DegreeOfFreedom> strandDOFs) {
        ArrayList<DegreeOfFreedom> ans = new ArrayList<DegreeOfFreedom>();
        for (DegreeOfFreedom dof : strandDOFs) {
            MoveableStrand str = dof instanceof StrandRotation ? ((StrandRotation)dof).getMoveableStrand() : ((StrandTranslation)dof).getMoveableStrand();
            if (!str.getResidues().contains(res)) continue;
            ans.add(dof);
        }
        return ans;
    }

    private void standardizeMutatableRes(ArrayList<ArrayList<String>> allowedAAs, ArrayList<String> flexibleRes) {
        for (int pos = 0; pos < this.numPos; ++pos) {
            Residue res = this.m.getResByPDBResNumber(flexibleRes.get(pos));
            String resName = res.template.name;
            if (EnvironmentVars.resTemplates.getTemplate(resName) == null) continue;
            ResidueTypeDOF mutDOF = this.mutDOFs.get(pos);
            for (String allowedAA : allowedAAs.get(pos)) {
                if (!allowedAA.equalsIgnoreCase("PRO")) continue;
                mutDOF.mutateTo("PRO");
                break;
            }
            if (!HardCodedResidueInfo.hasAminoAcidBB(res) || res.fullName.startsWith("FOL")) continue;
            mutDOF.mutateTo(resName);
        }
    }

    static ArrayList<DegreeOfFreedom> mutablePosDOFs(Residue res, ArrayList<String> allowedAAs) {
        ArrayList<DegreeOfFreedom> ans = new ArrayList<DegreeOfFreedom>();
        ans.add(new ResidueTypeDOF(EnvironmentVars.resTemplates, res));
        int maxNumDihedrals = 0;
        for (String AAType : allowedAAs) {
            maxNumDihedrals = Math.max(maxNumDihedrals, EnvironmentVars.resTemplates.numDihedralsForResType(AAType));
        }
        for (int dih = 0; dih < maxNumDihedrals; ++dih) {
            ans.add(new FreeDihedral(res, dih));
        }
        if (res.pucker != null) {
            ans.add(res.pucker);
        }
        return ans;
    }

    public double minimizeEnergy(int[] conf, EnergyFunction efunc, String outputPDBFile) {
        DoubleMatrix1D optDOFVals;
        RCTuple RCs2 = new RCTuple(conf);
        MoleculeModifierAndScorer energy = new MoleculeModifierAndScorer(efunc, this, RCs2);
        if (energy.getNumDOFs() > 0) {
            CCDMinimizer min = new CCDMinimizer(energy, false);
            optDOFVals = min.minimize().dofValues;
        } else {
            optDOFVals = DoubleFactory1D.dense.make(0);
        }
        double minE = energy.getValue(optDOFVals);
        if (outputPDBFile != null) {
            PDBIO.writeFile(this.m, "", (Double)minE, outputPDBFile);
        }
        return minE;
    }

    public MultiTermEnergyFunction getDecomposedMinimizedEnergy(int[] conf, EnergyFunction efunc, String outputPDBFile) {
        DoubleMatrix1D optDOFVals;
        RCTuple RCs2 = new RCTuple(conf);
        MoleculeModifierAndScorer energy = new MoleculeModifierAndScorer(efunc, this, RCs2);
        if (energy.getNumDOFs() > 0) {
            CCDMinimizer min = new CCDMinimizer(energy, false);
            optDOFVals = min.minimize().dofValues;
        } else {
            optDOFVals = DoubleFactory1D.dense.make(0);
        }
        double minE = energy.getValue(optDOFVals);
        if (outputPDBFile != null) {
            PDBIO.writeFile(this.m, "", (Double)minE, outputPDBFile);
        }
        return (MultiTermEnergyFunction)energy.getEfunc();
    }

    public int[] getNumRCsAtPos() {
        int[] numAllowed = new int[this.numPos];
        for (int pos = 0; pos < this.numPos; ++pos) {
            numAllowed[pos] = this.posFlex.get((int)pos).RCs.size();
        }
        return numAllowed;
    }

    public double getRCResEntropy(int pos, int rc) {
        String resType = this.posFlex.get((int)pos).RCs.get((int)rc).AAType;
        double resEntropy = EnvironmentVars.resTemplates.getResEntropy(resType);
        return resEntropy;
    }

    public double getConfResEntropy(int[] conf) {
        double ans = 0.0;
        for (int pos = 0; pos < this.numPos; ++pos) {
            ans += this.getRCResEntropy(pos, conf[pos]);
        }
        return ans;
    }

    public BigInteger getNumConformations() {
        BigInteger count = BigInteger.valueOf(1L);
        for (int pos = 0; pos < this.numPos; ++pos) {
            count = count.multiply(BigInteger.valueOf(this.posFlex.get((int)pos).RCs.size()));
        }
        return count;
    }

    public ArrayList<DegreeOfFreedom> listAllDOFs() {
        ArrayList<DegreeOfFreedom> ans = new ArrayList<DegreeOfFreedom>();
        ans.addAll(this.mutDOFs);
        ans.addAll(this.confDOFs);
        return ans;
    }
}

