/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.confspace;

import edu.duke.cs.osprey.confspace.RCTuple;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.TreeMap;

public class HigherTupleFinder<T>
implements Serializable {
    private ArrayList<Integer> interactingPos = new ArrayList();
    private ArrayList<TreeMap<Integer, T>> interactions = new ArrayList();
    private ArrayList<TreeMap<Integer, HigherTupleFinder<T>>> higher = new ArrayList();
    T defaultInteraction;

    public HigherTupleFinder(T defaultInteraction) {
        this.defaultInteraction = defaultInteraction;
    }

    public ArrayList<Integer> getInteractingPos() {
        return this.interactingPos;
    }

    public T getInteraction(int posNum, int RCNum) {
        for (int interactionNum = 0; interactionNum < this.interactingPos.size(); ++interactionNum) {
            if (this.interactingPos.get(interactionNum) != posNum) continue;
            if (this.interactions.get(interactionNum).containsKey(RCNum)) {
                return this.interactions.get(interactionNum).get(RCNum);
            }
            return this.defaultInteraction;
        }
        return this.defaultInteraction;
    }

    public HigherTupleFinder<T> getHigherInteractions(int posNum, int RCNum) {
        for (int interactionNum = 0; interactionNum < this.interactingPos.size(); ++interactionNum) {
            if (this.interactingPos.get(interactionNum) != posNum) continue;
            if (this.higher.get(interactionNum).containsKey(RCNum)) {
                return this.higher.get(interactionNum).get(RCNum);
            }
            return null;
        }
        return null;
    }

    public void setInteraction(RCTuple tup, T val) {
        if (tup.pos.size() == 1) {
            int pos = tup.pos.get(0);
            int rc = tup.RCs.get(0);
            int posIndex = this.getPosIndex(pos);
            this.interactions.get(posIndex).put(rc, val);
        } else {
            for (int index = 0; index < tup.pos.size(); ++index) {
                int pos = tup.pos.get(index);
                int rc = tup.RCs.get(index);
                int posIndex = this.getPosIndex(pos);
                RCTuple subTup = tup.subtractMember(index);
                HigherTupleFinder<T> nextHTF = this.higher.get(posIndex).get(rc);
                if (nextHTF == null) {
                    nextHTF = new HigherTupleFinder<T>(this.defaultInteraction);
                    this.higher.get(posIndex).put(rc, nextHTF);
                }
                nextHTF.setInteraction(subTup, val);
            }
        }
    }

    private int getPosIndex(int pos) {
        for (int interactionNum = 0; interactionNum < this.interactingPos.size(); ++interactionNum) {
            if (this.interactingPos.get(interactionNum) != pos) continue;
            return interactionNum;
        }
        this.interactingPos.add(pos);
        this.interactions.add(new TreeMap());
        this.higher.add(new TreeMap());
        return this.interactingPos.size() - 1;
    }

    public ArrayList<RCTuple> listInteractionsWithValue(T val) {
        ArrayList<RCTuple> ans = new ArrayList<RCTuple>();
        this.recordInteractionsWithValue(val, ans, Integer.MAX_VALUE);
        return ans;
    }

    private void recordInteractionsWithValue(T val, ArrayList<RCTuple> tupList, int maxPos) {
        for (int interactionNum = 0; interactionNum < this.interactingPos.size(); ++interactionNum) {
            int pos = this.interactingPos.get(interactionNum);
            if (pos >= maxPos) continue;
            for (int rc : this.interactions.get(interactionNum).keySet()) {
                if (this.interactions.get(interactionNum).get(rc) != val) continue;
                tupList.add(new RCTuple(pos, rc));
            }
            for (int rc : this.higher.get(interactionNum).keySet()) {
                ArrayList<RCTuple> subTupList = new ArrayList<RCTuple>();
                this.higher.get(interactionNum).get(rc).recordInteractionsWithValue(val, subTupList, pos);
                for (RCTuple subTup : subTupList) {
                    subTup.pos.add(pos);
                    subTup.RCs.add(rc);
                    tupList.add(subTup);
                }
            }
        }
    }
}

