/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.confspace;

import edu.duke.cs.osprey.confspace.ConfSpaceIteration;
import edu.duke.cs.osprey.confspace.SeqSpace;
import edu.duke.cs.osprey.tools.MathTools;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Function;

public class MultiStateConfSpace {
    public final SeqSpace seqSpace;
    public final List<State> states;
    public final List<State> sequencedStates;
    public final List<State> unsequencedStates;

    private MultiStateConfSpace(SeqSpace seqSpace, List<State> states, List<State> sequencedStates, List<State> unsequencedStates) {
        this.seqSpace = seqSpace;
        this.states = Collections.unmodifiableList(states);
        this.sequencedStates = sequencedStates;
        this.unsequencedStates = unsequencedStates;
    }

    public State getState(String name) {
        return this.states.stream().filter(state -> state.name.equals(name)).findFirst().orElseThrow(() -> new NoSuchElementException("no state with name " + name));
    }

    public LMFEBuilder lmfe() {
        return new LMFEBuilder();
    }

    public static class State {
        public final int index;
        public final int sequencedIndex;
        public final int unsequencedIndex;
        public final String name;
        public final ConfSpaceIteration confSpace;
        public final boolean isSequenced;

        private State(int index, int sequencedIndex, int unsequencedIndex, String name, ConfSpaceIteration confSpace) {
            this.index = index;
            this.sequencedIndex = sequencedIndex;
            this.unsequencedIndex = unsequencedIndex;
            this.name = name;
            this.confSpace = confSpace;
            this.isSequenced = sequencedIndex >= 0;
        }

        public int hashCode() {
            return this.index;
        }

        public boolean equals(Object other) {
            return other instanceof State && this.equals((State)other);
        }

        public boolean equals(State other) {
            return this.index == other.index;
        }
    }

    public class LMFEBuilder {
        private final Map<State, Double> weightsByState = new HashMap<State, Double>();

        public LMFEBuilder add(State state, double weight) {
            this.weightsByState.put(state, weight);
            return this;
        }

        public LMFEBuilder add(String stateName, double weight) {
            this.weightsByState.put(MultiStateConfSpace.this.getState(stateName), weight);
            return this;
        }

        public LMFEBuilder addPositive(State state) {
            return this.add(state, 1.0);
        }

        public LMFEBuilder addPositive(String stateName) {
            return this.addPositive(MultiStateConfSpace.this.getState(stateName));
        }

        public LMFEBuilder addNegative(State state) {
            return this.add(state, -1.0);
        }

        public LMFEBuilder addNegative(String stateName) {
            return this.addNegative(MultiStateConfSpace.this.getState(stateName));
        }

        public LMFE build() {
            return new LMFE(this.weightsByState);
        }
    }

    public class LMFECalculator {
        public final LMFE lmfe;
        public final MathTools.DoubleBounds bounds = new MathTools.DoubleBounds(0.0, 0.0);

        public LMFECalculator(MultiStateConfSpace this$0, LMFE lmfe) {
            this.lmfe = lmfe;
        }

        public LMFECalculator add(State state, MathTools.DoubleBounds freeEnergy) {
            Double weight = this.lmfe.getWeight(state);
            if (weight == null) {
                return this;
            }
            if (this.bounds.lower == Double.POSITIVE_INFINITY && this.bounds.upper == Double.POSITIVE_INFINITY || freeEnergy.lower == Double.POSITIVE_INFINITY && freeEnergy.upper == Double.POSITIVE_INFINITY) {
                this.bounds.lower = Double.POSITIVE_INFINITY;
                this.bounds.upper = Double.POSITIVE_INFINITY;
            } else if (weight < 0.0) {
                this.bounds.lower += freeEnergy.upper * weight;
                this.bounds.upper += freeEnergy.lower * weight;
            } else if (weight > 0.0) {
                this.bounds.lower += freeEnergy.lower * weight;
                this.bounds.upper += freeEnergy.upper * weight;
            }
            return this;
        }

        public LMFECalculator addAll(MathTools.DoubleBounds[] freeEnergiesByState) {
            for (State state : this.lmfe.confSpace.states) {
                this.add(state, freeEnergiesByState[state.index]);
            }
            return this;
        }
    }

    public class LMFE {
        public final MultiStateConfSpace confSpace;
        private final Map<State, Double> weightsByState;

        private LMFE(Map<State, Double> weightsByState) {
            this.confSpace = MultiStateConfSpace.this;
            this.weightsByState = Collections.unmodifiableMap(weightsByState);
        }

        public Set<State> states() {
            return this.weightsByState.keySet();
        }

        public Double getWeight(State state) {
            return this.weightsByState.get(state);
        }

        public MathTools.DoubleBounds[] collectFreeEnergies(Function<State, MathTools.DoubleBounds> f) {
            MathTools.DoubleBounds[] boundsByState = new MathTools.DoubleBounds[this.confSpace.states.size()];
            for (State state : this.states()) {
                boundsByState[state.index] = f.apply(state);
            }
            return boundsByState;
        }

        public LMFECalculator calc() {
            return new LMFECalculator(MultiStateConfSpace.this, this);
        }
    }

    public static class Builder {
        private final State sequencedState;
        private final List<State> states = new ArrayList<State>();
        private final List<State> sequencedStates = new ArrayList<State>();
        private final List<State> unsequencedStates = new ArrayList<State>();

        public Builder(String name, ConfSpaceIteration confSpace) {
            this.sequencedState = new State(this.states.size(), this.sequencedStates.size(), -1, name, confSpace);
            this.states.add(this.sequencedState);
            this.sequencedStates.add(this.sequencedState);
        }

        public Builder addMutableState(String name, ConfSpaceIteration confSpace) {
            if (!confSpace.seqSpace().isSubsetOf(this.sequencedState.confSpace.seqSpace())) {
                throw new IllegalArgumentException(String.format("sequence space for state \"%s\" doesn't match state \"%s\"\nexpected:%s\nobserved:%s", name, this.sequencedState.name, this.sequencedState.confSpace.seqSpace(), confSpace.seqSpace()));
            }
            State state = new State(this.states.size(), this.sequencedStates.size(), -1, name, confSpace);
            this.states.add(state);
            this.sequencedStates.add(state);
            return this;
        }

        public Builder addUnmutableState(String name, ConfSpaceIteration confSpace) {
            if (confSpace.seqSpace().hasMutants()) {
                throw new IllegalArgumentException("unmutable conf space can't have any mutants");
            }
            State state = new State(this.states.size(), -1, this.unsequencedStates.size(), name, confSpace);
            this.states.add(state);
            this.unsequencedStates.add(state);
            return this;
        }

        public MultiStateConfSpace build() {
            return new MultiStateConfSpace(this.sequencedState.confSpace.seqSpace(), this.states, this.sequencedStates, this.unsequencedStates);
        }
    }
}

