/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.confspace;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.colt.matrix.linalg.EigenvalueDecomposition;
import edu.duke.cs.osprey.bbfree.BBFreeBlock;
import edu.duke.cs.osprey.bbfree.BBFreeDOF;
import edu.duke.cs.osprey.confspace.RC;
import edu.duke.cs.osprey.confspace.RCIndexMap;
import edu.duke.cs.osprey.control.EnvironmentVars;
import edu.duke.cs.osprey.dof.DegreeOfFreedom;
import edu.duke.cs.osprey.dof.EllipseCoordDOF;
import edu.duke.cs.osprey.dof.MoveableStrand;
import edu.duke.cs.osprey.dof.deeper.perts.Perturbation;
import edu.duke.cs.osprey.restypes.ResidueTemplate;
import edu.duke.cs.osprey.restypes.ResidueTemplateLibrary;
import edu.duke.cs.osprey.structure.Residue;
import edu.duke.cs.osprey.tools.Protractor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class PositionConfSpace
implements Serializable {
    private static final long serialVersionUID = 2705824580246579508L;
    public ArrayList<RC> RCs = new ArrayList();
    public ArrayList<RC> wtRCs = new ArrayList();
    public Residue res;
    public int designIndex;
    public static double dihedFlexInterval = 9.0;
    static double ellipseAngMax = Math.PI;
    static double ellipseFinAngMax = Math.PI * 2;
    static double ellipseMin = 0.0;
    ArrayList<EllipseCoordDOF> ellipsoidalDOFs = new ArrayList();

    public PositionConfSpace(int pos, Residue res, ArrayList<DegreeOfFreedom> resDOFs, ArrayList<String> allowedAAs, boolean contSCFlex, ArrayList<DegreeOfFreedom> strandDOFs, ArrayList<Perturbation> perts, ArrayList<ArrayList<double[]>> pertIntervals, ArrayList<ArrayList<int[]>> pertStates, BBFreeBlock bfb, boolean useEllipses, ResidueTemplate wtRots, boolean wtRotOnly) {
        ResidueTemplateLibrary templateLib = EnvironmentVars.resTemplates;
        this.res = res;
        this.designIndex = pos;
        if (pertStates == null) {
            pertStates = new ArrayList();
            pertStates.add(null);
        }
        if (wtRots != null) {
            for (int i = 0; i < wtRots.getNumRotamers(); ++i) {
                double[] dihedrals = wtRots.getRotamericDihedrals(i);
                ArrayList<DegreeOfFreedom> dofListForRot = new ArrayList<DegreeOfFreedom>();
                for (int dih = 0; dih < dihedrals.length; ++dih) {
                    dofListForRot.add(resDOFs.get(dih));
                }
                boolean rotUsesEllipses = useEllipses && res.template.numDihedrals > 1;
                for (ArrayList<Object> pertState : pertStates) {
                    RC rc = this.createRC(dihedrals, res.template.name, wtRots, i, contSCFlex, dofListForRot, 0, strandDOFs, bfb, pertState, perts, pertIntervals, rotUsesEllipses);
                    this.wtRCs.add(rc);
                }
            }
        }
        if (!wtRotOnly) {
            for (String AAType : allowedAAs) {
                int numDihedrals = templateLib.numDihedralsForResType(AAType);
                double[] phipsi = Protractor.getPhiPsi(this.res);
                int numRot = templateLib.numRotForResType(this.designIndex, AAType, phipsi[0], phipsi[1]);
                ArrayList<DegreeOfFreedom> dofListForRot = new ArrayList<DegreeOfFreedom>();
                for (int dih = 0; dih < numDihedrals; ++dih) {
                    dofListForRot.add(resDOFs.get(dih));
                }
                for (ArrayList<Object> pertState : pertStates) {
                    if (AAType.equalsIgnoreCase("PRO")) {
                        for (int puckerVal : new int[]{0, 1}) {
                            this.createRC(null, AAType, null, -1, contSCFlex, dofListForRot, puckerVal, strandDOFs, bfb, pertState, perts, pertIntervals, false);
                        }
                        continue;
                    }
                    if (numRot == 0) {
                        this.createRC(null, AAType, null, -1, contSCFlex, dofListForRot, -1, strandDOFs, bfb, pertState, perts, pertIntervals, false);
                        continue;
                    }
                    boolean AATypeUsesEllipses = useEllipses && numDihedrals > 1;
                    for (int rot = 0; rot < numRot; ++rot) {
                        double[] dihedrals = new double[numDihedrals];
                        for (int i = 0; i < numDihedrals; ++i) {
                            dihedrals[i] = templateLib.getDihedralForRotamer(this.designIndex, AAType, phipsi[0], phipsi[1], rot, i);
                        }
                        this.createRC(dihedrals, AAType, null, rot, contSCFlex, dofListForRot, -1, strandDOFs, bfb, pertState, perts, pertIntervals, AATypeUsesEllipses);
                    }
                }
            }
        }
    }

    public PositionConfSpace(PositionConfSpace other) {
        this.RCs = new ArrayList();
        for (RC rc : other.RCs) {
            this.RCs.add(new RC(rc));
        }
        this.wtRCs = new ArrayList<RC>(other.wtRCs);
        this.res = other.res;
        this.designIndex = other.designIndex;
    }

    private RC createRC(double[] dihedrals, String AAType, ResidueTemplate template, int rot, boolean contSCFlex, ArrayList<DegreeOfFreedom> dofListForRot, int proPucker, ArrayList<DegreeOfFreedom> strandDOFs, BBFreeBlock bfb, ArrayList<int[]> pertState, ArrayList<Perturbation> perts, ArrayList<ArrayList<double[]>> pertIntervals, boolean useEllipses) {
        ArrayList<Double> dofLB = new ArrayList<Double>();
        ArrayList<Double> dofUB = new ArrayList<Double>();
        if (dihedrals == null) {
            dihedrals = new double[]{};
        }
        ArrayList<EllipseCoordDOF> ellCoords = this.makeEllCoords(useEllipses, dihedrals, dofListForRot);
        this.boundRotDOFs(dofLB, dofUB, contSCFlex, dihedrals, ellCoords, useEllipses);
        ArrayList<DegreeOfFreedom> dofListForRC = new ArrayList<DegreeOfFreedom>();
        if (useEllipses) {
            dofListForRC.addAll(ellCoords);
            this.ellipsoidalDOFs.addAll(ellCoords);
        } else {
            dofListForRC.addAll(dofListForRot);
        }
        if (AAType.equalsIgnoreCase("PRO")) {
            dofListForRC.add(this.res.pucker);
            dofLB.add(Double.valueOf(proPucker));
            dofUB.add(Double.valueOf(proPucker));
        }
        this.addStrandDOFs(strandDOFs, dofListForRC, dofLB, dofUB);
        this.addBFBDOFs(bfb, dofListForRC, dofLB, dofUB);
        this.addDEEPerDOFs(pertState, perts, pertIntervals, dofListForRC, dofLB, dofUB);
        RC newRC = new RC(AAType, template, rot, dofListForRC, dofLB, dofUB, this.RCs.size());
        this.RCs.add(newRC);
        return newRC;
    }

    private void addStrandDOFs(ArrayList<DegreeOfFreedom> strandDOFs, ArrayList<DegreeOfFreedom> dofListForRC, ArrayList<Double> dofLB, ArrayList<Double> dofUB) {
        for (DegreeOfFreedom strandDOF : strandDOFs) {
            dofListForRC.add(strandDOF);
            double[] bounds = MoveableStrand.getStrandDOFBounds(strandDOF);
            dofLB.add(bounds[0]);
            dofUB.add(bounds[1]);
        }
    }

    private void addBFBDOFs(BBFreeBlock bfb, ArrayList<DegreeOfFreedom> dofListForRC, ArrayList<Double> dofLB, ArrayList<Double> dofUB) {
        if (bfb != null) {
            ArrayList<BBFreeDOF> bbFreeDOFs = bfb.getDOFs();
            double[][] freeDOFVoxel = bfb.getFreeDOFVoxel();
            for (int dnum = 0; dnum < bbFreeDOFs.size(); ++dnum) {
                dofListForRC.add(bbFreeDOFs.get(dnum));
                dofLB.add(freeDOFVoxel[0][dnum]);
                dofUB.add(freeDOFVoxel[1][dnum]);
            }
        }
    }

    private void addDEEPerDOFs(ArrayList<int[]> pertState, ArrayList<Perturbation> perts, ArrayList<ArrayList<double[]>> pertIntervals, ArrayList<DegreeOfFreedom> dofListForRC, ArrayList<Double> dofLB, ArrayList<Double> dofUB) {
        if (pertState != null) {
            for (int[] singlePertState : pertState) {
                int pertNum = singlePertState[0];
                int pertStateNum = singlePertState[1];
                dofListForRC.add(perts.get(pertNum));
                double[] pertInterval = pertIntervals.get(pertNum).get(pertStateNum);
                dofLB.add(pertInterval[0]);
                dofUB.add(pertInterval[1]);
            }
        }
    }

    private void boundRotDOFs(ArrayList<Double> dofLB, ArrayList<Double> dofUB, boolean contSCFlex, double[] dihedrals, ArrayList<EllipseCoordDOF> ellCoords, boolean useEllipses) {
        for (int dih = 0; dih < dihedrals.length; ++dih) {
            if (useEllipses) {
                if (contSCFlex) {
                    dofLB.add(ellipseMin);
                    double radMax = 30.0;
                    dofUB.add(dih == 0 ? radMax : (dih == dihedrals.length - 1 ? ellipseFinAngMax : ellipseAngMax));
                    continue;
                }
                dofLB.add(ellCoords.get(dih).getCurVal());
                dofUB.add(ellCoords.get(dih).getCurVal());
                continue;
            }
            if (contSCFlex) {
                dofLB.add(dihedrals[dih] - dihedFlexInterval);
                dofUB.add(dihedrals[dih] + dihedFlexInterval);
                continue;
            }
            dofLB.add(dihedrals[dih]);
            dofUB.add(dihedrals[dih]);
        }
    }

    public double[] makeDOFBounds(double chi) {
        return new double[]{chi - dihedFlexInterval, chi + dihedFlexInterval};
    }

    private ArrayList<EllipseCoordDOF> makeEllCoords(boolean useEllipses, double[] dihValues, ArrayList<DegreeOfFreedom> dofListForRot) {
        ArrayList<EllipseCoordDOF> ellCoords = new ArrayList<EllipseCoordDOF>();
        if (useEllipses) {
            double[] ellValues = this.getEllipsoidalCoords(dihValues);
            DoubleMatrix2D A = DoubleFactory2D.dense.identity(ellValues.length);
            for (int i = 0; i < ellValues.length; ++i) {
                EllipseCoordDOF ellDOF = new EllipseCoordDOF(i == 0, i, ellValues[i], A, dofListForRot, dihValues);
                ellCoords.add(ellDOF);
            }
        }
        return ellCoords;
    }

    public double[] getEllipsoidalCoords(double[] dihedrals) {
        if (dihedrals.length == 0) {
            return new double[0];
        }
        DoubleMatrix2D A = DoubleFactory2D.dense.identity(dihedrals.length);
        DoubleMatrix1D c = DoubleFactory1D.dense.make(new double[dihedrals.length]);
        EigenvalueDecomposition evd = new EigenvalueDecomposition(A);
        DoubleMatrix2D Q = evd.getV();
        DoubleMatrix2D L = evd.getD();
        DoubleMatrix2D qT = Q.viewDice().copy();
        Algebra alg = new Algebra();
        double[] s = new double[dihedrals.length];
        for (int i = 0; i < dihedrals.length; ++i) {
            s[i] = dihedrals[i] - c.get(i);
        }
        double[] u = alg.mult(qT, DoubleFactory1D.dense.make(s)).toArray();
        double[] x = new double[u.length];
        for (int i = 0; i < u.length; ++i) {
            x[i] = u[i] / Math.sqrt(L.get(i, i));
        }
        dihedrals = x;
        int n = dihedrals.length;
        double[] phi = new double[n - 1];
        for (int i = 0; i < n - 1; ++i) {
            double d = 0.0;
            for (int j = i; j < n; ++j) {
                d += dihedrals[j] * dihedrals[j];
            }
            double quot = dihedrals[i] / Math.sqrt(d);
            phi[i] = Math.acos(quot);
        }
        if (dihedrals[n - 1] < 0.0) {
            phi[n - 2] = Math.PI * 2 - phi[n - 2];
        }
        double[] ellCoords = new double[n];
        ellCoords[0] = 0.0;
        for (int i = 1; i < n; ++i) {
            ellCoords[i] = phi[i - 1];
        }
        return ellCoords;
    }

    public ArrayList<EllipseCoordDOF> getEllipsoidalArray() {
        return this.ellipsoidalDOFs;
    }

    public RCIndexMap replaceRC(RC oldRC, List<RC> newRCs) {
        if (newRCs.isEmpty()) {
            throw new IllegalArgumentException("newRCs can't be empty");
        }
        Integer oldIndex = this.findRcIndex(oldRC);
        if (oldIndex == null) {
            throw new IllegalArgumentException("can't remove RC, it's not at this pos");
        }
        RCIndexMap map = new RCIndexMap(this.RCs.size());
        RC rc = newRCs.get(0);
        this.RCs.set(oldIndex, rc);
        rc.RCIndex = oldIndex;
        map.remove(oldIndex);
        map.add(oldIndex, oldIndex);
        for (int i = 1; i < newRCs.size(); ++i) {
            rc = newRCs.get(i);
            this.RCs.add(rc);
            rc.RCIndex = this.RCs.size() - 1;
            map.add(oldIndex, rc.RCIndex);
        }
        return map;
    }

    private Integer findRcIndex(RC rc) {
        for (int i = 0; i < this.RCs.size(); ++i) {
            if (this.RCs.get(i) != rc) continue;
            return i;
        }
        return null;
    }

    public int maxNumRCsPerResType() {
        HashMap<String, Integer> resTypeRCCounts = new HashMap<String, Integer>();
        for (RC rc : this.RCs) {
            String type = rc.AAType;
            if (resTypeRCCounts.containsKey(type)) {
                resTypeRCCounts.put(type, (Integer)resTypeRCCounts.get(type) + 1);
                continue;
            }
            resTypeRCCounts.put(type, 1);
        }
        int maxNumRCs = 0;
        Iterator iterator2 = resTypeRCCounts.values().iterator();
        while (iterator2.hasNext()) {
            int count = (Integer)iterator2.next();
            maxNumRCs = Math.max(maxNumRCs, count);
        }
        return maxNumRCs;
    }
}

