/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.confspace;

import java.util.ArrayList;
import java.util.List;

public class RCIndexMap {
    private List<List<Integer>> oldToNew;
    private List<Integer> newToOld;

    public RCIndexMap(int numOldRCs) {
        this.oldToNew = new ArrayList<List<Integer>>(numOldRCs);
        this.newToOld = new ArrayList<Integer>(numOldRCs);
        for (int i = 0; i < numOldRCs; ++i) {
            this.oldToNew.add(this.makeList(i));
            this.newToOld.add(i);
        }
    }

    private List<Integer> makeList(int val) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(val);
        return list;
    }

    public void remove(int oldIndex) {
        this.oldToNew.get(oldIndex).clear();
        this.newToOld.set(oldIndex, null);
    }

    public void add(int oldIndex, int newIndex) {
        this.oldToNew.get(oldIndex).add(newIndex);
        if (newIndex < this.newToOld.size()) {
            this.newToOld.set(newIndex, null);
        } else if (newIndex == this.newToOld.size()) {
            this.newToOld.add(null);
        } else {
            throw new IllegalArgumentException(String.format("can't handle new index %d yes, add %d first", newIndex, this.newToOld.size()));
        }
    }

    public Integer newToOld(int rc) {
        return this.newToOld.get(rc);
    }

    public List<Integer> oldToNew(int rc) {
        return this.oldToNew.get(rc);
    }
}

