/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.confspace;

import edu.duke.cs.osprey.confspace.ConfSpaceIteration;
import edu.duke.cs.osprey.confspace.Sequence;
import edu.duke.cs.osprey.confspace.SimpleConfSpace;
import edu.duke.cs.osprey.confspace.compiled.ConfSpace;
import edu.duke.cs.osprey.tools.MathTools;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;

public class SeqSpace
implements Serializable {
    private static final long serialVersionUID = -7309869148482636562L;
    public final List<Position> positions = new ArrayList<Position>();
    private final Map<String, Position> positionsByResNum = new HashMap<String, Position>();

    public static SeqSpace union(List<SeqSpace> seqSpaces) {
        return (SeqSpace)seqSpaces.stream().reduce((a, b) -> SeqSpace.union(a, b)).orElseThrow(() -> new IllegalArgumentException("conf spaces list is empty"));
    }

    public static SeqSpace union(SeqSpace a, SeqSpace b) {
        SeqSpace u = new SeqSpace();
        for (Position apos : a.positions) {
            u.makePos(apos.resNum, apos.wildType != null ? apos.wildType.name : null, apos.resTypes.stream().map(resType -> resType.name).collect(Collectors.toList()));
        }
        for (Position bpos : b.positions) {
            Position upos = u.getPosition(bpos.resNum);
            if (upos != null) {
                Set btypes;
                String bWildType;
                String uWildType = upos.wildType != null ? upos.wildType.name : null;
                String string = bWildType = bpos.wildType != null ? bpos.wildType.name : null;
                if (!Objects.equals(uWildType, bWildType)) {
                    throw new IllegalArgumentException(String.format("the two positions at residue %s have different wild types: %s != %s", upos.resNum, uWildType, bWildType));
                }
                Set utypes = bpos.resTypes.stream().map(resType -> resType.name).collect(Collectors.toSet());
                if (utypes.equals(btypes = bpos.resTypes.stream().map(resType -> resType.name).collect(Collectors.toSet()))) continue;
                throw new IllegalArgumentException(String.format("the two positions at residue %s have different residue types: %s != %s", upos.resNum, utypes, btypes));
            }
            u.makePos(bpos.resNum, bpos.wildType.name, bpos.resTypes.stream().map(resType -> resType.name).collect(Collectors.toList()));
        }
        return u;
    }

    public SeqSpace(SimpleConfSpace confSpace) {
        for (SimpleConfSpace.Position pos : confSpace.mutablePositions) {
            this.makePos(pos.resNum, pos.resFlex.wildType, pos.resTypes);
        }
    }

    public SeqSpace(ConfSpace confSpace) {
        for (ConfSpace.Pos pos : confSpace.positions) {
            List<String> types2 = Arrays.stream(pos.confs).map(conf -> conf.type).distinct().collect(Collectors.toList());
            this.makePos(pos.name, pos.wildType, types2);
        }
    }

    private SeqSpace() {
    }

    private void makePos(String resNum, String wildType2, List<String> resTypes) {
        Position pos = new Position(this.positions.size(), resNum, wildType2, resTypes);
        this.positions.add(pos);
        this.positionsByResNum.put(resNum, pos);
    }

    public List<String> getResNums() {
        return this.positions.stream().map(pos -> pos.resNum).collect(Collectors.toList());
    }

    public Position getPosition(String resNum) {
        return this.positionsByResNum.get(resNum);
    }

    public Position getPositionOrThrow(String resNum) {
        Position pos = this.getPosition(resNum);
        if (pos != null) {
            return pos;
        }
        throw new NoSuchElementException("no pos found in this sequence space at residue " + resNum + ". try one of " + String.valueOf(this.getResNums()));
    }

    public boolean containsWildTypeSequence() {
        for (Position pos : this.positions) {
            if (pos.wildType != null) continue;
            return false;
        }
        return true;
    }

    public Sequence makeUnassignedSequence() {
        return new Sequence(this);
    }

    public Sequence makeWildTypeSequence() {
        if (!this.containsWildTypeSequence()) {
            throw new NoSuchElementException("sequence space does not contain the wild-type sequence, so cannot create it");
        }
        Sequence seq = new Sequence(this);
        seq.fillWildType();
        return seq;
    }

    public Sequence makeSequence(List<String> resTypes) {
        if (resTypes.size() != this.positions.size()) {
            throw new IllegalArgumentException(String.format("expected %d residue types, but only got %d: %s", this.positions.size(), resTypes.size(), resTypes));
        }
        Sequence seq = this.makeUnassignedSequence();
        for (int i = 0; i < this.positions.size(); ++i) {
            Position pos = this.positions.get(i);
            seq.set(pos, resTypes.get(i));
        }
        return seq;
    }

    public Sequence makeSequence(String ... resTypes) {
        return this.makeSequence(Arrays.asList(resTypes));
    }

    public Sequence makeSequence(ConfSpaceIteration confSpace, int[] conf) {
        Sequence seq = this.makeUnassignedSequence();
        for (int posi = 0; posi < confSpace.numPos(); ++posi) {
            Position seqPos = this.getPosition(confSpace.name(posi));
            int confi = conf[posi];
            if (seqPos == null || confi == -1) continue;
            seq.set(seqPos, confSpace.confType(posi, confi));
        }
        return seq;
    }

    public boolean hasMutants() {
        for (Position pos : this.positions) {
            if (!pos.hasMutants()) continue;
            return true;
        }
        return false;
    }

    public BigInteger getNumSequences() {
        BigInteger count = BigInteger.ONE;
        for (Position pos : this.positions) {
            count = count.multiply(BigInteger.valueOf(pos.resTypes.size()));
        }
        return count;
    }

    public List<Sequence> getSequences() {
        return this.getSequences(this.positions.size());
    }

    public List<Sequence> getSequences(int maxSimultaneousMutations) {
        ArrayList<Sequence> sequences = new ArrayList<Sequence>();
        if (this.containsWildTypeSequence()) {
            sequences.add(this.makeWildTypeSequence());
        }
        sequences.addAll(this.getMutants(maxSimultaneousMutations));
        return sequences;
    }

    public List<Sequence> getMutants() {
        return this.getMutants(this.positions.size());
    }

    public List<Sequence> getMutants(File mutFile) {
        ArrayList<Sequence> sequences = new ArrayList<Sequence>();
        try {
            FileInputStream is = new FileInputStream(mutFile);
            BufferedReader bufread = new BufferedReader(new InputStreamReader(is));
            int seqNum = 0;
            String curLine = bufread.readLine();
            while (curLine != null) {
                StringTokenizer st = new StringTokenizer(curLine);
                int numPos = st.countTokens();
                ArrayList<String> seq = new ArrayList<String>();
                for (int pos = 0; pos < numPos; ++pos) {
                    seq.add(st.nextToken().split("=")[1]);
                }
                sequences.add(this.makeSequence(seq));
                ++seqNum;
                curLine = bufread.readLine();
            }
            bufread.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return sequences;
    }

    public List<Sequence> getMutants(int maxSimultaneousMutations) {
        return this.getMutants(maxSimultaneousMutations, false);
    }

    public List<Sequence> getMutants(int maxSimultaneousMutations, boolean reversePositionOrder) {
        ArrayList<Sequence> sequences = new ArrayList<Sequence>();
        List<List<Position>> powersetOfPositions = MathTools.powersetUpTo(this.positions, maxSimultaneousMutations);
        if (reversePositionOrder) {
            Collections.reverse(powersetOfPositions);
        }
        for (List<Position> positions : powersetOfPositions) {
            List mutationsByPos = positions.stream().map(pos -> pos.mutations).collect(Collectors.toList());
            for (List mutations : MathTools.cartesianProduct(mutationsByPos)) {
                Sequence sequence = this.makeUnassignedSequence();
                sequence.fillWildType();
                for (ResType rt : mutations) {
                    sequence.set(rt.pos, rt);
                }
                if (!sequence.isFullyAssigned()) continue;
                sequences.add(sequence);
            }
        }
        return sequences;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Residue Types:");
        for (Position pos : this.positions) {
            buf.append("\n\t");
            buf.append(pos.index);
            buf.append(":");
            buf.append(pos.resNum);
            buf.append("  [");
            for (ResType rt : pos.resTypes) {
                buf.append(" ");
                buf.append(rt.index);
                buf.append(":");
                if (pos.wildType == rt) {
                    buf.append(rt.name.toLowerCase());
                    continue;
                }
                buf.append(rt.name);
            }
            buf.append(" ]");
        }
        return buf.toString();
    }

    public boolean equals(Object other) {
        return other instanceof SeqSpace && this.equals((SeqSpace)other);
    }

    public boolean equals(SeqSpace other) {
        return this.positions.equals(other.positions);
    }

    public boolean isSubsetOf(SeqSpace other) {
        for (Position pos : this.positions) {
            Position otherPos = other.getPosition(pos.resNum);
            if (otherPos == null) {
                return false;
            }
            if (pos.resTypes.equals(otherPos.resTypes)) continue;
            return false;
        }
        return true;
    }

    public class Position
    implements Comparable<Position>,
    Serializable {
        private static final long serialVersionUID = -8317027786742083135L;
        public final SeqSpace seqSpace;
        public final int index;
        public final String resNum;
        public final ResType wildType;
        public final List<ResType> resTypes;
        public final List<ResType> mutations;
        private final Map<String, ResType> resTypesByName;

        private Position(int index, String resNum, String wildType2, List<String> resTypes) {
            this.seqSpace = SeqSpace.this;
            this.index = index;
            this.resNum = resNum;
            this.resTypes = new ArrayList<ResType>(resTypes.size());
            for (String resType : resTypes) {
                this.resTypes.add(new ResType(this, this.resTypes.size(), resType));
            }
            this.resTypesByName = new HashMap<String, ResType>();
            for (ResType rt2 : this.resTypes) {
                this.resTypesByName.put(this.normalizeResType(rt2.name), rt2);
            }
            this.wildType = this.getResType(wildType2);
            this.mutations = this.resTypes.stream().filter(rt -> rt != this.wildType).collect(Collectors.toList());
        }

        public ResType getResType(String name) {
            return this.resTypesByName.get(this.normalizeResType(name));
        }

        public ResType getResTypeOrThrow(String name) {
            ResType rt = this.getResType(name);
            if (rt != null) {
                return rt;
            }
            throw new NoSuchElementException("Res type " + name + " not allowed at position " + this.resNum + ". Try one of " + String.valueOf(this.resTypes));
        }

        private String normalizeResType(String type) {
            return type.toUpperCase();
        }

        public boolean hasMutants() {
            return !this.mutations.isEmpty();
        }

        public boolean equals(Object other) {
            return other instanceof Position && this.equals((Position)other);
        }

        public boolean equals(Position other) {
            return this.index == other.index && this.resNum.equals(other.resNum) && this.wildType.equals(other.wildType) && this.resTypes.equals(other.resTypes);
        }

        public String toString() {
            return String.format("%d:%s", this.index, this.resNum);
        }

        @Override
        public int compareTo(Position other) {
            return this.index - other.index;
        }
    }

    public class ResType
    implements Comparable<ResType>,
    Serializable {
        private static final long serialVersionUID = 1628630395970846143L;
        public final Position pos;
        public final int index;
        public final String name;

        public ResType(Position pos, int index, String name) {
            this.pos = pos;
            this.index = index;
            this.name = name;
        }

        public boolean equals(Object other) {
            return other instanceof ResType && this.equals((ResType)other);
        }

        public boolean equals(ResType other) {
            return this.index == other.index && this.name.equals(other.name);
        }

        public String toString() {
            return String.format("%d:%s", this.index, this.name);
        }

        @Override
        public int compareTo(ResType other) {
            return this.index - other.index;
        }

        public boolean isWildType() {
            return this.pos.wildType == this;
        }

        public boolean isMutation() {
            return this.pos.wildType != this;
        }

        public String mutationName() {
            if (this.isWildType()) {
                return this.name.toLowerCase();
            }
            return this.name.toUpperCase();
        }
    }
}

