/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.confspace;

import edu.duke.cs.osprey.confspace.RCTuple;
import edu.duke.cs.osprey.confspace.TupE;
import edu.duke.cs.osprey.ematrix.EnergyMatrix;
import edu.duke.cs.osprey.pruning.PruningMatrix;
import java.util.ArrayList;
import java.util.PriorityQueue;

public class TupleEnumerator {
    PruningMatrix pruneMat;
    EnergyMatrix emat;
    int numPosTotal;

    public TupleEnumerator(PruningMatrix pruneMat, EnergyMatrix emat, int numPosTotal) {
        this.pruneMat = pruneMat;
        this.emat = emat;
        this.numPosTotal = numPosTotal;
    }

    public ArrayList<RCTuple> enumerateUnprunedTuples(int numPosInTuple) {
        ArrayList<ArrayList<Integer>> posTupleCand = this.allPositionTuples(numPosInTuple);
        return this.enumerateUnprunedTuples(posTupleCand);
    }

    public ArrayList<RCTuple> enumerateUnprunedTuples(ArrayList<ArrayList<Integer>> posTupleCand) {
        ArrayList<RCTuple> allCandidates = new ArrayList<RCTuple>();
        for (ArrayList<Integer> posTuple : posTupleCand) {
            ArrayList<RCTuple> candidatesAtPos = this.pruneMat.unprunedRCTuplesAtPos(posTuple);
            allCandidates.addAll(candidatesAtPos);
        }
        return allCandidates;
    }

    public ArrayList<ArrayList<Integer>> allPositionTuples(int numPosInTuple) {
        ArrayList<ArrayList<Integer>> ans = new ArrayList<ArrayList<Integer>>();
        if (numPosInTuple == 1) {
            for (int pos = 0; pos < this.numPosTotal; ++pos) {
                ArrayList<Integer> singleton = new ArrayList<Integer>();
                singleton.add(pos);
                ans.add(singleton);
            }
        } else {
            ArrayList<ArrayList<Integer>> reducedTups = this.allPositionTuples(numPosInTuple - 1);
            for (ArrayList<Integer> redTup : reducedTups) {
                int lastPosInTup = redTup.get(numPosInTuple - 2);
                for (int newPos = lastPosInTup + 1; newPos < this.numPosTotal; ++newPos) {
                    ArrayList fullTup = (ArrayList)redTup.clone();
                    fullTup.add(newPos);
                    ans.add(fullTup);
                }
            }
        }
        return ans;
    }

    public ArrayList<ArrayList<Integer>> topPositionTriples(int numPartners) {
        ArrayList<ArrayList<Integer>> allPositionTriples = this.allPositionTuples(3);
        ArrayList<ArrayList<Integer>> ans = new ArrayList<ArrayList<Integer>>();
        boolean[][] strongInteraction = this.strongInteractingPairs(numPartners);
        for (ArrayList<Integer> posTriple : allPositionTriples) {
            int strongInteractionCount = 0;
            for (int i = 0; i < 3; ++i) {
                int p2;
                int p1 = posTriple.get(i);
                if (!strongInteraction[p1][p2 = posTriple.get((i + 1) % 3).intValue()]) continue;
                ++strongInteractionCount;
            }
            if (strongInteractionCount < 2) continue;
            ans.add(posTriple);
        }
        return ans;
    }

    public boolean[][] strongInteractingPairs(int numPartners) {
        int numPos = this.emat.getNumPos();
        double[][] strongestPairE = this.emat.topPairwiseInteractions();
        boolean[][] strongInteraction = new boolean[numPos][numPos];
        for (int pos = 0; pos < numPos; ++pos) {
            PriorityQueue<TupE> posTop = new PriorityQueue<TupE>();
            for (int pos2 = 0; pos2 < numPos; ++pos2) {
                if (pos == pos2) continue;
                posTop.add(new TupE(new RCTuple(pos2, -1), strongestPairE[pos][pos2]));
                if (posTop.size() <= numPartners) continue;
                posTop.poll();
            }
            for (TupE top : posTop) {
                int pos2 = top.tup.pos.get(0);
                strongInteraction[pos][pos2] = true;
                strongInteraction[pos2][pos] = true;
            }
        }
        return strongInteraction;
    }

    public ArrayList<RCTuple> clique2PairTriples(int numTriplesPerType) {
        ArrayList<RCTuple> tupList = new ArrayList<RCTuple>();
        PriorityQueue<TupE> topCliques = new PriorityQueue<TupE>();
        PriorityQueue<TupE> top2Pair = new PriorityQueue<TupE>();
        ArrayList<RCTuple> possibleTriples = this.enumerateUnprunedTuples(3);
        for (RCTuple triple : possibleTriples) {
            int i;
            double[] pairAbsE = new double[3];
            double minAbsE = Double.POSITIVE_INFINITY;
            double max2PairE = Double.NEGATIVE_INFINITY;
            for (i = 0; i < 3; ++i) {
                RCTuple pair = triple.subtractMember(i);
                pairAbsE[i] = Math.abs(this.emat.getPairwise(pair.pos.get(0), pair.RCs.get(0), pair.pos.get(1), pair.RCs.get(1)));
                minAbsE = Math.min(minAbsE, pairAbsE[i]);
            }
            for (i = 0; i < 3; ++i) {
                max2PairE = Math.max(max2PairE, Math.min(pairAbsE[(i + 1) % 3], pairAbsE[(i + 2) % 3]));
            }
            topCliques.add(new TupE(triple, minAbsE));
            top2Pair.add(new TupE(triple, max2PairE));
            if (topCliques.size() > numTriplesPerType) {
                topCliques.poll();
            }
            if (top2Pair.size() <= numTriplesPerType) continue;
            top2Pair.poll();
        }
        for (TupE tupe : topCliques) {
            tupList.add(tupe.tup);
        }
        for (TupE tupe : top2Pair) {
            tupList.add(tupe.tup);
        }
        return tupList;
    }

    public EnergyMatrix getEmat() {
        return this.emat;
    }

    public void setEmat(EnergyMatrix emat) {
        this.emat = emat;
    }
}

