/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.confspace;

import edu.duke.cs.osprey.confspace.HigherTupleFinder;
import edu.duke.cs.osprey.confspace.RCTuple;
import edu.duke.cs.osprey.confspace.SimpleConfSpace;
import edu.duke.cs.osprey.confspace.TupleTree;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.BiConsumer;

public interface TupleMatrix<T> {
    public void fill(T var1);

    public void fill(Iterator<T> var1);

    public double getPruningInterval();

    public int getNumPos();

    public int getNumConfAtPos(int var1);

    public T getOneBody(int var1, int var2);

    public void setOneBody(int var1, int var2, T var3);

    public void setOneBody(int var1, ArrayList<T> var2);

    default public T getOneBody(SimpleConfSpace.Position pos1, SimpleConfSpace.ResidueConf rc1) {
        return this.getOneBody(pos1.index, rc1.index);
    }

    default public void setOneBody(SimpleConfSpace.Position pos1, SimpleConfSpace.ResidueConf rc1, T val) {
        this.setOneBody(pos1.index, rc1.index, val);
    }

    public T getPairwise(int var1, int var2, int var3, int var4);

    public void setPairwise(int var1, int var2, int var3, int var4, T var5);

    public void setPairwise(int var1, int var2, ArrayList<ArrayList<T>> var3);

    default public T getPairwise(SimpleConfSpace.Position pos1, SimpleConfSpace.ResidueConf rc1, SimpleConfSpace.Position pos2, SimpleConfSpace.ResidueConf rc2) {
        return this.getPairwise(pos1.index, rc1.index, pos2.index, rc2.index);
    }

    default public void setPairwise(SimpleConfSpace.Position pos1, SimpleConfSpace.ResidueConf rc1, SimpleConfSpace.Position pos2, SimpleConfSpace.ResidueConf rc2, T val) {
        this.setPairwise(pos1.index, rc1.index, pos2.index, rc2.index, val);
    }

    public boolean hasHigherOrderTerms();

    public void setTupleValue(RCTuple var1, T var2);

    public HigherTupleFinder<T> getHigherOrderTerms(int var1, int var2, int var3, int var4);

    public void setHigherOrderTerms(int var1, int var2, int var3, int var4, HigherTupleFinder<T> var5);

    default public boolean hasHigherOrderTuples() {
        return false;
    }

    default public TupleTree<T> getHigherOrderTuples(int pos1, int rc1, int pos2, int rc2) {
        throw new UnsupportedOperationException();
    }

    default public TupleTree<T> getOrMakeHigherOrderTuples(int pos1, int rc1, int pos2, int rc2) {
        throw new UnsupportedOperationException();
    }

    default public T getTuple(RCTuple tuple) {
        tuple.checkSortedPositions();
        switch (tuple.size()) {
            case 0: {
                throw new IllegalArgumentException("zero-length tuple");
            }
            case 1: {
                int pos1 = tuple.pos.get(0);
                int rc1 = tuple.RCs.get(0);
                return this.getOneBody(pos1, rc1);
            }
            case 2: {
                int pos1 = tuple.pos.get(1);
                int rc1 = tuple.RCs.get(1);
                int pos2 = tuple.pos.get(0);
                int rc2 = tuple.RCs.get(0);
                return this.getPairwise(pos1, rc1, pos2, rc2);
            }
        }
        int pos1 = tuple.pos.get(0);
        int rc1 = tuple.RCs.get(0);
        int pos2 = tuple.pos.get(1);
        int rc2 = tuple.RCs.get(1);
        TupleTree<T> tree = this.getHigherOrderTuples(pos1, rc1, pos2, rc2);
        if (tree != null) {
            return tree.get(tuple);
        }
        return null;
    }

    default public void setTuple(RCTuple tuple, T val) {
        tuple.checkSortedPositions();
        switch (tuple.size()) {
            case 0: {
                throw new IllegalArgumentException("zero-length tuple");
            }
            case 1: {
                int pos1 = tuple.pos.get(0);
                int rc1 = tuple.RCs.get(0);
                this.setOneBody(pos1, rc1, val);
                break;
            }
            case 2: {
                int pos1 = tuple.pos.get(1);
                int rc1 = tuple.RCs.get(1);
                int pos2 = tuple.pos.get(0);
                int rc2 = tuple.RCs.get(0);
                this.setPairwise(pos1, rc1, pos2, rc2, val);
                break;
            }
            default: {
                int pos1 = tuple.pos.get(0);
                int rc1 = tuple.RCs.get(0);
                int pos2 = tuple.pos.get(1);
                int rc2 = tuple.RCs.get(1);
                this.getOrMakeHigherOrderTuples(pos1, rc1, pos2, rc2).put(tuple, val);
            }
        }
    }

    default public void forEachHigherOrderTupleIn(int[] conf, BiConsumer<RCTuple, T> callback) {
        if (!this.hasHigherOrderTuples()) {
            return;
        }
        int numPos = this.getNumPos();
        for (int pos1 = 1; pos1 < numPos; ++pos1) {
            int rc1 = conf[pos1];
            if (rc1 == -1) continue;
            for (int pos2 = 0; pos2 < pos1; ++pos2) {
                TupleTree<T> tree;
                int rc2 = conf[pos2];
                if (rc2 == -1 || (tree = this.getHigherOrderTuples(pos1, rc1, pos2, rc2)) == null) continue;
                tree.forEachIn(conf, callback);
            }
        }
    }

    default public void forEachHigherOrderTupleIn(int[] conf, int posa, BiConsumer<RCTuple, T> callback) {
        if (!this.hasHigherOrderTuples()) {
            return;
        }
        int numPos = this.getNumPos();
        for (int pos1 = 1; pos1 < numPos; ++pos1) {
            int rc1 = conf[pos1];
            if (rc1 == -1) continue;
            for (int pos2 = 0; pos2 < pos1; ++pos2) {
                TupleTree<T> tree;
                int rc2 = conf[pos2];
                if (rc2 == -1 || (tree = this.getHigherOrderTuples(pos1, rc1, pos2, rc2)) == null) continue;
                tree.forEachIn(conf, posa, callback);
            }
        }
    }

    default public void forEachHigherOrderTupleIn(int[] conf, int posa, int posb, BiConsumer<RCTuple, T> callback) {
        if (!this.hasHigherOrderTuples()) {
            return;
        }
        int numPos = this.getNumPos();
        for (int pos1 = 1; pos1 < numPos; ++pos1) {
            int rc1 = conf[pos1];
            if (rc1 == -1) continue;
            for (int pos2 = 0; pos2 < pos1; ++pos2) {
                TupleTree<T> tree;
                int rc2 = conf[pos2];
                if (rc2 == -1 || (tree = this.getHigherOrderTuples(pos1, rc1, pos2, rc2)) == null) continue;
                tree.forEachIn(conf, posa, posb, callback);
            }
        }
    }
}

