/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.confspace;

import edu.duke.cs.osprey.confspace.AbstractTupleMatrix;
import edu.duke.cs.osprey.confspace.ConfSpace;
import edu.duke.cs.osprey.confspace.SimpleConfSpace;
import java.util.ArrayList;
import java.util.BitSet;

public class TupleMatrixBoolean
extends AbstractTupleMatrix<Boolean> {
    private static final long serialVersionUID = -1286639255089978027L;
    private BitSet oneBody;
    private BitSet pairwise;

    protected TupleMatrixBoolean() {
    }

    public TupleMatrixBoolean(TupleMatrixBoolean other) {
        super(other);
        this.oneBody = (BitSet)other.oneBody.clone();
        this.pairwise = (BitSet)other.pairwise.clone();
    }

    public TupleMatrixBoolean(ConfSpace cSpace, double pruningInterval, boolean defaultHigherInteraction) {
        super(cSpace, pruningInterval, Boolean.valueOf(defaultHigherInteraction));
    }

    public TupleMatrixBoolean(SimpleConfSpace confSpace, double pruningInterval, boolean defaultHigherInteraction) {
        super(confSpace, pruningInterval, Boolean.valueOf(defaultHigherInteraction));
    }

    public TupleMatrixBoolean(int numPos, int[] numAllowedAtPos, double pruningInterval, boolean defaultHigherInteraction) {
        super(numPos, numAllowedAtPos, pruningInterval, defaultHigherInteraction);
    }

    @Override
    protected void allocate(int numOneBody, int numPairwise) {
        this.oneBody = new BitSet(numOneBody);
        this.pairwise = new BitSet(numPairwise);
    }

    @Override
    public Boolean getOneBody(int res, int conf) {
        return this.oneBody.get(this.getOneBodyIndex(res, conf));
    }

    @Override
    public void setOneBody(int res, int conf, Boolean val) {
        this.oneBody.set(this.getOneBodyIndex(res, conf), val);
    }

    @Override
    public void setOneBody(int res, ArrayList<Boolean> val) {
        int n = this.getNumConfAtPos(res);
        for (int i = 0; i < n; ++i) {
            this.oneBody.set(this.getOneBodyIndex(res, i), val.get(i));
        }
    }

    @Override
    public Boolean getPairwise(int res1, int conf1, int res2, int conf2) {
        return this.pairwise.get(this.getPairwiseIndex(res1, conf1, res2, conf2));
    }

    @Override
    public void setPairwise(int res1, int conf1, int res2, int conf2, Boolean val) {
        this.pairwise.set(this.getPairwiseIndex(res1, conf1, res2, conf2), val);
    }

    @Override
    public void setPairwise(int res1, int res2, ArrayList<ArrayList<Boolean>> val) {
        int n1 = this.getNumConfAtPos(res1);
        int n2 = this.getNumConfAtPos(res2);
        for (int i1 = 0; i1 < n1; ++i1) {
            for (int i2 = 0; i2 < n2; ++i2) {
                this.pairwise.set(this.getPairwiseIndex(res1, i1, res2, i2), val.get(i1).get(i2));
            }
        }
    }

    public String toString() {
        return this.toString(6, isPruned -> isPruned != false ? "  X   " : "      ");
    }
}

